<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	http://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There area two reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router what URI segments to use if those provided
| in the URL cannot be matched to a valid route.
|
*/

$route['default_controller'] 			= 	'login';
$route['404_override'] 					= 	'';
$route['Dashboard'] 					=	'dashboard';
$route['system_settings/categories']	=	'product_category';



//requisition
$route['requisition'] 					    =	'requisition';
$route['requisition/add'] 				    =	'requisition/requisition_add';
$route['requisition/view/(:num)'] 				    =	'requisition/view/$1';

$route['requisition']						    =	'requisition';
$route['requisition/manage/(:any)']				    =	'requisition/requisition_add/$1';
$route['requisition/details/(:any)']				    =	'requisition/requisition_details/$1';
$route['requisition/payments/(:any)']				    =	'requisition/loan_payments/$1';
$route['requisition/calendar/(:any)']				    =	'requisition/loan_calendar/$1';
$route['requisition/print_loan_invoice/(:any)']						=	'requisition/print_loan_invoice/$1';

$route['requisition/req_details/(:any)']				    =	'requisition/req_details/$1';


//suppliers
$route['suppliers']						=	'suppliers';
$route['suppliers/insert_supplier']		=	'suppliers/insert_supplier';
$route['suppliers/create_supplier']		=	'suppliers/create_supplier';
$route['suppliers/delete']				=	'suppliers/delete_supplier';
$route['suppliers/disable']				=	'suppliers/disable_supplier';
$route['suppliers/enable']				=	'suppliers/enable_supplier';
$route['suppliers/list_supplier']		=	'suppliers/list_supplier';
$route['suppliers/save_supplier']		=	'suppliers/save_supplier';

//locations
$route['locations']						=	'locations';
$route['locations/insert_location']		=	'locations/insert_location';
$route['locations/create_location']		=	'locations/create_location';
$route['locations/delete']				=	'locations/delete_location';
$route['locations/disable']				=	'locations/disable_location';
$route['locations/enable']				=	'locations/enable_location';
$route['locations/save_location']		=	'locations/save_location';
$route['locations/list_location']		=	'locations/list_location';


//sales return cus
$route['sales_return/custom'] 				 =	'sales_return_cus/sales_return_add_cus';
$route['sales_return/custom/(:num)'] 				 =	'sales_return_cus/sales_return_add_cus/$1';

//warehouse
$route['warehouse']						    =	'warehouse';

$route['expenses/manage/(:any)']				    =	'expenses/expenses_add/$1';
$route['expenses/details/(:any)']				    =	'expenses/expenses_details/$1';
$route['expenses']						    =	'expenses';

//unit
$route['unit']						    =	'unit';
$route['unit/add_unit']				    =	'unit/add_unit';
$route['unit/create_unit']			    =	'unit/create_unit';
$route['unit/delete']				    =	'unit/delete_unit';
$route['unit/disable']				    =	'unit/disable_unit';
$route['unit/enable']				    =	'unit/enable_unit';
$route['unit/save_unit']			    =	'unit/save_unit';
$route['unit/list_unit']			    =	'unit/list_unit';
$route['logout']			            =	'users/logout';

$route['purchases_order/manage/(:any)']				    =	'purchases_order/purchases_order_add/$1';
$route['purchases_order']						    =	'purchases_order';
$route['purchases_order/details/(:any)']				    =	'purchases_order/purchases_order_details/$1';

$route['customers']						=	'customers';
$route['products']						=	'products';
$route['products/add']					=	'products/add_product';
$route['users']							=	'users';
$route['users/create']					=	'users/create_user';
$route['users/edit']					=	'users/edit_user';

$route['purchases/add'] 				=	'purchases/add_purchases';
$route['notifications'] 				=	'notifications';
$route['system_settings'] 				=	'system_settings';
$route['purchases/view/(:num)'] 		=	'purchases/purchases_details/$1';
$route['purchases/add/(:num)/(:num)'] 		=	'purchases/add_purchases/$1/$1';



$route['service']						    =	'service';
$route['service/manage/(:any)']				    =	'service/service_add/$1';
$route['service/details/(:any)']				    =	'service/service_details/$1';
$route['service/payments/(:any)']				    =	'service/loan_payments/$1';


//sales
$route['sales'] 					    =	'sales';
$route['sales/add'] 				    =	'sales/add_sales';
$route['sales/add/(:num)'] 				    =	'sales/add_sales/$1';
//$route['sales/add/(:num)/(:num)/(:num)/(:num)'] 				    =	'sales/add_sales/$1/$1/$1/$1';
$route['sales/save_sales'] 			    =	'sales/save_sales';
$route['sales/view/(:num)'] 				    =	'sales/view/$1';



//quotations
$route['quotations'] 					    =	'quotations';
$route['quotations/add'] 				    =	'quotations/quotations_add';
$route['quotations/view/(:num)'] 				    =	'quotations/view/$1';

//product damage
$route['product_damage'] 					    =	'product_damage';
$route['product_damage/add'] 				    =	'product_damage/product_damage_add';

//transfer
$route['transfer'] 					    =	'transfer';
$route['transfer/add'] 				    =	'transfer/transfer_add';
$route['transfer/view/(:num)'] 				    =	'transfer/view/$1';

//sales return
$route['sales/sales_return'] 				 =	'sales_return';
$route['sales/sales_return/add/(:num)'] 	   =	'sales_return/sales_return_add/$1';
$route['sales/sales_return_details/(:num)'] 	   =	'sales_return/sales_return_details/$1';

//report
$route['reports/suppliers'] 				    =	'reports/suppliers';
$route['reports/products'] 				    =	'reports/products';
$route['reports/sales'] 				    =	'reports/sales';
$route['reports/grn'] 				    =	'reports/grn';
$route['reports/user_activitie'] 				    =	'reports/user_activitie';

//settings
$route['tax_rates'] 					=	'tax_rates';
$route['backups'] 						=	'backups';
$route['system_settings/user_groups'] 	=	'user_groups';
$route['system_settings/permissions/(:num)'] 	=	'user_groups/permissions/$1';

$route["system_settings/subcategories/(:num)"] = "product_category/subcategories/$1";

$route['multiple_payments/supplier/list']      = 'supplier_multiple_payment/supplier_multiple_payment_list';
$route['multiple_payments/supplier/add']       = 'supplier_multiple_payment';


/* End of file routes.php */
/* Location: ./application/config/routes.php */