<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Department extends CI_Controller {

    var $main_menu_name = "settings";
    var $sub_menu_name = "department";

    public function __construct()
    {
        parent::__construct();

        $this->load->model('Department_Model');
        $this->load->model('Common_Model');
        $this->load->model('Sequerty_Model');
    }

    public function index()
    {
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name'] = $this->sub_menu_name;
        $this->load->view('department',$data);
    }


    public function save_department()
    {
        $department_id=$this->input->post('department_id');
        $type=$this->input->post('type');
        $department_name=$this->input->post('department_name');
        $department_code=$this->input->post('department_code');

        $data=array(
            'department_name'=>$department_name,
            'department_code'=>$department_code,
        );

        $this->load->library('form_validation'); //form validation lib
        if($type=='A')
        {
            $this->form_validation->set_rules('department_code', 'Code', 'required|is_unique[mstr_department.department_code]');
        }
        else if($type=='E')
        {
            $this->form_validation->set_rules('department_code', 'Code', 'required');
        }

        if ($this->form_validation->run() == FALSE)
        {
            $st = array('status' =>0,'validation' => validation_errors());
            echo json_encode($st);
        }
        else
        {

            $_insert=$this->Department_Model->save_department($data,$department_id);
            $lastid=$this->db->insert_id();

            if($type=='A'){
                if ($lastid) {
                    echo json_encode(array('id'=>$lastid,'type'=>$type));
                } else {
                    echo json_encode(array('status'=>'error'));
                }
            }
            if($type=='E'){
                echo json_encode(array('type'=>$type));
            }
        }
    }
    
     public function save_type()
    {
        $department_id=$this->input->post('department_id');
        $type=$this->input->post('type');
        $department_name=$this->input->post('department_name');
        $department_code=$this->input->post('department_code');

        $data=array(
            'ptype_name'=>$department_name,
            'ptype_id'=>$department_code,
            'ptype_status'=>1,
        );

        $this->load->library('form_validation'); //form validation lib
        if($type=='A')
        {
            $this->form_validation->set_rules('department_code', 'Code', 'required|is_unique[mstr_pro_type.ptype_id]');
        }
        else if($type=='E')
        {
            $this->form_validation->set_rules('department_code', 'Code', 'required');
        }

        if ($this->form_validation->run() == FALSE)
        {
            $st = array('status' =>0,'validation' => validation_errors());
            echo json_encode($st);
        }
        else
        {

            $_insert=$this->Department_Model->save_types($data,$department_id);
            $lastid=$this->db->insert_id();

            if($type=='A'){
                if ($lastid) {
                    echo json_encode(array('id'=>$lastid,'type'=>$type));
                } else {
                    echo json_encode(array('status'=>'error'));
                }
            }
            if($type=='E'){
                echo json_encode(array('type'=>$type));
            }
        }
    }
    
    public function add_type()
    {
        if (isset($_GET['department_id'])) {
            $department_id=$_GET['department_id'];
        }
        else {
            $department_id='';
        }
        if($department_id){
            $data['department_id']=$department_id;
            $data['type']='E';
            $data['pageName']='UPDATE TYPE';
            $data['btnText']='Update Type';
            $data['suppliyer']= $this->Department_Model->get_department_info($department_id);
        }
        else {
            $data['department_id']='';
            $data['type']='A';
            $data['pageName']='ADD TYPE';
            $data['btnText']='Add Type';
            $data['suppliyer']=array();
        }
        $this->load->view('models/create_type',$data);
    }

    public function add_department()
    {
        if (isset($_GET['department_id'])) {
            $department_id=$_GET['department_id'];
        }
        else {
            $department_id='';
        }
        if($department_id){
            $data['department_id']=$department_id;
            $data['type']='E';
            $data['pageName']='UPDATE DEPARTMENT';
            $data['btnText']='Update Department';
            $data['suppliyer']= $this->Department_Model->get_department_info($department_id);
        }
        else {
            $data['department_id']='';
            $data['type']='A';
            $data['pageName']='ADD DEPARTMENT';
            $data['btnText']='Add Department';
            $data['suppliyer']=array();
        }
        $this->load->view('models/create_department',$data);
    }

    public function list_department()
    {
        $requestData= $_REQUEST;

        $columns = array(
            0 =>'department_code',
            1 => 'department_name'
        );

        $data = array();
        $department = $this->Department_Model->get_all_department();
        $totalData = count($department);
        $totalFiltered = $totalData;

        foreach ($department as $row){
            $nestedData=array();
            $nestedData[] =$row['department_code'];
            $nestedData[] = $row['department_name'];
            $actionTxtDisble='';
            $actionTxtEnable='';
            $actionTxtUpdate='';
            $actionTxtDelete='';
            $actionTxtUpdate='<a onClick="click_department_update_btn('.$row['department_id'].')" data-toggle="modal" href="#" class="btn btn-xs btn-blue tooltips" data-placement="top" data-original-title="Edit suppliers"><i class="glyphicon fa fa-edit"></i></a> &nbsp;';
            if($row['department_status']==1){
                $actionTxtDisble = '<a class="btn btn-xs btn-green tooltips" data-placement="top" data-original-title="Disable supplier" onClick="disableDepartmentData('.$row['department_id'].')"><i class="glyphicon fa fa-check"></i></a> &nbsp;';
            }
            if($row['department_status']==0){
                $actionTxtEnable = '<a class="btn btn-xs btn-warning tooltips" data-placement="top" data-original-title="Disable supplier" onClick="enableDepartmentData('.$row['department_id'].')"><i class="glyphicon fa fa-minus-circle"></i></a> &nbsp;';
            }
            $actionTxtDelete='<a class="btn btn-xs btn-bricky tooltips" data-placement="top" data-original-title="Delete supplier" onClick="deleteDepartmentData('.$row['department_id'].')">
															<i class="glyphicon fa fa-trash-o"></i></a>';

            $nestedData[]=$actionTxtUpdate.$actionTxtDisble.$actionTxtEnable.$actionTxtDelete;
            $data[] = $nestedData;
        }

        $json_data = array(
            //"draw"            => intval( $requestData['draw'] ),
            "recordsTotal"    => intval( $totalData ),
            "recordsFiltered" => intval( $totalFiltered ),
            "data"            => $data
        );

        echo json_encode($json_data);
    }


    function delete_department() {
        $department_id	= $this->input->post('department_id');
        $this->Department_Model->delete_department($department_id);
        if ($department_id) {
            echo json_encode(array('id'=>$department_id));
        } else {
            echo json_encode(array('status'=>'error'));
        }
    }

    function disable_department() {

        $department_id	= $this->input->post('department_id');
        $this->Department_Model->disable_department($department_id);
        if ($department_id) {
            echo json_encode(array('id'=>$department_id));
        } else {
            echo json_encode(array('status'=>'error'));
        }
    }

    function enable_department() {
        $department_id	= $this->input->post('department_id');
        $this->Department_Model->enable_department($department_id);
        if ($department_id) {
            echo json_encode(array('id'=>$department_id));
        } else {
            echo json_encode(array('status'=>'error'));
        }
    }
}