<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Expenses extends CI_Controller {

    var $main_menu_name = "expenses";
	var $sub_menu_name = "expenses";

	public function __construct()
	{
		parent::__construct();

		
		$this->load->model('Expenses_Model');
		$this->load->model('Supplier_Model');
		$this->load->model('Warehouse_Model');
		$this->load->model('Common_Model');
		$this->load->model('Tax_Rates_Model');
		$this->load->model('Customer_Model');
		$this->load->model('Sequerty_Model');
		$this->load->model('Product_Models');
		$this->load->model('Expenses_Model');
		$this->load->model('category_models');
		$this->load->model('Unit_Model');
		$this->load->model('User_Model');
		
		
	}
	
	//Requisition list page load
	public function index()
	{
		$data['expenses'] = $this->Expenses_Model->get_all_expenses();
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = $this->sub_menu_name;
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        $this->load->view('expenses',$data);
	}	
	

	public function itemlist()
	{
		$data['expenses'] = $this->Expenses_Model->get_all_expenses();
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = $this->sub_menu_name;
        $this->load->view('expenses',$data);
	}
		
	public function expenses_add_row()
	{
		$product_id=$this->input->post('id');
		
		$rowCount=$this->input->post('rowCount');
		$pro_dlts=$this->Product_Models->get_product_by_id($product_id);
		$supp_id=$this->input->post('supp_id');
		$cat_id=$this->input->post('cat_id');
		$exp_voucher_no=$this->input->post('exp_voucher_no');
		$exp_datetime=$this->input->post('exp_datetime');
		
		//
		
		//echo "supp id: $supp_id";
		//print_r($pro_dlts);
		$row_details='';
		$msg='';
		$error=false;
		
		$selbox='';
		//test 
		//$rowCount_e=1;
		$tmp_th_e=$rowCount;
		$pymnt_cheque_date='';
		$required_date=date('m/d/Y');
		
		
		//validate
		$this->load->library('form_validation');
		$this->form_validation->set_rules('supp_id', 'Supplier', 'required');
		
		/*if(!$supp_id){
			$error=true;
			$msg.="Supplier, ";
		}
		if(!$cat_id){
			$error=true;
			$msg.="Product Type, ";
		}*/
		/*if(!$exp_voucher_no){
			$error=true;
			$msg.="Voucher No., ";
		}*/
		if(!$exp_datetime){
			$error=true;
			$msg.="Voucher Date, ";
		}
		
		if (!$error)
        {
             $prodcut_name_fld_type='hidden';
			 $prodcut_name_txt=$pro_dlts->product_name;
			 if($pro_dlts->product_name=='Other'){
				 $prodcut_name_fld_type='text';
				 $prodcut_name_txt='';
			 }
			 
			 $unit_list = $this->Unit_Model->get_all_unit_list();
			 $unit_sel_box='';
			 $unit_sel_box.="<select id=\"product_unit_$tmp_th_e\" class=\"\" name=\"row_e[$tmp_th_e][product_unit][]\">";
																 $unit_sel_box.="<option value=\"\">
							-Select-
							</option>";
				  foreach ($unit_list as $row)
				  {
					  $sel='';
					  if($pro_dlts->product_unit==$row->unit_id){
						 $sel=" selected=\"selected\"";
					  }
					  else if($prodcut_name_txt==''){
						  if($row->unit_id==6){
						  $sel=" selected=\"selected\"";
						  }
					  }
					  
					  
						  $unit_sel_box.="<option value=\"$row->unit_id\" $sel>
								$row->unit_name
							</option>";}
							$unit_sel_box.="
						</select>";
			 
			 
			 
			$row_details="
			<tr id=\"row_e_$tmp_th_e\">
			<td class=\"text-left\">
			 $prodcut_name_txt
			<input type=\"$prodcut_name_fld_type\" style=\"width:100%; text-align:left\" name=\"row_e[$tmp_th_e][product_name][]\" id=\"product_name_$tmp_th_e\" value=\"$pro_dlts->product_name\" class=\"pymnt_amount\">
			<input type=\"hidden\" style=\"width:100%; text-align:left\" name=\"row_e[$tmp_th_e][product_id][]\" id=\"product_id_$tmp_th_e\" value=\"$pro_dlts->product_id\" class=\"product_id\">
			</td>
			<td>$unit_sel_box</td>
			<td><input type=\"text\" style=\"width:100%; text-align:right\" name=\"row_e[$tmp_th_e][expitm_qty][]\" id=\"expitm_qty_$tmp_th_e\" value=\"1.00\" class=\"expitm_qty\" onchange=\"changeQtyByProductID(this.value,$tmp_th_e);\" onclick=\"this.select(); setTmpVal(this.value);\"></td>
			<td><input type=\"text\" style=\"width:100%; text-align:right\" name=\"row_e[$tmp_th_e][product_cost][]\" id=\"product_cost_$tmp_th_e\" value=\"$pro_dlts->product_cost\" class=\"product_cost\" onchange=\"calculateTotal();\" ></td>
			<td><input type=\"text\" style=\"width:100%; text-align:right\" name=\"row_e[$tmp_th_e][expitm_dis][]\" id=\"expitm_dis_$tmp_th_e\" value=\"\" class=\"expitm_dis\" onchange=\"changeDiscountByProductID(this.value,1);\" onclick=\"this.select(); setTmpVal(this.value);\">
			<input type=\"hidden\" style=\"width:100%; text-align:right\" name=\"row_e[$tmp_th_e][expitm_dis_val][]\" id=\"expitm_val_$tmp_th_e\" value=\"\" class=\"expitm_dis_val\">
			</td>
			<td><input type=\"text\" style=\"width:100%; text-align:right\" name=\"row_e[$tmp_th_e][sub_total_item][]\" id=\"sub_total_item_$tmp_th_e\" value=\"\" class=\"\" readonly></td>
			<td><a onclick=\"deleteExpensesItem($tmp_th_e)\"><i style=\"cursor:pointer;\" title=\"Remove\" id=\"1446800197032\" class=\"fa fa-times tip podel\"></i></a></td>
			</tr>
			";
			
		 $e = array('status' =>1,'row_details' =>$row_details,'msg'=>$row_details);
		 echo json_encode($e);
		
		}else {
			$e = array('status' =>0,'row_details' =>'','msg'=>$msg);
		 	echo json_encode($e);
		}
		
	}
	
	//Requisition details view
	public function view()
	{
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = '';
		
		//get sale id
		$exp_id=$this->uri->segment('3');
		$data['exp_item_list']= $this->Expenses_Model->get_exp_item_list_by_exp_id($exp_id);
		$data['exp_details']= $this->Purchases_Order_Model->get_exp_info($exp_id);
		
	
		$data['customer_details']= $this->Customer_Model->get_customer_info($data['exp_details']['customer_id']);
		$data['warehouse_details']= $this->Warehouse_Model->get_warehouse_info($data['exp_details']['warehouse_id']);		
		
		$data['exp_id']=$exp_id;
        $this->load->view('expenses_view',$data);
	}

	//Requisition add page
	public function add_exp_payments()
	{
		$exp_pymnt_amount=$this->input->post('exp_pymnt_amount');
		$exp_id=$this->input->post('exp_id');
		$exp_pymnt_ref_no=$this->input->post('exp_pymnt_ref_no');
		$exp_pymnt_paying_by=$this->input->post('exp_pymnt_paying_by');
		$exp_pymnt_date_time=$this->input->post('exp_pymnt_date_time');
		$exp_pymnt_date_time_send=date('Y-m-d H:i:s', strtotime($exp_pymnt_date_time));
		$exp_pymnt_cheque_no=$this->input->post('exp_pymnt_cheque_no');
		$exp_pymnt_crdt_card_no=$this->input->post('exp_pymnt_crdt_card_no');
		$exp_pymnt_crdt_card_holder_name=$this->input->post('exp_pymnt_crdt_card_holder_name');
		$exp_pymnt_crdt_card_month=$this->input->post('exp_pymnt_crdt_card_month');
		$exp_pymnt_crdt_card_year=$this->input->post('exp_pymnt_crdt_card_year');
		$exp_pymnt_crdt_card_type=$this->input->post('exp_pymnt_crdt_card_type');
		$exp_type = $this->input->post('exp_type');

		$exp_pymnt_note=$this->input->post('exp_pymnt_note');
		$user_id=$this->session->userdata('ss_user_id');
		$exp_pymnt_added_date_time=date("Y-m-d H:i:s");
		$exp_pymnt_id='';
		
        $this->load->library('form_validation'); //form validation lib
        $this->form_validation->set_rules('exp_pymnt_amount', 'Amount', 'required');
		if($exp_pymnt_paying_by=='Credit Card'){
			$this->form_validation->set_rules('exp_pymnt_crdt_card_type', 'Card Type', 'required');
			$this->form_validation->set_rules('exp_pymnt_crdt_card_no', 'Credit Card No', 'required');
			$this->form_validation->set_rules('exp_pymnt_crdt_card_holder_name', 'Holder Name', 'required');
			$this->form_validation->set_rules('exp_pymnt_crdt_card_month', 'Month', 'required');
			$this->form_validation->set_rules('exp_pymnt_crdt_card_year', 'Year', 'required');
		}
		if($exp_pymnt_paying_by=='Cheque'){
			$this->form_validation->set_rules('exp_pymnt_cheque_no', 'Cheque No', 'required');
		}
		$this->form_validation->set_rules('exp_id', 'System Error', 'required');


        if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'validation' => validation_errors());
           echo json_encode($st);
        }
        else
        {
			$data=array(
				'exp_pymnt_amount'=>$exp_pymnt_amount,	
				'exp_pymnt_ref_no'=>$exp_pymnt_ref_no,
				'exp_pymnt_paying_by'=>$exp_pymnt_paying_by,
				'exp_pymnt_date_time'=>$exp_pymnt_date_time_send,
				'exp_pymnt_note'=>$exp_pymnt_note,
				'user_id'=>$user_id,
				'exp_id'=>$exp_id,
				'exp_pymnt_added_date_time'=>$exp_pymnt_added_date_time,
				'exp_pymnt_cheque_no'=>$exp_pymnt_cheque_no,
				'exp_pymnt_crdt_card_no'=>$exp_pymnt_crdt_card_no,
				'exp_pymnt_crdt_card_holder_name'=>$exp_pymnt_crdt_card_holder_name,
				'exp_pymnt_crdt_card_type'=>$exp_pymnt_crdt_card_type,
				'exp_pymnt_crdt_card_month'=>$exp_pymnt_crdt_card_month,
				'exp_pymnt_crdt_card_year'=>$exp_pymnt_crdt_card_year,
				'exp_payment_type' => $exp_type
			);
			
               if ($this->Purchases_Order_Model->save_exp_payments($data,$exp_pymnt_id)) {
                    $st = array('status' =>1,'validation' =>'Done!');
                    echo json_encode($st);
               } else {
                    $st = array('status' =>0,'validation' =>'error occurred please contact your system administrator');
                    echo json_encode($st);
               }
		}
	}	
	
	//Requisition payment page 
	public function payments()
	{
        $data['exp_id'] = $this->input->get('id');
        $data['exp_type'] = $this->input->get('exp_type');
        $this->load->view('models/expenses_payment',$data);	
	}
	
	
	public function update_exp_status()
	{
        $exp_id = $this->input->post('exp_id');
		$type = $this->input->get('type');
		$disMsg='';
		$prepared_user=0;
		$authorized_user=0;
		
		
		if($this->input->post('exp_prepared_status')=='Prepared')  $prepared_user=$this->session->userdata('ss_user_id');
		if($this->input->post('exp_authorized_status')=='Authorized')  $authorized_user=$this->session->userdata('ss_user_id');

		$data_edit=array();
		if($type=='prepared'){
			$data_edit=array(
				'exp_prepared_status'=>$this->input->post('exp_prepared_status'),
				'prepared_user'=>$prepared_user,
			);
		}
		if($type=='authorized'){
			$data_edit=array(
				 'exp_authorized_status'=>$this->input->post('exp_authorized_status'),
				'authorized_user'=>$authorized_user,
			);
		}
		
				
				
			$_insert=$this->Expenses_Model->save_expenses($data_edit,$exp_id);
			
			//echo $this->db->last_query();
        
        echo json_encode(array('exp_id'=>$exp_id,'error'=>'','disMsg'=>$disMsg,));
	}
	
	
	//Requisition save 
	//Requisition item save
	//Add expenses items to 54 table
	public function save_expenses()
	{
		$warehouse_id=$this->input->post('warehouse_id');//$this->session->userdata('ss_warehouse_id');
		//print_r($this->session->userdata());
		//echo 'w id:'.$warehouse_id;
		$supp_id=$this->input->post('supp_id');
		$cat_id=$this->input->post('cat_id');
		$rowCount=$this->input->post('rowCount');
		$exp_id=$this->input->post('exp_id');
		$exp_datetime=date('Y-m-d H:i:s', strtotime($this->input->post('exp_datetime')));
		$exp_voucher_no=$this->input->post('exp_voucher_no');
		
		$exp_total=$this->input->post('exp_total');
		$exp_discount=$this->input->post('exp_discount');
		$exp_discount_amt=$this->input->post('exp_discount_amt');
		$exp_net_total=$this->input->post('exp_net_total');
		$exp_supp_name=$this->input->post('exp_supp_name');
		$nbt_fld_val=$this->input->post('nbt_fld_val');
		$nbt_amount=$this->input->post('nbt_amount');
		$exp_vat_fld=$this->input->post('exp_vat_fld');
		$exp_vat=$this->input->post('exp_vat');
		$acctrnss_id=$this->input->post('acctrnss_id');
		

		if(!$exp_id){
				$exp_reference_no=$this->Common_Model->gen_ref_number('exp_id','expenses','REF/');
		}else {
			$exp_reference_no=$this->input->post('exp_reference_no');
		}
		
		
		//start get next referance no
				$warehouse_dtls=$this->Warehouse_Model->get_warehouse_info($warehouse_id);
				$warehouse_code=$warehouse_dtls['code'];
				$warehouse_last_id=(1+$this->Common_Model->get_next_warehouse_ref_no($warehouse_id,'warehouse_id','warehouse_last_id','expenses'));
				$exp_reference_no=$warehouse_code.'/E/'.sprintf("%04d",$warehouse_last_id);
				//end get next referance no
		
		$error='';
		$disMsg='';
		$lastid='';
		//$exp_id='';
		
		$error=false;
		
		
		if(!$error){
			
			$data_save=array(
				'exp_datetime'=>$exp_datetime,
				'exp_voucher_no'=>$exp_voucher_no,
				'warehouse_last_id'=>$warehouse_last_id,
				'supp_id'=>$supp_id,
				'cat_id'=>$cat_id,
				'exp_reference_no'=>$exp_reference_no,
				'warehouse_id'=>$warehouse_id,
				'exp_total'=>$exp_total,
				'exp_discount'=>$exp_discount,
				'exp_discount_amt'=>$exp_discount_amt,
				'exp_net_total'=>$exp_net_total,
				'exp_supp_name'=>$exp_supp_name,
				'warehouse_id'=>$warehouse_id,
				 'exp_vat'=>$exp_vat,
				 'exp_vat_fld'=>$exp_vat_fld,
				 'nbt_amount'=>$nbt_amount,
				 'nbt_fld_val'=>$nbt_fld_val,	
				 'acctrnss_id'=>$acctrnss_id
				
				);

			if($exp_id){
				
			
				$exp_id=$exp_id;
				$this->Expenses_Model->save_expenses($data_save,$exp_id);
				//delete old req items
				$this->Expenses_Model->delete_old_expenses_items($exp_id);
				$disMsg='Petty Cash successfully updated';
				
			}else {
				
			$_insert=$this->Expenses_Model->save_expenses($data_save,'');
			$lastid=$this->db->insert_id();
			$exp_id=$lastid;
			$disMsg='Petty Cash successfully added';
			}
			
			
			
			//insert sale item data
			$row=$this->input->post('row_e');
			$rowCount=$this->input->post('rowCount');
			//echo 'test:'.$rowCount;
			$data_item=array();
			for($i=1; $i<=$rowCount; $i++){
				if(isset($row[$i]['product_name'][0]))
				{
					
				$data_item=array(
					'exp_id'=>$exp_id,
					'product_name'=>$row[$i]['product_name'][0],
					'expitm_qty'=>$row[$i]['expitm_qty'][0],
					'product_cost'=>$row[$i]['product_cost'][0],
					'expitm_dis'=>$row[$i]['expitm_dis'][0],
					'expitm_dis_val'=>$row[$i]['expitm_dis_val'][0],
					'sub_total_item'=>$row[$i]['sub_total_item'][0],
					'product_unit'=>$row[$i]['product_unit'][0],
					//'unit_price'=>$row[$i]['unit_price'][0],
					//'discount_val'=>$row[$i]['discount_val'][0], 
					//'gross_total'=>$row[$i]['gross_total'][0]
				);
				$this->Expenses_Model->save_expenses_item($data_item);
				
				//add reford for f4 table
				/*
				$type='expenses';
				$ref_id=$exp_id;
				$product=$row[$i]['product_name'][0];
				$quantity=$row[$i]['product_name'][0];
				$unit_cost=$row[$i]['product_name'][0];
				$this->Common_Model->add_fi_table($type,$ref_id,$product,$quantity,$unit_cost);*/
				
				}
			}
			
			$this->session->set_flashdata('message', 'Requisition successfully added!');
		
		}else {
			
			$disMsg='Please select these before adding any product:'.$disMsg;
		}
		
		
		
	//	echo "Test:".$exp_id;;
		
		
		
		echo json_encode(array('exp_id'=>$exp_id,'error'=>$error,'disMsg'=>$disMsg,));
	}

	//Requisition reference no jenarate	
	public function get_next_ref_no(){
		$query=$this->Expenses_Model->get_next_ref_no();
		$result = $query->row();
		//print_r($result);
		$exp_reference_no=sprintf("%05d", $result->exp_id+1);
		$exp_reference_no=$exp_reference_no;
		echo json_encode(array('exp_reference_no'=>$exp_reference_no));
	}
	
	//Requisition ger avalable product qty
	public function get_avalable_product_qty(){
		$product_id=$this->input->get('product_id');
		$warehouse_id=$this->input->get('warehouse_id');
		
		$data['total']=$this->Expenses_Model->get_avalable_product_qty($product_id,$warehouse_id);
		echo json_encode(array('remmnaingQty'=>$data['total']));
	}
	
	//equisition details view
	public function expenses_details()
	{
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = '';
		
		//get sale id
		$exp_id=$this->uri->segment('3');
		if(isset($exp_id)){
			$data['exp_details']=$this->Expenses_Model->get_expenses_details_by_id($exp_id);
			$data['expitm_list']=$this->Expenses_Model->get_expenses_items_by_id($exp_id);
		}
		$data['exp_id'] =$exp_id;
		
        $this->load->view('expenses_details',$data);
		
	}
	
	
		public function expenses_print()
	{	
		$service_id=$this->uri->segment('3');
		
		$data['exp_details']=$this->Expenses_Model->get_expenses_details_by_id($service_id);
		$exp_details=$data['exp_details'];
		
		//get sale item list
		$data['expitm_list']=$this->Expenses_Model->get_expenses_items_by_id($service_id);
		
		
		//$data['customer_details']= $this->Customer_Model->get_customer_info($service_details->service_customer_id);
		
		//print_r($data['exp_details']);
		$data['warehouse_details']= $this->Warehouse_Model->get_warehouse_info($data['exp_details']->warehouse_id);
		
		//print_r($data['exp_details']);
        $this->load->view('models/expenses_print',$data);
	}

	//Requisition add form
    public function expenses_add()
    {
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'expenses_add';-
		
		$exp_id=$this->uri->segment('3');
		$data['expitm_list']=array();
		if(isset($exp_id)){
			$data['exp_details']=$this->Expenses_Model->get_expenses_details_by_id($exp_id);
			$data['expitm_list']=$this->Expenses_Model->get_expenses_items_by_id($exp_id);
		}
		
		$data['exp_id'] =$exp_id;
		//get suppliers list
		$data['suppliers'] = $this->Supplier_Model->get_all_supplier_obj();
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$data['tax_rates_list'] = $this->Tax_Rates_Model->get_all_tax_rates();
		$data['customer_list'] = $this->Customer_Model->get_all_customers();
		$data['status_list'] = $this->Common_Model->get_all_status();
		//$data['pr_list'] = $this->Requisition_Model->get_all_requisition_names();
		$data['main_category'] 	= $this->category_models->getCategory();
		
        $this->load->view('expenses_add',$data);
    }
	
	//Requisition product items get
	 public function suggestions($value='')
    {
		$term=$this->input->get('term');
		$data['expenses'] = $this->Expenses_Model->get_products_suggestions($term);
		$json = array();
		//echo "Count:".count($data['expenses']);
		//print_r($data['expenses']);
		foreach ($data['expenses'] as $row)
		{
			$product_name=$row['product_name'];
			$product_code=$row['product_code'];
			$product_part_no=$row['product_part_no'];
			$product_oem_part_number=$row['product_oem_part_number'];
			$product_id=$row['product_id'];
			$product_price=$row['product_price'];
			$sendParameters="'$product_id','$product_name','$product_code','$product_price'";
			$sendParameters="$product_id,$product_name,$product_code,$product_price";
			$extraName='';
			$extraName.=", Selling Price: ".number_format($product_price, 2, '.', ',');
			if($product_part_no) $extraName.=", Part No: $product_part_no";
			if($product_oem_part_number) $extraName.=", OEM Part No: $product_oem_part_number";
			
			 $json_itm=array(
			 		'id'=> $row['product_id'],
					'product_id'=> $row['product_id'],
					'product_code'=> $row['product_code'],
					'product_name'=> $row['product_name'],
					'product_price'=> $row['product_price'],
					'product_part_no'=> $row['product_part_no'],
					'product_oem_part_number'=> $row['product_oem_part_number'],
                    'value'=> $row['product_name']." (".$row['product_code'].")",
                    'label'=> $row['product_name']." (".$row['product_code'].")$extraName"
                    );
					array_push($json,$json_itm);
		}		
		echo json_encode($json);		
    }
	
	//Sale details page
	public function exp_details()
	{
		
		$exp_id=$this->input->get('exp_id');
		$data['exp_details']= $this->Expenses_Model->get_exp_info($exp_id);
		
		
		//get sale item list
		$data['exp_item_list']= $this->Expenses_Model->get_exp_item_list_by_exp_id($exp_id);
		
		$data['customer_details']= $this->Customer_Model->get_customer_info($data['exp_details']['customer_id']);
		$data['warehouse_details']= $this->Warehouse_Model->get_warehouse_info($data['exp_details']['warehouse_id']);
		
		$data['cr_limit_list'] = $this->Common_Model->get_all_cr_limit();
        $this->load->view('models/expenses_print',$data);
	}	
	
	//Expenses list
	public function list_expenses()
	{
	$requestData= $_REQUEST;
	$warehouse_id=$this->input->get('warehouse_id');
	
	$columns = array( 
		0 =>'exp_id', 
		1 => 'exp_id',
		2=> 'exp_id',
		3 =>'exp_id', 
		4 => 'exp_id',
		5=> 'exp_id'
	);
	
	$data = array();
	$expenses = $this->Expenses_Model->get_all_expenses($warehouse_id);
	$totalData = count($expenses);
	$totalFiltered = $totalData;  
	
	foreach ($expenses as $row){
		$nestedData=array(); 
		$exp_id=$row['exp_id'];
		$total_paid_amount='';
		$nestedData[] =$row['exp_id'];
		$nestedData[] = $row['exp_reference_no'];
		$nestedData[] =$row['name'];
		$nestedData[] =$row['exp_total'];//supp_company_name
		$nestedData[]=$row['cat_name'];
		$nestedData[] = date('d/M/Y', strtotime($row['exp_datetime']));
		$nestedData[] = $row['exp_voucher_no'];
		
		$prepared_status_dis='';
		$checked_status_dis='';
		$approved_status_dis='';
		$authorized_status_dis='';
		
		
		if (empty($row['exp_prepared_status'])) {
		  $prepared_status_dis = '<span class="label label-warning">Pending</span>';
		}else if($row['exp_prepared_status']=='Prepared'){
			$prepared_status_dis = '<span class="label label-success">Prepared</span>';
		}
		
		
		
		if (empty($row['exp_authorized_status'])) {
		  $authorized_status_dis = '<span class="label label-warning">Pending</span>';
		}else if($row['exp_authorized_status']=='Authorized'){
			$authorized_status_dis = '<span class="label label-success">Authorized</span>';
		}
		
		$nestedData[] = $prepared_status_dis;
		//$nestedData[] = $checked_status_dis;
		//$nestedData[] = $approved_status_dis;
		$nestedData[]=$authorized_status_dis;
		
		
		//$nestedData[] = $row['exp_id'];
		$actionTxtDisble='';
		$actionTxtEnable='';
		$actionTxtUpdate='';
		$actionTxtDelete='';
		
		$url=base_url("expenses/exp_details?exp_id=$exp_id");
		$actionTxtUpdate='<a onClick="fbs_click('.$row['exp_id'].')" data-toggle="modal" href="#" class="btn btn-xs btn-blue tooltips" data-placement="top" data-original-title="Edit suppliers"><i class="clip-zoom-in-2"></i></a> &nbsp;';
		
		$actionTxtViewDetails='<a href="'.base_url().'expenses/details/'.$exp_id.'" class="btn btn-xs btn-blue tooltips" data-placement="top" data-original-title="Edit suppliers"><i class="fa fa-file-text-o"></i></a> &nbsp;';
		
	
	
	$nestedData[] = '<div class="btn-group text-left">
                            <button data-toggle="dropdown" class="btn btn-default btn-xs btn-primary dropdown-toggle" type="button">Actions <span class="caret"></span></button>
                            <ul role="menu" class="dropdown-menu pull-right">
                            <li><a href="'.base_url().'expenses/details/'.$exp_id.'"><i class="fa fa-file-text-o"></i> Petty Cash Details</a></li>
							 
                            <li><a onClick="fbs_click('.$row['exp_id'].')" data-toggle="modal" href="#" data-placement="top" data-original-title="Edit suppliers"><i class="fa fa-print"></i> Print Petty Cash </a></li>
							
                            </ul></div>';
                            
                            /*
                            <li><a href="'.base_url().'expenses/manage/'.$exp_id.'"><i class="fa fa-file-text-o"></i> Update Petty Cash Details</a></li>
                            */
	
	$data[] = $nestedData;
}

	$json_data = array(
			//"draw"            => intval( $requestData['draw'] ),  
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data 
			);

	echo json_encode($json_data); 
	}
}