<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Reports extends CI_Controller {

    var $main_menu_name = "reports";
	var $sub_menu_name = "suppliers";

	public function __construct()
	{
		parent::__construct();

		
		$this->load->model('Common_Model');
		$this->load->model('Warehouse_Model');
		$this->load->model('Transfer_Model');
		$this->load->model('Sales_Model');
		$this->load->model('Purchases_Model');
		
		$this->load->model('Product_Damage_Model');
		$this->load->model('Sales_Return_Model');
		$this->load->model('Sequerty_Model');
		$this->load->model('Product_Models');
		$this->load->model('Customer_Model');
		$this->load->model('User_Model');
		$this->load->model('Product_Models');
		$this->load->model('Expenses_Model');
		$this->load->model('Report_Model');
		$this->load->model('category_models');
		$this->load->model('Custom_Model');
		$this->load->model('Department_Model');
		$this->load->model('User_Group_Model');
		$this->load->model('Salary_Model');
		$this->load->model('Purchase_Return_Model');
			$this->load->model('Supplier_Model');
				$this->load->model('Supplier_Multiple_Payment_Model');
		
		
	
		
	}
	
	public function sales_rep_jobs()
	{
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'sales_rep';
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$data['customer_list'] = array();//$this->Customer_Model->get_all_customers();
		//$data['rep_list'] = $this->User_Model->getUserstypeByID(2);
		$data['rep_list'] = $this->User_Model->getSalesRep();
		$data['technician_list'] = $this->User_Model->get_user_list_by_group_id(7);
		//print_r($data['rep_list']);
		
		$this->load->view('sale_ref_job',$data);
	}
	
	public function get_list_sale_ref_job_summery($value='')
	{
		//print_r($_REQUEST);
		$srh_to_date='';
		$srh_from_date='';
		$srh_warehouse_id=$this->input->post('srh_warehouse_id');
		$srh_technician_id=$this->input->post('srh_technician_id');
		if($this->input->post('srh_to_date')){
			$srh_to_date = date('Y-m-d', strtotime($this->input->post('srh_to_date')));
		}
		if($this->input->post('srh_from_date')){
			$srh_from_date=date('Y-m-d', strtotime($this->input->post('srh_from_date')));
		}
		
		$columns = array( 
    		0 =>'sale_datetime', 
    		1 => 'sale_reference_no',
    		2=> 'cus_name',
    		3 =>'sale_id', 
    		4 => 'sale_id',
    		5=> 'sale_id'
	    );
	
	    $data = array();
	   
	    $total_profit = 0;
    	$sales = $this->Report_Model->get_ref_jobs($srh_warehouse_id,$srh_to_date,$srh_from_date,$srh_technician_id);
    	//echo print_r($sales); die();
    	//echo $this->db->last_query();
    	$totalData = count($sales);
    	$totalFiltered = $totalData;  
    	
    	foreach ($sales as $row){
    	    $sale_items = $this->Report_Model->get_job_items($row['sale_id']);
    	    //echo print_r($sale_items); die();
    		$nestedData=array(); 
    		$nestedData[] =display_date_time_format($row['service_datetime']);
    		$nestedData[] = $row['service_reference_no'];
    		$nestedData[] = $row['sale_pymnt_amount'];
    		$nestedData[] = $sale_items;
    		$nestedData[] = number_format($row['sale_pymnt_amount']-$sale_items, 2, '.', '');
    		$total_profit = $total_profit + ($row['sale_pymnt_amount']-$sale_items);
    		$total_profit = number_format($total_profit, 2, '.', '');
    		$data[] = $nestedData;
        }

    	$json_data = array(
			//"draw"            => intval( $requestData['draw'] ),  
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"total_profit" => intval( $total_profit ),
			"data"            => $data 
			);

	    echo json_encode($json_data);
	}

	
	 public function cheque_summary()
    {
        
        $data['main_menu_name'] = 'finance';
        $data['sub_menu_name']  = 'cheque_summary';
        $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        $data['customer_list']  = array();//$this->Customer_Model->get_all_customers();
        $data['bank_details'] = $this->Supplier_Multiple_Payment_Model->get_all_bank_accounts();
     // echo "test"; die();
        $this->load->view('rep_cheque_summary', $data);
    }
    
     public function get_list_cheque_summary_for_report()
    {
      
        $data             = array();
        $srh_to_date      = '';
        $srh_from_date    = '';
        $srh_warehouse_id = $this->input->post('srh_warehouse_id');
        $srh_type         = $this->input->post('srh_type');
        $srh_payment_term = $this->input->post('srh_payment_term');
        $ss_user_id       = $this->input->post('ss_user_id');
         $b_id       = $this->input->post('b_id');
        if ($this->input->post('srh_to_date')) {
            $srh_to_date = date('Y-m-d', strtotime($this->input->post('srh_to_date')));
        }
        if ($this->input->post('srh_from_date')) {
            $srh_from_date = date('Y-m-d', strtotime($this->input->post('srh_from_date')));
        }
        $values  = $this->Sales_Model->getChequeForPrint_ar($srh_warehouse_id, $srh_to_date, $srh_from_date, $srh_type, $srh_payment_term, $ss_user_id,$b_id);
        
        $grn_cheque_list  = array();//$this->Sales_Model->getGRNChequeList($srh_warehouse_id, $srh_to_date, $srh_from_date, $srh_type, $srh_payment_term, $ss_user_id);
        
        $prety_cash_list=array();
        $prety_cash_list=$this->Sales_Model->get_prety_cash_list_by_date_range_and_bank_list($srh_warehouse_id, $srh_to_date, $srh_from_date, $srh_type, $srh_payment_term, $ss_user_id);
        
        
        // $values=array();
        // print_r($prety_cash_list);
        
       // $all_data=$values;
     //  $grn_cheque_list=array();
     
     $all_data=array();
     
       if(isset($values))
        {
            $all_data=$values;
        }
     
       
        if(isset($prety_cash_list))
        {
        $all_data=array_merge($all_data,$prety_cash_list);
        }

         //$all_data=array();
       // $all_data=$grn_cheque_list;
     //  echo "<pre>";
      // print_r($all_data);
        
         $all_data=$this->array_sort($all_data, 'dis_date', SORT_ASC);
         
  
       
        //echo "<pre>";
       // print_r($all_data);
        
        
        $columns = array(
            0 => 'bkng_id',
            1 => 'bkng_id',
            2 => 'bkng_id',
            3 => 'bkng_id',
            4 => 'bkng_id',
            5 => 'bkng_id',
            6 => 'bkng_id',
            7 => 'bkng_id',
            8 => 'bkng_id'
        );
        $tmp_id  = 0;
        $balance=0;
        if (!empty($all_data)) {
            foreach ($all_data as $users) {
                
                $item_type='';
                if(isset($users['sale_pymnt_id'])){
                    $item_type='payment';
                }else{
                    $item_type='deposit';
                }
                
                //echo "<br/> item_type:$item_type";
                
                
                if($item_type=='deposit'){
                    
                    $row       = array();
                    
                    if($users['fxd_ass_id']==2)
                    $balance+=$users['acctrnss_amount'];
                    
                   
                    $row[]           = $users['acctrnss_id'];
                    $row[]           = $users['b_name'];;//$users['acctrnss_id'];
                     $row[]           = $users['fxd_ass_name'];//'fxd_ass_name';
                      $row[]           = $users['b_name'];
                       $row[]           =  '';//$users['check_number'];
                        $row[]           =  site_date($users['dis_date']);//$users['dis_date'];
                         $row[]           = $users['acctrnss_id'];
                          $row[]           ='';// $users['amount'];
                           $row[]           =$users['acctrnss_amount'];
                            $row[]           =$balance;
                    
                     $data[] = $row;
                    
                }else{
                $row       = array();
                $bkng_id   = $users['sale_id'];
                $paymnt_id = $users['sale_pymnt_id'];
                $add_deposit_link='';

                 $dep_bank_name='';
                if($users['is_deposit']){
                    $dep_bank_name='bank';
                    $dep_bank_name=$this->Sales_Model->get_bank_name_by_id($users['deposit_bak_id']);
                   // print_r($dep_bank_name);
                   // die();
                    $add_deposit_link='<br/><span class="label label-success">Deposited to '.$dep_bank_name.' Bank</span>';
                }
                
                $tmp_id++;
                $row[]           = $paymnt_id;
                $row[]           = $users['cus_name'];
                
                $sale_payment_type='';
                $grn_amount=0;
                $sale_amount=0;
                
                $sale_payment_type=$users['sale_payment_type'];//." Payment";
                if($sale_payment_type=='sale') {
                    $sale_amount=$users['sale_pymnt_amount'];
                    $balance+=$sale_amount;
                }
                if($sale_payment_type=='grn') {
                    $grn_amount=$users['sale_pymnt_amount'];
                    $balance-=$grn_amount;
                }
                
                $row[]           =$sale_payment_type;// site_date_time($users['sale_pymnt_added_date_time']);
                $row[]           = $users['sale_pymnt_note'].$add_deposit_link;
                
                $row[]           = $users['sale_pymnt_cheque_no'];
                $row[]           = site_date($users['sale_pymnt_date_time']);
                $row[]           = $users['sale_reference_no'];
                $pymnt_collected = '';
                $checked_status  = '';
                if ($pymnt_collected == 1) {
                    $checked_status = 'checked=\"checked\"';
                } else {
                    $checked_status = '';
                }
				if($users['smp_amount']>0)
                $row[]  = $users['smp_amount'];
				else 
				$row[]  = $grn_amount;//$users['sale_pymnt_amount'];
				
				 $row[]           =$sale_amount;
				  $row[]           =$balance;
				
                $paid   = 0;
                $data[] = $row;
            }
            
            
            }
            
            
            $output = array(
                'data' => $data
            );
           
            
            
            echo json_encode($output);
            
            
            
        } else {
            $output = array(
                'data' => ''
            );
            echo json_encode($output);
        }
        
        
    }
    
    	function array_sort($array, $on, $order=SORT_ASC){

    $new_array = array();
    $sortable_array = array();

    if (count($array) > 0) {
        foreach ($array as $k => $v) {
            if (is_array($v)) {
                foreach ($v as $k2 => $v2) {
                    if ($k2 == $on) {
                        $sortable_array[$k] = $v2;
                    }
                }
            } else {
                $sortable_array[$k] = $v;
            }
        }

        switch ($order) {
            case SORT_ASC:
                asort($sortable_array);
                break;
            case SORT_DESC:
                arsort($sortable_array);
                break;
        }

        foreach ($sortable_array as $k => $v) {
            $new_array[$k] = $array[$k];
        }
    }

    return $new_array;
}

	
	function supplier_balance()
    {
        $this->load->model('Supplier_Model');
        $data['main_menu_name'] = 'reports';
        $data['sub_menu_name']  = 'supplier_balance';
        $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        $data['user_list']      = $this->User_Model->getUsers();
        $data['warehouse']      = $this->Warehouse_Model->get_warehouse_info($this->session->userdata['ss_warehouse_id']);
        $data['suppliers']      = $this->Supplier_Model->get_all_supplier();
        $this->load->view('rep_supplier_balance', $data);
    }
    
        public function rep_cus_balance_sum_list() {
        $search_key = $this->input->post('search');
        $search_key_val = $search_key['value'];
        $start = $this->input->post('start');
        $length = $this->input->post('length');
        $warehouse_id = $this->input->post('warehouse_id');
        $srh_user_id = $this->input->post('srh_user_id');
        $srh_from_date = $this->input->post('srh_from_date');
        $srh_to_date = $this->input->post('srh_to_date');
        $show_all= $this->input->post('show_all');

        $salary_payment_list = $this->Report_Model->rep_cus_balance_sum_list($start, $length, $search_key_val, $srh_user_id, $warehouse_id, $srh_from_date, $srh_to_date,$show_all);
        
        
        $salary_payment_list_count = $this->Report_Model->rep_cus_balance_sum_list('', '', $search_key_val, $srh_user_id, $warehouse_id, $srh_from_date, $srh_to_date,$show_all);

        $totalData = $salary_payment_list_count;
        $totalFiltered = $totalData;

        $data = array();
        $balance_amount = 0;
       
        $no_item=0;
        
       // echo "test";
       // die();
        foreach ($salary_payment_list as $row) {
            
             $sale_total=$row['sale_total'];
             $cus_tot_balance=0;
             $cus_each_sale_balance=0;
             $customer_id=$row['customer_id'];
             $sale_reference_no='';
             $sale_date='';
             $other_details="";
             
             $test="";
             
             if($show_all){ //show summary 
             
                //get tot sale
                 $cus_tot_sale=0;//$row['cus_tot_sale'];
                 $cus_tot_sale=$this->Report_Model->get_total_sale_by_customer_id($customer_id);
                 
                /*
                if($customer_id==1){
                    echo "customer_id:$customer_id , ";
                }
                 */
                 //get_customer_tot_return
                 $cus_tot_return=0;
                //  $cus_tot_return=$this->Report_Model->get_total_return_paid_by_customer_id($customer_id);
                 
                  $cus_tot_paid=0;
                  $cus_tot_paid=$this->Report_Model->get_total_paid_by_customer_id($customer_id);
                  
                  
                   $cus_tot_balance = $cus_tot_sale-$cus_tot_paid-$cus_tot_return;
                   
                  // $cus_tot_balance=-$cus_tot_paid;
                   
                    $test=" ( cus_tot_sale:$cus_tot_sale , cus_tot_paid:$cus_tot_paid , cus_tot_return:$cus_tot_return )";
                    
                    $test='';
                  
                 
             }else{
                 $cus_each_sale_balance=$sale_total;
                 
                 $sale_id=$row['sale_id'];
                 $sale_reference_no="  " .$row['sale_reference_no'];//.""."".$row['sale_id'].")";
                  $sale_date=site_date($row['sale_datetime']);
	            $sale_total=$row['sale_total'];
	            $sl_rtn_id=$row['sl_rtn_id'];
	            $sls_rtn_total_paid=0;
	            if($sl_rtn_id){
		            $sale_rtn_details=$this->Sales_Return_Model->get_sale_return_info($sl_rtn_id);
		        $sls_rtn_total_paid=$sale_rtn_details['sls_rtn_total_paid'];
		        //$sl_rtn_reference_no=$sale_rtn_details['sl_rtn_reference_no'];
		        }
		
			    $total_paid_amount=$this->Sales_Model->get_total_paid_by_sale_id($sale_id);
                 $balance=$sale_total-$sls_rtn_total_paid-$total_paid_amount;
                  $cus_tot_balance = number_format($balance, 2, '.', '');
                  
                  $other_details=" <br/> Invoice No:$sale_reference_no , Date:$sale_date , Amount:$sale_total , Paid :$total_paid_amount , Balance Due : $balance";
             }
             
             
             
            $nestedData = array();
            $no_item++;
           // $cus_tot_balance=10;
            $nestedData[] =$no_item;
            $nestedData[] = $row['cus_name'].$other_details.$test;// . ' ' . $row['user_last_name'];
            $nestedData[] =  $row['cus_phone'];//'';//$row['sp_date'];
            $type = '';
            
            //$nestedData[] ='';// $type;
			// $nestedData[] ='';// $row['sp_note'];
            $nestedData[] =round($cus_tot_balance,2);// number_format($row['sp_amount'], 2, '.', '');
           // $tem_warehouse = $this->Warehouse_Model->get_warehouse_info($row['warehouse_id']);
           // $nestedData[] = $tem_warehouse['name'];

            
			

          //  $nestedData[] ='';// $actionTxtUpdate . $actionTxtDelete;

            $data[] = $nestedData;
        }

        $json_data = array(
            //"draw"            => intval( $requestData['draw'] ),  
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data" => $data
        );

        echo json_encode($json_data);
    }




        public function rep_cus_sum_list() {
        $search_key = $this->input->post('search');
        $search_key_val = $search_key['value'];
        $start = $this->input->post('start');
        $length = $this->input->post('length');
        $warehouse_id = $this->input->post('warehouse_id');
        $srh_user_id = $this->input->post('srh_user_id');
        $srh_from_date = $this->input->post('srh_from_date');
        $srh_to_date = $this->input->post('srh_to_date');
        $show_all= $this->input->post('show_all');
        $customer_id= $this->input->post('customer_id');

        $salary_payment_list = $this->Report_Model->rep_cus_sum_list($start, $length, $search_key_val, $srh_user_id, $warehouse_id, $srh_from_date, $srh_to_date,$show_all,$customer_id);
        
        //	echo $this->db->last_query();
        
        
        $salary_payment_list_count = $this->Report_Model->rep_cus_sum_list('', '', $search_key_val, $srh_user_id, $warehouse_id, $srh_from_date, $srh_to_date,$show_all,$customer_id);

        $totalData = $salary_payment_list_count;
        $totalFiltered = $totalData;

        $data = array();
        $balance_amount = 0;
       
        $no_item=0;
        
       // echo "test";
       // die();
     //  print_r($salary_payment_list);
        foreach ($salary_payment_list as $row) {
            
             $sale_total=$row['sale_total'];
             $cus_tot_balance=0;
             $cus_each_sale_balance=0;
             $customer_id=$row['customer_id'];
             $sale_reference_no='';
             $sale_date='';
             $other_details="";
             
             $test="";
             
             if($show_all){ //show summary 
             
                //get tot sale
                 $cus_tot_sale=0;//$row['cus_tot_sale'];
                 $cus_tot_sale=$this->Report_Model->get_total_sale_by_customer_id_and_daterang($customer_id, $srh_from_date, $srh_to_date);
                 
                
                 
                 //get_customer_tot_return
                 $cus_tot_return=0;
                //  $cus_tot_return=$this->Report_Model->get_total_return_paid_by_customer_id($customer_id);
                 
                  $cus_tot_paid=0;
                  
                  $cus_tot_paid=$this->Report_Model->get_total_paid_by_customer_id($customer_id);
                  
                  
                   $cus_tot_balance = $cus_tot_sale-$cus_tot_paid-$cus_tot_return;
                   
                  // $cus_tot_balance=-$cus_tot_paid;
                   
                    $test=" ( cus_tot_sale:$cus_tot_sale , cus_tot_paid:$cus_tot_paid , cus_tot_return:$cus_tot_return )";
                    
                    $test='';
                  
                 
             }else{
                 $cus_each_sale_balance=$sale_total;
                 
                 $sale_id=$row['sale_id'];
                 $sale_reference_no="  " .$row['sale_reference_no'];//.""."".$row['sale_id'].")";
                  $sale_date=site_date($row['sale_datetime']);
	            $sale_total=$row['sale_total'];
	            $sl_rtn_id=$row['sl_rtn_id'];
	            $sls_rtn_total_paid=0;
	            if($sl_rtn_id){
		            $sale_rtn_details=$this->Sales_Return_Model->get_sale_return_info($sl_rtn_id);
		        $sls_rtn_total_paid=$sale_rtn_details['sls_rtn_total_paid'];
		        //$sl_rtn_reference_no=$sale_rtn_details['sl_rtn_reference_no'];
		        }
		
			    $total_paid_amount=$this->Sales_Model->get_total_paid_by_sale_id($sale_id);
                 $balance=$sale_total-$sls_rtn_total_paid-$total_paid_amount;
                  $cus_tot_balance = number_format($balance, 2, '.', '');
                  
                  $other_details=" <br/> Invoice No:$sale_reference_no , Date:$sale_date , Amount:$sale_total , Paid :$total_paid_amount , Balance Due : $balance";
             }
             
             
             
            $nestedData = array();
            $no_item++;
           // $cus_tot_balance=10;
            $nestedData[] =$no_item;
            $nestedData[] = $row['cus_name'].$other_details.$test;// . ' ' . $row['user_last_name'];
            $nestedData[] =  $row['cus_phone'];//'';//$row['sp_date'];
            $type = '';
            
            //$nestedData[] ='';// $type;
			// $nestedData[] ='';// $row['sp_note'];
            $nestedData[] =round($cus_tot_balance,2);// number_format($row['sp_amount'], 2, '.', '');
           // $tem_warehouse = $this->Warehouse_Model->get_warehouse_info($row['warehouse_id']);
           // $nestedData[] = $tem_warehouse['name'];

            
			

          //  $nestedData[] ='';// $actionTxtUpdate . $actionTxtDelete;

            $data[] = $nestedData;
        }

        $json_data = array(
            //"draw"            => intval( $requestData['draw'] ),  
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data" => $data
        );

        echo json_encode($json_data);
    }


	public function get_product_sn(){
        $str = $this->input->post('search_string');
		$srh_warehouse_id = $this->input->get('srh_warehouse_id');
		$service_item_avalable = $this->input->post('service_item_avalable');
		$cat_srh = $this->input->post('cat_srh');
		$subcategory = $this->input->post('subcategory');
		
		//echo "test";
       // $result = $this->Service_Model->get_product_sn($str);
	 //  $str='';
	   $srh_warehouse_id='';
		 $result=$this->Sales_Model->get_products_list_suggestions_get_by_warehouse_id_2($str,$srh_warehouse_id,$cat_srh,$subcategory);
        echo json_encode($result);
    }
    
    	public function get_product_sn_2(){
        $str = $this->input->post('search_string');
		$srh_warehouse_id = $this->input->get('srh_warehouse_id');
		$service_item_avalable = $this->input->post('service_item_avalable');
		$cat_srh = $this->input->post('cat_srh');
		$subcategory = $this->input->post('subcategory');
		
		//echo "test";
       // $result = $this->Service_Model->get_product_sn($str);
	 //  $str='';
	   $srh_warehouse_id='';
		 $result=$this->Sales_Model->get_products_list_suggestions_get_by_warehouse_id_3($str,$srh_warehouse_id,$cat_srh,$subcategory);
        echo json_encode($result);
    }
    
    
    
	
	
	public function rep_cus_balance_sum() {
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name'] = 'rep_cus_balance_sum';
$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        $this->load->view('rep_cus_balance_sum', $data);
    }
    

	public function rep_member_wise_invoice_details() {
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name'] = 'rep_member_wise_invoice_details';
$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        $this->load->view('rep_member_wise_invoice_details', $data);
    }
    
    	
	public function index()
	{
		$this->load->model('Supplier_Model');
		$data['suppliers'] = $this->Supplier_Model->get_all_supplier();
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = $this->sub_menu_name;
		$this->load->view('rep_reports',$data);
	}
	
	public function opening_balance_get(){
		$srh_from_date=$this->input->post('srh_from_date');
		$srh_to_date=$this->input->post('srh_to_date');
		$warehouse_id=$this->input->post('srh_warehouse_id');
		
		$opening_balance_summ=floatval($this->Report_Model->opening_balance_get($srh_from_date,$srh_to_date,$warehouse_id));
		//$result = $query->row();
		//print_r($result);
		
		echo json_encode(array('opening_balance_summ'=>$opening_balance_summ));
	}
	
	public function bank_deposit_get(){
		$srh_from_date=$this->input->post('srh_from_date');
		$srh_to_date=$this->input->post('srh_to_date');
		$warehouse_id=$this->input->post('srh_warehouse_id');
		
		$bank_deposit_summ=floatval($this->Report_Model->bank_deposit_get($srh_from_date,$srh_to_date,$warehouse_id));
		//$result = $query->row();
		//print_r($result);
		
		echo json_encode(array('bank_deposit_summ'=>$bank_deposit_summ));
	}
	
		public function cash_transfer_get(){
		$srh_from_date=$this->input->post('srh_from_date');
		$srh_to_date=$this->input->post('srh_to_date');
		$warehouse_id=$this->input->post('srh_warehouse_id');
		
		$cash_transfer_summ=floatval($this->Report_Model->cash_transfer_get($srh_from_date,$srh_to_date,$warehouse_id));
		//$result = $query->row();
		//print_r($result);
		
		echo json_encode(array('cash_transfer_summ'=>$cash_transfer_summ));
	}
	
		public function cash_transfer_res_get(){
		$srh_from_date=$this->input->post('srh_from_date');
		$srh_to_date=$this->input->post('srh_to_date');
		$warehouse_id=$this->input->post('srh_warehouse_id');
		
		$cash_transfer_res_summ=floatval($this->Report_Model->cash_transfer_res_get($srh_from_date,$srh_to_date,$warehouse_id));
		//$result = $query->row();
		//print_r($result);
		
		echo json_encode(array('cash_transfer_res_summ'=>$cash_transfer_res_summ));
	}

public function stock_movement(){
	$data['main_menu_name'] = $this->main_menu_name;
	$data['sub_menu_name']='product_reports';
	$data['sub_menu_name_1']='';
    $data['product_list'] = $this->Product_Models->getProductsStockMovReport();
	$data['location_list']=array();//$this->Location_Model->get_all_location_for_dropdown();
	$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
	$data['category_list'] 	= $this->category_models->getCategory();
	$data['sub_category_list']   = $this->category_models->getSubCategory(1);
	$this->load->view('stock_movement',$data);
	}
	public function stock_book(){
	$data['main_menu_name'] = $this->main_menu_name;
	$data['sub_menu_name']='product_reports';
	$data['sub_menu_name_1']='';
	$cat_id=4;
    $data['product_list'] = $this->Product_Models->getProductsStockMovReport('','','','',$cat_id);
	$data['location_list']=array();//$this->Location_Model->get_all_location_for_dropdown();
	$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
	$data['category_list'] 	= $this->category_models->getCategory();
	$data['sub_category_list']   = $this->category_models->getSubCategory(1);
	$this->load->view('stock_book',$data);
	}

	public function transfer_items() {
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'transfer_items';
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$data['rep_list'] = $this->User_Model->getUserstypeByID(5);
		$data['category_list'] 	= $this->category_models->getCategory();
		$this->load->view('transfer_items', $data);
		//  else
		//  show_404();
	}	
	
	   public function list_transfer_items() {
        $requestData = $this->input->post();
        $search_key = $this->input->post('search');
        $search_key_val = $search_key['value'];
        $start = $this->input->post('start');
        $length = $this->input->post('length');
		$srh_from_date = $this->input->post('srh_from_date');
        $srh_to_date = $this->input->post('srh_to_date');
		$srh_warehouse_id = $this->input->post('srh_warehouse_id');
		$srh_sales_rep_id = $this->input->post('srh_sales_rep_id');
		$category = $this->input->post('category');
		
		//get all sales

        $data = array();
        $sales_tot = $this->Report_Model->get_all_transfer('','',$search_key_val,$srh_from_date,$srh_to_date,$srh_warehouse_id,$srh_sales_rep_id,'item_count');
		$sales = $this->Report_Model->get_all_transfer($start,$length,$search_key_val,$srh_from_date,$srh_to_date,$srh_warehouse_id,$srh_sales_rep_id);
	
		$totalData = ($sales_tot);
		$totalFiltered = $totalData;  
		
        //print_r($sales);
        foreach ($sales as $row) {
			
            $nestedData = array();
            $trnsfr_id=$row['trnsfr_id'];
            $nestedData[] = site_date($row['trnsfr_datetime']);
            $nestedData[] = "<center>" . $row['trnsfr_reference_no'] . "</center>";
			//get to warehouse name
			 $ware_house_des=$this->Warehouse_Model->get_warehouse_info($row['trnsfr_to_warehouse_id']);
            $nestedData[] = $ware_house_des['name'];//$row['cus_name'];
            $nestedData[] = $row['trnsfr_total'];
			$nestedData[] = '';//"<left>" . $row['product_name'] . "</left>";
            $actionTxtDisble = '';
            $actionTxtEnable = '';
            $actionTxtUpdate = '';
            $actionTxtDelete = '';
            $nestedData[] = ''; 
			 $nestedData[] = ''; 
			 $nestedData[] ='';
			
            $data[] = $nestedData;
			
			
			//get sale items by sale id
			//$sale_items = $this->Sales_Model->get_all_sale_items('', '', '',$sale_id,$category);
			$trnsfr_item_list= $this->Transfer_Model->get_trnsfr_item_list_by_trnsfr_id($trnsfr_id);
			foreach ($trnsfr_item_list as $sale_items_row) {
				//print_r($sale_items_row);
				$no_of_items=0;
				$trnsfr_itm_id=$sale_items_row['trnsfr_itm_id'];
				$saleItemData = array();
				$saleItemData[] ='';
				$saleItemData[] ='';
				$saleItemData[] ='';
				$saleItemData[] ='';
				$qty=$sale_items_row['trnsfr_itm_quantity'];
				//get returned qty by sale_id and product id
				//$returned_qty_des=$this->Sales_Model->get_returned_qty_by_sale_id_and_product_id($sale_id,$sale_items_row['product_id']);
				$sale_sn_list='';
				//$sale_sn_list="<br/> $sale_id , $sale_item_id";
				// $sn_list=$this->Sales_Model->get_sales_serial_by_id($sale_id,$sale_item_id);
				$sn_list=$this->Transfer_Model->get_transfer_serial_by_id($trnsfr_id,$trnsfr_itm_id);
				if(!empty($sn_list)){
				//echo "<br/> Serial No. ";
				foreach ($sn_list as $sn) { 
				$sale_sn_list.=" $sn->tis_number , ";
				
				}
				}
				
				if($sale_sn_list) $sale_sn_list="<br/> Emei: ".$sale_sn_list;
				
				
				//print_r($returned_qty_des);
				$returned_qty=0;
				$returned_dis_text='';
				$balance_qty=0;
				//$returned_qty=intval($returned_qty_des->quantity);
				//if($returned_qty){
				//	$returned_dis_text="  <span class='label label-danger'>$returned_qty Item(s) Returned</span>";
				//}
				
				$balance_qty=$sale_items_row['trnsfr_itm_quantity']-$returned_qty;
				
				$no_of_items=$no_of_items+$balance_qty;
				
				$cal_class_1='';
				$cal_class_2='';
				//if($sale_items_row['cat_id']==3)
				{
					$cal_class_1="";//"<span class='label label-success'>";
					$cal_class_2="";//"</span>";
				}
				$saleItemData[] ="<left>$cal_class_1".$sale_items_row['product_name'].' ('. $sale_items_row['product_code'].") X ($qty) $cal_class_1 $returned_dis_text $sale_sn_list</left>";
				if($this->session->userdata('ss_group_id')==1){
				$saleItemData[] ='';//number_format($balance_qty*$sale_items_row['item_cost'], 2, '.', '');
				}else{
					$saleItemData[] ='';
				}
				$val_tmp=1;
				$qty_tmp=$qty;
				if($qty==0.00)
				{
				    
				    $qty_tmp=1;
				}
				
				if(!empty($qty)){
				$val_tmp=($sale_items_row['trnsfr_itm_unit_price']/$qty_tmp);//*$balance_qty;
				}
				$saleItemData[] =number_format($val_tmp, 2, '.', '');
				$saleItemData[] =$no_of_items;
				//	
				$data[] = $saleItemData;			
			}
			

			
			
        }

        $json_data = array(
           // "draw" => intval($requestData['draw']),
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data" => $data
        );

        echo json_encode($json_data);
    }

	
	
public function get_list_payments_for_report()	
{
	       
	        $data = array();
			//print_r($values);
		$srh_to_date='';
		$srh_from_date='';
		$srh_warehouse_id=$this->input->post('srh_warehouse_id');
		$srh_type=$this->input->post('srh_type');
		$srh_payment_term=$this->input->post('srh_payment_term');
		$ss_user_id=$this->input->post('ss_user_id');
		if($this->input->post('srh_to_date')){
			$srh_to_date=date('Y-m-d', strtotime($this->input->post('srh_to_date')));
		}
		if($this->input->post('srh_from_date')){
			$srh_from_date=date('Y-m-d', strtotime($this->input->post('srh_from_date')));
		}
		
		$srh_type='sale';
		
	//	echo "test 1";
		
		 $values = $this->Sales_Model->getPaymentsForPrint($srh_warehouse_id,$srh_to_date,$srh_from_date,$srh_type,$srh_payment_term,$ss_user_id);
		 
		 
		 //	echo "test 2";
		 
	 //echo $this->db->last_query();
		 
		 
		 
	//	 die();
		 
		
			$columns = array( 
		0 =>'bkng_id', 
		1 => 'bkng_id',
		2=> 'bkng_id',
		3 =>'bkng_id', 
		4 => 'bkng_id',
		5=> 'bkng_id',
		6=> 'bkng_id',
		7=> 'bkng_id',
		8=> 'bkng_id'
		);
	        if (!empty($values)) {
	            foreach ($values as $users) {
					$invoice_no='';
					$display=false;
					if($users->sale_payment_type=='sale'){
						$invoice_no=$users->sale_reference_no;
						$display=true;
					}else if($users->sale_payment_type=='sales_return'){
						//get sales return ref no
						$sales_return_des=$this->Sales_Return_Model->get_sale_return_info($users->sale_id);
						$invoice_no=$sales_return_des['sl_rtn_reference_no'];
						$warehouse_id_sales_rtn=$sales_return_des['warehouse_id'];
						if($warehouse_id_sales_rtn==$srh_warehouse_id){
							$display=true;
						}else {
							$display=false;
						}
					}
					
					if($display){
					
	            $row = array();
					$bkng_id=$users->sale_id;
					$paymnt_id=$users->sale_pymnt_id;
					  $row[] = sprintf("%04d", $users->sale_pymnt_id);
					  //$row[] = ($users->sale_pymnt_date_time);
					  $row[] = site_date($users->sale_pymnt_added_date_time);
					   $row[] = $invoice_no."-".date('d/m/Y', strtotime($users->sale_datetime)); ;
					  
					   
					// checked="checked"
					$pymnt_collected='';
					$checked_status='';
					if($pymnt_collected==1) {
						$checked_status='checked=\"checked\"';
					}else {
						$checked_status='';
					}
					/*
					  $row[] = "<label class=\"checkbox-inline\">
										<input id=\"collected_$paymnt_id\" type=\"checkbox\" class=\"flat-red\" value=\"$paymnt_id\" onchange=\"changeColectedStatus($paymnt_id,this.checked)\" $checked_status>
										Collected
									</label>";	
									
							
									
*/
						$returned_text='';
						if($users->sale_pymnt_cheque_rtn_status==1)
						{
							$returned_text='Returned';
						}
						$sale_pymnt_amount=$users->sale_pymnt_amount;
						$credit_card_interest_rate=0.03;//3%
						$credit_card_interest=0;
						if($users->sale_pymnt_paying_by=='Credit Card'){
							if($users->extra_val_1){
								$credit_card_interest=$sale_pymnt_amount*$credit_card_interest_rate;
							}
						}
						
						 $row[] =  $users->cus_name;
						 $row[] =  $users->sale_payment_type;
						 $row[] =  $users->sale_pymnt_paying_by;
						  $row[] = number_format($users->sale_pymnt_amount, 2, '.', '');
						   $row[] = number_format($credit_card_interest, 2, '.', '');
						    $row[] = $users->sale_pymnt_amount;	
							 $row[] = $returned_text;	
                      		$paid=0;
							//$paid=$this->Booking_Model->get_total_paid_by_booking_id($bkng_id);
						//$row[] =number_format($paid, 2, '.', ',');
						
							//$row[] =number_format($users->bkng_tot_amount-$paid, 2, '.', ',');
				
				//$row[]=$actionTxtUpdate.$actionTxtDisble.$actionTxtEnable.$actionTxtPw.$actionTxtDelete;
	
	                $data[] = $row;
					}
	            }


	            $output = array('data' =>$data);
	            echo json_encode($output);
	        }else{
	            $output = array('data' =>'');
	            echo json_encode($output);

	        }

}
	public function print_product_code_popup()
	{
		$data['main_menu_name'] = 'reports';
		$cat_srh=$this->uri->segment(3);
		$sub_cat_srh=$this->uri->segment(4);
		$data['product_list'] = $this->Product_Models->getProductsProduCodePrint($cat_srh,$sub_cat_srh);
		$this->load->view('models/print_product_code_popup',$data);
		
	}
	
		public function print_product_barcode_list_popup()
	{
		$data['main_menu_name'] = 'reports';
		$cat_srh=$this->uri->segment(3);
		$sub_cat_srh=$this->uri->segment(4);
		$data['product_list'] = $this->Product_Models->getProductsProduCodePrint($cat_srh,$sub_cat_srh);
		$this->load->view('models/print_product_barcode_list_popup.php',$data);
		
	}
	
	public function print_product_code_list_popup()
	{
		$data['main_menu_name'] = 'reports';
		$cat_srh=$this->uri->segment(3);
		$sub_cat_srh=$this->uri->segment(4);
		$data['product_list'] = $this->Product_Models->getProductsProduCodePrint($cat_srh,$sub_cat_srh);
		$this->load->view('models/print_product_code_list_popup',$data);
		
	}
	
	public function print_product_code()
	{
		$this->load->model('category_models');
		$data['main_menu_name'] = 'reports';
		$data['sub_menu_name'] = 'print_product_code';
		
		$cat_srh=$this->input->post('cat_srh');
		$sub_cat_srh=$this->input->post('cat_srh');
		
		
		$data['category_list'] 	= $this->category_models->getCategory();
		// $data['sub_category_list']   = $this->category_models->getSubCategory(1);
		
		$this->load->view('rep_product_code_print',$data);
		
		
			
	}
	
	public function get_list_product_for_code_print($value='')
	{
		$cat_srh=$this->input->post('cat_srh');
		$sub_cat_srh=$this->input->post('sub_cat_srh');
		
			$this->load->model('Product_Models');
	        $values = $this->Product_Models->getProductsProduCodePrint($cat_srh,$sub_cat_srh);
	        $data = array();

	        if (!empty($values)) {
	            foreach ($values as $products) {

	            if ($products->product_status == 0) {$k = "btn-warning";$m = "fa-minus-circle";} else {$k = "btn-green";$m = "fa-check";}
				$retVal = (empty($products->sub_cat_name)) ? "--:--" : $products->sub_cat_name ;

	            $row = array();
				
				
				 $row = array();
				
				 
                  $row[] = $products->product_code;
	                $row[] = $products->product_name;
					 $row[] = $products->cat_name;//. " ($products->supp_code)";
					  $row[] = $products->sub_cat_name;
					  
					
	                //$row[] = $transferd_qty;
	                $data[] = $row;
	            }

	            $output = array('data' =>$data);
	            echo json_encode($output);
	        }else{
	            $output = array('data' =>'');
	            echo json_encode($output);

	        }
	}
	
	public function user_activitie(){
		$data['main_menu_name'] = 'reports';
		$data['sub_menu_name'] = 'user_activitie';
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$this->load->view('rep_user_activitie',$data);
	}

	public function sale_interest(){
		$data['main_menu_name'] = 'reports';
		$data['sub_menu_name'] = 'user_activitie';
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$this->load->view('rep_sale_interest',$data);
	}

	
	public function get_list_user_activitie_for_print($value='')
	{
		$this->load->model('User_Model');
		//print_r($_REQUEST);
		$srh_to_date='';
		$srh_from_date='';
		$srh_warehouse_id=$this->input->post('srh_warehouse_id');
		if($this->input->post('srh_to_date')){
			$srh_to_date=date('Y-m-d H:i:s', strtotime($this->input->post('srh_to_date')));
		}
		if($this->input->post('srh_from_date')){
			$srh_from_date=date('Y-m-d H:i:s', strtotime($this->input->post('srh_from_date')));
		}
		$this->load->model('Sales_Model');
		$columns = array( 
		0 =>'id', 
		1 => 'id',
		2=> 'id',
		3 =>'id', 
		4 => 'id',
	
	);
	$data = array();
	$grn_data = $this->User_Model->get_all_user_activitie_for_report($srh_warehouse_id,$srh_to_date,$srh_from_date);
	$totalData = count($grn_data);
	$totalFiltered = $totalData;  
	
	foreach ($grn_data as $row){
		$nestedData=array(); 
		$id=$row['id'];
		$nestedData[] =$row['id'];
		$nestedData[] =$row['details'];
		/*$nestedData[]=$row['page'];*/ 
		$nestedData[] = $row['user_first_name'];
		$nestedData[] =display_date_time_format($row['datetime']);

	$data[] = $nestedData;
}

	$json_data = array(
			//"draw"            => intval( $requestData['draw'] ),  
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data 
			);

	echo json_encode($json_data);
	}



	
	public function get_list_sale_interest($value='')
	{
		//$this->load->model('User_Model');
		//print_r($_REQUEST);
		$srh_to_date='';
		$srh_from_date='';
		$srh_warehouse_id=$this->input->post('srh_warehouse_id');
		if($this->input->post('srh_to_date')){
			$srh_to_date=date('Y-m-d', strtotime($this->input->post('srh_to_date')));
		}
		if($this->input->post('srh_from_date')){
			$srh_from_date=date('Y-m-d', strtotime($this->input->post('srh_from_date')));
		}
		//$this->load->model('Sales_Model');
		$columns = array( 
		0 =>'id', 
		1 => 'id',
		2=> 'id',
		3 =>'id', 
		4 => 'id',
	);
	$data = array();
	$grn_data = $this->Sales_Model->get_list_sale_interest($srh_warehouse_id,$srh_to_date,$srh_from_date);
	$totalData = count($grn_data);
	$totalFiltered = $totalData;  
	foreach ($grn_data as $row){
		$nestedData=array(); 
		$id=$row['si_id'];
		$nestedData[] =$row['si_id'];
		$nestedData[] =$row['sale_reference_no'];
		$nestedData[] =$row['si_amount'];
		/*$nestedData[]=$row['page'];*/ 
		$nestedData[] = $row['si_remark'];
		$nestedData[] =display_date_time_format($row['si_added']);

	$data[] = $nestedData;
	}
	
	$grn_data = $this->Sales_Model->get_list_sale_current_interest($srh_warehouse_id,$srh_to_date,$srh_from_date);
	$totalData = count($grn_data)+$totalData;
	$totalFiltered = $totalData;  
	foreach ($grn_data as $row){
		$nestedData=array(); 
		$id='';//$row['si_id'];
		$nestedData[] ='';
		$nestedData[] =$row['sale_reference_no'];
		$nestedData[] =$row['current_interest'];
		/*$nestedData[]=$row['page'];*/ 
		$nestedData[] = $row['current_interest_remark'];
		$nestedData[] =display_date_time_format($row['current_interest_date']);

	$data[] = $nestedData;
	}
	
	

	$json_data = array(
			//"draw"            => intval( $requestData['draw'] ),  
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data 
			);

	echo json_encode($json_data);
	}
		
	public function grn()
	{
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'grn';
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$data['supplier_list'] = $this->Purchases_Model->get_supplier();
		$this->load->view('rep_grn',$data);
	}
	
	public function get_list_grn_for_print($value='')
	{
		$this->load->model('Purchases_Model');
		//print_r($_REQUEST);
		$srh_to_date='';
		$srh_from_date='';
		$srh_warehouse_id=$this->input->post('srh_warehouse_id');
		$srh_supplier_id=$this->input->post('srh_supplier_id');
		$srh_payment_status=$this->input->post('srh_payment_status');
		
		if($this->input->post('srh_to_date')){
			$srh_to_date=date('Y-m-d', strtotime($this->input->post('srh_to_date')));
		}
		if($this->input->post('srh_from_date')){
			$srh_from_date=date('Y-m-d', strtotime($this->input->post('srh_from_date')));
		}
		
		$this->load->model('Sales_Model');
		$columns = array( 
		0 =>'sale_datetime', 
		1 => 'sale_reference_no',
		2=> 'cus_name',
		3 =>'sale_id', 
		4 => 'sale_id',
		5=> 'sale_id'
	);
	$data = array();
	$grn_data = $this->Purchases_Model->get_all_grn_for_report($srh_warehouse_id,$srh_to_date,$srh_from_date,'','',$srh_supplier_id);
	$totalData = count($grn_data);
	$totalFiltered = $totalData;  
	
	foreach ($grn_data as $row){
		
		
		$p_status='';
		$total_paid_amount=$row['grn_total_paid'];
		if (empty($total_paid_amount)) {
		  $pay_st = '<span class="label label-warning">Pending</span>';
		  $p_status='Pending';
		}else{
		  if ($total_paid_amount >= $row['grand_total']) {
			$pay_st = '<span class="label label-success">Paid</span>';
			$p_status='Paid';
		  }else{
			$pay_st = '<span class="label label-info">Partial</span>';
			$p_status='Partial';
		  }
		}
		
		if($srh_payment_status){
			if($srh_payment_status==$p_status)
		{
		$nestedData=array(); 
		$id=$row['id'];
		$nestedData[] =site_date($row['date']);
		$nestedData[] = $row['reference_no'];
		$nestedData[] = $row['supp_company_name'];	
	//	$nestedData[]=$pay_st;
		$nestedData[] = number_format($row['grand_total'], 2, '.', '');
	//	$nestedData[] = number_format($total_paid_amount, 2, '.', '');
	//	$nestedData[] = number_format($row['grand_total']-$total_paid_amount, 2, '.', '');
		$data[] = $nestedData;
		}}
		else {
			$nestedData=array(); 
		$id=$row['id'];
		$nestedData[] =site_date($row['date']);
		$nestedData[] = $row['reference_no'];
		$nestedData[] = $row['supp_company_name'];	
	//	$nestedData[]=$pay_st;
		$nestedData[] = number_format($row['grand_total'], 2, '.', '');
	//	$nestedData[] = number_format($total_paid_amount, 2, '.', '');
	//	$nestedData[] = number_format($row['grand_total']-$total_paid_amount, 2, '.', '');
		$data[] = $nestedData;
		}
		
		
		
}

	$json_data = array(
			//"draw"            => intval( $requestData['draw'] ),  
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data 
			);

	echo json_encode($json_data);
	}
	
	

	public function print_grn()
	{
		
		$this->load->model('Purchases_Model');
		$this->load->model('Supplier_Model');
		$srh_to_date='';
		$srh_from_date='';
		$srh_warehouse_id=$this->input->get('srh_warehouse_id');
		$srh_supplier_id=$this->input->get('srh_supplier_id');
		$srh_payment_status=$this->input->get('srh_payment_status');
		$data['srh_payment_status']=$srh_payment_status;
		//echo "$srh_warehouse_id";
		if($this->input->get('srh_to_date')){
			$srh_to_date=date('Y-m-d H:i:s', strtotime($this->input->get('srh_to_date')));
		}
		if($this->input->get('srh_from_date')){
			$srh_from_date=date('Y-m-d H:i:s', strtotime($this->input->get('srh_from_date')));
		}
		$this->load->model('Sales_Model');
		//$data['sales_list'] = $this->Sales_Model->get_all_sales_for_print_sales();
		$data['grn_list'] = $this->Purchases_Model->get_all_grn_for_report($srh_warehouse_id,$srh_to_date,$srh_from_date,'','',$srh_supplier_id);
		
		$srh_supplier_name='';
		
		if($srh_warehouse_id){
			$warehouse_details=$this->Warehouse_Model->get_warehouse_info($srh_warehouse_id);
			$data['warehouse_details']=$warehouse_details;
			$data['srh_warehouse_name']=$warehouse_details['name'];
		}else {
			$data['srh_warehouse_name']="-All-";
		}
		if($srh_supplier_id){
			$supplier_details=$this->Supplier_Model->get_supplier_info($srh_supplier_id);
			
			$srh_supplier_name=$supplier_details['supp_company_name'];
		}
		$data['srh_supplier_name']=$srh_supplier_name;
		if($srh_to_date){
			$data['srh_to_date_dis']=display_date_time_format($srh_to_date);
		}else {
			$data['srh_to_date_dis']='';	
		}
		if($srh_from_date){
			$data['srh_from_date_dis']=display_date_time_format($srh_from_date);
		}else {
			$data['srh_from_date_dis']='';	
		}
		
		
		
		$this->load->view('models/print_grn',$data);
	}
	

	public function daily_sales()
	{
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'daily_sales';
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$data['rep_list'] = $this->User_Model->getUserstypeByID();
		$this->load->view('rep_sales_daily',$data);
	}	

	public function sales()
	{
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'sales';
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$data['customer_list'] = $this->Customer_Model->get_all_customers();
		$this->load->view('rep_sales',$data);
	}


	public function sales_rep()
	{
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'sales_rep';
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$data['customer_list'] = array();//$this->Customer_Model->get_all_customers();
		//$data['rep_list'] = $this->User_Model->getUserstypeByID(2);
		$data['rep_list'] = $this->User_Model->getSalesRep();
		//print_r($data['rep_list']);
		
		$this->load->view('rep_sales_rep',$data);
	}
	
	
	
	public function sales_assistant_wise_sales_summary()
	{
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'sales_assistant_wise_sales_summary';
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$data['customer_list'] = array();//$this->Customer_Model->get_all_customers();
		//$data['rep_list'] = $this->User_Model->getUserstypeByID(2);
		$data['rep_list'] = $this->User_Model->getSalesRep();
		//print_r($data['rep_list']);
		
		$this->load->view('sales_assistant_wise_sales_summary',$data);
	}
	
	public function sales_rep_comm()
	{
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'sales_rep_comm';
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$data['customer_list'] = array();//$this->Customer_Model->get_all_customers();
		$data['rep_list'] = $this->User_Model->getUserstypeByID();
		//print_r($data['rep_list']);
		
		$this->load->view('rep_sales_rep_comm',$data);
	}
		
	public function print_sale()
	{
		$srh_to_date='';
		$srh_from_date='';
		$srh_warehouse_id=$this->input->get('srh_warehouse_id');
		$srh_customer_id=$this->input->get('srh_customer_id');
		//echo "cus id:".$srh_customer_id;
		$srh_payment_status=$this->input->get('srh_payment_status');  
		$data['srh_payment_status']=$srh_payment_status;
		if($this->input->get('srh_to_date')){
			$srh_to_date=date('Y-m-d', strtotime($this->input->get('srh_to_date')));
		}
		if($this->input->get('srh_from_date')){
			$srh_from_date=date('Y-m-d', strtotime($this->input->get('srh_from_date')));
		}
		$this->load->model('Sales_Model');
		//$data['sales_list'] = $this->Sales_Model->get_all_sales_for_print_sales();
		$data['sales_list'] = $this->Sales_Model->get_all_sales_for_report($srh_warehouse_id,$srh_to_date,$srh_from_date,'','','',$srh_customer_id);
		
		
		
		$srh_customer_name='';
		
		if($srh_customer_id){
			$customer_details=$this->Customer_Model->get_customer_info($srh_customer_id);
			//$data['customer_details']=$customer_details;
			$data['srh_customer_name']=$customer_details['cus_name'];
		}else {
			$data['srh_customer_name']="-All-";
		}
		
		if($srh_warehouse_id){
			$warehouse_details=$this->Warehouse_Model->get_warehouse_info($srh_warehouse_id);
			$data['srh_warehouse_name']=$warehouse_details['name'];
			$data['warehouse_details']=$warehouse_details;
		}else {
			$data['srh_warehouse_name']="-All-";
		}
		if($srh_to_date){
			$data['srh_to_date_dis']=($srh_to_date);
		}else {
			$data['srh_to_date_dis']='';	
		}
		if($srh_from_date){
			$data['srh_from_date_dis']=($srh_from_date);
		}else {
			$data['srh_from_date_dis']='';	
		}
		
		$this->load->view('models/print_sale',$data);
	}
	
	public function suppliers()
	{
		$this->load->model('Supplier_Model');
		$data['suppliers'] = $this->Supplier_Model->get_all_supplier();
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = $this->sub_menu_name;
		$this->load->view('rep_suppliers',$data);
	}
	
	public function print_supplier()
	{
		$this->load->model('Supplier_Model');
		$data['suppliers_list'] = $this->Supplier_Model->get_all_supplier();

		$this->load->view('models/print_supplier',$data);
	}
	
	public function item_avalable()
	{
		$this->load->model('Product_Models');
		$this->load->model('category_models');
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$data['product_list'] = '';//$this->Product_Models->getProducts();
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'item_avalable';
		$data['category_list'] 	= $this->category_models->getCategory();
		$this->load->view('item_avalable',$data);
	}
	
		public function stock_book_2()
	{
		$this->load->model('Product_Models');
		$this->load->model('category_models');
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$data['product_list'] = '';//$this->Product_Models->getProducts();
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'stock_book_2';
		$data['category_list'] 	= $this->category_models->getCategory();
		$this->load->view('stock_book_2',$data);
	}
	
	public function products()
	{
		$this->load->model('Product_Models');
		$this->load->model('category_models');
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$data['product_list'] = '';//$this->Product_Models->getProducts();
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'products';
		$data['category_list'] 	= $this->category_models->getCategory();
		$data['department_list'] 	= $this->Department_Model->get_all_department_list();
		$data['type_list'] 	= $this->Department_Model->get_all_type_list();
		$data['sub_category']   = $this->category_models->getSubCategory();
		
		$data['pro_model_list']   = $this->category_models->getProductModel();
           
           $data['pro_color_list']   = $this->category_models->getProductColor();
            $data['pro_capacity_list']   = $this->category_models->getProductCapacity();


		$this->load->view('rep_products',$data);
	}
	
	
		public function warehouse_wise_product_summary()
	{
		$this->load->model('Product_Models');
		$this->load->model('category_models');
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$data['product_list'] = '';//$this->Product_Models->getProducts();
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'products';
		$data['category_list'] 	= $this->category_models->getCategory();
		$data['department_list'] 	= $this->Department_Model->get_all_department_list();
		$data['type_list'] 	= $this->Department_Model->get_all_type_list();
		$data['sub_category']   = $this->category_models->getSubCategory();
		$data['pro_model_list']   = $this->category_models->getProductModel();
           
           $data['pro_color_list']   = $this->category_models->getProductColor();
		$this->load->view('warehouse_wise_product_summary',$data);
	}
	
		public function products_sm()
	{
		$this->load->model('Product_Models');
		$this->load->model('category_models');
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$data['product_list'] = '';//$this->Product_Models->getProducts();
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'products_sm';
		$data['category_list'] 	= $this->category_models->getCategory();
		$data['department_list'] 	= $this->Department_Model->get_all_department_list();
		$data['type_list'] 	= $this->Department_Model->get_all_type_list();
		$data['sub_category']   = $this->category_models->getSubCategory();
		$this->load->view('rep_products_sm',$data);
	}
	
		public function dynamic_stock_report()
	{
		$this->load->model('Product_Models');
		$this->load->model('category_models');
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$data['product_list'] = '';//$this->Product_Models->getProducts();
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'dynamic_stock_report';
		$data['category_list'] 	= $this->category_models->getCategory();
		$data['department_list'] 	= $this->Department_Model->get_all_department_list();
		$data['type_list'] 	= $this->Department_Model->get_all_type_list();
		$data['sub_category']   = $this->category_models->getSubCategory();
		$this->load->view('dynamic_stock_report',$data);
	}
	
	
	
	
		public function products_iw()
	{
		$this->load->model('Product_Models');
		$this->load->model('category_models');
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$data['product_list'] = '';//$this->Product_Models->getProducts();
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'products_iw';
		$data['category_list'] 	= $this->category_models->getCategory();
		$data['department_list'] 	= $this->Department_Model->get_all_department_list();
		$data['type_list'] 	= $this->Department_Model->get_all_type_list();
		$this->load->view('rep_products_iw',$data);
	}
	
	
		public function products_iw_v2()
	{
		$this->load->model('Product_Models');
		$this->load->model('category_models');
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$data['product_list'] = '';//$this->Product_Models->getProducts();
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'products_iw_v2';
		$data['category_list'] 	= $this->category_models->getCategory();
		$data['department_list'] 	= $this->Department_Model->get_all_department_list();
		$data['type_list'] 	= $this->Department_Model->get_all_type_list();
		$this->load->view('products_iw_v2',$data);
	}
	
			public function products_iw_v3()
	{
		$this->load->model('Product_Models');
		$this->load->model('category_models');
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$data['product_list'] = '';//$this->Product_Models->getProducts();
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'products_iw_v3';
		$data['category_list'] 	= $this->category_models->getCategory();
		$data['department_list'] 	= $this->Department_Model->get_all_department_list();
		$data['type_list'] 	= $this->Department_Model->get_all_type_list();
		$data['sub_category']   = $this->category_models->getSubCategory();
		$this->load->view('products_iw_v3',$data);
	}
	
	
		public function department_wise_gross_profit_report()
	{
		$this->load->model('Product_Models');
		$this->load->model('category_models');
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$data['product_list'] = '';//$this->Product_Models->getProducts();
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'department_wise_gross_profit_report';
		$data['category_list'] 	= $this->category_models->getCategory();
		$data['department_list'] 	= $this->Department_Model->get_all_department_list();
		$data['type_list'] 	= $this->Department_Model->get_all_type_list();
		$this->load->view('rep_department_wise_gross_profit_report',$data);
	}
	
		public function department_wise_gross_profit_filter_report()
	{
		$this->load->model('Product_Models');
		$this->load->model('category_models');
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$data['product_list'] = '';//$this->Product_Models->getProducts();
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'department_wise_gross_profit_filter_report';
		$data['category_list'] 	= $this->category_models->getCategory();
		$data['department_list'] 	= $this->Department_Model->get_all_department_list();
		$data['type_list'] 	= $this->Department_Model->get_all_type_list();
		$this->load->view('department_wise_gross_profit_filter_report',$data);
	}
	
	public function rep_wise_sales_summary_report()
	{
		$this->load->model('Product_Models');
		$this->load->model('category_models');
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$data['product_list'] = '';//$this->Product_Models->getProducts();
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'department_wise_gross_profit_filter_report';
		$data['category_list'] 	= $this->category_models->getCategory();
		$data['department_list'] 	= $this->Department_Model->get_all_department_list();
		$data['type_list'] 	= $this->Department_Model->get_all_type_list();
		$this->load->view('rep_wise_sales_summary_report',$data);
	}
	
		public function sales_assistant_wise_department_sales_summary()
	{
		$this->load->model('Product_Models');
		$this->load->model('category_models');
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$data['product_list'] = '';//$this->Product_Models->getProducts();
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'sales_assistant_wise_department_sales_summary';
		$data['category_list'] 	= $this->category_models->getCategory();
		$data['department_list'] 	= $this->Department_Model->get_all_department_list();
		$data['rep_list'] = $this->User_Model->getUserstypeByID();
		$data['type_list'] 	= $this->Department_Model->get_all_type_list();
		$this->load->view('sales_assistant_wise_department_sales_summary',$data);
	}
	
	
	public function dep_wise_pro_cost_summ()
	{
		$this->load->model('Product_Models');
		$this->load->model('category_models');
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$data['product_list'] = '';//$this->Product_Models->getProducts();
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'dep_wise_pro_cost_summ';
		$data['category_list'] 	= $this->category_models->getCategory();
		$data['department_list'] 	= $this->Department_Model->get_all_department_list();
		$data['type_list'] 	= $this->Department_Model->get_all_type_list();
		$this->load->view('dep_wise_pro_cost_summ',$data);
	}
	
		public function supplier_wise_gross_profit_report()
	{
		$this->load->model('Product_Models');
		$this->load->model('category_models');
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$data['product_list'] = '';//$this->Product_Models->getProducts();
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'supplier_wise_gross_profit_report';
		$data['category_list'] 	= $this->category_models->getCategory();
		$data['department_list'] 	= $this->Department_Model->get_all_department_list();
		$data['type_list'] 	= $this->Department_Model->get_all_type_list();
		$data['supplier_list']=$this->Purchases_Model->get_supplier();
		
		$this->load->view('rep_supplier_wise_gross_profit_report',$data);
	}
	
	
		public function products_supp()
	{
		$this->load->model('Product_Models');
		$this->load->model('category_models');
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$data['product_list'] = '';//$this->Product_Models->getProducts();
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'products_supp';
		$data['category_list'] 	= $this->category_models->getCategory();
		$data['department_list'] 	= $this->Department_Model->get_all_department_list();
		$data['supplier'] = $this->Purchases_Model->get_supplier();
		$data['sub_category']   = $this->category_models->getSubCategory();
		$data['type_list'] 	= $this->Department_Model->get_all_type_list();
		$this->load->view('rep_products_supp',$data);
	}
	
	
			public function products_sales_supp()
	{
		$this->load->model('Product_Models');
		$this->load->model('category_models');
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$data['product_list'] = '';//$this->Product_Models->getProducts();
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'products_sales_supp';
		$data['category_list'] 	= $this->category_models->getCategory();
		$data['department_list'] 	= $this->Department_Model->get_all_department_list();
		$data['supplier'] = $this->Purchases_Model->get_supplier();
		$data['type_list'] 	= $this->Department_Model->get_all_type_list();
		$this->load->view('rep_products_sales_supp',$data);
	}
	
	
		public function sales_assistant_wise_sales_item_summary()
	{
		$this->load->model('Product_Models');
		$this->load->model('category_models');
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$data['product_list'] = '';//$this->Product_Models->getProducts();
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'sales_assistant_wise_sales_item_summary';
		$data['category_list'] 	= $this->category_models->getCategory();
		$data['department_list'] 	= $this->Department_Model->get_all_department_list();
		$data['supplier'] = $this->User_Model->getUsers();
		$data['type_list'] 	= $this->Department_Model->get_all_type_list();
		$this->load->view('sales_assistant_wise_sales_item_summary',$data);
	}
	
			public function products_purchase_supp()
	{
		$this->load->model('Product_Models');
		$this->load->model('category_models');
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$data['product_list'] = '';//$this->Product_Models->getProducts();
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'products_purchase_supp';
		$data['category_list'] 	= $this->category_models->getCategory();
		$data['department_list'] 	= $this->Department_Model->get_all_department_list();
		$data['supplier'] = $this->Purchases_Model->get_supplier();
		$data['type_list'] 	= $this->Department_Model->get_all_type_list();
		$this->load->view('rep_products_purchase_supp',$data);
	}
	
	
			public function fast_slow_movement_report()
	{
		$this->load->model('Product_Models');
		$this->load->model('category_models');
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$data['product_list'] = '';//$this->Product_Models->getProducts();
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'fast_slow_movement_report';
		$data['category_list'] 	= $this->category_models->getCategory();
		$data['department_list'] 	= $this->Department_Model->get_all_department_list();
		$data['sub_category']   = $this->category_models->getSubCategory();
		$data['supplier'] = $this->Purchases_Model->get_supplier();
		$data['type_list'] 	= $this->Department_Model->get_all_type_list();
		$this->load->view('fast_slow_movement_report',$data);
	}
	
	public function products_quantity()
	{
		$this->load->model('Product_Models');
		$this->load->model('category_models');
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$data['product_list'] = $this->Product_Models->getProducts();
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'products_quantity';
		$data['category_list'] 	= $this->category_models->getCategory();
		$this->load->view('rep_products_quantity',$data);
	}
	
	public function supplier_products()
	{
		$this->load->model('Product_Models');
		$this->load->model('purchases_model');
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$data['product_list'] = $this->Product_Models->getProducts();
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'supplier_products';
		$data['supplier_list']=$this->purchases_model->get_supplier();
		
		$this->load->view('rep_supplier_products',$data);
	}
	
	public function alert_quantity()
	{
		$this->load->model('Product_Models');
		$this->load->model('category_models');
		$data['category_list'] 	= $this->category_models->getCategory();
		
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$data['product_list'] = array();//$this->Product_Models->getProducts();
		$data['main_menu_name'] = 'alert_quantity';
		$data['sub_menu_name'] = 'alert_quantity';
		$this->load->view('rep_alert_quantity',$data);
	}
	
	public function print_products()
	{
		$this->load->model('Product_Models');
		
		$data['product_list'] = $this->Product_Models->getProducts();
		$this->load->view('models/print_products',$data);
	}
	
	public function print_alert_quantity()
	{
		$this->load->model('Product_Models');
		
		$data['product_list'] = $this->Product_Models->getProducts();
		$this->load->view('models/print_alert_quantity',$data);
	}

	public function get_list_sales_for_print($value='')
	{
		//print_r($_REQUEST);
		$srh_to_date='';
		$srh_from_date='';
		$srh_warehouse_id=$this->input->post('srh_warehouse_id');
		$srh_customer_id=$this->input->post('srh_customer_id');
		$srh_sales_rep_id=$this->input->post('srh_sales_rep_id');
		$srh_payment_status=$this->input->post('srh_payment_status');
		if($this->input->post('srh_to_date')){
			$srh_to_date = date('Y-m-d', strtotime($this->input->post('srh_to_date')));
			//$srh_to_date=date('Y-m-d', strtotime($srh_to_date);
		}
		if($this->input->post('srh_from_date')){
			$srh_from_date=date('Y-m-d', strtotime($this->input->post('srh_from_date')));
		}
		
		
		
		$this->load->model('Sales_Model');
		$columns = array( 
		0 =>'sale_datetime', 
		1 => 'sale_reference_no',
		2=> 'cus_name',
		3 =>'sale_id', 
		4 => 'sale_id',
		5=> 'sale_id'
	);
	
	$data = array();

	
	
	$sales = $this->Sales_Model->get_all_sales_for_report($srh_warehouse_id,$srh_to_date,$srh_from_date,'','','',$srh_customer_id,$srh_sales_rep_id);
	//echo $this->db->last_query();
	$totalData = count($sales);
	$totalFiltered = $totalData;  
	
	foreach ($sales as $row){
		$nestedData=array(); 
		$p_status='';
		$pay_st ='';
		$sale_id=$row['sale_id'];
		$total_paid_amount=0;
		$total_paid_amount=$this->Sales_Model->get_total_paid_by_sale_id($sale_id);
		//$total_paid_amount=$row['total_paid_amount']; 
		
		$return_tot_amt=0;
		$return_tot_amt=$this->Sales_Return_Model->get_total_return_by_sale_id($sale_id);
		
		//get rep name
		$rep_name='';
		//$rep_name='';
		if(!empty($row['rep_id'])){
		$rep_name_des=$this->User_Model->get_user_info($row['rep_id']);
		$rep_name=$rep_name_des['user_first_name'];
		}
		
		$nestedData[] =display_date_time_format($row['sale_datetime']);
		$nestedData[] = $row['sale_reference_no'];
		$nestedData[] = $row['cus_name'];
		$nestedData[] = $rep_name;
		$nestedData[] =number_format($row['sale_inv_rc'], 2, '.', '');
		
		
		if (empty($total_paid_amount)) {
		  $pay_st = '<span class="label label-warning">Pending</span>';
		   $p_status='Pending';
		}else{
		  if ($total_paid_amount >= ($row['sale_total']-$return_tot_amt)) {
			$pay_st = '<span class="label label-success">Paid</span>';
			$p_status='Paid';
		  }else{
			$pay_st = '<span class="label label-info">Partial</span>';
			$p_status='Partial';
		  }
		}
		
		if($srh_payment_status){
			if($srh_payment_status==$p_status)
		{
		$nestedData[]=$pay_st;
		//$nestedData[] = number_format($row['cost_total'], 2, '.', '');
		$nestedData[] =number_format($row['sale_total'], 2, '.', '');
		$nestedData[] =$return_tot_amt;
		$nestedData[] = number_format($total_paid_amount, 2, '.', '');
		$nestedData[] = number_format($row['sale_total']-$return_tot_amt-$total_paid_amount, 2, '.', '');

	$data[] = $nestedData;
	
		}}else {
			$nestedData[]=$pay_st;
		//$nestedData[] = number_format($row['cost_total'], 2, '.', '');
		$nestedData[] = number_format($row['sale_total'], 2, '.', '');
		$nestedData[] =$return_tot_amt;
		$nestedData[] = number_format($total_paid_amount, 2, '.', '');
		$nestedData[] = number_format($row['sale_total']-$return_tot_amt-$total_paid_amount, 2, '.', '');

	$data[] = $nestedData;
		}
}

	$json_data = array(
			//"draw"            => intval( $requestData['draw'] ),  
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data 
			);

	echo json_encode($json_data);
	}
	

	public function get_list_sales_assistant_wise_sales_summary($value='')
	{
		//print_r($_REQUEST);
		$srh_to_date='';
		$srh_from_date='';
		$srh_warehouse_id=$this->input->post('srh_warehouse_id');
		$srh_customer_id=$this->input->post('srh_customer_id');
		$srh_sales_rep_id=$this->input->post('srh_sales_rep_id');
		$srh_payment_status=$this->input->post('srh_payment_status');
		if($this->input->post('srh_to_date')){
			$srh_to_date = date('Y-m-d', strtotime($this->input->post('srh_to_date')));
			//$srh_to_date=date('Y-m-d', strtotime($srh_to_date);
		}
		if($this->input->post('srh_from_date')){
			$srh_from_date=date('Y-m-d', strtotime($this->input->post('srh_from_date')));
		}
		
		
		
		$this->load->model('Sales_Model');
		$columns = array( 
		0 =>'sale_datetime', 
		1 => 'sale_reference_no',
		2=> 'cus_name',
		3 =>'sale_id', 
		4 => 'sale_id',
		5=> 'sale_id'
	);
	
	$data = array();

	
	
	$sales = $this->Sales_Model->get_sales_assistant_wise_sales_summary($srh_warehouse_id,$srh_to_date,$srh_from_date,'','','',$srh_customer_id,$srh_sales_rep_id);
	//echo $this->db->last_query();
	$totalData = count($sales);
	$totalFiltered = $totalData;  
	
	foreach ($sales as $row){
		$nestedData=array(); 
		$p_status='';
		$pay_st ='';
		$sale_id=$row['sale_id'];
		$total_paid_amount=0;
		$total_paid_amount=$this->Sales_Model->get_total_paid_by_sale_id($sale_id);
		//$total_paid_amount=$row['total_paid_amount']; 
		
		$return_tot_amt=0;
		$return_tot_amt=$this->Sales_Return_Model->get_total_return_by_sale_id($sale_id);
		
		//get rep name
		$rep_name='';
		//$rep_name='';
		if(!empty($row['rep_id'])){
		$rep_name_des=$this->User_Model->get_user_info($row['rep_id']);
		$rep_name=$rep_name_des['user_first_name'];
		}
		
		$nestedData[] =display_date_time_format($row['sale_datetime']);
		$nestedData[] = $row['sale_reference_no'];
		$nestedData[] = $row['cus_name'];
		$nestedData[] = $rep_name;
		$nestedData[] ='';//number_format($row['sale_inv_rc'], 2, '.', '');
		
		
		if (empty($total_paid_amount)) {
		  $pay_st = '<span class="label label-warning">Pending</span>';
		   $p_status='Pending';
		}else{
		  if ($total_paid_amount >= ($row['sale_total']-$return_tot_amt)) {
			$pay_st = '<span class="label label-success">Paid</span>';
			$p_status='Paid';
		  }else{
			$pay_st = '<span class="label label-info">Partial</span>';
			$p_status='Partial';
		  }
		}
		
		if($srh_payment_status){
			if($srh_payment_status==$p_status)
		{
		$nestedData[]=$pay_st;
		//$nestedData[] = number_format($row['cost_total'], 2, '.', '');
		$nestedData[] =number_format($row['sale_total'], 2, '.', '');
		$nestedData[] =$return_tot_amt;
		$nestedData[] = number_format($total_paid_amount, 2, '.', '');
		$nestedData[] = number_format($row['sale_total']-$return_tot_amt-$total_paid_amount, 2, '.', '');

	$data[] = $nestedData;
	
		}}else {
			$nestedData[]=$pay_st;
		//$nestedData[] = number_format($row['cost_total'], 2, '.', '');
		$nestedData[] = number_format($row['sale_total'], 2, '.', '');
		$nestedData[] =$return_tot_amt;
		$nestedData[] = number_format($total_paid_amount, 2, '.', '');
		$nestedData[] = number_format($row['sale_total']-$return_tot_amt-$total_paid_amount, 2, '.', '');

	$data[] = $nestedData;
		}
}

	$json_data = array(
			//"draw"            => intval( $requestData['draw'] ),  
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data 
			);

	echo json_encode($json_data);
	}
	



	public function get_list_sales_for_rep_comm_print($value='')
	{
		//print_r($_REQUEST);
		$srh_to_date='';
		$srh_from_date='';
		$srh_warehouse_id=$this->input->post('srh_warehouse_id');
		$srh_customer_id=$this->input->post('srh_customer_id');
		$srh_sales_rep_id=$this->input->post('srh_sales_rep_id');
		$srh_payment_status=$this->input->post('srh_payment_status');
		if($this->input->post('srh_to_date')){
			$srh_to_date = date('Y-m-d', strtotime($this->input->post('srh_to_date') . ' +1 day'));
			//$srh_to_date=date('Y-m-d', strtotime($srh_to_date);
		}
		if($this->input->post('srh_from_date')){
			$srh_from_date=date('Y-m-d', strtotime($this->input->post('srh_from_date')));
		}
		
		
		
		$this->load->model('Sales_Model');
		$columns = array( 
		0 =>'sale_datetime', 
		1 => 'sale_reference_no',
		2=> 'cus_name',
		3 =>'sale_id', 
		4 => 'sale_id',
		5=> 'sale_id'
	);
	
	$data = array();
	
	//get rep details
	$rep_details=$this->User_Model->get_user_info($srh_sales_rep_id);
	//echo $this->db->last_query();
	//print_r($rep_details);	
	$rep_com_1=$rep_details['rep_com_1'];
	$rep_com_2=$rep_details['rep_com_2'];
	$rep_com_3=$rep_details['rep_com_3'];
	
	$sales = $this->Sales_Model->get_all_sales_for_rep_com_report($srh_warehouse_id,$srh_to_date,$srh_from_date,'','','',$srh_customer_id,$srh_sales_rep_id);
	//echo $this->db->last_query();
	$totalData = count($sales);
	$totalFiltered = $totalData;  
	
	foreach ($sales as $row){
		$nestedData=array(); 
		$rep_comm=0;
		$p_status='';
		$pay_st ='';
		$sale_id=$row['sale_id'];
		$total_paid_amount=0;
		$total_paid_amount=$this->Sales_Model->get_total_paid_by_sale_id($sale_id);
		//$total_paid_amount=$row['total_paid_amount']; 
		
		$return_tot_amt=0;
		$return_tot_amt=$this->Sales_Return_Model->get_total_return_by_sale_id($sale_id);
		
		//get rep name
		$rep_name='';
		//$rep_name='';
		if(!empty($row['rep_id'])){
		$rep_name_des=$this->User_Model->get_user_info($row['rep_id']);
		$rep_name=$rep_name_des['user_first_name'];
		}
		
		$nestedData[] =display_date_time_format($row['sale_datetime']);
		$nestedData[] = $row['sale_reference_no'];
		$nestedData[]=$row['sale_pymnt_date_time'];
		$nestedData[] = $row['cus_name'];
		$nestedData[] = $rep_name;
	
		
		
		if (empty($total_paid_amount)) {
		  $pay_st = '<span class="label label-warning">Pending</span>';
		   $p_status='Pending';
		}else{
		  if ($total_paid_amount >= ($row['sale_total']-$return_tot_amt)) {
			$pay_st = '<span class="label label-success">Paid</span>';
			$p_status='Paid';
		  }else{
			$pay_st = '<span class="label label-info">Partial</span>';
			$p_status='Partial';
		  }
		}
		
		
		$sale_date=$row['sale_datetime'];;
		$sale_payment_date=$row['sale_pymnt_date_time'];
		$datetime1 = new DateTime($sale_date);
		$datetime2 = new DateTime($sale_payment_date);
		$interval = $datetime1->diff($datetime2);
		//$rep_comm=$interval->format('%R%a days');
		$days_deff=$interval->format('%R%a');
		
		if($days_deff>=0) {
			if($days_deff>=0 && $days_deff<=30){
				$rep_com_rete=$rep_com_1;
			}
			else if($days_deff>30 && $days_deff<=60){
				$rep_com_rete=$rep_com_2;
			}
			else if($days_deff>60){
				$rep_com_rete=$rep_com_3;
			}
			
			$rep_comm=$total_paid_amount*($rep_com_rete/100);
			
		}
		
		//if($days_deff<0) {$rep_comm='-';}
		
		
		//$rep_comm_ary=explode("Rs.",$rep_comm);
		//$rep_comm=100;
		
		if($srh_payment_status){
			if($srh_payment_status==$p_status)
		{
		$nestedData[]=$pay_st;
		//$nestedData[] = number_format($row['cost_total'], 2, '.', '');
		$nestedData[] =number_format($row['sale_total'], 2, '.', '');
		$nestedData[] =$return_tot_amt;
		$nestedData[] = number_format($total_paid_amount, 2, '.', '');
		$nestedData[] = number_format($row['sale_total']-$return_tot_amt-$total_paid_amount, 2, '.', '');
		$nestedData[] =number_format($rep_comm, 2, '.', '');
		//$nestedData[] =$rep_comm;
		

	$data[] = $nestedData;
	
		}}else {
			$nestedData[]=$pay_st;
		//$nestedData[] = number_format($row['cost_total'], 2, '.', '');
		$nestedData[] = number_format($row['sale_total'], 2, '.', '');
		$nestedData[] =$return_tot_amt;
		$nestedData[] = number_format($total_paid_amount, 2, '.', '');
		$nestedData[] = number_format($row['sale_total']-$return_tot_amt-$total_paid_amount, 2, '.', '');
		$nestedData[] =number_format($rep_comm, 2, '.', '');
		//$nestedData[] =$rep_comm;
		$data[] = $nestedData;
		}
}

	$json_data = array(
			//"draw"            => intval( $requestData['draw'] ),  
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data 
			);

	echo json_encode($json_data);
	}
	
	
	
	public function get_list_sales_for_print_rep_sales($value='')
	{
		//print_r($_REQUEST);
		$srh_to_date='';
		$srh_from_date='';
		$srh_warehouse_id=$this->input->post('srh_warehouse_id');
		$srh_customer_id=$this->input->post('srh_customer_id');
		$srh_sales_rep_id=$this->input->post('srh_sales_rep_id');
		$srh_payment_status=$this->input->post('srh_payment_status');
		if($this->input->post('srh_to_date')){
			$srh_to_date = date('Y-m-d', strtotime($this->input->post('srh_to_date') . ' +1 day'));
			//$srh_to_date=date('Y-m-d', strtotime($srh_to_date);
		}
		if($this->input->post('srh_from_date')){
			$srh_from_date=date('Y-m-d', strtotime($this->input->post('srh_from_date')));
		}
		
		
		
		$this->load->model('Sales_Model');
		$columns = array( 
		0 =>'sale_datetime', 
		1 => 'sale_reference_no',
		2=> 'cus_name',
		3 =>'sale_id', 
		4 => 'sale_id',
		5=> 'sale_id'
	);
	
	$data = array();

	
	
	$sales = $this->Sales_Model->get_all_sales_for_report($srh_warehouse_id,$srh_to_date,$srh_from_date,'','','',$srh_customer_id,$srh_sales_rep_id);
	//echo $this->db->last_query();
	$totalData = count($sales);
	$totalFiltered = $totalData;  
	
	foreach ($sales as $row){
		$nestedData=array(); 
		$p_status='';
		$pay_st ='';
		$sale_id=$row['sale_id'];
		$total_paid_amount=0;
		$total_paid_amount=$this->Sales_Model->get_total_paid_by_sale_id($sale_id);
		//$total_paid_amount=$row['total_paid_amount']; 
		
		$return_tot_amt=0;
		$return_tot_amt=$this->Sales_Return_Model->get_total_return_by_sale_id($sale_id);
		
		//get rep name
		$rep_name='';
		//$rep_name='';
		if(!empty($row['rep_id'])){
		$rep_name_des=$this->User_Model->get_user_info($row['rep_id']);
		$rep_name=$rep_name_des['user_first_name'];
		}
		

$now = strtotime(date("Y-m-d H:i:s")); // or your date as well
$your_date = strtotime($row['sale_datetime']);
$datediff = $now - $your_date;

$diff =  floor($datediff / (60 * 60 * 24));
if($diff<0) $diff=0;

		
		$nestedData[] =display_date_time_format($row['sale_datetime']);
		$nestedData[] = $row['sale_reference_no'];
		$nestedData[] = $row['cus_name'];
		
		
		if (empty($total_paid_amount)) {
		  $pay_st = '<span class="label label-warning">Pending</span>';
		   $p_status='Pending';
		}else{
		  if ($total_paid_amount >= ($row['sale_total']-$return_tot_amt)) {
			$pay_st = '<span class="label label-success">Paid</span>';
			$p_status='Paid';
		  }else{
			$pay_st = '<span class="label label-info">Partial</span>';
			$p_status='Partial';
		  }
		}
		
		if($srh_payment_status){
			if($srh_payment_status==$p_status)
		{
		//$nestedData[]=$pay_st;
		$nestedData[] = $rep_name;
		$nestedData[] = $diff;
		
		$nestedData[] ='';
		//$nestedData[] = number_format($row['cost_total'], 2, '.', '');
		$nestedData[] =number_format($row['sale_total'], 2, '.', '');
		$nestedData[] =$return_tot_amt;
		$nestedData[] = number_format($total_paid_amount, 2, '.', '');
		$nestedData[] = number_format($row['sale_total']-$return_tot_amt-$total_paid_amount, 2, '.', '');

	$data[] = $nestedData;
	
		}}else {
			$nestedData[]=$pay_st;
			$nestedData[] = $rep_name;
			$nestedData[] = $diff;
		//$nestedData[] = number_format($row['cost_total'], 2, '.', '');
		$nestedData[] = number_format($row['sale_total'], 2, '.', '');
		$nestedData[] =$return_tot_amt;
		$nestedData[] = number_format($total_paid_amount, 2, '.', '');
		$nestedData[] = number_format($row['sale_total']-$return_tot_amt-$total_paid_amount, 2, '.', '');

	$data[] = $nestedData;
		}
}

	$json_data = array(
			//"draw"            => intval( $requestData['draw'] ),  
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data 
			);

	echo json_encode($json_data);
	}
	
	
	public function get_list_sales_report_for_print_daily($value='')
	{
		//print_r($_REQUEST);
		$srh_to_date='';
		$srh_from_date='';
		$srh_warehouse_id=$this->input->post('srh_warehouse_id');
		$srh_rep_id=$this->input->post('srh_rep_id');
		if($this->input->post('srh_to_date')){
			$srh_to_date=date('Y-m-d', strtotime($this->input->post('srh_to_date')));
		}
		if($this->input->post('srh_from_date')){
			$srh_from_date=date('Y-m-d', strtotime($this->input->post('srh_from_date')));
		}
		
		
		
		$this->load->model('Sales_Model');
		$columns = array( 
		0 =>'sale_datetime', 
		1 => 'sale_reference_no',
		2=> 'cus_name',
		3 =>'sale_id', 
		4 => 'sale_id',
		5=> 'sale_id'
	);
	
	$data = array();

	
	
	$sales = $this->Sales_Model->get_all_sales_return_for_report($srh_warehouse_id,$srh_to_date,$srh_from_date,$srh_rep_id);
	//echo $this->db->last_query();
	$totalData = count($sales);
	$totalFiltered = $totalData;  
	
	foreach ($sales as $row){
		$nestedData=array(); 
		$sale_id=$row['sale_id'];
		$total_paid_amount=$row['total_paid_amount']; //$this->Sales_Model->get_total_paid_by_sale_id($sale_id);
		$nestedData[] =display_date_time_format($row['sl_rtn_datetime']);
		$nestedData[] = $row['sl_rtn_reference_no'];
		
		
		
		if (empty($total_paid_amount)) {
		  $pay_st = '<span class="label label-warning">Pending</span>';
		}else{
		  if ($total_paid_amount >= $row['sl_rtn_total']) {
			$pay_st = '<span class="label label-success">Paid</span>';
		  }else{
			$pay_st = '<span class="label label-info">Partial</span>';
		  }
		}
		
		$nestedData[]=$pay_st;
		$nestedData[] = number_format($row['cost_total'], 2, '.', '');
		$nestedData[] = number_format($row['sl_rtn_total'], 2, '.', '');
	
		//$nestedData[] = number_format($row['sl_rtn_total']-$row['cost_total'], 2, '.', '');

	$data[] = $nestedData;
}

	$json_data = array(
			//"draw"            => intval( $requestData['draw'] ),  
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data 
			);

	echo json_encode($json_data);
	}
	
	
	public function get_list_sales_for_print_daily($value='')
	{
		//print_r($_REQUEST);
		$srh_to_date='';
		$srh_from_date='';
		$srh_warehouse_id=$this->input->post('srh_warehouse_id');
		if($this->input->post('srh_to_date')){
			$srh_to_date=date('Y-m-d', strtotime($this->input->post('srh_to_date')));
		}
		if($this->input->post('srh_from_date')){
			$srh_from_date=date('Y-m-d', strtotime($this->input->post('srh_from_date')));
		}
		
		
		
		$this->load->model('Sales_Model');
		$columns = array( 
		0 =>'sale_datetime', 
		1 => 'sale_reference_no',
		2=> 'cus_name',
		3 =>'sale_id', 
		4 => 'sale_id',
		5=> 'sale_id'
	);
	
	$data = array();

	
	
	$sales = $this->Sales_Model->get_all_sales_for_report($srh_warehouse_id,$srh_to_date,$srh_from_date);
	//echo $this->db->last_query(); die();
	$totalData = count($sales);
	$totalFiltered = $totalData;  
	
	foreach ($sales as $row){
		$nestedData=array(); 
		$sale_id=$row['sale_id'];
		
		//get rep name
		$rep_name='';
		//$rep_name='';
		if(!empty($row['rep_id'])){
		$rep_name_des=$this->User_Model->get_user_info($row['rep_id']);
		$rep_name=$rep_name_des['user_first_name'];
		}
		
		$nestedData[] =display_date_time_format($row['sale_datetime']);
		$nestedData[] = $row['sale_reference_no'];
		$nestedData[] = $rep_name;
		
		$total_paid_amount_inv=0;
		//$sale_paid = $this->Sales_Model->get_total_paid_by_sale_id($sale_id);
		if($row['sale_id']!=0){
		    $sale_id=(int)$row['service_id'];
		    $sale_payments_list= $this->Sales_Model->get_sale_payments_by_sale_id($sale_id,'service');
		}else{
		    $sale_payments_list= $this->Sales_Model->get_sale_payments_by_sale_id($sale_id);
		}
		
		$tot_advnc_paid=0;
		$cr_interest_tot=0;
 		foreach ($sale_payments_list as $row_p){
			$sale_pymnt_amount=0;
			$cr_interest=0;
			$sale_pymnt_amount=$row_p->sale_pymnt_amount;
			if($row_p->extra_val_1){
				//$tot_advnc_paid+=$row_p->sale_pymnt_amount;
				$cr_interest=$sale_pymnt_amount*0.03;
			}
			$cr_interest_tot+=$cr_interest;
			$tot_advnc_paid=$tot_advnc_paid+(float)$sale_pymnt_amount;//-$cr_interest;
 		}
		//$tot_advnc_paid=0;
		$total_paid_amount=($sale_id==0)?$row['total_paid_amount']:$tot_advnc_paid; //$this->Sales_Model->get_total_paid_by_sale_id($sale_id);
	
		//$total_paid_amount=$row['total_paid_amount']; 
		
		if (empty($total_paid_amount)) {
		  $pay_st = '<span class="label label-warning">Pending</span>';
		}else{
		  if ($total_paid_amount >= $row['sale_total']) {
			$pay_st = '<span class="label label-success">Paid</span>';
		  }else{
			$pay_st = '<span class="label label-info">Partial</span>';
		  }
		}
		
		$nestedData[]=$pay_st;
		$nestedData[] = number_format($row['cost_total'], 2, '.', '');
		$nestedData[] = number_format($row['sale_total'], 2, '.', '');
		$nestedData[] = number_format($row['sale_total']-$row['cost_total'], 2, '.', '');
		
		
		$nestedData[] =number_format($tot_advnc_paid, 2, '.', '');
		$nestedData[] =number_format($cr_interest_tot, 2, '.', '');
	
		

	$data[] = $nestedData;
}

	$json_data = array(
			//"draw"            => intval( $requestData['draw'] ),  
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data 
			);

	echo json_encode($json_data);
	}
	
		
	
	public function get_list_sales_for_print_daily_old($value='')
	{
		//print_r($_REQUEST);
		$srh_to_date='';
		$srh_from_date='';
		$srh_warehouse_id=$this->input->post('srh_warehouse_id');
		if($this->input->post('srh_to_date')){
			$srh_to_date=date('Y-m-d', strtotime($this->input->post('srh_to_date')));
		}
		if($this->input->post('srh_from_date')){
			$srh_from_date=date('Y-m-d', strtotime($this->input->post('srh_from_date')));
		}
		
		
		
		$this->load->model('Sales_Model');
		$columns = array( 
		0 =>'sale_datetime', 
		1 => 'sale_reference_no',
		2=> 'cus_name',
		3 =>'sale_id', 
		4 => 'sale_id',
		5=> 'sale_id'
	);
	
	$data = array();

	
	
	$sales = $this->Sales_Model->get_all_sales_for_report($srh_warehouse_id,$srh_to_date,$srh_from_date);
	//echo $this->db->last_query();
	$totalData = count($sales);
	$totalFiltered = $totalData;  
	
	foreach ($sales as $row){
		$nestedData=array(); 
		$sale_id=$row['sale_id'];
		
		//get rep name
		$rep_name='';
		//$rep_name='';
		if(!empty($row['rep_id'])){
		$rep_name_des=$this->User_Model->get_user_info($row['rep_id']);
		$rep_name=$rep_name_des['user_first_name'];
		}
		
		$total_paid_amount=$row['total_paid_amount']; //$this->Sales_Model->get_total_paid_by_sale_id($sale_id);
		$nestedData[] =display_date_time_format($row['sale_datetime']);
		$nestedData[] = $row['sale_reference_no'];
		$nestedData[] = $rep_name;
		
		
		if (empty($total_paid_amount)) {
		  $pay_st = '<span class="label label-warning">Pending</span>';
		}else{
		  if ($total_paid_amount >= $row['sale_total']) {
			$pay_st = '<span class="label label-success">Paid</span>';
		  }else{
			$pay_st = '<span class="label label-info">Partial</span>';
		  }
		}
		
		
		$total_paid_amount_inv=0;
		//$sale_paid = $this->Sales_Model->get_total_paid_by_sale_id($sale_id);
		$sale_payments_list= $this->Sales_Model->get_sale_payments_by_sale_id($sale_id);
		$tot_advnc_paid=0;
		$cr_interest_tot=0;
 		foreach ($sale_payments_list as $row_p){
			$sale_pymnt_amount=0;
			$cr_interest=0;
			$sale_pymnt_amount=$row_p->sale_pymnt_amount;
			if($row_p->extra_val_1){
				//$tot_advnc_paid+=$row_p->sale_pymnt_amount;
				$cr_interest=$sale_pymnt_amount*0.03;
			}
			$cr_interest_tot+=$cr_interest;
			$tot_advnc_paid=$tot_advnc_paid+$sale_pymnt_amount;//-$cr_interest;
 		}
		//$tot_advnc_paid=0;
		
		$nestedData[]=$pay_st;
		$nestedData[] = number_format($row['cost_total'], 2, '.', '');
		$nestedData[] = number_format($row['sale_total'], 2, '.', '');
		$nestedData[] = number_format($row['sale_total']-$row['cost_total'], 2, '.', '');
		
		
		$nestedData[] =number_format($tot_advnc_paid, 2, '.', '');
		$nestedData[] =number_format($cr_interest_tot, 2, '.', '');
	
		

	$data[] = $nestedData;
}

	$json_data = array(
			//"draw"            => intval( $requestData['draw'] ),  
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data 
			);

	echo json_encode($json_data);
	}
	
	
	public function get_list_supplier_for_print($value='')
	{
		$this->load->model('Supplier_Model');
		$requestData= $_REQUEST;
		
	
		$columns = array( 
			0 =>'supp_code', 
			0 =>'supp_company_name', 
			1 => 'supp_email',
			2=> 'supp_company_phone',
			3 =>'supp_city', 
			4 => 'country_id',
			5=> 'supp_id'
		);
	
	$data = array();
	$suppliers = $this->Supplier_Model->get_all_supplier();
	$totalData = count($suppliers);
	$totalFiltered = $totalData; 
	//print_r($suppliers);
	
	foreach ($suppliers as $row){
		$nestedData=array(); 
		$nestedData[] =$row['supp_code'];
		$nestedData[] =$row['supp_company_name'];
		$nestedData[] = $row['supp_email'];
		$nestedData[] = $row['supp_company_phone'];
		$nestedData[] =$row['supp_city'];
		$nestedData[] = $row['country_short_name'];
		$data[] = $nestedData;
	 }
	 	$json_data = array(
			//"draw"            => intval( $requestData['draw'] ),  
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data 
			);

	echo json_encode($json_data); 
	}
	

	public function get_list_supplier_product_for_print($value='')
	{
		$srh_warehouse_id=$this->input->post('srh_warehouse_id');
		$supplier_srh=$this->input->post('supplier_srh');
		
			$this->load->model('Product_Models');
	        $values = $this->Product_Models->getSupplierProductsForReport($srh_warehouse_id,$supplier_srh);
	        $data = array();

	        if (!empty($values)) {
	            foreach ($values as $products) {

	            if ($products->product_status == 0) {$k = "btn-warning";$m = "fa-minus-circle";} else {$k = "btn-green";$m = "fa-check";}
				$retVal = (empty($products->sub_cat_name)) ? "--:--" : $products->sub_cat_name ;

	            $row = array();
				
				//get transferd qty
				$transferd_qty=0;
				$transfer_reseve_qty=0;
				$transferd_qty=$this->Transfer_Model->getTransferdQtyByWarehouseId($srh_warehouse_id,$products->product_id);
				$transfer_reseve_qty=$this->Transfer_Model->getTransferResevedQtyByWarehouseId($srh_warehouse_id,$products->product_id);
				$sold_qty=$this->Sales_Model->getSoldQtyByWarehouseId($srh_warehouse_id,$products->product_id);
				$purchased_qty=$this->Purchases_Model->getPurchasedQtyByWarehouseId($srh_warehouse_id,$products->product_id);
				$product_damaged_qty=$this->Product_Damage_Model->getProductDamagedQtyByWarehouseId($srh_warehouse_id,$products->product_id);
				$sales_return_qty=$this->Sales_Return_Model->getSalesReturnQtyByWarehouseId($srh_warehouse_id,$products->product_id);
				 
				 $row = array();
				 $balance_qty=$purchased_qty+$transfer_reseve_qty+$sales_return_qty-$sold_qty-$transferd_qty-$product_damaged_qty;
				
				 
                  $row[] = $products->product_code;
	                $row[] = $products->product_name;
					 $row[] = $products->supp_company_name;//. " ($products->supp_code)";
					 if($products->product_part_no){
					  $row[] = $products->product_part_no;
					 }else {
						$row[] = ''; 
					 }
					  $row[] = number_format($purchased_qty, 2, '.', ',');
					   $row[] = number_format($sold_qty, 2, '.', ',');
	                $row[] = number_format($products->product_alert_qty, 2, '.', ',');
					 $row[] = number_format($balance_qty, 2, '.', ',');
					 
					
	                //$row[] = $transferd_qty;
	                $data[] = $row;
	            }

	            $output = array('data' =>$data);
	            echo json_encode($output);
	        }else{
	            $output = array('data' =>'');
	            echo json_encode($output);

	        }
	   }
	   
	public function get_product_balance_by_product_id($srh_warehouse_id='',$product_id='',$product_sn_exissts=''){
		$balance=0;
		$transferd_qty=0;
		$transfer_reseve_qty=0;
		$sold_qty=0;
		$purchased_qty=0;
		$product_damaged_qty=0;
		$sales_return_qty=0;
		//$=0;
		$srh_from_date='';
		$srh_to_date='';
				
				$transferd_qty=$this->Transfer_Model->getTransferdQtyByWarehouseId($srh_warehouse_id,$product_id,$srh_from_date,$srh_to_date);
				$transfer_reseve_qty=$this->Transfer_Model->getTransferResevedQtyByWarehouseId($srh_warehouse_id,$product_id,$srh_from_date,$srh_to_date);
				$sold_qty=$this->Sales_Model->getSoldQtyByWarehouseId($srh_warehouse_id,$product_id,$srh_from_date,$srh_to_date);
				
				$purchased_qty=$this->Purchases_Model->getPurchasedQtyByWarehouseId($srh_warehouse_id,$product_id,$srh_from_date,$srh_to_date);
				//$purchased_qty=1;
				$product_damaged_qty=$this->Product_Damage_Model->getProductDamagedQtyByWarehouseId($srh_warehouse_id,$product_id,$srh_from_date,$srh_to_date);
				$sales_return_qty=$this->Sales_Return_Model->getSalesReturnQtyByWarehouseId($srh_warehouse_id,$product_id,$srh_from_date,$srh_to_date);
				
		return $balance;
	}
	
	
 /* Start get_warehouse_wise_product_summary_details */
 
	public function get_warehouse_wise_product_summary_details($value = '') {
        $srh_warehouse_id = $this->input->post('srh_warehouse_id');
        $cat_srh = $this->input->post('cat_srh');
		$with_emi_no = $this->input->post('with_emi_no');
		$subcategory = $this->input->post('subcategory');
		$product_id = $this->input->post('product_id');
		$show_all = $this->input->post('show_all');
		$product_name = $this->input->post('product_name');
		$dep_id = $this->input->post('dep_id');
		$srh_sub_cat = $this->input->post('srh_sub_cat');
			$show_details = $this->input->post('show_details');
			
			$only_empty=$this->input->post('only_empty');

$pro_color_id=$this->input->post('pro_color_id');
$pro_model_id=$this->input->post('pro_model_id');
		

        $srh_from_date = '';
        $srh_to_date = '';
        if ($this->input->post('srh_to_date')) {
            $srh_to_date = date('Y-m-d', strtotime($this->input->post('srh_to_date')));
        }
        if ($this->input->post('srh_from_date')) {
            $srh_from_date = date('Y-m-d', strtotime($this->input->post('srh_from_date')));
        }

        /*         * ****************** */
        $search_key = $this->input->post('search');
        $search_key_val = $search_key['value'];
        $start = $this->input->post('start');
        $length = $this->input->post('length');

        $this->load->model('Product_Models');
        $values = '';
        $totalFiltered = 0;

//	$sales = $this->Sales_Model->get_all_sales($start,$length,$search_key_val);
//	$sales_count = $this->Sales_Model->get_all_sales('','','');

        $totalData = 0;
//	echo $length."//";
        //$getSumProductsForReport = $this->Product_Models->getSumProductsForReport($srh_warehouse_id,$cat_srh);

        if ($search_key_val) {
            $values = $this->Product_Models->getProductsForReport($srh_warehouse_id, $cat_srh, $start, $length, $search_key_val,'',$subcategory,$product_id,$product_name,$dep_id,$srh_sub_cat,$pro_model_id,$pro_color_id);
            //$values_c = $this->Product_Models->getProductsForReport_c($srh_warehouse_id, $cat_srh, '', '', $search_key_val);
            $totalData = $this->Product_Models->getProductsForReport($srh_warehouse_id, $cat_srh, $start, $length, $search_key_val,1,$subcategory,$product_id,$product_name,$dep_id,$srh_sub_cat,$pro_model_id,$pro_color_id);
        } else {
            $values = $this->Product_Models->getProductsForReport($srh_warehouse_id, $cat_srh, $start, $length, '','',$subcategory,$product_id,$product_name,$dep_id,$srh_sub_cat,$pro_model_id,$pro_color_id);
           // $values_c = $this->Product_Models->getProductsForReport_c($srh_warehouse_id, $cat_srh, $start, '', '');
            //print_r($values_c[0]->count);
             $totalData = $this->Product_Models->getProductsForReport($srh_warehouse_id, $cat_srh, '', '', '',1,$subcategory,$product_id,$product_name,$dep_id,$srh_sub_cat,$pro_model_id,$pro_color_id);
        }

        $totalFiltered = $totalData;
        /*         * ****************** */

        $costPriceTot = 0; //$this->Purchases_Model->getPurchasedQtyByWarehouseId('','',$srh_from_date,$srh_to_date);

        $data = array();
        $warehouse_list = $this->Warehouse_Model->get_all_warehouse();

        if (!empty($values)) {
            foreach ($values as $products) {

                if ($products->product_status == 0) {
                    $k = "btn-warning";
                    $m = "fa-minus-circle";
                } else {
                    $k = "btn-green";
                    $m = "fa-check";
                }
                $retVal = (empty($products->sub_cat_name)) ? "--:--" : $products->sub_cat_name;

                $row = array();

                //get transferd qty
                $transferd_qty = 0;
				$pending_transferd_qty=0;
                $transfer_reseve_qty = 0;
				$purchases_return_qty=0;

               // $transferd_qty=$this->Transfer_Model->getTransferdQtyByWarehouseId($srh_warehouse_id,$products->product_id,$srh_from_date,$srh_to_date);
				// $transfer_reseve_qty=$this->Transfer_Model->getTransferResevedQtyByWarehouseId($srh_warehouse_id,$products->product_id,$srh_from_date,$srh_to_date);
			   

			   
			   /*
			    if($this->session->userdata('ss_user_id')==1){
               echo "transferd_qty:".$transferd_qty;
              }
               */
                

                $product_balance = 0;
                
				
				$details='';
				
				
				
				
				

                //$product_balance = $purchased_qty + $sales_return_qty - $sold_qty - $purchases_return_qty;

                $sale_price_sub_tot = $products->product_price * $product_balance;
				
				//get cost price for serial no
				$cost_price_sub_tot=0;
				
				if($products->product_sn_exissts){
					
						
				}else{
					 $cost_price_sub_tot = $products->product_cost * $product_balance;
				}
				
				if($products->product_sn_exissts){
				$details="<a style=\"cursor:pointer\" onclick=\"pop_up_serial_no('$products->product_id')\">Serial</a>";
				}
				
				/*show serial list*/
				$product_id=$products->product_id;
				
			//	$sn_list_by_avalable_warehosue = $this->Purchases_Model->get_serial_no_by_avalable_warehosue_id($product_id,$srh_warehouse_id);
			//	echo $this->db->last_query();
				
				
				$i=0;
				
				
				//echo "with_emi_no:$with_emi_no";
				
				if($with_emi_no){
					
				
					
					
					//list avalable ware house array
					//$details.= "<br/>..System Under Testing..<br/>";
					$k=0;
					
					//print_r($sn_list_by_avalable_warehosue);
					/*
					foreach ($sn_list_by_avalable_warehosue as $row_1){ 
						$k++;
						$details.= "<br/> ($k).<a href=''>".$row_1->pis_number.'</a> - '.$row_1->code. " Cost: ".$row_1->pis_cost_price. " , Cash Price: ".$row_1->pis_cash_price;
					}
					*/
					
				}
				
				//print_r($sn_list_by_avalable_warehosue);
				//sanath coment impornt
			//	$product_balance=count($sn_list_by_avalable_warehosue);
		
				$display=0;
				
				
				
				
				if($product_balance!=''){
					$display=1;	
				}
				
				
				if($show_all){
				$display=1;	// show all items with 0 stcok
				}
				
				
					if($only_empty){
					    if($product_balance==''){
				$display=1;	// show all items with 0 stcok
					    }
				}
				
				
				
             //$products->product_code;
			   $u_url="<a href='../products/edit/".$products->product_id."' target='_blank'>". $products->product_id." </a>";
                $row[] = $u_url;
                $row[] = $products->product_name;
                
                //get cash price
                //$grn_itm_des=$this->Purchases_Model->get_last_grn_cost_price_by_prodcut_id($products->product_id);
                
               // print_r($grn_itm_des);
                $pis_cash_price=0;
                $pis_cash_price=$products->product_price;
                /*
                 if(isset($grn_itm_des)){
                     if(isset($grn_itm_des['pis_cash_price'])){
                    $pis_cash_price=$grn_itm_des['pis_cash_price'];
                     }
                }
                */
                
                $row[] = '';//$pis_cash_price;
                //$row[] = '';//$products->cat_name;
               
                
                //$row[] = '';//$products->sub_cat_name;
                
                if($show_details){
                
                
                }else{
                    //$row[] = '';
                    //$row[] = '';
                    //$row[] = '';
                    //$row[] = '';
                   // $row[] = '';
                    /*
                    $row[] = '';
                    $row[] = '';
                    $row[] = '';
                    $row[] = '';
                    $row[] = '';
                    */
                    $itm_w_balance=0;
                    $all_warehouse_tot=0;
                    foreach ($warehouse_list as $row_w){
				        $tmp_whe_id=$row_w->id;
				        $sn_list_by_avalable_warehosue_2 = $this->Purchases_Model->get_serial_no_by_avalable_warehosue_id($product_id,$tmp_whe_id);
				        $itm_w_balance=count($sn_list_by_avalable_warehosue_2);
				        $all_warehouse_tot=$all_warehouse_tot+$itm_w_balance;
                        $row[] = $itm_w_balance;
                    }
                }
                $row[] = $all_warehouse_tot;
                //	$costPriceTot += $cost_price_sub_tot;
                
               
                
                
                $row[] = $details;
				if($display){
                $data[] = $row;
				}
				 
            }
            /**/

            $purchased_qty = 0;
            $purchases_return_qty = 0;
            $sold_qty = 0;
            $sales_return_qty = 0;
            $product_balance = 0;

            $sale_price_tot = 0;
            $cost_price_tot = 0;
           
            /**/

            /**/
            $output = array(
                "purchased_qty" => intval($purchased_qty),
                "sold_qty" => intval($sold_qty),
                "sales_return_qty" => intval($sales_return_qty),
                "purchases_return_qty" => intval($purchases_return_qty),
                "product_balance" => intval($product_balance),
                "damadge_qty" => 0,
                "sale_price_tot" => floatval($sale_price_tot),
                "cost_price_tot" => floatval($cost_price_tot),
                "recordsTotal" => intval($totalData),
                "recordsFiltered" => intval($totalFiltered),
                'data' => $data);
            echo json_encode($output);
        } else {
            $output = array(
                "recordsTotal" => '',
                "recordsFiltered" => '',
                'data' => '');
            echo json_encode($output);
        }
    }
	   
	 /* End get_warehouse_wise_product_summary_details   */
	   
    public function get_list_product_for_print($value = '') {
        $srh_warehouse_id = $this->input->post('srh_warehouse_id');
        $cat_srh = $this->input->post('cat_srh');
		$with_emi_no = $this->input->post('with_emi_no');
		$subcategory = $this->input->post('subcategory');
		$product_id = $this->input->post('product_id');
		$show_all = $this->input->post('show_all');
		$product_name = $this->input->post('product_name');
		$dep_id = $this->input->post('dep_id');
		$srh_sub_cat = $this->input->post('srh_sub_cat');
		$show_details = $this->input->post('show_details');
			
		$only_empty=$this->input->post('only_empty');
		$pro_model_id=$this->input->post('pro_model_id');
        $pro_color_id=$this->input->post('pro_color_id');
        $pro_capacity_id=$this->input->post('pro_capacity_id');
		
		

        $srh_from_date = '';
        $srh_to_date = '';
        if ($this->input->post('srh_to_date')) {
            $srh_to_date = date('Y-m-d', strtotime($this->input->post('srh_to_date')));
        }
        if ($this->input->post('srh_from_date')) {
            $srh_from_date = date('Y-m-d', strtotime($this->input->post('srh_from_date')));
        }

        /*         * ****************** */
        $search_key = $this->input->post('search');
        $search_key_val = $search_key['value'];
        $start = $this->input->post('start');
        $length = $this->input->post('length');

        $this->load->model('Product_Models');
        $values = '';
        $totalFiltered = 0;

//	$sales = $this->Sales_Model->get_all_sales($start,$length,$search_key_val);
//	$sales_count = $this->Sales_Model->get_all_sales('','','');

        $totalData = 0;
//	echo $length."//";
        //$getSumProductsForReport = $this->Product_Models->getSumProductsForReport($srh_warehouse_id,$cat_srh);

        if ($search_key_val) {
            $values = $this->Product_Models->getProductsForReport($srh_warehouse_id, $cat_srh, $start, $length, $search_key_val,'',$subcategory,$product_id,$product_name,$dep_id,$srh_sub_cat,$pro_model_id,$pro_color_id,$pro_capacity_id);
            //$values_c = $this->Product_Models->getProductsForReport_c($srh_warehouse_id, $cat_srh, '', '', $search_key_val);
            $totalData = $this->Product_Models->getProductsForReport($srh_warehouse_id, $cat_srh, $start, $length, $search_key_val,1,$subcategory,$product_id,$product_name,$dep_id,$srh_sub_cat,$pro_model_id,$pro_color_id,$pro_capacity_id);
        } else {
            $values = $this->Product_Models->getProductsForReport($srh_warehouse_id, $cat_srh, $start, $length, '','',$subcategory,$product_id,$product_name,$dep_id,$srh_sub_cat,$pro_model_id,$pro_color_id,$pro_capacity_id);
           // $values_c = $this->Product_Models->getProductsForReport_c($srh_warehouse_id, $cat_srh, $start, '', '');
            //print_r($values_c[0]->count);
             $totalData = $this->Product_Models->getProductsForReport($srh_warehouse_id, $cat_srh, '', '', '',1,$subcategory,$product_id,$product_name,$dep_id,$srh_sub_cat,$pro_model_id,$pro_color_id,$pro_capacity_id);
        }

        $totalFiltered = $totalData;
        /*         * ****************** */

        $costPriceTot = 0; //$this->Purchases_Model->getPurchasedQtyByWarehouseId('','',$srh_from_date,$srh_to_date);

        $data = array();

        if (!empty($values)) {
            foreach ($values as $products) {

                if ($products->product_status == 0) {
                    $k = "btn-warning";
                    $m = "fa-minus-circle";
                } else {
                    $k = "btn-green";
                    $m = "fa-check";
                }
                $retVal = (empty($products->sub_cat_name)) ? "--:--" : $products->sub_cat_name;

                $row = array();

                //get transferd qty
                $transferd_qty = 0;
				$pending_transferd_qty=0;
                $transfer_reseve_qty = 0;
				$purchases_return_qty=0;

               // $transferd_qty=$this->Transfer_Model->getTransferdQtyByWarehouseId($srh_warehouse_id,$products->product_id,$srh_from_date,$srh_to_date);
				// $transfer_reseve_qty=$this->Transfer_Model->getTransferResevedQtyByWarehouseId($srh_warehouse_id,$products->product_id,$srh_from_date,$srh_to_date);
			   
			  
			   if(!$srh_warehouse_id){
			   $warehouse_list = $this->Warehouse_Model->get_all_warehouse();
			   foreach ($warehouse_list as $row_w){
				   $tmp_whe_id=$row_w->id;
				   $this_tqty=$this->Transfer_Model->getTransferdQtyByWarehouseId($tmp_whe_id,$products->product_id,$srh_from_date,$srh_to_date);
				   //echo $this->db->last_query();
				   //echo "$tmp_whe_id: $this_tqty / <br/> ";
				   $transferd_qty=$transferd_qty+$this_tqty;
				   
				   
				    $this_rtqty=$this->Transfer_Model->getTransferResevedQtyByWarehouseId($tmp_whe_id,$products->product_id,$srh_from_date,$srh_to_date);
					 $transfer_reseve_qty=$transfer_reseve_qty+$this_rtqty;
			   }
			   
			   
			  
			   
			   
			   }else{
				    $transferd_qty=$this->Transfer_Model->getTransferdQtyByWarehouseId($srh_warehouse_id,$products->product_id,$srh_from_date,$srh_to_date);
				    /*
				     if($this->session->userdata('ss_user_id')==1){
				         echo $this->db->last_query();
				     }*/
				    
				 $transfer_reseve_qty=$this->Transfer_Model->getTransferResevedQtyByWarehouseId($srh_warehouse_id,$products->product_id,$srh_from_date,$srh_to_date);
				 
				  if($this->session->userdata('ss_user_id')==1){
				         //echo $this->db->last_query();
				     }
				 //$transfer_reseve_qty=90;
			   }
			   
			   /*
			    if($this->session->userdata('ss_user_id')==1){
               echo "transferd_qty:".$transferd_qty;
              }
               */
                $sold_qty = $this->Sales_Model->getSoldQtyByWarehouseId($srh_warehouse_id, $products->product_id, $srh_from_date, $srh_to_date);

                $purchased_qty = $this->Purchases_Model->getPurchasedQtyByWarehouseId($srh_warehouse_id, $products->product_id, $srh_from_date, $srh_to_date);
				
				// echo $this->db->last_query();

                //echo	$srh_warehouse_id;

                $purchases_return_qty = $this->Purchases_Model->getReturnQtyByWarehouseId($srh_warehouse_id, $products->product_id, $srh_from_date, $srh_to_date);

                //$purchased_qty=1;
                $product_damaged_qty=$this->Product_Damage_Model->getProductDamagedQtyByWarehouseId($srh_warehouse_id,$products->product_id,$srh_from_date,$srh_to_date);
                $sales_return_qty = $this->Sales_Return_Model->getSalesReturnQtyByWarehouseId($srh_warehouse_id, $products->product_id, $srh_from_date, $srh_to_date);

                $product_balance = 0;
                $product_balance=$purchased_qty+$transfer_reseve_qty+$sales_return_qty-$sold_qty-$transferd_qty-$product_damaged_qty-$purchases_return_qty;
				
				$details='';
				
				
				
				
				

                //$product_balance = $purchased_qty + $sales_return_qty - $sold_qty - $purchases_return_qty;

                $sale_price_sub_tot = $products->product_price * $product_balance;
				
				//get cost price for serial no
				$cost_price_sub_tot=0;
				$sn_tot_list=array();
				if($products->product_sn_exissts){
					$sn_list1 = $this->Purchases_Model->get_serial_no_by_product_id($products->product_id,$srh_warehouse_id);
		 			$sn_list_tra_res2 = $this->Purchases_Model->get_transfer_reserved_serial_no_by_product_id($products->product_id,$srh_warehouse_id);
					$sn_list=array_merge($sn_list1,$sn_list_tra_res2);
					
					$sn_tot_list=$this->Purchases_Model->get_serial_no_by_product_id_v5($products->product_id,$srh_warehouse_id);
				//	print_r($sn_tot_list);
					 foreach ($sn_tot_list as $row_1){
						$cost_price_sub_tot=$cost_price_sub_tot+$row_1->pis_cost_price; 
					 }
						
					//	echo "cost_price_sub_tot:$cost_price_sub_tot:"; die();
				}else{
					 $cost_price_sub_tot = $products->product_cost * $product_balance;
				}
				
				if($products->product_sn_exissts){
				$details="<a style=\"cursor:pointer\" onclick=\"pop_up_serial_no('$products->product_id')\">Serial</a>";
				}
				
				/*show serial list*/
				$product_id=$products->product_id;
				$sn_list1 = $this->Purchases_Model->get_serial_no_by_product_id($product_id,$srh_warehouse_id);
				$sn_list_tra_res2= $this->Purchases_Model->get_transfer_reserved_serial_no_by_product_id($product_id,$srh_warehouse_id);
				//print_r($sn_list_tra_res2);
				$sn_list_grn_rtn= $this->Purchases_Model->get_grn_return_serial_no_by_product_id($product_id,$srh_warehouse_id);
				
				$sn_list_by_avalable_warehosue = $this->Purchases_Model->get_serial_no_by_avalable_warehosue_id($product_id,$srh_warehouse_id);
			//	echo $this->db->last_query();
				
				$tra_pending_sn_list_by_avalable_warehosue = $this->Purchases_Model->get_tra_pending_serial_no_by_avalable_warehosue_id($product_id,$srh_warehouse_id);
				
				$sn_list=array_merge($sn_list1,$sn_list_tra_res2);
				$i=0;
				
				
				//echo "with_emi_no:$with_emi_no";
				
				if($with_emi_no){
					
					//print_r($sn_list);
					
					//print_r($sn_list_grn_rtn);
					
				/*foreach ($sn_list as $row_1){ 
					if (in_array($row_1->pis_number, array_column($sn_list_grn_rtn, 'pris_number'))){
						
						//$details.="<br/>($i).".$row_1->pis_number;
						$test='yes';
					}else{
						$i++;
						//$details.= "<br/> ($i).".$row_1->pis_number;
					}
					
					
					}*/
					
					
					//list avalable ware house array
					//$details.= "<br/>..System Under Testing..<br/>";
					$k=0;
					
					//print_r($sn_list_by_avalable_warehosue);
					foreach ($sn_list_by_avalable_warehosue as $row_1){ 
						$k++;
						$details.= "<br/> ($k).<a href=''>".$row_1->pis_number.'</a> - '.$row_1->code. " Cost: ".$row_1->pis_cost_price. " , Cash Price: ".$row_1->pis_cash_price;
					}
					foreach ($tra_pending_sn_list_by_avalable_warehosue as $row_1){ 
						$k++;
						$details.= "<br/> ($k).".$row_1->pis_number."( TP)".' - '.$row_1->code;
					}
				}
				
				//print_r($sn_list_by_avalable_warehosue);
				//sanath coment impornt
				$product_balance=count($sn_list_by_avalable_warehosue);
				//echo "product_balance:$product_balance";
				//$product_balance=0;
				//print_r($sn_list_by_avalable_warehosue);
				
				//echo "des:".$details;
				/*
				if($sn_list_grn_rtn){
				foreach ($sn_list_grn_rtn as $row_r){ 
						$i++;
						$details.="<br/>($i).".$row_r->pris_number;
					}
				}
				*/
				$display=0;
				
				
				
				/*
				if($purchased_qty!='' || $transferd_qty!='' || $transfer_reseve_qty!=''  || $sales_return_qty!=''  || $purchases_return_qty!=''|| $product_balance!=''){
					$display=1;	
				}
				
				*/
				if($product_balance!=''){
					$display=1;	
				}
				
				
				if($show_all){
				$display=1;	// show all items with 0 stcok
				}
				
			//	echo "only_empty:$only_empty";
					if($only_empty){
					    $display=0;	
					    if($product_balance==''){
				$display=1;	// show all items with 0 stcok
					    }
				}
				
				
				
             //$products->product_code;
			   $u_url="<a href='../products/edit/".$products->product_id."' target='_blank'>". $products->product_id."  </a>";
                $row[] = $u_url;
                $row[] = $products->product_name;
                
                //get cash price
                //$grn_itm_des=$this->Purchases_Model->get_last_grn_cost_price_by_prodcut_id($products->product_id);
                
               // print_r($grn_itm_des);
                $pis_cash_price=0;
                $pis_cash_price=$products->product_price;
                /*
                 if(isset($grn_itm_des)){
                     if(isset($grn_itm_des['pis_cash_price'])){
                    $pis_cash_price=$grn_itm_des['pis_cash_price'];
                     }
                }
                */
                
                $row[] = '';//$pis_cash_price;
                $row[] = '';//$products->cat_name;
               
                
                $row[] = '';//$products->sub_cat_name;
                
                if($show_details){
                $row[] = $products->store_position;
                $row[] = number_format($purchased_qty, 2, '.', ',');
				$row[] = number_format($transferd_qty, 2, '.', ',');
				
				$row[] = number_format($transfer_reseve_qty, 2, '.', ',');
                $row[] = number_format($sold_qty, 2, '.', ',');
                $row[] = number_format($sales_return_qty, 2, '.', ',');
                $row[] = number_format($purchases_return_qty, 2, '.', ',');
                $row[] = number_format($product_damaged_qty, 2, '.', ',');
                $row[] = $sale_price_sub_tot;
                $row[] = $cost_price_sub_tot;
                //$row[] = number_format($transferd_qty, 2, '.', ',');
                //$row[] = number_format($transfer_reseve_qty, 2, '.', ',');
                
                }else{
                    $row[] = '';
                    $row[] = '';
                    $row[] = '';
                    $row[] = '';
                    $row[] = '';
                    $row[] = '';
                    $row[] = '';
                    $row[] = '';
                    $row[] = '';
                    $row[] = '';
                }
                $row[] = $product_balance;
                //	$costPriceTot += $cost_price_sub_tot;
                
                $status_text='';
                
                //$status_text='<br/> '.$products->product_status;
                
                if ($products->product_status == 1) {
                            $status_text.=' <br/><a style="cursor: pointer;" onClick="disable_product(' . $products->product_id . ')"><i class="glyphicon fa fa-minus-circle"></i>Disable</a>';
                        } else   if ($products->product_status == 0) {
                            $status_text.=' <br/><a style="cursor: pointer;" onClick="enable_product(' . $products->product_id . ')"><i class="fa fa-check"></i>Enable</a>';
                        }
                        
                        if($this->input->post('ss_user_id')!=114)
                        
                          if ($this->session->userdata('ss_group_id')== 1 || $this->session->userdata('ss_group_id')== 9){
                        $status_text=$status_text;
                          }
                
                $row[] = $details;//.$status_text;
				if($display){
                $data[] = $row;
				}
				 
            }
            /**/

            $purchased_qty = 0;
            $purchases_return_qty = 0;
            $sold_qty = 0;
            $sales_return_qty = 0;
            $product_balance = 0;

            $sale_price_tot = 0;
            $cost_price_tot = 0;
            /* $product_id				= '';
              if (!empty($values_c)) {


              $transferd_qty=0;
              $transfer_reseve_qty=0;
              $transferd_qty=0;//$this->Transfer_Model->getTransferdQtyByWarehouseId($srh_warehouse_id,$products->product_id,$srh_from_date,$srh_to_date);
              $transfer_reseve_qty= 0;//$this->Transfer_Model->getTransferResevedQtyByWarehouseId($srh_warehouse_id,$products->product_id,$srh_from_date,$srh_to_date);
              $sold_qty=$this->Sales_Model->getSoldQtyByWarehouseId($srh_warehouse_id,$product_id,$srh_from_date,$srh_to_date,$search_key_val,$cat_srh);
              $purchased_qty=$this->Purchases_Model->getPurchasedQtyByWarehouseId($srh_warehouse_id,$product_id,$srh_from_date,$srh_to_date,$search_key_val,$cat_srh);
              $purchases_return_qty=$this->Purchases_Model->getReturnQtyByWarehouseId($srh_warehouse_id,$product_id,$srh_from_date,$srh_to_date,$search_key_val,$cat_srh);
              $product_damaged_qty= 0;//$this->Product_Damage_Model->getProductDamagedQtyByWarehouseId($srh_warehouse_id,$products->product_id,$srh_from_date,$srh_to_date);
              $sales_return_qty=$this->Sales_Return_Model->getSalesReturnQtyByWarehouseId($srh_warehouse_id,$product_id,$srh_from_date,$srh_to_date,$search_key_val,$cat_srh);


              //$product_balance=$purchased_qty+$transfer_reseve_qty+$sales_return_qty-$sold_qty-$transferd_qty-$product_damaged_qty-$purchases_return_qty;

              //$sale_price_tot=$this->Sales_Model->getSoldPriceByWarehouseId($srh_warehouse_id,'',$srh_from_date,$srh_to_date,$search_key_val,$cat_srh);
              //$cost_price_tot=$this->Sales_Model->getCostPriceByWarehouseId($srh_warehouse_id,'',$srh_from_date,$srh_to_date,$search_key_val,$cat_srh);

              //$sale_price_tot=$product_price*$product_balance;
              //$cost_price_tot=$product_cost*$product_balance;


              } */
            /**/

            /**/
            $output = array(
                "purchased_qty" => intval($purchased_qty),
                "sold_qty" => intval($sold_qty),
                "sales_return_qty" => intval($sales_return_qty),
                "purchases_return_qty" => intval($purchases_return_qty),
                "product_balance" => intval($product_balance),
                "damadge_qty" => 0,
                "sale_price_tot" => floatval($sale_price_tot),
                "cost_price_tot" => floatval($cost_price_tot),
                "recordsTotal" => intval($totalData),
                "recordsFiltered" => intval($totalFiltered),
                'data' => $data);
            echo json_encode($output);
        } else {
            $output = array(
                "recordsTotal" => '',
                "recordsFiltered" => '',
                'data' => '');
            echo json_encode($output);
        }
    }
	   
	   
	public function get_list_product_for_print_sm($value = '') {
        $srh_warehouse_id = $this->input->post('srh_warehouse_id');
        $cat_srh = $this->input->post('cat_srh');
		$with_emi_no = $this->input->post('with_emi_no');
		$subcategory = $this->input->post('subcategory');
		$product_id = $this->input->post('product_id');
		$show_all = $this->input->post('show_all');
		$product_name = $this->input->post('product_name');
		$dep_id = $this->input->post('dep_id');
		$srh_sub_cat = $this->input->post('srh_sub_cat');
			$show_details = $this->input->post('show_details');
		
		

        $srh_from_date = '';
        $srh_to_date = '';
        if ($this->input->post('srh_to_date')) {
            $srh_to_date = date('Y-m-d', strtotime($this->input->post('srh_to_date')));
        }
        if ($this->input->post('srh_from_date')) {
            $srh_from_date = date('Y-m-d', strtotime($this->input->post('srh_from_date')));
        }

        /*         * ****************** */
        $search_key = $this->input->post('search');
        $search_key_val = $search_key['value'];
        $start = $this->input->post('start');
        $length = $this->input->post('length');

        $this->load->model('Product_Models');
        $values = '';
        $totalFiltered = 0;

//	$sales = $this->Sales_Model->get_all_sales($start,$length,$search_key_val);
//	$sales_count = $this->Sales_Model->get_all_sales('','','');

        $totalData = 0;
//	echo $length."//";
        //$getSumProductsForReport = $this->Product_Models->getSumProductsForReport($srh_warehouse_id,$cat_srh);

        if ($search_key_val) {
            $values = $this->Product_Models->getProductsForReport($srh_warehouse_id, $cat_srh, $start, $length, $search_key_val,'',$subcategory,$product_id,$product_name,$dep_id,$srh_sub_cat);
            //$values_c = $this->Product_Models->getProductsForReport_c($srh_warehouse_id, $cat_srh, '', '', $search_key_val);
            $totalData = $this->Product_Models->getProductsForReport($srh_warehouse_id, $cat_srh, $start, $length, $search_key_val,1,$subcategory,$product_id,$product_name,$dep_id,$srh_sub_cat);
        } else {
            $values = $this->Product_Models->getProductsForReport($srh_warehouse_id, $cat_srh, $start, $length, '','',$subcategory,$product_id,$product_name,$dep_id,$srh_sub_cat);
           // $values_c = $this->Product_Models->getProductsForReport_c($srh_warehouse_id, $cat_srh, $start, '', '');
            //print_r($values_c[0]->count);
             $totalData = $this->Product_Models->getProductsForReport($srh_warehouse_id, $cat_srh, '', '', '',1,$subcategory,$product_id,$product_name,$dep_id,$srh_sub_cat);
        }

        $totalFiltered = $totalData;
        /*         * ****************** */

        $costPriceTot = 0; //$this->Purchases_Model->getPurchasedQtyByWarehouseId('','',$srh_from_date,$srh_to_date);

        $data = array();

        if (!empty($values)) {
            foreach ($values as $products) {

                if ($products->product_status == 0) {
                    $k = "btn-warning";
                    $m = "fa-minus-circle";
                } else {
                    $k = "btn-green";
                    $m = "fa-check";
                }
                $retVal = (empty($products->sub_cat_name)) ? "--:--" : $products->sub_cat_name;

                $row = array();

                //get transferd qty
                $transferd_qty = 0;
				$pending_transferd_qty=0;
                $transfer_reseve_qty = 0;
				$purchases_return_qty=0;

               // $transferd_qty=$this->Transfer_Model->getTransferdQtyByWarehouseId($srh_warehouse_id,$products->product_id,$srh_from_date,$srh_to_date);
				// $transfer_reseve_qty=$this->Transfer_Model->getTransferResevedQtyByWarehouseId($srh_warehouse_id,$products->product_id,$srh_from_date,$srh_to_date);
			   
			  
			   if(!$srh_warehouse_id){
			   $warehouse_list = $this->Warehouse_Model->get_all_warehouse();
			   foreach ($warehouse_list as $row_w){
				   $tmp_whe_id=$row_w->id;
				   $this_tqty=$this->Transfer_Model->getTransferdQtyByWarehouseId($tmp_whe_id,$products->product_id,$srh_from_date,$srh_to_date);
				   //echo $this->db->last_query();
				   //echo "$tmp_whe_id: $this_tqty / <br/> ";
				   $transferd_qty=$transferd_qty+$this_tqty;
				   
				   
				    $this_rtqty=$this->Transfer_Model->getTransferResevedQtyByWarehouseId($tmp_whe_id,$products->product_id,$srh_from_date,$srh_to_date);
					 $transfer_reseve_qty=$transfer_reseve_qty+$this_rtqty;
			   }
			   
			   
			  
			   
			   
			   }else{
				    $transferd_qty=$this->Transfer_Model->getTransferdQtyByWarehouseId($srh_warehouse_id,$products->product_id,$srh_from_date,$srh_to_date);
				    /*
				     if($this->session->userdata('ss_user_id')==1){
				         echo $this->db->last_query();
				     }*/
				    
				 $transfer_reseve_qty=$this->Transfer_Model->getTransferResevedQtyByWarehouseId($srh_warehouse_id,$products->product_id,$srh_from_date,$srh_to_date);
				 
				  if($this->session->userdata('ss_user_id')==1){
				         //echo $this->db->last_query();
				     }
				 //$transfer_reseve_qty=90;
			   }
			   
			   /*
			    if($this->session->userdata('ss_user_id')==1){
               echo "transferd_qty:".$transferd_qty;
              }
               */
                $sold_qty = $this->Sales_Model->getSoldQtyByWarehouseId($srh_warehouse_id, $products->product_id, $srh_from_date, $srh_to_date);

                $purchased_qty = $this->Purchases_Model->getPurchasedQtyByWarehouseId($srh_warehouse_id, $products->product_id, $srh_from_date, $srh_to_date);
				
				// echo $this->db->last_query();

                //echo	$srh_warehouse_id;

                $purchases_return_qty = $this->Purchases_Model->getReturnQtyByWarehouseId($srh_warehouse_id, $products->product_id, $srh_from_date, $srh_to_date);

                //$purchased_qty=1;
                $product_damaged_qty=$this->Product_Damage_Model->getProductDamagedQtyByWarehouseId($srh_warehouse_id,$products->product_id,$srh_from_date,$srh_to_date);
                $sales_return_qty = $this->Sales_Return_Model->getSalesReturnQtyByWarehouseId($srh_warehouse_id, $products->product_id, $srh_from_date, $srh_to_date);

                $product_balance = 0;
                $product_balance=$purchased_qty+$transfer_reseve_qty+$sales_return_qty-$sold_qty-$transferd_qty-$product_damaged_qty-$purchases_return_qty;
				
				$details='';
				
				
				
				
				

                //$product_balance = $purchased_qty + $sales_return_qty - $sold_qty - $purchases_return_qty;

                $sale_price_sub_tot = $products->product_price * $product_balance;
				
				//get cost price for serial no
				$cost_price_sub_tot=0;
				
				if($products->product_sn_exissts){
					$sn_list1 = $this->Purchases_Model->get_serial_no_by_product_id($products->product_id,$srh_warehouse_id);
		 			$sn_list_tra_res2 = $this->Purchases_Model->get_transfer_reserved_serial_no_by_product_id($products->product_id,$srh_warehouse_id);
					$sn_list=array_merge($sn_list1,$sn_list_tra_res2);
					 foreach ($sn_list as $row_1){
						$cost_price_sub_tot=$cost_price_sub_tot+$row_1->pis_cost_price; 
					 }
						
				}else{
					 $cost_price_sub_tot = $products->product_cost * $product_balance;
				}
				
				if($products->product_sn_exissts){
				$details="<a style=\"cursor:pointer\" onclick=\"pop_up_serial_no('$products->product_id')\">View Serial</a>";
				}
				
				/*show serial list*/
				$product_id=$products->product_id;
				$sn_list1 = $this->Purchases_Model->get_serial_no_by_product_id($product_id,$srh_warehouse_id);
				$sn_list_tra_res2= $this->Purchases_Model->get_transfer_reserved_serial_no_by_product_id($product_id,$srh_warehouse_id);
				//print_r($sn_list_tra_res2);
				$sn_list_grn_rtn= $this->Purchases_Model->get_grn_return_serial_no_by_product_id($product_id,$srh_warehouse_id);
				
				$sn_list_by_avalable_warehosue = $this->Purchases_Model->get_serial_no_by_avalable_warehosue_id($product_id,$srh_warehouse_id);
			//	echo $this->db->last_query();
				
				$tra_pending_sn_list_by_avalable_warehosue = $this->Purchases_Model->get_tra_pending_serial_no_by_avalable_warehosue_id($product_id,$srh_warehouse_id);
				
				$sn_list=array_merge($sn_list1,$sn_list_tra_res2);
				$i=0;
				
				
				//echo "with_emi_no:$with_emi_no";
				
				if($with_emi_no){
					
					//print_r($sn_list);
					
					//print_r($sn_list_grn_rtn);
					
				/*foreach ($sn_list as $row_1){ 
					if (in_array($row_1->pis_number, array_column($sn_list_grn_rtn, 'pris_number'))){
						
						//$details.="<br/>($i).".$row_1->pis_number;
						$test='yes';
					}else{
						$i++;
						//$details.= "<br/> ($i).".$row_1->pis_number;
					}
					
					
					}*/
					
					
					//list avalable ware house array
					//$details.= "<br/>..System Under Testing..<br/>";
					$k=0;
					foreach ($sn_list_by_avalable_warehosue as $row_1){ 
						$k++;
						$details.= "<br/> ($k).<a href=''>".$row_1->pis_number.'</a> - '.$row_1->code;
					}
					foreach ($tra_pending_sn_list_by_avalable_warehosue as $row_1){ 
						$k++;
						$details.= "<br/> ($k).".$row_1->pis_number."( TP)".' - '.$row_1->code;
					}
				}
				
				//echo "des:".$details;
				/*
				if($sn_list_grn_rtn){
				foreach ($sn_list_grn_rtn as $row_r){ 
						$i++;
						$details.="<br/>($i).".$row_r->pris_number;
					}
				}
				*/
				$display=0;
				
				
				
				/*
				if($purchased_qty!='' || $transferd_qty!='' || $transfer_reseve_qty!=''  || $sales_return_qty!=''  || $purchases_return_qty!=''|| $product_balance!=''){
					$display=1;	
				}
				
				*/
				if($product_balance!=''){
					$display=1;	
				}
				
				
				if($show_all){
				$display=1;	// show all items with 0 stcok
				}
				
             //$products->product_code;
			   $u_url="<a href='../products/edit/".$products->product_id."' target='_blank'>". $products->product_id." </a>";
                $row[] = $u_url;
                $row[] = $products->product_name;
                $row[] = '';
                $row[] = '';//$products->cat_name;
                
                
                $row[] = '';//$products->sub_cat_name;
                
                if($show_details){
                $row[] = $products->store_position;
                $row[] = number_format($purchased_qty, 2, '.', ',');
				$row[] = number_format($transferd_qty, 2, '.', ',');
				
				$row[] = number_format($transfer_reseve_qty, 2, '.', ',');
                $row[] = number_format($sold_qty, 2, '.', ',');
                $row[] = number_format($sales_return_qty, 2, '.', ',');
                $row[] = number_format($purchases_return_qty, 2, '.', ',');
                $row[] = number_format($product_damaged_qty, 2, '.', ',');
                $row[] = $sale_price_sub_tot;
                $row[] = $cost_price_sub_tot;
                //$row[] = number_format($transferd_qty, 2, '.', ',');
                //$row[] = number_format($transfer_reseve_qty, 2, '.', ',');
                
                }else{
                    $row[] = '';
                    $row[] = '';
                    $row[] = '';
                    $row[] = '';
                    $row[] = '';
                    $row[] = '';
                    $row[] = '';
                    $row[] = '';
                    $row[] = '';
                    $row[] = '';
                }
                $row[] = $product_balance;
                //	$costPriceTot += $cost_price_sub_tot;
                $row[] = '';//$details;
				if($display){
                $data[] = $row;
				}
				 
            }
            /**/

            $purchased_qty = 0;
            $purchases_return_qty = 0;
            $sold_qty = 0;
            $sales_return_qty = 0;
            $product_balance = 0;

            $sale_price_tot = 0;
            $cost_price_tot = 0;
            /* $product_id				= '';
              if (!empty($values_c)) {


              $transferd_qty=0;
              $transfer_reseve_qty=0;
              $transferd_qty=0;//$this->Transfer_Model->getTransferdQtyByWarehouseId($srh_warehouse_id,$products->product_id,$srh_from_date,$srh_to_date);
              $transfer_reseve_qty= 0;//$this->Transfer_Model->getTransferResevedQtyByWarehouseId($srh_warehouse_id,$products->product_id,$srh_from_date,$srh_to_date);
              $sold_qty=$this->Sales_Model->getSoldQtyByWarehouseId($srh_warehouse_id,$product_id,$srh_from_date,$srh_to_date,$search_key_val,$cat_srh);
              $purchased_qty=$this->Purchases_Model->getPurchasedQtyByWarehouseId($srh_warehouse_id,$product_id,$srh_from_date,$srh_to_date,$search_key_val,$cat_srh);
              $purchases_return_qty=$this->Purchases_Model->getReturnQtyByWarehouseId($srh_warehouse_id,$product_id,$srh_from_date,$srh_to_date,$search_key_val,$cat_srh);
              $product_damaged_qty= 0;//$this->Product_Damage_Model->getProductDamagedQtyByWarehouseId($srh_warehouse_id,$products->product_id,$srh_from_date,$srh_to_date);
              $sales_return_qty=$this->Sales_Return_Model->getSalesReturnQtyByWarehouseId($srh_warehouse_id,$product_id,$srh_from_date,$srh_to_date,$search_key_val,$cat_srh);


              //$product_balance=$purchased_qty+$transfer_reseve_qty+$sales_return_qty-$sold_qty-$transferd_qty-$product_damaged_qty-$purchases_return_qty;

              //$sale_price_tot=$this->Sales_Model->getSoldPriceByWarehouseId($srh_warehouse_id,'',$srh_from_date,$srh_to_date,$search_key_val,$cat_srh);
              //$cost_price_tot=$this->Sales_Model->getCostPriceByWarehouseId($srh_warehouse_id,'',$srh_from_date,$srh_to_date,$search_key_val,$cat_srh);

              //$sale_price_tot=$product_price*$product_balance;
              //$cost_price_tot=$product_cost*$product_balance;


              } */
            /**/

            /**/
            $output = array(
                "purchased_qty" => intval($purchased_qty),
                "sold_qty" => intval($sold_qty),
                "sales_return_qty" => intval($sales_return_qty),
                "purchases_return_qty" => intval($purchases_return_qty),
                "product_balance" => intval($product_balance),
                "damadge_qty" => 0,
                "sale_price_tot" => floatval($sale_price_tot),
                "cost_price_tot" => floatval($cost_price_tot),
                "recordsTotal" => intval($totalData),
                "recordsFiltered" => intval($totalFiltered),
                'data' => $data);
            echo json_encode($output);
        } else {
            $output = array(
                "recordsTotal" => '',
                "recordsFiltered" => '',
                'data' => '');
            echo json_encode($output);
        }
    }
	   
	  
	  
	  function get_avalable_qty_by_date_rang($product_id,$srh_from_date='',$srh_to_date='',$srh_warehouse_id=''){
	      $location_id=0;
	      //opening_stock_qty get
	$day_before = date( 'Y-m-d', strtotime( $srh_from_date . ' -1 day' ) );
	$opening_stock_date=$day_before;
	$opening_stock_qty=0;
	$opening_stock_from_date='2017-12-24';//date('2018-06-24');
	$date_1=date( 'Y-m-d', strtotime( $opening_stock_from_date . ' +1 day' ) );
	$os_i=0;//$this->Report_Model->get_location_issue_by_location_id_and_date($location_id,$product_id,$date_1,$day_before);
	//os grn
	$os_grn=0;
	$os_grn_rtn=0;
	$os_grn=$this->Purchases_Model->getPurchasedQtyByWarehouseIdAndDateRange($location_id,$product_id,$date_1,$day_before);
	$os_grn_rtn=$this->Purchases_Model->getPurchaseRTNdQtyByWarehouseIdAndDateRange($location_id,$product_id,$date_1,$day_before);
	$os_ir=0;//$this->Report_Model->get_location_issue_return_by_location_id_and_date($location_id,$product_id,$date_1,$day_before);
	$os_s =$this->Report_Model->get_location_sale_by_location_id_and_date($location_id,$product_id,$date_1,$day_before);
	
	$os_sales_return_qty = $this->Sales_Return_Model->getSalesReturnQtyByWarehouseId($srh_warehouse_id, $product_id, $date_1, $day_before);
	
	//$os_s=$this->Report_Model->get_location_sale_by_location_id_and_date(0,$product_id,$srh_from_date,$srh_to_date,'',$srh_warehouse_id);
	//echo $this->db->last_query();
	$os_h =0;// $this->Report_Model->get_location_sale_by_location_id_and_date($location_id,$product_id,$date_1,$day_before,'Hire');
	$os_st_adj=0;
		//$os_st_adj=$this->Purchases_Model->getStockAdjQtyByWarehouseIdAndDateRange($location_id,$product_id,$date_1,$day_before);
	
	//service issue 
	$os_ser_issue=$this->Purchases_Model->getServiceIssueWarehouseIdAndDateRange($location_id,$product_id,$date_1,$day_before);
	$os_ser_issue_rtn=$this->Purchases_Model->getServiceReturnWarehouseIdAndDateRange($location_id,$product_id,$date_1,$day_before);
	
	
	$trf_out_os=0;
	$trf_in_os=0;
	$trf_out_os=intVal($this->Transfer_Model->getTransferdQtyByWarehouseId($srh_warehouse_id,$product_id,$date_1,$day_before,''));
	
	//$warehouse_id,$product_id,$srh_from_date='',$srh_to_date='',$search_key_val='',$cat_srh='',$trnsfr_to_warehouse_id=''
	$trf_in_os=intVal($this->Transfer_Model->getTransferdQtyByWarehouseId('',$product_id,$date_1,$day_before,'','',$srh_warehouse_id));
	
	
	$os_exchange_qty=0;//$this->Report_Model->get_location_sale_exchange_by_location_id_and_date(0,$product_id,$date_1,$day_before,'',$srh_warehouse_id);
	
	$os_exchange_qty=intval($os_exchange_qty);
	
	
	
	
	//
	
	$test_var='';
	$opening_stock_qty_des="";
	$warehouse_opening_stock=0;
	//Start Date: $opening_stock_from_date 
	$opening_stock_qty_des="<br/>wos:$warehouse_opening_stock , os_i:$os_i ,os_ir:$os_ir ,os_s:$os_s ,os_h:$os_h , os e :$os_exchange_qty:";
	//$opening_stock_qty=$os_i-$os_ir-$os_s-$os_h;
	$opening_stock_qty=$warehouse_opening_stock+$os_i-$os_ir-$os_s-$os_h;
	$warehouse_opening_stock_tot=0;
	$warehouse_opening_stock_tot=$warehouse_opening_stock+$os_grn-$os_grn_rtn-$os_i+$os_ir-$os_s-$os_h-$os_ser_issue+$os_ser_issue_rtn+$os_exchange_qty-$os_st_adj+$os_sales_return_qty;
	return $warehouse_opening_stock_tot;
	  }
	
	public function get_list_dynamic_stock_report($value = '') {
        $srh_warehouse_id = $this->input->post('srh_warehouse_id');
        $cat_srh = $this->input->post('cat_srh');
		$with_emi_no = $this->input->post('with_emi_no');
		$subcategory = $this->input->post('subcategory');
		$product_id = $this->input->post('product_id');
		$show_all = $this->input->post('show_all');
		$product_name = $this->input->post('product_name');
		$dep_id = $this->input->post('dep_id');
		$srh_sub_cat = $this->input->post('srh_sub_cat');
			$show_details = $this->input->post('show_details');
		

        $srh_from_date = '';
        $srh_to_date = '';
        if ($this->input->post('srh_to_date')) {
            $srh_to_date = date('Y-m-d', strtotime($this->input->post('srh_to_date')));
        }
        if ($this->input->post('srh_from_date')) {
            $srh_from_date = date('Y-m-d', strtotime($this->input->post('srh_from_date')));
        }
        
        $openning_stock=0;
		$openning_stock=$this->get_avalable_qty_by_date_rang($product_id,$srh_from_date,$srh_to_date,$srh_warehouse_id);

        /*         * ****************** */
        $search_key = $this->input->post('search');
        $search_key_val = $search_key['value'];
        $start = $this->input->post('start');
        $length = $this->input->post('length');

        $this->load->model('Product_Models');
        $values = '';
        $totalFiltered = 0;

//	$sales = $this->Sales_Model->get_all_sales($start,$length,$search_key_val);
//	$sales_count = $this->Sales_Model->get_all_sales('','','');

        $totalData = 0;
//	echo $length."//";
        //$getSumProductsForReport = $this->Product_Models->getSumProductsForReport($srh_warehouse_id,$cat_srh);

        if ($search_key_val) {
            $values = $this->Product_Models->getProductsForReport($srh_warehouse_id, $cat_srh, $start, $length, $search_key_val,'',$subcategory,$product_id,$product_name,$dep_id,$srh_sub_cat);
            //$values_c = $this->Product_Models->getProductsForReport_c($srh_warehouse_id, $cat_srh, '', '', $search_key_val);
            $totalData = $this->Product_Models->getProductsForReport($srh_warehouse_id, $cat_srh, $start, $length, $search_key_val,1,$subcategory,$product_id,$product_name,$dep_id,$srh_sub_cat);
        } else {
            $values = $this->Product_Models->getProductsForReport($srh_warehouse_id, $cat_srh, $start, $length, '','',$subcategory,$product_id,$product_name,$dep_id,$srh_sub_cat);
           // $values_c = $this->Product_Models->getProductsForReport_c($srh_warehouse_id, $cat_srh, $start, '', '');
            //print_r($values_c[0]->count);
             $totalData = $this->Product_Models->getProductsForReport($srh_warehouse_id, $cat_srh, '', '', '',1,$subcategory,$product_id,$product_name,$dep_id,$srh_sub_cat);
        }

        $totalFiltered = $totalData;
        /*         * ****************** */

        $costPriceTot = 0; //$this->Purchases_Model->getPurchasedQtyByWarehouseId('','',$srh_from_date,$srh_to_date);

        $data = array();

        if (!empty($values)) {
            foreach ($values as $products) {

                if ($products->product_status == 0) {
                    $k = "btn-warning";
                    $m = "fa-minus-circle";
                } else {
                    $k = "btn-green";
                    $m = "fa-check";
                }
                $retVal = (empty($products->sub_cat_name)) ? "--:--" : $products->sub_cat_name;

                $row = array();

                //get transferd qty
                $transferd_qty = 0;
				$pending_transferd_qty=0;
                $transfer_reseve_qty = 0;
				$purchases_return_qty=0;

               // $transferd_qty=$this->Transfer_Model->getTransferdQtyByWarehouseId($srh_warehouse_id,$products->product_id,$srh_from_date,$srh_to_date);
				// $transfer_reseve_qty=$this->Transfer_Model->getTransferResevedQtyByWarehouseId($srh_warehouse_id,$products->product_id,$srh_from_date,$srh_to_date);
			   
			  
			   if(!$srh_warehouse_id){
			   $warehouse_list = $this->Warehouse_Model->get_all_warehouse();
			   foreach ($warehouse_list as $row_w){
				   $tmp_whe_id=$row_w->id;
				   $this_tqty=$this->Transfer_Model->getTransferdQtyByWarehouseId($tmp_whe_id,$products->product_id,$srh_from_date,$srh_to_date);
				   //echo $this->db->last_query();
				   //echo "$tmp_whe_id: $this_tqty / <br/> ";
				   $transferd_qty=$transferd_qty+$this_tqty;
				   
				   
				    $this_rtqty=$this->Transfer_Model->getTransferResevedQtyByWarehouseId($tmp_whe_id,$products->product_id,$srh_from_date,$srh_to_date);
					 $transfer_reseve_qty=$transfer_reseve_qty+$this_rtqty;
			   }
			   
			   
			  
			   
			   
			   }else{
				    $transferd_qty=$this->Transfer_Model->getTransferdQtyByWarehouseId($srh_warehouse_id,$products->product_id,$srh_from_date,$srh_to_date);
				    /*
				     if($this->session->userdata('ss_user_id')==1){
				         echo $this->db->last_query();
				     }*/
				    
				 $transfer_reseve_qty=$this->Transfer_Model->getTransferResevedQtyByWarehouseId($srh_warehouse_id,$products->product_id,$srh_from_date,$srh_to_date);
				 
				  if($this->session->userdata('ss_user_id')==1){
				         //echo $this->db->last_query();
				     }
				 //$transfer_reseve_qty=90;
			   }
			   
			   /*
			    if($this->session->userdata('ss_user_id')==1){
               echo "transferd_qty:".$transferd_qty;
              }
               */
                $sold_qty = $this->Sales_Model->getSoldQtyByWarehouseId($srh_warehouse_id, $products->product_id, $srh_from_date, $srh_to_date);

                $purchased_qty = $this->Purchases_Model->getPurchasedQtyByWarehouseId($srh_warehouse_id, $products->product_id, $srh_from_date, $srh_to_date);
				
				// echo $this->db->last_query();

                //echo	$srh_warehouse_id;

                $purchases_return_qty = $this->Purchases_Model->getReturnQtyByWarehouseId($srh_warehouse_id, $products->product_id, $srh_from_date, $srh_to_date);

                //$purchased_qty=1;
                $product_damaged_qty=$this->Product_Damage_Model->getProductDamagedQtyByWarehouseId($srh_warehouse_id,$products->product_id,$srh_from_date,$srh_to_date);
                $sales_return_qty = $this->Sales_Return_Model->getSalesReturnQtyByWarehouseId($srh_warehouse_id, $products->product_id, $srh_from_date, $srh_to_date);

                $product_balance = 0;
                $product_balance=$openning_stock+$purchased_qty+$transfer_reseve_qty+$sales_return_qty-$sold_qty-$transferd_qty-$product_damaged_qty-$purchases_return_qty;
				
				$details='';
				
				
				
				
				

                //$product_balance = $purchased_qty + $sales_return_qty - $sold_qty - $purchases_return_qty;

                $sale_price_sub_tot = $products->product_price * $product_balance;
				
				//get cost price for serial no
				$cost_price_sub_tot=0;
				
				if($products->product_sn_exissts){
					$sn_list1 = $this->Purchases_Model->get_serial_no_by_product_id($products->product_id,$srh_warehouse_id);
		 			$sn_list_tra_res2 = $this->Purchases_Model->get_transfer_reserved_serial_no_by_product_id($products->product_id,$srh_warehouse_id);
					$sn_list=array_merge($sn_list1,$sn_list_tra_res2);
					 foreach ($sn_list as $row_1){
						$cost_price_sub_tot=$cost_price_sub_tot+$row_1->pis_cost_price; 
					 }
						
				}else{
					 $cost_price_sub_tot = $products->product_cost * $product_balance;
				}
				
				if($products->product_sn_exissts){
				$details="<a style=\"cursor:pointer\" onclick=\"pop_up_serial_no('$products->product_id')\">View Serial</a>";
				}
				
				/*show serial list*/
				$product_id=$products->product_id;
				$sn_list1 = $this->Purchases_Model->get_serial_no_by_product_id($product_id,$srh_warehouse_id);
				$sn_list_tra_res2= $this->Purchases_Model->get_transfer_reserved_serial_no_by_product_id($product_id,$srh_warehouse_id);
				//print_r($sn_list_tra_res2);
				$sn_list_grn_rtn= $this->Purchases_Model->get_grn_return_serial_no_by_product_id($product_id,$srh_warehouse_id);
				
				$sn_list_by_avalable_warehosue = $this->Purchases_Model->get_serial_no_by_avalable_warehosue_id($product_id,$srh_warehouse_id);
			//	echo $this->db->last_query();
				
				$tra_pending_sn_list_by_avalable_warehosue = $this->Purchases_Model->get_tra_pending_serial_no_by_avalable_warehosue_id($product_id,$srh_warehouse_id);
				
				$sn_list=array_merge($sn_list1,$sn_list_tra_res2);
				$i=0;
				
				
				//echo "with_emi_no:$with_emi_no";
				
				if($with_emi_no){
					
					//print_r($sn_list);
					
					//print_r($sn_list_grn_rtn);
					
				/*foreach ($sn_list as $row_1){ 
					if (in_array($row_1->pis_number, array_column($sn_list_grn_rtn, 'pris_number'))){
						
						//$details.="<br/>($i).".$row_1->pis_number;
						$test='yes';
					}else{
						$i++;
						//$details.= "<br/> ($i).".$row_1->pis_number;
					}
					
					
					}*/
					
					
					//list avalable ware house array
					//$details.= "<br/>..System Under Testing..<br/>";
					$k=0;
					foreach ($sn_list_by_avalable_warehosue as $row_1){ 
						$k++;
						$details.= "<br/> ($k).<a href=''>".$row_1->pis_number.'</a> - '.$row_1->code;
					}
					foreach ($tra_pending_sn_list_by_avalable_warehosue as $row_1){ 
						$k++;
						$details.= "<br/> ($k).".$row_1->pis_number."( TP)".' - '.$row_1->code;
					}
				}
				
				//echo "des:".$details;
				/*
				if($sn_list_grn_rtn){
				foreach ($sn_list_grn_rtn as $row_r){ 
						$i++;
						$details.="<br/>($i).".$row_r->pris_number;
					}
				}
				*/
				$display=0;
				
				
				
				/*
				if($purchased_qty!='' || $transferd_qty!='' || $transfer_reseve_qty!=''  || $sales_return_qty!=''  || $purchases_return_qty!=''|| $product_balance!=''){
					$display=1;	
				}
				
				*/
				if($product_balance!=''){
					$display=1;	
				}
				
				
				if($show_all){
				$display=1;	// show all items with 0 stcok
				}
				
             //$products->product_code;
			   $u_url="<a href='../products/edit/".$products->product_id."' target='_blank'>". $products->product_code." </a>";
                $row[] = $u_url;
                $row[] = $products->product_name;
                $row[] = '';
                $row[] = '';//$products->cat_name;
                
                
                //$products->sub_cat_name;
                
                if($show_details){
                    
                $row[] = $products->store_position;
                $row[] = $openning_stock;
                $row[] = number_format($purchased_qty, 2, '.', ',');
				$row[] = number_format($transferd_qty, 2, '.', ',');
				
				$row[] = number_format($transfer_reseve_qty, 2, '.', ',');
                $row[] = number_format($sold_qty, 2, '.', ',');
                $row[] = number_format($sales_return_qty, 2, '.', ',');
                $row[] = number_format($purchases_return_qty, 2, '.', ',');
                $row[] = number_format($product_damaged_qty, 2, '.', ',');
                $row[] = $sale_price_sub_tot;
                $row[] = $cost_price_sub_tot;
                //$row[] = number_format($transferd_qty, 2, '.', ',');
                //$row[] = number_format($transfer_reseve_qty, 2, '.', ',');
                
                }else{
                    $row[] = '';
                    $row[] = '';
                    $row[] = '';
                    $row[] = '';
                    $row[] = '';
                    $row[] = '';
                    $row[] = '';
                    $row[] = '';
                    $row[] = '';
                    $row[] = '';
                    $row[] = '';
                }
                $row[] = $product_balance;
                //	$costPriceTot += $cost_price_sub_tot;
                $row[] = '';//$details;
				if($display){
                $data[] = $row;
				}
				 
            }
            /**/

            $purchased_qty = 0;
            $purchases_return_qty = 0;
            $sold_qty = 0;
            $sales_return_qty = 0;
            $product_balance = 0;

            $sale_price_tot = 0;
            $cost_price_tot = 0;
            /* $product_id				= '';
              if (!empty($values_c)) {


              $transferd_qty=0;
              $transfer_reseve_qty=0;
              $transferd_qty=0;//$this->Transfer_Model->getTransferdQtyByWarehouseId($srh_warehouse_id,$products->product_id,$srh_from_date,$srh_to_date);
              $transfer_reseve_qty= 0;//$this->Transfer_Model->getTransferResevedQtyByWarehouseId($srh_warehouse_id,$products->product_id,$srh_from_date,$srh_to_date);
              $sold_qty=$this->Sales_Model->getSoldQtyByWarehouseId($srh_warehouse_id,$product_id,$srh_from_date,$srh_to_date,$search_key_val,$cat_srh);
              $purchased_qty=$this->Purchases_Model->getPurchasedQtyByWarehouseId($srh_warehouse_id,$product_id,$srh_from_date,$srh_to_date,$search_key_val,$cat_srh);
              $purchases_return_qty=$this->Purchases_Model->getReturnQtyByWarehouseId($srh_warehouse_id,$product_id,$srh_from_date,$srh_to_date,$search_key_val,$cat_srh);
              $product_damaged_qty= 0;//$this->Product_Damage_Model->getProductDamagedQtyByWarehouseId($srh_warehouse_id,$products->product_id,$srh_from_date,$srh_to_date);
              $sales_return_qty=$this->Sales_Return_Model->getSalesReturnQtyByWarehouseId($srh_warehouse_id,$product_id,$srh_from_date,$srh_to_date,$search_key_val,$cat_srh);


              //$product_balance=$purchased_qty+$transfer_reseve_qty+$sales_return_qty-$sold_qty-$transferd_qty-$product_damaged_qty-$purchases_return_qty;

              //$sale_price_tot=$this->Sales_Model->getSoldPriceByWarehouseId($srh_warehouse_id,'',$srh_from_date,$srh_to_date,$search_key_val,$cat_srh);
              //$cost_price_tot=$this->Sales_Model->getCostPriceByWarehouseId($srh_warehouse_id,'',$srh_from_date,$srh_to_date,$search_key_val,$cat_srh);

              //$sale_price_tot=$product_price*$product_balance;
              //$cost_price_tot=$product_cost*$product_balance;


              } */
            /**/

            /**/
            $output = array(
                "purchased_qty" => intval($purchased_qty),
                "sold_qty" => intval($sold_qty),
                "sales_return_qty" => intval($sales_return_qty),
                "purchases_return_qty" => intval($purchases_return_qty),
                "product_balance" => intval($product_balance),
                "damadge_qty" => 0,
                "sale_price_tot" => floatval($sale_price_tot),
                "cost_price_tot" => floatval($cost_price_tot),
                "recordsTotal" => intval($totalData),
                "recordsFiltered" => intval($totalFiltered),
                'data' => $data);
            echo json_encode($output);
        } else {
            $output = array(
                "recordsTotal" => '',
                "recordsFiltered" => '',
                'data' => '');
            echo json_encode($output);
        }
    }
    
	
	    public function get_list_product_for_print_iw($value = '') {
	        
	     //   echo "test";
        $srh_warehouse_id = $this->input->post('srh_warehouse_id');
        $cat_srh = $this->input->post('cat_srh');
		$with_emi_no = $this->input->post('with_emi_no');
		$subcategory = $this->input->post('subcategory');
		$product_id = $this->input->post('product_id');
		$show_all = $this->input->post('show_all');
		$product_name = $this->input->post('product_name');
		$dep_id = $this->input->post('dep_id');
		$srh_sub_cat = $this->input->post('srh_sub_cat');
		
		

        $srh_from_date = '';
        $srh_to_date = '';
        if ($this->input->post('srh_to_date')) {
            $srh_to_date = date('Y-m-d', strtotime($this->input->post('srh_to_date')));
        }
        if ($this->input->post('srh_from_date')) {
            $srh_from_date = date('Y-m-d', strtotime($this->input->post('srh_from_date')));
        }

        /*         * ****************** */
        $search_key = $this->input->post('search');
        $search_key_val = $search_key['value'];
        $start = $this->input->post('start');
        $length = $this->input->post('length');

        $this->load->model('Product_Models');
        $values = '';
        $totalFiltered = 0;
        
        
        $row_no='';
        $product_code='';
      //  $product_name='';
        $product_tot_cost='';
        $product_balance='';
        $totalData=0;
        $data=array();
        
        
        $values = $this->Product_Models->getProductsForReport($srh_warehouse_id, $cat_srh, $start, $length, '','',$subcategory,$product_id,$product_name,$dep_id,$srh_sub_cat);
        
       // echo $this->db->last_query();
           // $values_c = $this->Product_Models->getProductsForReport_c($srh_warehouse_id, $cat_srh, $start, '', '');
            //print_r($values_c[0]->count);
             $totalData = $this->Product_Models->getProductsForReport($srh_warehouse_id, $cat_srh, '', '', '',1,$subcategory,$product_id,$product_name,$dep_id,$srh_sub_cat);
             
              if (!empty($values)) {
            foreach ($values as $products) {
                
                $product_id=$products->product_id;
              
                //get item total balance by prodcut id
                $item_des=$this->Report_Model->get_total_balance_by_product_id($product_id,$srh_warehouse_id);
                
                $avalable_sn_list=array();
                
                $avalable_sn_list_des='';
                 $avalable_sn_list=$this->Purchases_Model->get_serial_no_by_avalable_warehosue_id($product_id,$srh_warehouse_id);
                if($with_emi_no){
                   
                    foreach ($avalable_sn_list as $row_1){  
                        if($row_1->pis_number){
                            $avalable_sn_list_des.=" / $row_1->pis_number  ";
                        }
                    }
                }
                
                if($avalable_sn_list_des) $avalable_sn_list_des='<br/>'.$avalable_sn_list_des;
                
                    
                   // print_r($item_des);
                    
                    $product_balance=$item_des->product_balance;
                    
                    //sanath comment imp
                    $product_balance=count($avalable_sn_list);
                    $product_tot_cost=$item_des->product_tot_cost;
                    $display='';
                    if($product_balance!=''){
					$display=1;	
				    }
				
				
				    if($show_all){
				        $display=1;	// show all items with 0 stcok
				    }
                
                 if($display){
                    $row=array();
                    $row_no++;
                    $row[] = $row_no;
                    $row[] = $products->product_code;
                    $row[] = $products->product_name.$avalable_sn_list_des;
                    $ava_cost=0;
                    if($product_balance){
                    $ava_cost=$product_tot_cost/$product_balance;
                    }
                       $row[] =  number_format(($ava_cost), 2, '.', '');;
                    $row[] = $product_balance;
                    $row[] = $product_tot_cost;
                   
                   
                    $data[] = $row;
                    }
            
            }
            
            
            $output = array(
                "row_no" => intval($row_no),
                "product_code" => ($product_code),
                "product_name" => $product_name,
                "product_balance" => floatval($product_tot_cost),
                "product_tot_cost" => floatval($product_balance),
                "recordsTotal" => intval($totalData),
                "recordsFiltered" => intval($totalFiltered),
                'data' => $data);
            echo json_encode($output);
            
            
        } else {
            $output = array(
                "recordsTotal" => '',
                "recordsFiltered" => '',
                'data' => '');
            echo json_encode($output);
        }
        
    }
    
    
     public function get_list_product_for_print_iw_v2($value = '') {
	        
	     //   echo "test";
        $srh_warehouse_id = $this->input->post('srh_warehouse_id');
        $cat_srh = $this->input->post('cat_srh');
		$with_emi_no = $this->input->post('with_emi_no');
		$subcategory = $this->input->post('subcategory');
		$product_id = $this->input->post('product_id');
		$show_all = $this->input->post('show_all');
		$product_name = $this->input->post('product_name');
		$dep_id = $this->input->post('dep_id');
		$srh_sub_cat = $this->input->post('srh_sub_cat');
		
		

        $srh_from_date = '';
        $srh_to_date = '';
        if ($this->input->post('srh_to_date')) {
            $srh_to_date = date('Y-m-d', strtotime($this->input->post('srh_to_date')));
        }
        if ($this->input->post('srh_from_date')) {
            $srh_from_date = date('Y-m-d', strtotime($this->input->post('srh_from_date')));
        }

        /*         * ****************** */
        $search_key = $this->input->post('search');
        $search_key_val = $search_key['value'];
        $start = $this->input->post('start');
        $length = $this->input->post('length');

        $this->load->model('Product_Models');
        $values = '';
        $totalFiltered = 0;
        
        
        $row_no='';
        $product_code='';
      //  $product_name='';
        $product_tot_cost='';
        $product_balance='';
        $totalData=0;
        $data=array();
        
        
        $values = $this->Product_Models->getProductsForReport($srh_warehouse_id, $cat_srh, $start, $length, '','',$subcategory,$product_id,$product_name,$dep_id,$srh_sub_cat);
        
       // echo $this->db->last_query();
           // $values_c = $this->Product_Models->getProductsForReport_c($srh_warehouse_id, $cat_srh, $start, '', '');
            //print_r($values_c[0]->count);
             $totalData = $this->Product_Models->getProductsForReport($srh_warehouse_id, $cat_srh, '', '', '',1,$subcategory,$product_id,$product_name,$dep_id,$srh_sub_cat);
             
              if (!empty($values)) {
            foreach ($values as $products) {
                
                $product_id=$products->product_id;
              $item_des=array();//
                //get item total balance by prodcut id
 $item_des=$this->Report_Model->get_total_balance_by_product_id_v2($product_id,$srh_warehouse_id);
 
                
                $avalable_sn_list=array();
                
                $avalable_sn_list_des='';
                
                /*
                 $avalable_sn_list=$this->Purchases_Model->get_serial_no_by_avalable_warehosue_id($product_id,$srh_warehouse_id);
                if($with_emi_no){
                   
                    foreach ($avalable_sn_list as $row_1){  
                        if($row_1->pis_number){
                            $avalable_sn_list_des.=" / $row_1->pis_number  ";
                        }
                    }
                }
                
                */
                
                if($avalable_sn_list_des) $avalable_sn_list_des='<br/>'.$avalable_sn_list_des;
                
                    
                   // print_r($item_des);
                    
                    //get balance
                    $product_balance=$item_des->product_balance;
                    
                    //sanath comment imp
                    $product_balance=count($avalable_sn_list);
                    
                    
                    //print_r($item_des);
                    
                    $product_balance=$item_des->product_balance;
                    
                   // echo "product_balance:$product_balance";
                    
                    
                    
                    //$product_tot_cost=$item_des->product_tot_cost;
                    
                    $display='';
                    if($product_balance!=''){
					$display=1;	
				    }
				
				
				    if($show_all){
				        $display=1;	// show all items with 0 stcok
				    }
                
                 if($display){
                    $row=array();
                    $row_no++;
                    $row[] = $row_no;
                    $row[] = $products->product_code;
                    $row[] = $products->product_name.$avalable_sn_list_des;
                    $ava_cost=0;
                    if($product_balance){
                    //$ava_cost=$product_tot_cost/$product_balance;
                    }
                       $row[] =  number_format(($ava_cost), 2, '.', '');;
                    $row[] = $product_balance;
                    $row[] = $product_tot_cost;
                   
                   
                    $data[] = $row;
                    }
            
            }
            
            
            $output = array(
                "row_no" => intval($row_no),
                "product_code" => ($product_code),
                "product_name" => $product_name,
                "product_balance" => floatval($product_tot_cost),
                "product_tot_cost" => floatval($product_balance),
                "recordsTotal" => intval($totalData),
                "recordsFiltered" => intval($totalFiltered),
                'data' => $data);
            echo json_encode($output);
            
            
        } else {
            $output = array(
                "recordsTotal" => '',
                "recordsFiltered" => '',
                'data' => '');
            echo json_encode($output);
        }
        
    }
    
    
     public function get_list_product_for_print_iw_v3($value = '') {
	        
	     //   echo "test";
        $srh_warehouse_id = $this->input->post('srh_warehouse_id');
        $cat_srh = $this->input->post('cat_srh');
		$with_emi_no = $this->input->post('with_emi_no');
		$subcategory = $this->input->post('subcategory');
		$product_id = $this->input->post('product_id');
		$show_all = $this->input->post('show_all');
		$product_name = $this->input->post('product_name');
		$dep_id = $this->input->post('dep_id');
		$srh_sub_cat = $this->input->post('srh_sub_cat');
		
		

        $srh_from_date = '';
        $srh_to_date = '';
        if ($this->input->post('srh_to_date')) {
            $srh_to_date = date('Y-m-d', strtotime($this->input->post('srh_to_date')));
        }
        if ($this->input->post('srh_from_date')) {
            $srh_from_date = date('Y-m-d', strtotime($this->input->post('srh_from_date')));
        }

        /*         * ****************** */
        $search_key = $this->input->post('search');
        $search_key_val = $search_key['value'];
        $start = $this->input->post('start');
        $length = $this->input->post('length');

        $this->load->model('Product_Models');
        $values = '';
        $totalFiltered = 0;
        
        
        $row_no='';
        $product_code='';
      //  $product_name='';
        $product_tot_cost='';
        $product_balance='';
        $totalData=0;
        $data=array();
        
        
        $values = $this->Product_Models->getProductsForReport_v3($srh_warehouse_id, $cat_srh, $start, $length, '','',$subcategory,$product_id,$product_name,$dep_id,$srh_sub_cat);
        
       // echo $this->db->last_query();
           // $values_c = $this->Product_Models->getProductsForReport_c($srh_warehouse_id, $cat_srh, $start, '', '');
            //print_r($values_c[0]->count);
             $totalData = $this->Product_Models->getProductsForReport_v3($srh_warehouse_id, $cat_srh, '', '', '',1,$subcategory,$product_id,$product_name,$dep_id,$srh_sub_cat);
             
              if (!empty($values)) {
            foreach ($values as $products) {
                
                $product_id=$products->product_id;
              $item_des=array();//
                //get item total balance by prodcut id
// $item_des=$this->Report_Model->get_total_balance_by_product_id_v2($product_id,$srh_warehouse_id);
 
                
                $avalable_sn_list=array();
                
                $avalable_sn_list_des='';
                
                //$avalable_sn_list_des='sn';
                
                if($with_emi_no){
                 $avalable_sn_list=$this->Purchases_Model->get_serial_no_by_avalable_warehosue_id($product_id,$srh_warehouse_id);
                if($with_emi_no){
                   $sn_c=0;
                    foreach ($avalable_sn_list as $row_1){  
                        if($row_1->pis_number){
                            $sn_c++;
                            $avalable_sn_list_des.=" <br/> ($sn_c). $row_1->pis_number  ";
                        }
                    }
                }
                }
                
                
                
               // if($avalable_sn_list_des) $avalable_sn_list_des='<br/>'.$avalable_sn_list_des;
                
                    
                   // print_r($item_des);
                    
                    //get balance
                   // $product_balance=$item_des->product_balance;
                    
                    //sanath comment imp
                    $product_balance=count($avalable_sn_list);
                    
                    
                    //print_r($item_des);
                    
                   $product_balance=$products->product_balance;
                    
                   // echo "product_balance:$product_balance";
                    
                    
                    
                    $product_tot_cost=$products->product_tot_cost;
                    
                    $display='';
                    if($product_balance!=''){
					$display=1;	
				    }
				
				
				    if($show_all){
				        $display=1;	// show all items with 0 stcok
				    }
                
                 if($display){
                    $row=array();
                    $row_no++;
                    $row[] = $row_no;
                    $row[] = $products->product_id;
                    $row[] = $products->product_name.$avalable_sn_list_des;
                    $ava_cost=0;
                    if($product_balance){
                    $ava_cost=$product_tot_cost/$product_balance;
                    }
                       $row[] =  number_format(($ava_cost), 2, '.', '');;
                    $row[] = $product_balance;
                    $row[] = $product_tot_cost;
                   
                   
                    $data[] = $row;
                    }
            
            }
            
            
            $output = array(
                "row_no" => intval($row_no),
                "product_code" => ($product_code),
                "product_name" => $product_name,
                "product_balance" => floatval($product_tot_cost),
                "product_tot_cost" => floatval($product_balance),
                "recordsTotal" => intval($totalData),
                "recordsFiltered" => intval($totalFiltered),
                'data' => $data);
            echo json_encode($output);
            
            
        } else {
            $output = array(
                "recordsTotal" => '',
                "recordsFiltered" => '',
                'data' => '');
            echo json_encode($output);
        }
        
    }
    
    
    
	    public function get_dep_wise_pro_cost_summ($value = '') {
	        
	     //   echo "test";
        $srh_warehouse_id = $this->input->post('srh_warehouse_id');
        $cat_srh = $this->input->post('cat_srh');
		$with_emi_no = $this->input->post('with_emi_no');
		$subcategory = $this->input->post('subcategory');
		$product_id = $this->input->post('product_id');
		$show_all = $this->input->post('show_all');
		$product_name = $this->input->post('product_name');
		$dep_id = $this->input->post('dep_id');
		$srh_sub_cat = $this->input->post('srh_sub_cat');
		
		

        $srh_from_date = '';
        $srh_to_date = '';
        if ($this->input->post('srh_to_date')) {
            $srh_to_date = date('Y-m-d', strtotime($this->input->post('srh_to_date')));
        }
        if ($this->input->post('srh_from_date')) {
            $srh_from_date = date('Y-m-d', strtotime($this->input->post('srh_from_date')));
        }

        /*         * ****************** */
        $search_key = $this->input->post('search');
        $search_key_val = $search_key['value'];
        $start = $this->input->post('start');
        $length = $this->input->post('length');

        $this->load->model('Product_Models');
        $values = '';
        $totalFiltered = 0;
        
        
        $row_no='';
        $product_code='';
        $product_name='';
        $product_tot_cost='';
        $product_balance='';
        $totalData=0;
        $data=array();
        
        //echo "<br/>test";
        	$department_list 	= $this->category_models->getCategory(1);
        //print_r($department_list);
       // die();
        
        
              if (!empty($department_list)) {
                  $no=0;
            foreach ($department_list as $items) {
                $no++;
                $product_id='';//$products->product_id;
               // print_r($items);
              $dep_id=$items->cat_id;
               
                //get sold qty by 
                $sold_qty=0;
                $sales_val=0;
                $sales_cost=0;
                
                $return_qty=0;
                $sales_rtn_cost=0;
                $sales_rtn_val=0;
                
                $tot_cost=$this->Report_Model->get_dep_tot_cost($srh_warehouse_id,$dep_id);
                
                 $tot_qty=$this->Report_Model->get_dep_tot_cost_qty($srh_warehouse_id,$dep_id);
                
                
                //error_reporting(E_ALL);
                
                /*
                
                $tot_item=0;
                $tot_item_cost=0;
                $sold_qty_ary=$this->Report_Model->getAvalableQtyByWarehouseIdAndDepID($srh_warehouse_id,$dep_id,$srh_from_date,$srh_to_date);
                if(count($sold_qty_ary)){
                    $tot_item=$sold_qty_ary['tot_item'];
                     $tot_item_cost=$sold_qty_ary['tot_item_cost'];
                     //$sales_cost=$sold_qty_ary['sale_cost_total'];
                }
                
                
                $return_qty_ary=$this->Report_Model->getReturnQtyByWarehouseIdAndDepID($srh_warehouse_id,$dep_id,$srh_from_date,$srh_to_date);
                //print_r($return_qty_ary);
                if(count($return_qty_ary)){
                    $return_qty=$return_qty_ary['return_qty'];
                     $sales_rtn_val=$return_qty_ary['sales_rtn_val'];
                     $sales_rtn_cost=$return_qty_ary['sales_rtn_cost'];
                }
                
                
                 $sales_val_net=$sales_val-$sales_rtn_val;
                 $qty_net_tot=0;
                 $qty_net_tot=$sold_qty-$return_qty;
            
                
                //$sales_grand_tot=$sales_val-$sales_rtn_val;
                
                
                
                $sales_cost_grand=$sales_cost-$sales_rtn_cost;
                
                $gp=$sales_val_net-$sales_cost_grand;
                
                $gp_presnt='';
                if($sales_val_net){
                    $gp_presnt=round(($gp/$sales_val_net*100),2)."%";
                }
                
                $sold_qty=number_format($sold_qty, 2, '.', '');
                $sales_val_net=number_format($sales_val_net, 2, '.', '');
                $sales_cost_grand=number_format($sales_cost_grand, 2, '.', '');
                $gp=number_format($gp, 2, '.', '');
                
                $dev_text='';
               // $dev_text=" : dep_id:$dep_id , srh_from_date:$srh_from_date , srh_to_date:$srh_to_date";
               
               */
               
               if(!$tot_cost) $tot_cost=0;
               if(!$tot_qty) $tot_qty=0;
               
                $dev_text='';
                
                 //if($display)
                 {
                        $row=array();
                        $row_no++;
                        $row[] = $row_no;
                        $row[] =  $items->cat_name.$dev_text;
                        $row[] =  $tot_qty;//$qty_net_tot;
                        $row[] = $tot_cost;// $sales_val_net;
                        $row[] =  '';
                        $row[] =  '';
                        $row[] = '';
                        $data[] = $row;
                    }
            
            }
            
            
            $output = array(
                "row_no" => '',
                "product_code" =>'',
                "product_name" => '',
                "product_balance" => '',
                "product_tot_cost" => '',
                "recordsTotal" => intval($totalData),
                "recordsFiltered" => intval($totalFiltered),
                'data' => $data);
            echo json_encode($output);
            
            
        } else {
            $output = array(
                "recordsTotal" => '',
                "recordsFiltered" => '',
                'data' => '');
            echo json_encode($output);
        }
        
    }
    
    
    
      public function get_supplier_wise_gross_profit_report($value = '') {
	        
	     //   echo "test";
        $srh_warehouse_id = $this->input->post('srh_warehouse_id');
        $cat_srh = $this->input->post('cat_srh');
		$with_emi_no = $this->input->post('with_emi_no');
		$subcategory = $this->input->post('subcategory');
		$product_id = $this->input->post('product_id');
		$show_all = $this->input->post('show_all');
		$product_name = $this->input->post('product_name');
		$dep_id = $this->input->post('dep_id');
		$srh_sub_cat = $this->input->post('srh_sub_cat');
		$supplier_id=$this->input->post('supplier');
		
		

        $srh_from_date = '';
        $srh_to_date = '';
        if ($this->input->post('srh_to_date')) {
            $srh_to_date = date('Y-m-d', strtotime($this->input->post('srh_to_date')));
        }
        if ($this->input->post('srh_from_date')) {
            $srh_from_date = date('Y-m-d', strtotime($this->input->post('srh_from_date')));
        }

        /*         * ****************** */
        $search_key = $this->input->post('search');
        $search_key_val = $search_key['value'];
        $start = $this->input->post('start');
        $length = $this->input->post('length');

        $this->load->model('Product_Models');
        $values = '';
        $totalFiltered = 0;
        
        
        $row_no='';
        $product_code='';
        $product_name='';
        $product_tot_cost='';
        $product_balance='';
        $totalData=0;
        $data=array();
        
        //echo "<br/>test";
        	$department_list 	= $this->category_models->getCategory(1);
        //print_r($department_list);
       // die();
        
        
              if (!empty($department_list)) {
                  $no=0;
            foreach ($department_list as $items) {
                $no++;
                $product_id='';//$products->product_id;
               // print_r($items);
              $dep_id=$items->cat_id;
               
                //get sold qty by 
                $sold_qty=0;
                $sales_val=0;
                $sales_cost=0;
                
                $return_qty=0;
                $sales_rtn_cost=0;
                $sales_rtn_val=0;
                
                
                //error_reporting(E_ALL);
                
                
                $sold_qty_ary=$this->Report_Model->getSoldQtyByWarehouseIdAndDepID_supp($srh_warehouse_id,$dep_id,$srh_from_date,$srh_to_date,$supplier_id);
                if(count($sold_qty_ary)){
                    $sold_qty=$sold_qty_ary['sale_tot_qty'];
                     $sales_val=$sold_qty_ary['sale_gross_total'];
                     $sales_cost=$sold_qty_ary['sale_cost_total'];
                }
                
                
                $return_qty_ary=$this->Report_Model->getReturnQtyByWarehouseIdAndDepID_supp($srh_warehouse_id,$dep_id,$srh_from_date,$srh_to_date,$supplier_id);
                //print_r($return_qty_ary);
                if(count($return_qty_ary)){
                    $return_qty=$return_qty_ary['return_qty'];
                     $sales_rtn_val=$return_qty_ary['sales_rtn_val'];
                     $sales_rtn_cost=$return_qty_ary['sales_rtn_cost'];
                }
                
                
                 $sales_val_net=$sales_val-$sales_rtn_val;
                 $qty_net_tot=0;
                 $qty_net_tot=$sold_qty-$return_qty;
            
                
                //$sales_grand_tot=$sales_val-$sales_rtn_val;
                
                
                
                $sales_cost_grand=$sales_cost-$sales_rtn_cost;
                
                $gp=$sales_val_net-$sales_cost_grand;
                
                $gp_presnt='';
                if($sales_val_net){
                    $gp_presnt=round(($gp/$sales_val_net*100),2)."%";
                }
                
                $sold_qty=number_format($sold_qty, 2, '.', '');
                $sales_val_net=number_format($sales_val_net, 2, '.', '');
                $sales_cost_grand=number_format($sales_cost_grand, 2, '.', '');
                $gp=number_format($gp, 2, '.', '');
                
                $dev_text='';
               // $dev_text=" : dep_id:$dep_id , srh_from_date:$srh_from_date , srh_to_date:$srh_to_date";
                
                 //if($display)
                 {
                        $row=array();
                        $row_no++;
                        $row[] = $row_no;
                        $row[] =  $items->cat_name.$dev_text;
                        $row[] =  $qty_net_tot;
                        $row[] =  $sales_val_net;
                        $row[] =  $sales_cost_grand;
                        $row[] =  $gp;
                        $row[] = $gp_presnt;
                        $data[] = $row;
                    }
            
            }
            
            
            $output = array(
                "row_no" => '',
                "product_code" =>'',
                "product_name" => '',
                "product_balance" => '',
                "product_tot_cost" => '',
                "recordsTotal" => intval($totalData),
                "recordsFiltered" => intval($totalFiltered),
                'data' => $data);
            echo json_encode($output);
            
            
        } else {
            $output = array(
                "recordsTotal" => '',
                "recordsFiltered" => '',
                'data' => '');
            echo json_encode($output);
        }
        
    }
    
    
    	    public function get_list_product_for_print_supp($value = '') {
	        
	     //   echo "test";
        $srh_warehouse_id = $this->input->post('srh_warehouse_id');
        $cat_srh = $this->input->post('cat_srh');
		$with_emi_no = $this->input->post('with_emi_no');
		$subcategory = $this->input->post('subcategory');
		$product_id = $this->input->post('product_id');
		$show_all = $this->input->post('show_all');
		$product_name = $this->input->post('product_name');
		$dep_id = $this->input->post('dep_id');
		$srh_sub_cat = $this->input->post('srh_sub_cat');
		$supplier_id= $this->input->post('supplier');
		
		

        $srh_from_date = '';
        $srh_to_date = '';
        if ($this->input->post('srh_to_date')) {
            $srh_to_date = date('Y-m-d', strtotime($this->input->post('srh_to_date')));
        }
        if ($this->input->post('srh_from_date')) {
            $srh_from_date = date('Y-m-d', strtotime($this->input->post('srh_from_date')));
        }

        /*         * ****************** */
        $search_key = $this->input->post('search');
        $search_key_val = $search_key['value'];
        $start = $this->input->post('start');
        $length = $this->input->post('length');

        $this->load->model('Product_Models');
        $values = '';
        $totalFiltered = 0;
        
        
        $row_no='';
        $product_code='';
        $product_name='';
        $product_tot_cost='';
        $product_balance='';
        $totalData=0;
        $data=array();
        
        
        $values = $this->Product_Models->getProductsForReport_supp($srh_warehouse_id, $cat_srh, $start, $length, '','',$subcategory,$product_id,$product_name,$dep_id,$srh_sub_cat,$supplier_id);
        
       // echo $this->db->last_query();
           // $values_c = $this->Product_Models->getProductsForReport_c($srh_warehouse_id, $cat_srh, $start, '', '');
            //print_r($values_c[0]->count);
             $totalData = $this->Product_Models->getProductsForReport_supp($srh_warehouse_id, $cat_srh, '', '', '',1,$subcategory,$product_id,$product_name,$dep_id,$srh_sub_cat,$supplier_id);
             
              if (!empty($values)) {
            foreach ($values as $products) {
                
                $product_id=$products->product_id;
              
                //get item total balance by prodcut id
                $item_des=$this->Report_Model->get_total_balance_by_product_id_supp($product_id,$srh_warehouse_id,$supplier_id,$srh_from_date,$srh_to_date);
                
                $avalable_sn_list=array();
                
                $avalable_sn_list_des='';
                
                if($with_emi_no){
                    $avalable_sn_list=$this->Purchases_Model->get_serial_no_by_avalable_warehosue_id($product_id,$srh_warehouse_id,$supplier_id,$srh_from_date,$srh_to_date);
                    foreach ($avalable_sn_list as $row_1){  
                        if($row_1->pis_number){
                            $avalable_sn_list_des.=" / $row_1->pis_number  ";
                        }
                    }
                }
                
                if($avalable_sn_list_des) $avalable_sn_list_des='<br/>'.$avalable_sn_list_des;
                
                    
                   // print_r($item_des);
                    
                    $product_balance=$item_des->product_balance;
                    $product_tot_cost=$item_des->product_tot_cost;
                    $display='';
                    if($product_balance!=''){
					$display=1;	
				    }
				
				
				    if($show_all){
				        $display=1;	// show all items with 0 stcok
				    }
                
                 if($display){
                    $row=array();
                    $row_no++;
                    $row[] = $row_no;
                    $row[] = $products->product_id;
                    $row[] = $products->product_name.$avalable_sn_list_des;
                    $row[] = $product_balance;
                    $row[] = $product_tot_cost;
                   
                   
                    $data[] = $row;
                    }
            
            }
            
            
            $output = array(
                "row_no" => intval($row_no),
                "product_code" => ($product_code),
                "product_name" => $product_name,
                "product_balance" => floatval($product_tot_cost),
                "product_tot_cost" => floatval($product_balance),
                "recordsTotal" => intval($totalData),
                "recordsFiltered" => intval($totalFiltered),
                'data' => $data);
            echo json_encode($output);
            
            
        } else {
            $output = array(
                "recordsTotal" => '',
                "recordsFiltered" => '',
                'data' => '');
            echo json_encode($output);
        }
        
    }
    
    
      public function get_list_product_for_print_supp_sales($value = '') {
	        
	     //   echo "test";
        $srh_warehouse_id = $this->input->post('srh_warehouse_id');
        $cat_srh = $this->input->post('cat_srh');
		$with_emi_no = $this->input->post('with_emi_no');
		$subcategory = $this->input->post('subcategory');
		$product_id = $this->input->post('product_id');
		$show_all = $this->input->post('show_all');
		$product_name = $this->input->post('product_name');
		$dep_id = $this->input->post('dep_id');
		$srh_sub_cat = $this->input->post('srh_sub_cat');
		$supplier_id= $this->input->post('supplier');
		$srh_from_date= $this->input->post('srh_from_date');
		$srh_to_date= $this->input->post('srh_to_date');
		
		

        $srh_from_date = '';
        $srh_to_date = '';
        if ($this->input->post('srh_to_date')) {
            $srh_to_date = date('Y-m-d', strtotime($this->input->post('srh_to_date')));
        }
        if ($this->input->post('srh_from_date')) {
            $srh_from_date = date('Y-m-d', strtotime($this->input->post('srh_from_date')));
        }

        /*         * ****************** */
        $search_key = $this->input->post('search');
        $search_key_val = $search_key['value'];
        $start = $this->input->post('start');
        $length = $this->input->post('length');

        $this->load->model('Product_Models');
        $values = '';
        $totalFiltered = 0;
        
        
        $row_no='';
        $product_code='';
        $product_name='';
        $product_tot_cost='';
        $product_balance='';
        $totalData=0;
        $data=array();
        
        
        $values = $this->Product_Models->getProductsForReport_supp($srh_warehouse_id, $cat_srh, $start, $length, '','',$subcategory,$product_id,$product_name,$dep_id,$srh_sub_cat,$supplier_id);
        
       // echo $this->db->last_query();
           // $values_c = $this->Product_Models->getProductsForReport_c($srh_warehouse_id, $cat_srh, $start, '', '');
            //print_r($values_c[0]->count);
             $totalData = $this->Product_Models->getProductsForReport_supp($srh_warehouse_id, $cat_srh, '', '', '',1,$subcategory,$product_id,$product_name,$dep_id,$srh_sub_cat,$supplier_id);
             
              if (!empty($values)) {
            foreach ($values as $products) {
                
                $product_id=$products->product_id;
              
                //get item total balance by prodcut id
                $item_des=$this->Report_Model->get_total_balance_by_product_id_supp_sales_v1($product_id,$srh_warehouse_id,$supplier_id,$srh_from_date,$srh_to_date);
                
                
               // print_r($item_des);
                
                $sold_item_qty='';
                
                $sold_item_qty=count($item_des);
                
                
                $avalable_sn_list=array();
                
                $avalable_sn_list_des='';
                
                /*
                if($with_emi_no){
                    $avalable_sn_list=$this->Purchases_Model->get_serial_no_by_avalable_warehosue_id($product_id,$srh_warehouse_id);
                    */
                    foreach ($item_des as $row_1){  
                        if($row_1->sis_number){
                            $avalable_sn_list_des.=" / $row_1->sis_number  ";
                        }
                    }
                    
                    /*
                    
                }
                */
                
                if($avalable_sn_list_des) $avalable_sn_list_des='<br/>'.$avalable_sn_list_des;
                
                    
                   // print_r($item_des);
                    
                    $product_balance=$sold_item_qty;//$item_des->product_balance;
                    $product_tot_cost='';//$item_des->product_tot_cost;
                    $display='';
                    if($product_balance!=''){
					$display=1;	
				    }
				
				
				    if($show_all){
				        $display=1;	// show all items with 0 stcok
				    }
                
                 if($display){
                    $row=array();
                    $row_no++;
                    $row[] = $row_no;
                    $row[] = $products->product_code;
                    $row[] = $products->product_name.$avalable_sn_list_des;
                    $row[] = $product_balance;
                    $row[] = $product_tot_cost;
                   
                   
                    $data[] = $row;
                    }
            
            }
            
            
            $output = array(
                "row_no" => intval($row_no),
                "product_code" => ($product_code),
                "product_name" => $product_name,
                "product_balance" => floatval($product_tot_cost),
                "product_tot_cost" => floatval($product_balance),
                "recordsTotal" => intval($totalData),
                "recordsFiltered" => intval($totalFiltered),
                'data' => $data);
            echo json_encode($output);
            
            
        } else {
            $output = array(
                "recordsTotal" => '',
                "recordsFiltered" => '',
                'data' => '');
            echo json_encode($output);
        }
        
    }
    
    
       public function get_list_product_for_print_supp_sales_sales_ass($value = '') {
	        
	     //   echo "test";
        $srh_warehouse_id = $this->input->post('srh_warehouse_id');
        $cat_srh = $this->input->post('cat_srh');
		$with_emi_no = $this->input->post('with_emi_no');
		$subcategory = $this->input->post('subcategory');
		$product_id = $this->input->post('product_id');
		$show_all = $this->input->post('show_all');
		$product_name = $this->input->post('product_name');
		$dep_id = $this->input->post('dep_id');
		$srh_sub_cat = $this->input->post('srh_sub_cat');
		$user_id= $this->input->post('supplier');
		$srh_from_date= $this->input->post('srh_from_date');
		$srh_to_date= $this->input->post('srh_to_date');
		
		

        $srh_from_date = '';
        $srh_to_date = '';
        if ($this->input->post('srh_to_date')) {
            $srh_to_date = date('Y-m-d', strtotime($this->input->post('srh_to_date')));
        }
        if ($this->input->post('srh_from_date')) {
            $srh_from_date = date('Y-m-d', strtotime($this->input->post('srh_from_date')));
        }

        /*         * ****************** */
        $search_key = $this->input->post('search');
        $search_key_val = $search_key['value'];
        $start = $this->input->post('start');
        $length = $this->input->post('length');

        $this->load->model('Product_Models');
        $values = '';
        $totalFiltered = 0;
        
        
        $row_no='';
        $product_code='';
        $product_name='';
        $product_tot_cost='';
        $product_balance='';
        $totalData=0;
        $data=array();
        
        
        $values = $this->Product_Models->getProductsForReport_supp($srh_warehouse_id, $cat_srh, $start, $length, '','',$subcategory,$product_id,$product_name,$dep_id,$srh_sub_cat,0);
        
       // echo $this->db->last_query();
           // $values_c = $this->Product_Models->getProductsForReport_c($srh_warehouse_id, $cat_srh, $start, '', '');
            //print_r($values_c[0]->count);
             $totalData = $this->Product_Models->getProductsForReport_supp($srh_warehouse_id, $cat_srh, '', '', '',1,$subcategory,$product_id,$product_name,$dep_id,$srh_sub_cat,0);
             
              if (!empty($values)) {
            foreach ($values as $products) {
                
                $product_id=$products->product_id;
                
                $item_selling_price=0;
                //get item selling price
                $item_sale_des=$this->Sales_Model->get_last_selling_price_by_product_id($product_id);
                //print_r($item_sale_des);
                
               // if(count($item_sale_des))
               if(isset($item_sale_des->gross_total))
                $item_selling_price=$item_sale_des->gross_total/$item_sale_des->quantity;
                
              
                //get item total balance by prodcut id
                $item_des=$this->Report_Model->get_total_balance_by_product_id_supp_sales_rep_sum($product_id,$srh_warehouse_id,$user_id,$srh_from_date,$srh_to_date);
                
                
               // print_r($item_des);
                
                $sold_item_qty='';
                
                $sold_item_qty=count($item_des);
                
                
                $avalable_sn_list=array();
                
                $avalable_sn_list_des='';
                
                /*
                if($with_emi_no){
                    $avalable_sn_list=$this->Purchases_Model->get_serial_no_by_avalable_warehosue_id($product_id,$srh_warehouse_id);
                    foreach ($avalable_sn_list as $row_1){  
                        if($row_1->pis_number){
                            $avalable_sn_list_des.=" / $row_1->pis_number  ";
                        }
                    }
                }
                */
                
                if($avalable_sn_list_des) $avalable_sn_list_des='<br/>'.$avalable_sn_list_des;
                
                    
                   // print_r($item_des);
                    
                    $product_balance=$sold_item_qty;//$item_des->product_balance;
                    $product_tot_cost='';//$item_des->product_tot_cost;
                    $display='';
                    if($product_balance!=''){
					$display=1;	
				    }
				
				
				    if($show_all){
				        $display=1;	// show all items with 0 stcok
				    }
                
                 if($display){
                    $row=array();
                    $row_no++;
                    $row[] = $row_no;
                    $row[] = $products->product_code;
                    $row[] = $products->product_name.$avalable_sn_list_des;
                    $row[] = $product_balance;
                    $row[] = $product_tot_cost;
                    $row[] = $item_selling_price;
                   
                    $data[] = $row;
                    }
            
            }
            
            
            $output = array(
                "row_no" => intval($row_no),
                "product_code" => ($product_code),
                "product_name" => $product_name,
                "product_balance" => floatval($product_tot_cost),
                "product_tot_cost" => floatval($product_balance),
                "recordsTotal" => intval($totalData),
                "recordsFiltered" => intval($totalFiltered),
                'data' => $data);
            echo json_encode($output);
            
            
        } else {
            $output = array(
                "recordsTotal" => '',
                "recordsFiltered" => '',
                'data' => '');
            echo json_encode($output);
        }
        
    }
    
    

      public function get_list_product_for_print_supp_purchase($value = '') {
	        
	     //   echo "test";
        $srh_warehouse_id = $this->input->post('srh_warehouse_id');
        $cat_srh = $this->input->post('cat_srh');
		$with_emi_no = $this->input->post('with_emi_no');
		$subcategory = $this->input->post('subcategory');
		$product_id = $this->input->post('product_id');
		$show_all = $this->input->post('show_all');
		$product_name = $this->input->post('product_name');
		$dep_id = $this->input->post('dep_id');
		$srh_sub_cat = $this->input->post('srh_sub_cat');
		$supplier_id= $this->input->post('supplier');
		$srh_from_date= $this->input->post('srh_from_date');
		$srh_to_date= $this->input->post('srh_to_date');
		
		

        $srh_from_date = '';
        $srh_to_date = '';
        if ($this->input->post('srh_to_date')) {
            $srh_to_date = date('Y-m-d', strtotime($this->input->post('srh_to_date')));
        }
        if ($this->input->post('srh_from_date')) {
            $srh_from_date = date('Y-m-d', strtotime($this->input->post('srh_from_date')));
        }

        /*         * ****************** */
        $search_key = $this->input->post('search');
        $search_key_val = $search_key['value'];
        $start = $this->input->post('start');
        $length = $this->input->post('length');

        $this->load->model('Product_Models');
        $values = '';
        $totalFiltered = 0;
        
        
        $row_no='';
        $product_code='';
        $product_name='';
        $product_tot_cost='';
        $product_balance='';
        $totalData=0;
        $data=array();
        
        
        $values = $this->Product_Models->getProductsForReport_supp($srh_warehouse_id, $cat_srh, $start, $length, '','',$subcategory,$product_id,$product_name,$dep_id,$srh_sub_cat,$supplier_id);
        
       // echo $this->db->last_query();
           // $values_c = $this->Product_Models->getProductsForReport_c($srh_warehouse_id, $cat_srh, $start, '', '');
            //print_r($values_c[0]->count);
             $totalData = $this->Product_Models->getProductsForReport_supp($srh_warehouse_id, $cat_srh, '', '', '',1,$subcategory,$product_id,$product_name,$dep_id,$srh_sub_cat,$supplier_id);
             
              if (!empty($values)) {
            foreach ($values as $products) {
                
                $product_id=$products->product_id;
              
                //get item total balance by prodcut id
                $item_des=$this->Report_Model->get_total_balance_by_product_id_supp_purchase($product_id,$srh_warehouse_id,$supplier_id,$srh_from_date,$srh_to_date);
                //print_r($item_des);
                $tot_cost=0;
                foreach ($item_des as $row_1){  
                    $cost=0;
                    
                    //print_r($row_1);
                    $cost=$row_1->pis_cost_price;
                      $tot_cost=$tot_cost+$cost;
                   // $pis_cost_price=$pis_cost_price+$cost;
                    
                        //if($row_1['pis_cost_price']){
                          //  $pis_cost_price=$pis_cost_price+$row_1['pis_cost_price'];
                        //}
                    }
                    
                    
                //echo "test";
                
                
               // print_r($item_des);
                
                $sold_item_qty='';
                
                $sold_item_qty=count($item_des);
                
                
                $avalable_sn_list=array();
                
                $avalable_sn_list_des='';
                
                /*
                if($with_emi_no){
                    $avalable_sn_list=$this->Purchases_Model->get_serial_no_by_avalable_warehosue_id($product_id,$srh_warehouse_id);
                    foreach ($avalable_sn_list as $row_1){  
                        if($row_1->pis_number){
                            $avalable_sn_list_des.=" / $row_1->pis_number  ";
                        }
                    }
                }
                */
                
                if($avalable_sn_list_des) $avalable_sn_list_des='<br/>'.$avalable_sn_list_des;
                
                    
                   // print_r($item_des);
                    
                    $product_balance=$sold_item_qty;//$item_des->product_balance;
                    $product_tot_cost='';//$item_des->product_tot_cost;
                    $display='';
                    if($product_balance!=''){
					$display=1;	
				    }
				
				
				    if($show_all){
				        $display=1;	// show all items with 0 stcok
				    }
                
                 if($display){
                    $row=array();
                    $row_no++;
                    $row[] = $row_no;
                    $row[] = $products->product_code;
                    $row[] = $products->product_name.$avalable_sn_list_des;
                    $row[] = $product_balance;
                    $row[] = $tot_cost;
                   
                   
                    $data[] = $row;
                    }
            
            }
            
            
            $output = array(
                "row_no" => intval($row_no),
                "product_code" => ($product_code),
                "product_name" => $product_name,
                "product_balance" => floatval($product_tot_cost),
                "product_tot_cost" => floatval($product_balance),
                "recordsTotal" => intval($totalData),
                "recordsFiltered" => intval($totalFiltered),
                'data' => $data);
            echo json_encode($output);
            
            
        } else {
            $output = array(
                "recordsTotal" => '',
                "recordsFiltered" => '',
                'data' => '');
            echo json_encode($output);
        }
        
    }
    
      public function get_list_fast_slow_movement_report($value = '') {
	        
	     //   echo "test";
        $srh_warehouse_id = $this->input->post('srh_warehouse_id');
        $cat_srh = $this->input->post('cat_srh');
		$with_emi_no = $this->input->post('with_emi_no');
		$subcategory = $this->input->post('subcategory');
		$product_id = $this->input->post('product_id');
		$show_all = $this->input->post('show_all');
		$product_name = $this->input->post('product_name');
		$dep_id = $this->input->post('dep_id');
		$srh_sub_cat = $this->input->post('srh_sub_cat');
		$supplier_id= $this->input->post('supplier');
		$srh_from_date= $this->input->post('srh_from_date');
		$srh_to_date= $this->input->post('srh_to_date');
		$seach_key_9=$this->input->post('seach_key_9');
		
		
		$nonmoving = $this->input->post('nonmoving');
		
		
		

        $srh_from_date = '';
        $srh_to_date = '';
        if ($this->input->post('srh_to_date')) {
            $srh_to_date = date('Y-m-d', strtotime($this->input->post('srh_to_date')));
        }
        if ($this->input->post('srh_from_date')) {
            $srh_from_date = date('Y-m-d', strtotime($this->input->post('srh_from_date')));
        }

        /*         * ****************** */
        $search_key = $this->input->post('search');
        
        //print_r($search_key);
        $search_key_val = $search_key['value'];
        $start = $this->input->post('start');
        $length = $this->input->post('length');
        
        //print_r($this->input->post('order'));
        $order=$this->input->post('order');
        $ord_col = $order[0]['column'];
        $ord_dir = $order[0]['dir'];
        
        //echo "<br/>dir:$ord_dir";

        $this->load->model('Product_Models');
        $values = '';
        $totalFiltered = 0;
        
        
        $row_no='';
        $product_code='';
        $product_name='';
        $product_tot_cost='';
        $product_balance='';
        $totalData=0;
        $data=array();
        
        
        $values = $this->Product_Models->get_fast_slow_movement_report($srh_warehouse_id, $cat_srh, $start, $length, '','',$subcategory,$product_id,$product_name,$dep_id,$srh_sub_cat,$supplier_id,$ord_col,$ord_dir,$seach_key_9);
        
       // echo $this->db->last_query();
           // $values_c = $this->Product_Models->getProductsForReport_c($srh_warehouse_id, $cat_srh, $start, '', '');
            //print_r($values_c[0]->count);
             $totalData = $this->Product_Models->get_fast_slow_movement_report($srh_warehouse_id, $cat_srh, '', '', '',1,$subcategory,$product_id,$product_name,$dep_id,$srh_sub_cat,$supplier_id);
             
              if (!empty($values)) {
            foreach ($values as $products) {
                
                $product_id=$products->product_id;
              
                //get item total balance by prodcut id
                $item_des=$this->Report_Model->get_total_balance_by_product_id_supp_sales_v1($product_id,$srh_warehouse_id,$supplier_id,$srh_from_date,$srh_to_date);
                
                
                $product_avalable_qty=0;
   $alable_des=$this->Report_Model->get_total_balance_by_product_id_v2($product_id,$srh_warehouse_id);
  // print_r($alable_des);
    $product_avalable_qty=$alable_des->product_balance;
                 
               // print_r($item_des);
                
                $sold_item_qty='';
                
                $sold_item_qty=count($item_des);
                
                
                $avalable_sn_list=array();
                
                $avalable_sn_list_des='';
                
                /*
                if($with_emi_no){
                    $avalable_sn_list=$this->Purchases_Model->get_serial_no_by_avalable_warehosue_id($product_id,$srh_warehouse_id);
                    foreach ($avalable_sn_list as $row_1){  
                        if($row_1->pis_number){
                            $avalable_sn_list_des.=" / $row_1->pis_number  ";
                        }
                    }
                }
                */
                
                if($avalable_sn_list_des) $avalable_sn_list_des='<br/>'.$avalable_sn_list_des;
                
                    
                   // print_r($item_des);
                    
                    $product_balance=$sold_item_qty;//$item_des->product_balance;
                    $product_tot_cost='';//$item_des->product_tot_cost;
                    $display='';
                    if($product_balance!=''){
					$display=1;	
				    }
				
				
				    if($show_all){
				        $display=1;	// show all items with 0 stcok
				    }
				    
				    
				    if($nonmoving){
				         if($product_balance=='0'){
				        	$display=1;	
				         }else{
				             	$display=0;	
				         }
				        
				    }
				    
				    
				    //echo " nonmoving:$nonmoving";
				    //	$display=0;
                
                 if($display){
                    $row=array();
                    $row_no++;
                    $row[] = $row_no;
                    $row[] = $products->product_id;
                    $row[] = $products->product_name.$avalable_sn_list_des;
                    $row[] = $product_balance;
                   $row[] = $product_avalable_qty;
                   // $row[] = $product_tot_cost;
                   
                   
                    $data[] = $row;
                    }
            
            }
            
            
            $output = array(
                "row_no" => intval($row_no),
                "product_code" => ($product_code),
                "product_name" => $product_name,
                "product_balance" => floatval($product_tot_cost),
                "product_tot_cost" => floatval($product_balance),
                "recordsTotal" => intval($totalData),
                "recordsFiltered" => intval($totalFiltered),
                'data' => $data);
            echo json_encode($output);
            
            
        } else {
            $output = array(
                "recordsTotal" => '',
                "recordsFiltered" => '',
                'data' => '');
            echo json_encode($output);
        }
        
    }
	      
	   	public function get_list_product_qty_for_print($value='')
	{
		$srh_warehouse_id=$this->input->post('srh_warehouse_id');
		$cat_srh=$this->input->post('cat_srh');
		
			$this->load->model('Product_Models');
	        $values = $this->Product_Models->getProductsForQTYReport($srh_warehouse_id,$cat_srh);
	        $data = array();

	        if (!empty($values)) {
	            foreach ($values as $products) {

	            if ($products->product_status == 0) {$k = "btn-warning";$m = "fa-minus-circle";} else {$k = "btn-green";$m = "fa-check";}
				$retVal = (empty($products->sub_cat_name)) ? "--:--" : $products->sub_cat_name ;

	            $row = array();
				
				//get transferd qty
				$transferd_qty=0;
				$transfer_reseve_qty=0;
				$transferd_qty=$this->Transfer_Model->getTransferdQtyByWarehouseId($srh_warehouse_id,$products->product_id);
				$transfer_reseve_qty=$this->Transfer_Model->getTransferResevedQtyByWarehouseId($srh_warehouse_id,$products->product_id);
				$sold_qty=$this->Sales_Model->getSoldQtyByWarehouseId($srh_warehouse_id,$products->product_id);
				$purchased_qty=$this->Purchases_Model->getPurchasedQtyByWarehouseId($srh_warehouse_id,$products->product_id);
				$product_damaged_qty=$this->Product_Damage_Model->getProductDamagedQtyByWarehouseId($srh_warehouse_id,$products->product_id);
				$sales_return_qty=$this->Sales_Return_Model->getSalesReturnQtyByWarehouseId($srh_warehouse_id,$products->product_id);
				 
                  $row[] = $products->product_code;
	                $row[] = $products->product_name;
					// $row[] = $products->product_part_no;
					  $row[] = $products->cat_name;
					   $row[] = $products->sub_cat_name;
	                
					$tmp_qty=$purchased_qty+$transfer_reseve_qty+$sales_return_qty-$sold_qty-$transferd_qty-$product_damaged_qty;
					 $row[] = number_format(($products->product_cost), 2, '.', '');
					 $row[] = number_format(($products->product_price), 2, '.', '');
					 
	                $row[] = number_format($tmp_qty, 2, '.', '');
					
					  $row[] = number_format(($products->product_cost*$tmp_qty), 2, '.', '');
					 $row[] = number_format(($products->product_price*$tmp_qty), 2, '.', '');
					
					
	                //$row[] = $transferd_qty;
	                $data[] = $row;
	            }

	            $output = array('data' =>$data);
	            echo json_encode($output);
	        }else{
	            $output = array('data' =>'');
	            echo json_encode($output);

	        }
	   }
	   
	
	public function item_balance_warehoue_id($srh_warehouse_id='', $product_id, $srh_from_date='', $srh_to_date=''){
	    
	    $balance_qty=0;
	    
	            $transferd_qty=0;
				$transfer_reseve_qty=0;
				$sold_qty=0;
				$purchased_qty=0;
				$product_damaged_qty=0;
				$sales_return_qty=0;
				$purchases_return_qty=0;
				$transferd_qty=$this->Custom_Model->getTransferdQtyByWarehouseId($srh_warehouse_id,$product_id);
				$transfer_reseve_qty=$this->Custom_Model->getTransferResevedQtyByWarehouseId($srh_warehouse_id,$product_id);
				$sold_qty=$this->Custom_Model->getSoldQtyByWarehouseId($srh_warehouse_id,$product_id);
				$purchased_qty=$this->Custom_Model->getPurchasedQtyByWarehouseId($srh_warehouse_id,$product_id);
				$purchases_return_qty = $this->Custom_Model->getReturnQtyByWarehouseId($srh_warehouse_id, $product_id, $srh_from_date, $srh_to_date);
				$product_damaged_qty=$this->Custom_Model->getProductDamagedQtyByWarehouseId($srh_warehouse_id,$product_id);//$srh_warehouse_id
				$sales_return_qty=$this->Custom_Model->getSalesReturnQtyByWarehouseId($srh_warehouse_id,$product_id);
				 
				 $row = array();
				 
				 
			//	 $balance_qty=$this->item_balance_warehoue_id();
				 
				  $balance_qty=$purchased_qty+$transfer_reseve_qty+$sales_return_qty-$sold_qty-$transferd_qty-$product_damaged_qty+$purchases_return_qty;
				  
				  return $balance_qty;
	    
	}
	   
	   public function get_list_product_alert_quantity_for_print($value='')
	{
		$srh_warehouse_id=$this->input->post('srh_warehouse_id');
		
	//	print_r($srh_warehouse_id);
		$cat_srh=$this->input->post('cat_srh');
		$srh_from_date='';
		$srh_to_date='';
			$this->load->model('Product_Models');
			
	        $values = $this->Product_Models->getProductsForReport($srh_warehouse_id,$cat_srh);
	        $data = array();

	        if (!empty($values)) {
	            foreach ($values as $products) {

	            if ($products->product_status == 0) {$k = "btn-warning";$m = "fa-minus-circle";} else {$k = "btn-green";$m = "fa-check";}
				$retVal = (empty($products->sub_cat_name)) ? "--:--" : $products->sub_cat_name ;

	            
				
				//get transferd qty
			
				 
				 $row = array();
				 
				 $balance_qty=0;
				 $balance_qty=$this->item_balance_warehoue_id($srh_warehouse_id, $products->product_id, $srh_from_date, $srh_to_date);
				 
				 //$balance_qty=$purchased_qty+$transfer_reseve_qty+$sales_return_qty-$sold_qty-$transferd_qty-$product_damaged_qty+$purchases_return_qty;
                  if($balance_qty<=$products->product_alert_qty){
				  
				  $row[] = $products->product_code;
	                $row[] = $products->product_name;
					 $row[] = $products->product_part_no;
					 $row[] = $products->cat_name;
					 $row[] = $products->sub_cat_name;
					  $row[] = $products->product_alert_qty;
					  $row[] = $products->product_max_qty;
					  
	               
	                $row[] = number_format(($balance_qty), 2, '.', ',');
	                //$row[] = $transferd_qty;
	                $data[] = $row;
				  }
	            }

	            $output = array('data' =>$data);
	            echo json_encode($output);
	        }else{
	            $output = array('data' =>'');
	            echo json_encode($output);

	        }
	   }
/*customer_receivable*/
	public function customer_receivable()
	{
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'customer_receivable';
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$data['customer_list'] = $this->Customer_Model->get_all_customers();
		$data['rep_list'] = $this->User_Model->getSalesRep();
		$this->load->view('rep_customer_receivable',$data);
	}	
	public function get_list_customer_receivable_for_report($value='')
	{
		//print_r($_REQUEST);
		$srh_to_date='';
		$srh_from_date='';
		$srh_warehouse_id=$this->input->post('srh_warehouse_id');
		$srh_customer_id=$this->input->post('srh_customer_id');
		$srh_payment_status=$this->input->post('srh_payment_status');
		$srh_customer_id=$this->input->post('srh_customer_id');
		$srh_payment_status=$this->input->post('srh_payment_status');
		if($this->input->post('srh_to_date')){
			$srh_to_date=date('Y-m-d', strtotime($this->input->post('srh_to_date')));
		}
		if($this->input->post('srh_from_date')){
			$srh_from_date=date('Y-m-d', strtotime($this->input->post('srh_from_date')));
		}
		
		
		
		$this->load->model('Sales_Model');
		$columns = array( 
		0 =>'sale_datetime', 
		1 => 'sale_reference_no',
		2=> 'cus_name',
		3 =>'sale_id', 
		4 => 'sale_id',
		5=> 'sale_id'
	);
	
	$data = array();

	
	
	$sales = $this->Sales_Model->get_all_sales_for_report($srh_warehouse_id,$srh_to_date,$srh_from_date,'','','',$srh_customer_id);
	//echo $this->db->last_query();
	$totalData = count($sales);
	$totalFiltered = $totalData;  
	
	foreach ($sales as $row){
		$nestedData=array(); 
		$p_status='';
		$pay_st ='';
		$sale_id=$row['sale_id'];
		$total_paid_amount=$row['total_paid_amount']; //$this->Sales_Model->get_total_paid_by_sale_id($sale_id);
		$nestedData[] =display_date_time_format($row['sale_datetime']);
		$nestedData[] = $row['sale_reference_no'];
		$nestedData[] = $row['cus_name'];
		
		
		if (empty($total_paid_amount)) {
		  $pay_st = '<span class="label label-warning">Pending</span>';
		   $p_status='Pending';
		}else{
		  if ($total_paid_amount >= $row['sale_total']) {
			$pay_st = '<span class="label label-success">Paid</span>';
			$p_status='Paid';
		  }else{
			$pay_st = '<span class="label label-info">Partial</span>';
			$p_status='Partial';
		  }
		}
		
		if($srh_payment_status){
			if($srh_payment_status==$p_status)
		{
		$nestedData[]=$pay_st;
		$nestedData[] = number_format($row['cost_total'], 2, '.', '');
		$nestedData[] = number_format($row['sale_total'], 2, '.', '');
		$nestedData[] = number_format($total_paid_amount, 2, '.', '');
		$nestedData[] = number_format($row['sale_total']-$total_paid_amount, 2, '.', '');

	$data[] = $nestedData;
	
		}}else {
			$nestedData[]=$pay_st;
		$nestedData[] = number_format($row['cost_total'], 2, '.', '');
		$nestedData[] = number_format($row['sale_total'], 2, '.', '');
		$nestedData[] = number_format($total_paid_amount, 2, '.', '');
		$nestedData[] = number_format($row['sale_total']-$total_paid_amount, 2, '.', '');

	$data[] = $nestedData;
		}
}

	$json_data = array(
			//"draw"            => intval( $requestData['draw'] ),  
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data 
			);

	echo json_encode($json_data);
	}
	
	function print_customer_receivable(){
		$data['main_menu_name'] = 'reports';
		
		$srh_warehouse_id=$this->input->get('srh_warehouse_id');
		$srh_customer_id=$this->input->get('srh_customer_id');
		$srh_from_date=$this->input->get('srh_from_date');
		$srh_to_date=$this->input->get('srh_to_date');
		
		
		
		if($srh_warehouse_id){
			$warehouse_details=$this->Warehouse_Model->get_warehouse_info($srh_warehouse_id);
			$data['srh_warehouse_name']=$warehouse_details['name'];
			$data['warehouse_details']=$warehouse_details;
			
			$customer_details=$this->Customer_Model->get_all_customer_print($srh_customer_id);
			$data['customer_details']=$customer_details;
			$data['srh_from_date']=$srh_from_date;
			$data['srh_to_date']=$srh_to_date;
		}else {
			$data['srh_warehouse_name']="-All-";
		}
		
		
		
		$this->load->view('models/print_customer_receivable',$data);
	}
	/*customer_receivable*/	
	
	
	   public function get_list_product_for_print_summary($value = '') {
        $srh_warehouse_id = $this->input->get('srh_warehouse_id');
        $cat_srh = $this->input->get('cat_srh');

        $srh_from_date = '';
        $srh_to_date = '';
        if ($this->input->get('srh_to_date')) {
            $srh_to_date = date('Y-m-d', strtotime($this->input->get('srh_to_date')));
        }

        if ($this->input->get('srh_from_date')) {
            $srh_from_date = date('Y-m-d', strtotime($this->input->get('srh_from_date')));
        }
        /* echo $srh_from_date;echo "||";
          echo $srh_to_date; */

//	$sales = $this->Sales_Model->get_all_sales($start,$length,$search_key_val);
//	$sales_count = $this->Sales_Model->get_all_sales('','','');

        $totalData = 0;
//	echo $length."//";
        //$getSumProductsForReport = $this->Product_Models->getSumProductsForReport($srh_warehouse_id,$cat_srh);
        //$all_values = $this->Product_Models->getProductIdsForReport($srh_warehouse_id,$cat_srh,'','','');
        $values = $this->Product_Models->getProductIdsForReport($srh_warehouse_id, $cat_srh);
        //print_r($values);	
        /* 	if($search_key_val){
          $values = $this->Product_Models->getProductsForReport($srh_warehouse_id,$cat_srh,$start,$length,$search_key_val);
          $values_c = $this->Product_Models->getProductsForReport_c($srh_warehouse_id,$cat_srh,'','',$search_key_val);
          $totalData = $values_c[0]->count;
          }else{
          $values = $this->Product_Models->getProductsForReport($srh_warehouse_id,$cat_srh,$start,$length,'');
          $values_c = $this->Product_Models->getProductsForReport_c($srh_warehouse_id,$cat_srh,$start,'','');
          //print_r($values_c[0]->count);
          $totalData = $values_c[0]->count;
          } */

        //$totalFiltered = $totalData;
        /*         * ****************** */

        $purchased_qty_tot = 0;
        $purchases_return_qty_tot = 0;
        $sold_qty_tot = 0;
        $sales_return_qty_tot = 0;
        $product_balance_tot = 0;
        $sale_price_tot = 0;   //$this->Purchases_Model->getPurchasedQtyByWarehouseId('','',$srh_from_date,$srh_to_date);
        $cost_price_tot = 0;
        $data = array();

        if (!empty($values)) {
            foreach ($values as $products) {


                $transferd_qty = 0;
                $transfer_reseve_qty = 0;
				 $purchases_return_qty=0;

                $sold_qty = $this->Sales_Model->getSoldQtyByWarehouseId($srh_warehouse_id, $products->product_id, $srh_from_date, $srh_to_date);

                $sold_qty_tot += $sold_qty;
                /* echo "|sq:".$sold_qty."|";
                  echo "|sqt:".$sold_qty_tot."|"; */
                $purchased_qty = $this->Purchases_Model->getPurchasedQtyByWarehouseId($srh_warehouse_id, $products->product_id, $srh_from_date, $srh_to_date);
                $purchased_qty_tot += $purchased_qty;

              //  $purchases_return_qty = $this->Purchases_Model->getReturnQtyByWarehouseId($srh_warehouse_id, $products->product_id, $srh_from_date, $srh_to_date);

                $purchases_return_qty_tot+= $purchases_return_qty;

                $sales_return_qty = $this->Sales_Return_Model->getSalesReturnQtyByWarehouseId($srh_warehouse_id, $products->product_id, $srh_from_date, $srh_to_date);
                $sales_return_qty_tot += $sales_return_qty;

                $product_balance = $purchased_qty + $sales_return_qty - $sold_qty - $purchases_return_qty;
                $product_balance_tot += $product_balance;

                $sale_price_tot += $products->product_price * $product_balance;
                $cost_price_tot += $products->product_cost * $product_balance;
            }
            /**/
//$output = array();
            $output = array(
                "purchased_qty" => intval($purchased_qty_tot),
                "sold_qty" => intval($sold_qty_tot),
                "sales_return_qty" => intval($sales_return_qty_tot),
                "purchases_return_qty" => intval($purchases_return_qty_tot),
                "product_balance" => intval($product_balance_tot),
                "damadge_qty" => 0,
                "sale_price_tot" => floatval($sale_price_tot),
                "cost_price_tot" => floatval($cost_price_tot)
            );

            echo json_encode($output);
        } else {
            $output = array(
                "recordsTotal" => '',
                "recordsFiltered" => '',
                'data' => '');
            echo json_encode($output);
        }
    }
	
	public function cash_report(){
		$data['main_menu_name'] = 'reports';
		$data['sub_menu_name'] = 'reports/cash_report';
		$service_type=$this->uri->segment('3');
		$data['service_type']=$service_type;
		$pageName='';
		
		$data['pageName'] =$pageName;
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$data['user_list'] = $this->User_Model->getUsers();
		//$data['vehicle_list'] = $this->Vehicle_Model->get_all_vehicle();
		$this->load->view('rep_cash_report',$data);
	}
	
	public function get_list_payments_for_report_rtn()	
{
	       
	        $data = array();
			//print_r($values);
		$srh_to_date='';
		$srh_from_date='';
		$srh_warehouse_id=$this->input->post('srh_warehouse_id');
		$srh_type=$this->input->post('srh_type');
		$srh_payment_term=$this->input->post('srh_payment_term');
		$ss_user_id=$this->input->post('ss_user_id');
		if($this->input->post('srh_to_date')){
			$srh_to_date=date('Y-m-d', strtotime($this->input->post('srh_to_date')));
		}
		if($this->input->post('srh_from_date')){
			$srh_from_date=date('Y-m-d', strtotime($this->input->post('srh_from_date')));
		}
		
		$srh_type='sales_return';
		 $values = $this->Sales_Model->getPaymentsForPrint_rtn_2($srh_warehouse_id,$srh_to_date,$srh_from_date,$srh_type,$srh_payment_term,$ss_user_id);
		
			$columns = array( 
		0 =>'bkng_id', 
		1 => 'bkng_id',
		2=> 'bkng_id',
		3 =>'bkng_id', 
		4 => 'bkng_id',
		5=> 'bkng_id',
		6=> 'bkng_id',
		7=> 'bkng_id',
		8=> 'bkng_id'
		);
	        if (!empty($values)) {
	            foreach ($values as $users) {
					$invoice_no='';
					$display=false;
					
						//get sales return ref no
						//$sales_return_des=$this->Sales_Return_Model->get_sale_return_info($users->sale_id);
						//$invoice_no=$sales_return_des['sl_rtn_reference_no'];
						//$warehouse_id_sales_rtn=$sales_return_des['warehouse_id'];
						
					
					
					
					
	            $row = array();
					//$bkng_id=$users->sale_id;
					//$paymnt_id=$users->sale_pymnt_id;
					
					$row[] =sprintf("%04d", $users->sale_pymnt_id);
					$row[] = $users->sale_pymnt_date_time;
					$row[] = $users->sl_rtn_reference_no;
					$row[] =  $users->cus_name;
					$row[] = $users->sale_payment_type;
					$row[] = $users->sale_pymnt_paying_by;
					$row[] = $users->sale_pymnt_amount;
					 // $row[] = sprintf("%04d", $users->sale_pymnt_id);
					//  $row[] = $users->sale_pymnt_date_time;
					 //  $row[] = $invoice_no;
					  
					   
					
					//$pymnt_collected='';
				//	$checked_status='';
					

					// $row[] =  $users->sale_payment_type;
					// $row[] =  $users->sale_pymnt_paying_by;
					//$row[] = $users->sale_pymnt_amount;		
                   $paid=0;
							
	
	                $data[] = $row;
					
	            }


	            $output = array('data' =>$data);
	            echo json_encode($output);
	        }else{
	            $output = array('data' =>'');
	            echo json_encode($output);

	        }

}
public function get_list_payments_for_report_grn()	
{
	       
	        $data = array();
			//print_r($values);
		$srh_to_date='';
		$srh_from_date='';
		$srh_warehouse_id=$this->input->post('srh_warehouse_id');
		$srh_type=$this->input->post('srh_type');
		$srh_payment_term=$this->input->post('srh_payment_term');
		$ss_user_id=$this->input->post('ss_user_id');
		if($this->input->post('srh_to_date')){
			$srh_to_date=date('Y-m-d', strtotime($this->input->post('srh_to_date')));
		}
		if($this->input->post('srh_from_date')){
			$srh_from_date=date('Y-m-d', strtotime($this->input->post('srh_from_date')));
		}
		
		
		 $values = $this->Purchases_Model->getPaymentsForPrint_grn($srh_warehouse_id,$srh_to_date,$srh_from_date,$srh_type,$srh_payment_term,$ss_user_id);
		 
		 
		
		//echo $this->db->last_query();
			$columns = array( 
		0 =>'bkng_id', 
		1 => 'bkng_id',
		2=> 'bkng_id',
		3 =>'bkng_id', 
		4 => 'bkng_id',
		5=> 'bkng_id',
		6=> 'bkng_id',
		7=> 'bkng_id',
		8=> 'bkng_id'
		);
	        if (!empty($values)) {
	            foreach ($values as $users) {
					$invoice_no='';
					$display=false;
					
						//get sales return ref no
						//$sales_return_des=$this->Sales_Return_Model->get_sale_return_info($users->sale_id);
						//$invoice_no=$sales_return_des['sl_rtn_reference_no'];
						//$warehouse_id_sales_rtn=$sales_return_des['warehouse_id'];
						
					
					
					
					
	            $row = array();
					//$bkng_id=$users->sale_id;
					//$paymnt_id=$users->sale_pymnt_id;
					
					$row[] =sprintf("%04d", $users->sale_pymnt_id);
					$row[] = $users->sale_pymnt_date_time;
					$row[] = $users->reference_no;
					$row[] = $users->supp_company_name;
					$row[] = $users->sale_payment_type;
					$row[] = $users->sale_pymnt_paying_by;
					$row[] = $users->sale_pymnt_amount;
					 // $row[] = sprintf("%04d", $users->sale_pymnt_id);
					//  $row[] = $users->sale_pymnt_date_time;
					 //  $row[] = $invoice_no;
					  
					   
					
					//$pymnt_collected='';
				//	$checked_status='';
					

					// $row[] =  $users->sale_payment_type;
					// $row[] =  $users->sale_pymnt_paying_by;
					//$row[] = $users->sale_pymnt_amount;		
                   $paid=0;
							
	
	                $data[] = $row;
					
	            }


	            $output = array('data' =>$data);
	            echo json_encode($output);
	        }else{
	            $output = array('data' =>'');
	            echo json_encode($output);

	        }

}

public function get_list_expenses_for_report()	
{
	       
	        $data = array();
			//print_r($values);
		$srh_to_date='';
		$srh_from_date='';
		$srh_warehouse_id=$this->input->post('srh_warehouse_id');
		$srh_type=$this->input->post('srh_type');
		$srh_payment_term=$this->input->post('srh_payment_term');
		$ss_user_id=$this->input->post('ss_user_id');
		if($this->input->post('srh_to_date')){
			$srh_to_date=date('Y-m-d', strtotime($this->input->post('srh_to_date')));
		}
		if($this->input->post('srh_from_date')){
			$srh_from_date=date('Y-m-d', strtotime($this->input->post('srh_from_date')));
		}
		
		
		 $values = $this->Expenses_Model->get_all_expenses_items_for_report($srh_warehouse_id,$srh_to_date,$srh_from_date,$srh_type,$srh_payment_term,$ss_user_id);
		
			$columns = array( 
		0 =>'bkng_id', 
		1 => 'bkng_id',
		2=> 'bkng_id',
		3 =>'bkng_id', 
		4 => 'bkng_id',
		5=> 'bkng_id',
		6=> 'bkng_id',
		7=> 'bkng_id',
		8=> 'bkng_id'
		);
		$itm_count=0;
	        if (!empty($values)) {
	            foreach ($values as $users) {
					
	            $row = array();
				$itm_count++;
					$exp_id=$users->exp_id;
					$row[]=sprintf("%03d", $itm_count);
					$row[]=sprintf("%04d", $users->exp_id);
					$row[]=$users->exp_datetime;
					//$row[]=$users->user_first_name;
					$row[]=$users->product_name;
					//$row[]=$users->unit_name;
					$row[]=$users->product_cost;
					$row[]=$users->expitm_qty;
					$row[]="($users->expitm_dis_val)".$users->expitm_dis_val;
					$row[]=$users->sub_total_item;
					
					//$paymnt_id=$users->sale_pymnt_id;
					$row[]='';
					//  $row[] = sprintf("%04d", $users->sale_pymnt_id);
					//  $row[] = $users->sale_pymnt_date_time;
					//   $row[] = $users->sale_reference_no;
					  
					   
					// checked="checked"
					$pymnt_collected='';
					$checked_status='';
					if($pymnt_collected==1) {
						$checked_status='checked=\"checked\"';
					}else {
						$checked_status='';
					}
					/*
					  $row[] = "<label class=\"checkbox-inline\">
										<input id=\"collected_$paymnt_id\" type=\"checkbox\" class=\"flat-red\" value=\"$paymnt_id\" onchange=\"changeColectedStatus($paymnt_id,this.checked)\" $checked_status>
										Collected
									</label>";	
*/
						// $row[] =  $users->user_first_name;
						// $row[] =  $users->sale_payment_type;
						// $row[] =  $users->sale_pymnt_paying_by;
						//  $row[] = $users->sale_pymnt_amount;		
                      		$paid=0;
							//$paid=$this->Booking_Model->get_total_paid_by_booking_id($bkng_id);
						//$row[] =number_format($paid, 2, '.', ',');
						
							//$row[] =number_format($users->bkng_tot_amount-$paid, 2, '.', ',');
				
				//$row[]=$actionTxtUpdate.$actionTxtDisble.$actionTxtEnable.$actionTxtPw.$actionTxtDelete;
	
	                $data[] = $row;
	            }


	            $output = array('data' =>$data);
	            echo json_encode($output);
	        }else{
	            $output = array('data' =>'');
	            echo json_encode($output);

	        }

}


	public function get_list_payments_for_report_service()	
{
	       
	        $data = array();
			//print_r($values);
		$srh_to_date='';
		$srh_from_date='';
		$srh_warehouse_id=$this->input->post('srh_warehouse_id');
		$srh_type=$this->input->post('srh_type');
		$srh_payment_term=$this->input->post('srh_payment_term');
		$ss_user_id=$this->input->post('ss_user_id');
		if($this->input->post('srh_to_date')){
			$srh_to_date=date('Y-m-d', strtotime($this->input->post('srh_to_date')));
		}
		if($this->input->post('srh_from_date')){
			$srh_from_date=date('Y-m-d', strtotime($this->input->post('srh_from_date')));
		}
		
		$srh_type='sales_return';
		 $values = $this->Sales_Model->getPaymentsForPrintService($srh_warehouse_id,$srh_to_date,$srh_from_date,$srh_type,$srh_payment_term,$ss_user_id);
		
			$columns = array( 
		0 =>'bkng_id', 
		1 => 'bkng_id',
		2=> 'bkng_id',
		3 =>'bkng_id', 
		4 => 'bkng_id',
		5=> 'bkng_id',
		6=> 'bkng_id',
		7=> 'bkng_id',
		8=> 'bkng_id'
		);
	        if (!empty($values)) {
				$k=0;
	            foreach ($values as $users) {
					$k++;
					$invoice_no='';
					$display=false;
					
						//get sales return ref no
						//$sales_return_des=$this->Sales_Return_Model->get_sale_return_info($users->sale_id);
						//$invoice_no=$sales_return_des['sl_rtn_reference_no'];
						//$warehouse_id_sales_rtn=$sales_return_des['warehouse_id'];
						
					
					
					
					
	            $row = array();
					//$bkng_id=$users->sale_id;
					//$paymnt_id=$users->sale_pymnt_id;
					
					$returned_text='';
						if($users->sale_pymnt_cheque_rtn_status==1)
						{
							$returned_text='Returned';
						}
					
					$row[] =sprintf("%04d", $k);
					$row[] =sprintf("%04d", $users->sale_pymnt_id);
					$row[] = $users->sale_pymnt_date_time;//$users->sl_rtn_reference_no;
					$row[] =$users->service_reference_no;//sprintf("%04d", $users->service_id);
					$row[] = $users->service_walking_cus_name;
					//$row[] ='';// $users->sale_payment_type;
					
					
					//$row[] =  '';
					$row[] = $users->sale_pymnt_paying_by;
					$row[] = $users->sale_pymnt_amount;
					$row[] =$returned_text;
					 // $row[] = sprintf("%04d", $users->sale_pymnt_id);
					//  $row[] = $users->sale_pymnt_date_time;
					 //  $row[] = $invoice_no;
					  
					   
					
					//$pymnt_collected='';
				//	$checked_status='';
					

					// $row[] =  $users->sale_payment_type;
					// $row[] =  $users->sale_pymnt_paying_by;
					//$row[] = $users->sale_pymnt_amount;		
                   $paid=0;
							
	
	                $data[] = $row;
					
	            }


	            $output = array('data' =>$data);
	            echo json_encode($output);
	        }else{
	            $output = array('data' =>'');
	            echo json_encode($output);

	        }

}

 public function view_serial_by_product_id()
    {
       
		  $product_id = $this->uri->segment(3);
		 // echo $product_id;
		   $warehouse_id = $this->uri->segment(4);
		   //$each_price=$this->uri->segment(7);
		   $data['product_id']=$product_id;
		   //$data['each_price']=floatval($each_price);
		   $product_des=$this->Product_Models->get_product_by_id($product_id);
		   $data['product_dis_name']=$product_des->product_code." ".$product_des->product_name;
		   
		
		//echo "test:".$this->uri->segment(3);
		// $data['btnText'] = 'Submit';
		// $data['sn_list1'] = $this->Purchases_Model->get_serial_no_by_product_id($product_id,$warehouse_id);
		 
		 // echo $this->db->last_query();
		 
		 //get transfer reseved serial no
		// $data['sn_list_tra_res2'] = $this->Purchases_Model->get_transfer_reserved_serial_no_by_product_id($product_id,$warehouse_id);
		 
		// $data['sn_list']=array_merge($data['sn_list1'],$data['sn_list_tra_res2']);
		$data['sn_list']=$this->Purchases_Model->get_serial_no_by_avalable_warehosue_id($product_id,$warehouse_id);
		 
		// print_r($data['sn_list_tra_res']);
		 
		// print_r($data['sn_list']);
        $this->load->view('models/rep_serial_no',$data);
    }
	
	
	 public function view_transfer_details()
    {
       
		  $product_id = $this->uri->segment(3);
		 // echo $product_id;
		   $warehouse_id = $this->uri->segment(4);
		   //$each_price=$this->uri->segment(7);
		   $data['product_id']=$product_id;
		   //$data['each_price']=floatval($each_price);
		   $product_des=$this->Product_Models->get_product_by_id($product_id);
		   $data['product_dis_name']=$product_des->product_code." ".$product_des->product_name;
		   
		
		//echo "test:".$this->uri->segment(3);
		// $data['btnText'] = 'Submit';
		// $data['sn_list1'] = $this->Purchases_Model->get_serial_no_by_product_id($product_id,$warehouse_id);
		 
		 // echo $this->db->last_query();
		 
		 //get transfer reseved serial no
		// $data['sn_list_tra_res2'] = $this->Purchases_Model->get_transfer_reserved_serial_no_by_product_id($product_id,$warehouse_id);
		 
		// $data['sn_list']=array_merge($data['sn_list1'],$data['sn_list_tra_res2']);
		$data['sn_list']=$this->Purchases_Model->get_serial_no_by_avalable_warehosue_id($product_id,$warehouse_id);
		 
		// print_r($data['sn_list_tra_res']);
		 
		// print_r($data['sn_list']);
        $this->load->view('models/view_transfer_details',$data);
    }
	
public function product_enquiry_reports(){
	$data['main_menu_name'] = $this->main_menu_name;
	$data['sub_menu_name']='enquiry_reports';
	$data['sub_menu_name_1']='hire_purchase';
   // $data['location_list']=$this->Location_Model->get_all_location_for_dropdown();
	//$data['route_list']=$this->Route_Model->get_routes_for_dropdown();
	$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
	//$data['cash_collector_list']=$this->User_Model->get_all_cash_collector_users();
	$this->load->view('rep_product_enquiry',$data);
	}
	
		public function get_list_product_for_product_enquiry_report($value='')
	{
		$srh_warehouse_id=$this->input->post('srh_warehouse_id');
		$serail_no=$this->input->post('serail_no');
		
		
		$data = array();
	
		
		//$data = array();
		//get transer data
		
		$values_transer = $this->Report_Model->get_trasfer_details_by_serail_no($serail_no);
		// echo $this->db->last_query();
		$row=array();
		foreach ($values_transer as $products) {
			$row=array();
			$rep_type='Transfer / '.site_date($products->trnsfr_datetime). ' <br/>To: '.$products->name;
			$trnsfr_id=$products->trnsfr_id;
			$ref_no='<a target=\"_blank\" href="'.base_url().'transfer/view/'.$trnsfr_id.'" class="" data-placement="top" data-original-title="Edit suppliers"> '.$products->trnsfr_reference_no.'</a>  ';
			//$ref_no="<a onclick=\"fbs_click($products->trnsfr_id)\"href='#'>".$products->trnsfr_id."</a>";	
			$row[] = strtotime($products->trnsfr_datetime);//$products->product_code;
			$row[] = $products->product_name;
			$row[] = $serail_no;
			$row[] =$rep_type;
			$row[] = $ref_no;
			if($products->trnsfr_id){
			$data[] = $row;
			}
		}
		
		
		
		
		
		//get sale
		$values_issue = $this->Report_Model->get_sale_details_by_serail_no($serail_no);
		$row=array();
		$ref_no='';
		$rep_type='';
		//print_r($values_issue);
		
		foreach ($values_issue as $products) {
			//
			$row=array();
			$rep_type='Sale / '.site_date($products->sale_datetime);
			$ref_no='';
			$ref_no="<a target=\"_blank\" href='".base_url("sales/view/$products->sale_id")."'>".$products->sale_reference_no."</a>";
			
			//print_r($products->sale_id); echo " , ";	
			$row[] = strtotime($products->sale_datetime);//$products->product_code;
			
			$sel_price='';
			
			if($products->quantity){
			$sel_price=" <br/><span class='label label-success'>"." , Selling Price : ".$products->gross_total/$products->quantity."</span>";
			}
			
			$row[] = $products->product_name.$sel_price;
			
			$exchanged="";
			/*
			if($products->item_exchanged){
				$exchanged=" (Item Exchanged)";
			}
			*/
			$row[] = $serail_no ." $exchanged";
			$row[] =$rep_type;
			
			$row[] = $ref_no;
			$data[] = $row;
		}
		
		
		//get sale return
		$values_issue = $this->Report_Model->get_sale_return_details_by_serail_no($serail_no);
		$row=array();
		$ref_no='';
		$rep_type='';
		//print_r($values_issue);
		
		foreach ($values_issue as $products) {
			//
			$row=array();
			$rep_type='Sale Return / '.site_date($products->sl_rtn_datetime);
			$ref_no='';
			$ref_no="<a target=\"_blank\" href='".base_url("sales/sales_return_details/$products->sl_rtn_id")."'>".$products->sl_rtn_reference_no."</a>";
			
			//print_r($products->sale_id); echo " , ";	
			$row[] = strtotime($products->sl_rtn_datetime);//$products->product_code;
			$row[] = $products->product_name;
			$row[] = $serail_no;
			$row[] =$rep_type;
			
			$row[] = $ref_no;
			$data[] = $row;
		}
		
		
			//get grn return start
		$values_issue = $this->Report_Model->get_grn_return_details_by_serail_no($serail_no);
		$row=array();
		$ref_no='';
		$rep_type='';
		//print_r($values_issue);
		$serail_no_rtn='';
		
		foreach ($values_issue as $products) {
			//
			$row=array();
			$rep_type='GRN Return / '.site_date($products->pur_rtn_datetime);
			$ref_no='';
			$ref_no="<a target=\"_blank\" href='".base_url("purchase_return/purchase_return_details/$products->pur_rtn_id")."'>".$products->pur_rtn_reference_no."</a>";
			
			//print_r($products->sale_id); echo " , ";	
			$row[] = strtotime($products->pur_rtn_datetime);//$products->product_code;
			$row[] = $products->product_name;
			$row[] = $serail_no;
			$row[] =$rep_type;
			
			$row[] = $ref_no;
			$data[] = $row;
			
		//	$serail_no=$serail_no."_".$products->pur_rtn_id;
			$serail_no_rtn=$serail_no."_".$products->pur_rtn_id;
		}
		//get grn return end
		
			//get grn data
		$values_grn = $this->Report_Model->get_grn_details_by_serail_no($serail_no);
		$row=array();
		foreach ($values_grn as $products) {
			$row=array();
			$rep_type='GRN / '.site_date($products->date);
			$ref_no="<a target=\"_blank\" href='".base_url("purchases/view/$products->id")."'>".$products->reference_no."</a>";
			
			$pro_status_text='';
			if($products->product_status==1)
			$pro_status_text="Status: Enable";
			else 
				$pro_status_text="<span style='color:red'>Status: Disable</span>";
			$detils="$pro_status_text , ID : $products->product_id , Code : $products->product_code ,  Cost Price : $products->pis_cost_price";
			
			$detils.=" , Cash Price : $products->pis_cash_price";
				$detils.=" , Minimum Cash Price : $products->pis_min_cash_price , Supplier : $products->supp_company_name";
			//"  , Min. Sell Price:  $products->pis_min_cash_price";
			$row[] = strtotime($products->date);//$products->product_code;
			$row[] = $products->product_name. " <br/><span class='enquery_spe_cls'>$detils</span>";
			$row[] = $serail_no;
			$row[] =$rep_type;
			$row[] = $ref_no;
			$data[] = $row;
		}
		
		
			//get grn data if return
		$values_grn = $this->Report_Model->get_grn_details_by_serail_no($serail_no_rtn);
		$row=array();
		foreach ($values_grn as $products) {
			$row=array();
			$rep_type='GRN / '.site_date($products->date);
			$ref_no="<a target=\"_blank\" href='".base_url("purchases/view/$products->id")."'>".$products->reference_no."</a>";
			$detils=" Cost Price : $products->pis_cost_price";
			
			$detils.=" , Cash Price : $products->pis_cash_price";
				$detils.=" , Minimum Cash Price : $products->pis_min_cash_price , Supplier : $products->supp_company_name";
			//"  , Min. Sell Price:  $products->pis_min_cash_price";
			$row[] = strtotime($products->date);//$products->product_code;
			$row[] = $products->product_name. " <br/><span class='enquery_spe_cls'>$detils</span>";
			$row[] = $serail_no;
			$row[] =$rep_type;
			$row[] = $ref_no;
			$data[] = $row;
		}
		
		
		
			//get damage start
		$values_issue = $this->Report_Model->get_damage_details_by_serail_no($serail_no);
		$row=array();
		$ref_no='';
		$rep_type='';
		//print_r($values_issue);
		
		foreach ($values_issue as $products) {
			//
			$row=array();
			$rep_type='Product Damage / '.site_date($products->pdmg_datetime);
			$ref_no='';
			$ref_no="<a href='#'>".$products->pdmg_reference_no."</a>";
			
			//print_r($products->sale_id); echo " , ";	
			$row[] = strtotime($products->pdmg_datetime);//$products->product_code;
			$row[] = $products->product_name;
			$row[] = $serail_no;
			$row[] =$rep_type;
			
			$row[] = $ref_no;
			$data[] = $row;
		}
		//get damage end
		

			$output = array('data' =>$data);
			echo json_encode($output);
	       
	   }	
	   
	   
	 public function get_list_product_by_product_code_for_product_enquiry_report($value='')
	{
		$srh_warehouse_id=$this->input->post('srh_warehouse_id');
		$product_code=$this->input->post('product_code');
		
		
		$data = array();
		//get grn data
		$values_grn = $this->Report_Model->get_grn_details_by_product_code($product_code,$srh_warehouse_id);
		//print_r($values_grn);
		$row=array();
		foreach ($values_grn as $products) {
			$row=array();
			$rep_type='GRN';
			$ref_no="<a target=\"_blank\" href='".base_url("purchases/view/$products->grn_id")."'>".$products->reference_no."</a>";	
			$row[] = $products->product_code;
			$row[] = $products->product_name;
			$row[] =$rep_type;
			$row[] = $ref_no;
			$row[] = $products->grn_date;
			$data[] = $row;
		}
		
		//get trasfer data
		$values_transer = $this->Report_Model->get_trsfer_details_by_product_code($product_code,$srh_warehouse_id);
		//print_r($values_grn);
		$row=array();
		foreach ($values_transer as $products) {
			$row=array();
			$rep_type='Transfer';
			$ref_no="<a onclick=\"fbs_click($products->trnsfr_id)\"href='#'>".$products->trnsfr_id."</a>";	
			$row[] = $products->product_code;
			$row[] = $products->product_name;
			$row[] =$rep_type;
			$row[] = $ref_no;
			$row[] = $products->trnsfr_datetime;
			if($products->trnsfr_id){
			$data[] = $row;
			}
		}
		
		//get trasfer reserved data
		$values_transer = $this->Report_Model->get_trsfer_reserverd_details_by_product_code($product_code,$srh_warehouse_id);
		//print_r($values_grn);
		$row=array();
		foreach ($values_transer as $products) {
			$row=array();
			$rep_type='Transfer Reserved';
			$ref_no="<a onclick=\"fbs_click($products->trnsfr_id)\"href='#'>".$products->trnsfr_id."</a>";	
			$row[] = $products->product_code;
			$row[] = $products->product_name;
			$row[] =$rep_type;
			$row[] = $ref_no;
			$row[] = $products->trnsfr_datetime;
			if($products->trnsfr_id){
			$data[] = $row;
			}
		}
		

			$output = array('data' =>$data);
			echo json_encode($output);
	       
	   }	
	   
    public function customer_balance()
    {
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name']  = 'customer_balance';
        $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        $data['customer_list']  = $this->Customer_Model->get_all_customers();
        if ($this->input->get('type')) {
            $data['wh']  = $this->input->get('wh');
            $data['cs']  = $this->input->get('cs');
            $data['dt']  = $this->input->get('dt');
            $data['csn'] = $this->input->get('csn');
            $this->load->view('rep_customer_balance_print', $data);
        } else {
            $this->load->view('rep_customer_balance', $data);
        }
    }
	
	   public function get_list_sales_return_for_balance_report($value = '')
    {
        $srh_to_date      = '';
        $srh_from_date    = '';
        $srh_customer_id  = '';
        $srh_warehouse_id = $this->input->post('srh_warehouse_id');
        if ($this->input->post('srh_to_date')) {
            $srh_to_date = date('Y-m-d 23:59:59', strtotime($this->input->post('srh_to_date')));
        }
        if ($this->input->post('srh_from_date')) {
            $srh_from_date = date('Y-m-d 00:00:00', strtotime($this->input->post('srh_from_date')));
        }
        if ($this->input->post('srh_customer_id')) {
            $srh_customer_id = $this->input->post('srh_customer_id');
        }
        $this->load->model('Sales_Model');
        $columns       = array(
            0 => 'sale_datetime',
            1 => 'sale_reference_no',
            2 => 'cus_name',
            3 => 'sale_id',
            4 => 'sale_id',
            5 => 'sale_id'
        );
        $data          = array();
        $sales         = $this->Sales_Model->get_all_sales_return_for_balance_report($srh_warehouse_id, $srh_to_date, $srh_from_date, $srh_customer_id);
        $totalData     = count($sales);
        $totalFiltered = $totalData;
        foreach ($sales as $row) {
            $nestedData        = array();
            $total_paid_amount = $row['total_paid_amount'];
            $pay_st            = '';
            $nestedData[]      = display_date_time_format($row['sl_rtn_datetime']);
            $nestedData[]      = $row['sl_rtn_reference_no'];
            $nestedData[]      = $row['cus_name'];
            if (empty($total_paid_amount)) {
                $pay_st = '<span class="label label-warning">Pending</span>';
            } else {
                if ($total_paid_amount >= $row['sl_rtn_total']) {
                    $pay_st = '<span class="label label-success">Paid</span>';
                } else {
                    $pay_st = '<span class="label label-info">Partial</span>';
                }
            }
            $nestedData[] = $pay_st;
            $nestedData[] = $row['sl_rtn_total'];
            $data[]       = $nestedData;
        }
        $json_data = array(
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data" => $data
        );
        echo json_encode($json_data);
    }
    public function get_list_payments_for_balance_report()
    {
        $data             = array();
        $srh_to_date      = '';
        $srh_from_date    = '';
        $srh_customer_id  = $this->input->post('srh_customer_id');
        $srh_warehouse_id = $this->input->post('srh_warehouse_id');
        $srh_type         = $this->input->post('srh_type');
        $srh_payment_term = $this->input->post('srh_payment_term');
        $ss_user_id       = $this->input->post('ss_user_id');
        if ($this->input->post('srh_to_date')) {
            $srh_to_date = date('Y-m-d 23:59:59', strtotime($this->input->post('srh_to_date')));
        }
        if ($this->input->post('srh_from_date')) {
            $srh_from_date = date('Y-m-d 00:00:00', strtotime($this->input->post('srh_from_date')));
        }
        $values  = $this->Sales_Model->getPaymentsForBalance($srh_warehouse_id, $srh_to_date, $srh_from_date, $srh_type, $srh_payment_term, $ss_user_id, $srh_customer_id);
        $columns = array(
            0 => 'bkng_id',
            1 => 'bkng_id',
            2 => 'bkng_id',
            3 => 'bkng_id',
            4 => 'bkng_id',
            5 => 'bkng_id',
            6 => 'bkng_id',
            7 => 'bkng_id',
            8 => 'bkng_id'
        );
        if (!empty($values)) {
            foreach ($values as $users) {
                $row             = array();
                $bkng_id         = $users->sale_id;
                $paymnt_id       = $users->sale_pymnt_id;
                $row[]           = sprintf("%04d", $users->sale_pymnt_id);
                $row[]           = $users->sale_pymnt_date_time;
				
				if($srh_type == 'sale')
                $row[]           = $users->sale_reference_no;
				
				if($srh_type == 'sales_return')
                $row[]           = $users->sl_rtn_id;
                $pymnt_collected = '';
                $checked_status  = '';
                if ($pymnt_collected == 1) {
                    $checked_status = 'checked=\"checked\"';
                } else {
                    $checked_status = '';
                }
                $row[]  = $users->sale_payment_type;
                $row[]  = $users->sale_pymnt_paying_by;
                $row[]  = $users->sale_pymnt_amount;
                $paid   = 0;
                $data[] = $row;
            }
            $output = array(
                'data' => $data
            );
            echo json_encode($output);
        } else {
            $output = array(
                'data' => ''
            );
            echo json_encode($output);
        }
    }
    public function get_list_sales_for_print_balance($value = '')
    {
        $srh_to_date        = '';
        $srh_from_date      = '';
        $srh_warehouse_id   = $this->input->post('srh_warehouse_id');
        $srh_customer_id    = $this->input->post('srh_customer_id');
        $srh_payment_status = $this->input->post('srh_payment_status');
        if ($this->input->post('srh_to_date')) {
            $srh_to_date = date('Y-m-d 23:59:59', strtotime($this->input->post('srh_to_date')));
        }
        if ($this->input->post('srh_from_date')) {
            $srh_from_date = date('Y-m-d 00:00:00', strtotime($this->input->post('srh_from_date')));
        }
        $this->load->model('Sales_Model');
        $columns       = array(
            0 => 'sale_datetime',
            1 => 'sale_reference_no',
            2 => 'cus_name',
            3 => 'sale_id',
            4 => 'sale_id',
            5 => 'sale_id'
        );
        $data          = array();
        $sales         = $this->Sales_Model->get_all_sales_for_report_balance($srh_warehouse_id, $srh_to_date, $srh_from_date, '', '', '', $srh_customer_id);
        $totalData     = count($sales);
        $totalFiltered = $totalData;
        foreach ($sales as $row) {
            $nestedData        = array();
            $p_status          = '';
            $pay_st            = '';
            $sale_id           = $row['sale_id'];
            $total_paid_amount = 0;
            $total_paid_amount = $this->Sales_Model->get_total_paid_by_sale_id($sale_id);
            $return_tot_amt    = 0;
            $return_tot_amt    = $this->Sales_Return_Model->get_total_return_by_sale_id($sale_id);
            $nestedData[]      = $row['sale_id'];
            $nestedData[]      = display_date_time_format($row['sale_datetime']);
            $nestedData[]      = $row['sale_reference_no'];
            $nestedData[]      = $row['cus_name'];
            if (empty($total_paid_amount)) {
                $pay_st   = '<span class="label label-warning">Pending</span>';
                $p_status = 'Pending';
            } else {
                if ($total_paid_amount >= ($row['sale_total'] - $return_tot_amt)) {
                    $pay_st   = '<span class="label label-success">Paid</span>';
                    $p_status = 'Paid';
                } else {
                    $pay_st   = '<span class="label label-info">Partial</span>';
                    $p_status = 'Partial';
                }
            }
            if ($srh_payment_status) {
                if ($srh_payment_status == $p_status) {
                    $nestedData[] = $pay_st;
                    $nestedData[] = number_format($row['sale_total'], 2, '.', '');
                    $nestedData[] = $return_tot_amt;
                    $nestedData[] = number_format($total_paid_amount, 2, '.', '');
                    $nestedData[] = number_format($row['sale_total'] - $return_tot_amt - $total_paid_amount, 2, '.', '');
                    $nestedData[] = $row['sale_note'];
                    $data[]       = $nestedData;
                }
            } else {
                $nestedData[] = $pay_st;
                $nestedData[] = number_format($row['sale_total'], 2, '.', '');
                $nestedData[] = $return_tot_amt;
                $nestedData[] = number_format($total_paid_amount, 2, '.', '');
                $nestedData[] = number_format($row['sale_total'] - $return_tot_amt - $total_paid_amount, 2, '.', '');
                $nestedData[] = $row['sale_note'];
                $data[]       = $nestedData;
            }
        }
        $json_data = array(
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data" => $data
        );
        echo json_encode($json_data);
    }
	
	   public function get_unrealized_cheques()
    {
        $cash             = 0;
        $ret_amt          = 0;
        $srh_warehouse_id = $this->input->get('warehouse_id');
        $cus_id           = $this->input->get('cus_id');
        $date             = $this->input->get('date');
        $date             = date('Y-m-d', strtotime($date));
        $totcash          = 0;
        $cheque           = 0;
        $today            = date("Y-m-d");
        $total_paid       = $this->Sales_Model->getPaymentsForBalance($srh_warehouse_id, '', '', 'sale', '', '', $cus_id);
        if ($total_paid) {
            foreach ($total_paid as $row2) {
                if ($row2->sale_pymnt_paying_by != 'Return_Cash') {
                    if ($row2->sale_pymnt_paying_by == 'Cheque') {
                        if ($row2->sale_pymnt_date_time > $date) {
                            $cheque = $cheque + $row2->sale_pymnt_amount;
                        }
                    }
                }
            }
        }
        echo json_encode(array(
            'old_credit_amount' => $cheque
        ));
    }
    public function customer_balance_summery()
    {
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name']  = 'customer_summery_balance';
        $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        $data['customer_list']  = $this->Customer_Model->get_all_customers();
        $this->load->view('rep_customer_balance_summery', $data);
    }
    function print_customer_summery()
    {
        $data['main_menu_name'] = 'reports';
        $srh_warehouse_id       = $this->input->get('srh_warehouse_id');
        $srh_customer_id        = $this->input->get('srh_customer_id');
        $srh_from_date          = $this->input->get('srh_from_date');
        $srh_to_date            = $this->input->get('srh_to_date');
        $type                   = $this->input->get('type');
        $data['customers']      = $this->Customer_Model->get_customers($srh_customer_id);
        if ($srh_warehouse_id) {
            $warehouse_details          = $this->Warehouse_Model->get_warehouse_info($srh_warehouse_id);
            $data['srh_warehouse_name'] = $warehouse_details['name'];
            $data['warehouse_details']  = $warehouse_details;
            $data['warehouse_id']       = $srh_warehouse_id;
            $data['srh_from_date']      = $srh_from_date;
            $data['srh_to_date']        = $srh_to_date;
            $data['srh_customer_id']    = $srh_customer_id;
        } else {
            $data['srh_warehouse_name'] = "-All-";
        }
        if ($type == 'a') {
            $data['summery'] = $this->Customer_Model->get_all_customer();
            $this->load->view('rep_summery_view', $data);
        }
        if ($type == 'b')
            $this->load->view('rep_summery_balance_view', $data);
    }
	
	 public function cheque()
    {
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name']  = 'cheque';
        $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        $data['customer_list']  = array();//$this->Customer_Model->get_all_customers();
        $this->load->view('rep_cheque', $data);
    }
    
    public function supplier_payment_report()
    {
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name']  = 'supplier_payment_report';
        $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        $data['customer_list']  = array();//$this->Customer_Model->get_all_customers();
        $this->load->view('rep_supplier_payment_report', $data);
    }
    
     public function credit_card_report()
    {
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name']  = 'credit_card_report';
        $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        $data['customer_list']  = array();//$this->Customer_Model->get_all_customers();
        $this->load->view('rep_credit_card_report', $data);
    }
    public function unrealized_cheque()
    {
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name']  = 'unrealized_cheque';
        $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        $data['customer_list']  = array();//$this->Customer_Model->get_all_customers();
        $this->load->view('rep_unrealized_cheque', $data);
    }
    public function return_cheque()
    {
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name']  = 'return_cheque';
        $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        $data['customer_list']  =array();// $this->Customer_Model->get_all_customers();
        $this->load->view('rep_cheque_return', $data);
    }
	
	 public function get_list_cheque_for_report()
    {
        $data             = array();
        $srh_to_date      = '';
        $srh_from_date    = '';
        $srh_warehouse_id = $this->input->post('srh_warehouse_id');
        $srh_type         = $this->input->post('srh_type');
        $srh_payment_term = $this->input->post('srh_payment_term');
        $ss_user_id       = $this->input->post('ss_user_id');
        if ($this->input->post('srh_to_date')) {
            $srh_to_date = date('Y-m-d', strtotime($this->input->post('srh_to_date')));
        }
        if ($this->input->post('srh_from_date')) {
            $srh_from_date = date('Y-m-d', strtotime($this->input->post('srh_from_date')));
        }
        $values  = $this->Sales_Model->getChequeForPrint($srh_warehouse_id, $srh_to_date, $srh_from_date, $srh_type, $srh_payment_term, $ss_user_id);
        $columns = array(
            0 => 'bkng_id',
            1 => 'bkng_id',
            2 => 'bkng_id',
            3 => 'bkng_id',
            4 => 'bkng_id',
            5 => 'bkng_id',
            6 => 'bkng_id',
            7 => 'bkng_id',
            8 => 'bkng_id'
        );
        $tmp_id  = 0;
        if (!empty($values)) {
            foreach ($values as $users) {
                $row       = array();
                $bkng_id   = $users->sale_id;
                $paymnt_id = $users->sale_pymnt_id;
                $tmp_id++;
                $row[]           = $tmp_id;
                $row[]           = $users->cus_name;
                $row[]           = site_date_time($users->sale_pymnt_added_date_time);
                $row[]           = $users->sale_pymnt_note;
                $row[]           = $users->sale_pymnt_cheque_no;
                $row[]           = site_date($users->sale_pymnt_date_time);
                $row[]           = $users->sale_reference_no;
                $pymnt_collected = '';
                $checked_status  = '';
                if ($pymnt_collected == 1) {
                    $checked_status = 'checked=\"checked\"';
                } else {
                    $checked_status = '';
                }
				if($users->smp_amount>0)
                $row[]  = $users->smp_amount;
				else 
				$row[]  = $users->sale_pymnt_amount;
				
                $paid   = 0;
                $data[] = $row;
            }
            $output = array(
                'data' => $data
            );
            echo json_encode($output);
        } else {
            $output = array(
                'data' => ''
            );
            echo json_encode($output);
        }
    }
    
    
     public function get_list_supplier_payment_for_report()
    {
        $data             = array();
        $srh_to_date      = '';
        $srh_from_date    = '';
        $srh_warehouse_id = $this->input->post('srh_warehouse_id');
        $srh_type         = $this->input->post('srh_type');
        $srh_payment_term = $this->input->post('srh_payment_term');
        $ss_user_id       = $this->input->post('ss_user_id');
        if ($this->input->post('srh_to_date')) {
            $srh_to_date = date('Y-m-d', strtotime($this->input->post('srh_to_date')));
        }
        if ($this->input->post('srh_from_date')) {
            $srh_from_date = date('Y-m-d', strtotime($this->input->post('srh_from_date')));
        }
        $values  = $this->Sales_Model->getsupplier_paymentForPrint($srh_warehouse_id, $srh_to_date, $srh_from_date, $srh_type, $srh_payment_term, $ss_user_id);
        $columns = array(
            0 => 'bkng_id',
            1 => 'bkng_id',
            2 => 'bkng_id',
            3 => 'bkng_id',
            4 => 'bkng_id',
            5 => 'bkng_id',
            6 => 'bkng_id',
            7 => 'bkng_id',
            8 => 'bkng_id'
        );
        $tmp_id  = 0;
        if (!empty($values)) {
            foreach ($values as $users) {
                $row       = array();
                $bkng_id   = $users->sale_id;
                $paymnt_id = $users->sale_pymnt_id;
                $tmp_id++;
                $row[]           = $tmp_id;
                $row[]           = $users->cus_name;
                $row[]           = site_date_time($users->sale_pymnt_added_date_time);
                $row[]           = $users->sale_pymnt_note;
                $row[]           = $users->sale_pymnt_cheque_no;
                $row[]           = site_date($users->sale_pymnt_date_time);
                $row[]           = $users->sale_reference_no;
                $pymnt_collected = '';
                $checked_status  = '';
                if ($pymnt_collected == 1) {
                    $checked_status = 'checked=\"checked\"';
                } else {
                    $checked_status = '';
                }
				if($users->smp_amount>0)
                $row[]  = $users->smp_amount;
				else 
				$row[]  = $users->sale_pymnt_amount;
				
                $paid   = 0;
                $data[] = $row;
            }
            $output = array(
                'data' => $data
            );
            echo json_encode($output);
        } else {
            $output = array(
                'data' => ''
            );
            echo json_encode($output);
        }
    }
    
    
     public function get_list_credit_card_for_report()
    {
        $data             = array();
        $srh_to_date      = '';
        $srh_from_date    = '';
        $srh_warehouse_id = $this->input->post('srh_warehouse_id');
        $srh_type         = $this->input->post('srh_type');
        $srh_payment_term = $this->input->post('srh_payment_term');
        $ss_user_id       = $this->input->post('ss_user_id');
        if ($this->input->post('srh_to_date')) {
            $srh_to_date = date('Y-m-d', strtotime($this->input->post('srh_to_date')));
        }
        if ($this->input->post('srh_from_date')) {
            $srh_from_date = date('Y-m-d', strtotime($this->input->post('srh_from_date')));
        }
        $values  = $this->Sales_Model->getCreditCardForPrint($srh_warehouse_id, $srh_to_date, $srh_from_date, $srh_type, $srh_payment_term, $ss_user_id);
        $columns = array(
            0 => 'bkng_id',
            1 => 'bkng_id',
            2 => 'bkng_id',
            3 => 'bkng_id',
            4 => 'bkng_id',
            5 => 'bkng_id',
            6 => 'bkng_id',
            7 => 'bkng_id',
            8 => 'bkng_id'
        );
        $tmp_id  = 0;
        if (!empty($values)) {
            foreach ($values as $users) {
                $row       = array();
                $bkng_id   = $users->sale_id;
                $paymnt_id = $users->sale_pymnt_id;
                $tmp_id++;
                $row[]           = $tmp_id;
                $row[]           = $users->cus_name;
                $row[]           = site_date_time($users->sale_pymnt_added_date_time);
                $row[]           = $users->sale_pymnt_note;
                $row[]           = $users->sale_pymnt_cheque_no;
                $row[]           = site_date($users->sale_pymnt_date_time);
                $row[]           = $users->sale_reference_no;
                $pymnt_collected = '';
                $checked_status  = '';
                if ($pymnt_collected == 1) {
                    $checked_status = 'checked=\"checked\"';
                } else {
                    $checked_status = '';
                }
				if($users->smp_amount>0)
                $row[]  = $users->smp_amount;
				else 
				$row[]  = $users->sale_pymnt_amount;
				
                $paid   = 0;
                $data[] = $row;
            }
            $output = array(
                'data' => $data
            );
            echo json_encode($output);
        } else {
            $output = array(
                'data' => ''
            );
            echo json_encode($output);
        }
    }
    
    
    public function get_list_unrealized_cheque_for_report()
    {
        $data             = array();
        $srh_to_date      = '';
        $srh_from_date    = '';
        $srh_warehouse_id = $this->input->post('srh_warehouse_id');
        $srh_type         = $this->input->post('srh_type');
        $srh_payment_term = $this->input->post('srh_payment_term');
        $ss_user_id       = $this->input->post('ss_user_id');
        if ($this->input->post('srh_to_date')) {
            $srh_to_date = date('Y-m-d', strtotime($this->input->post('srh_to_date')));
        }
        if ($this->input->post('srh_from_date')) {
            $srh_from_date = date('Y-m-d', strtotime($this->input->post('srh_from_date')));
        }
        $values  = $this->Sales_Model->getUnrealizedChequeForPrint($srh_warehouse_id, $srh_to_date, $srh_from_date, $srh_type, $srh_payment_term, $ss_user_id);
        $columns = array(
            0 => 'bkng_id',
            1 => 'bkng_id',
            2 => 'bkng_id',
            3 => 'bkng_id',
            4 => 'bkng_id',
            5 => 'bkng_id',
            6 => 'bkng_id',
            7 => 'bkng_id',
            8 => 'bkng_id'
        );
        $tmp_id  = 0;
        if (!empty($values)) {
            foreach ($values as $users) {
                $row       = array();
                $bkng_id   = $users->sale_id;
                $paymnt_id = $users->sale_pymnt_id;
                $tmp_id++;
                $row[]           = $tmp_id;
                $row[]           = $users->cus_name;
                $row[]           = site_date_time($users->sale_pymnt_added_date_time);
                $row[]           = $users->sale_pymnt_note;
                $row[]           = $users->sale_pymnt_cheque_no;
                $row[]           = site_date($users->sale_pymnt_date_time);
                $row[]           = $users->sale_reference_no;
                $pymnt_collected = '';
                $checked_status  = '';
                if ($pymnt_collected == 1) {
                    $checked_status = 'checked=\"checked\"';
                } else {
                    $checked_status = '';
                }
                $row[]  = $users->sale_pymnt_amount;
                $paid   = 0;
                $data[] = $row;
            }
            $output = array(
                'data' => $data
            );
            echo json_encode($output);
        } else {
            $output = array(
                'data' => ''
            );
            echo json_encode($output);
        }
    }
    public function get_list_return_cheque_for_report()
    {
        $data             = array();
        $srh_to_date      = '';
        $srh_from_date    = '';
        $srh_warehouse_id = $this->input->post('srh_warehouse_id');
        $srh_type         = $this->input->post('srh_type');
        $srh_payment_term = $this->input->post('srh_payment_term');
        $ss_user_id       = $this->input->post('ss_user_id');
        if ($this->input->post('srh_to_date')) {
            $srh_to_date = date('Y-m-d', strtotime($this->input->post('srh_to_date')));
        }
        if ($this->input->post('srh_from_date')) {
            $srh_from_date = date('Y-m-d', strtotime($this->input->post('srh_from_date')));
        }
        $values  = $this->Sales_Model->getRetChequeForPrint($srh_warehouse_id, $srh_to_date, $srh_from_date, $srh_type, $srh_payment_term, $ss_user_id);
        $columns = array(
            0 => 'bkng_id',
            1 => 'bkng_id',
            2 => 'bkng_id',
            3 => 'bkng_id',
            4 => 'bkng_id',
            5 => 'bkng_id',
            6 => 'bkng_id',
            7 => 'bkng_id',
            8 => 'bkng_id'
        );
        $tmp_id  = 0;
        if (!empty($values)) {
            foreach ($values as $users) {
                $row       = array();
                $bkng_id   = $users->sale_id;
                $paymnt_id = $users->sale_pymnt_id;
                $tmp_id++;
                $row[]           = $tmp_id;
                $row[]           = $users->cus_name;
                $row[]           = site_date_time($users->sale_pymnt_added_date_time);
                $row[]           = $users->sale_pymnt_note;
                $row[]           = $users->sale_pymnt_cheque_no;
                $row[]           = site_date($users->sale_pymnt_date_time);
                $row[]           = $users->sale_reference_no;
                $pymnt_collected = '';
                $checked_status  = '';
                if ($pymnt_collected == 1) {
                    $checked_status = 'checked=\"checked\"';
                } else {
                    $checked_status = '';
                }
                $row[]  = $users->sale_pymnt_amount;
                $paid   = 0;
                $data[] = $row;
            }
            $output = array(
                'data' => $data
            );
            echo json_encode($output);
        } else {
            $output = array(
                'data' => ''
            );
            echo json_encode($output);
       
	   
	    }
    }
	
	public function get_transfer_des_for_sm_report(){
		$des='';
		$srh_warehouse_id=$this->input->post('srh_warehouse_id');
		$product_id=$this->input->post('product_id');
		$srh_from_date=$this->input->post('srh_from_date');
		$srh_to_date=$this->input->post('srh_to_date');
		$warehouse_list = $this->Warehouse_Model->get_all_warehouse();
		foreach ($warehouse_list as $row){
			
			//get transer qty 
			$trnsfr_to_warehouse_id=$row->id;
			$transferd_qty=0;
			if($trnsfr_to_warehouse_id!=$srh_warehouse_id){
				//$warehouse_id,$product_id,$srh_from_date='',$srh_to_date='',$search_key_val='',$cat_srh='',$trnsfr_to_warehouse_id=''
				$transferd_qty=intVal($this->Transfer_Model->getTransferdQtyByWarehouseId($trnsfr_to_warehouse_id,$product_id,$srh_from_date,$srh_to_date,'','',$srh_warehouse_id));
				if($transferd_qty){		
					if($des) $des=$des." , ";
					$des=$des."$transferd_qty ($row->name) "; 
				}
			}                                                            
		}
		 $st = array('status' =>0,'des' =>$des);
         echo json_encode($st);
	}

	public function get_transfer_reseved_des_for_sm_report(){
		$des='';
		$srh_warehouse_id=$this->input->post('srh_warehouse_id');
		$product_id=$this->input->post('product_id');
		$srh_from_date=$this->input->post('srh_from_date');
		$srh_to_date=$this->input->post('srh_to_date');
		$warehouse_list = $this->Warehouse_Model->get_all_warehouse();
		foreach ($warehouse_list as $row){
			
			//get transer qty 
			$trnsfr_to_warehouse_id=$row->id;
			if($trnsfr_to_warehouse_id!=$srh_warehouse_id){
			$transferd_qty=intVal($this->Transfer_Model->getTransferdQtyByWarehouseId($srh_warehouse_id,$product_id,$srh_from_date,$srh_to_date,$trnsfr_to_warehouse_id))
			;
			if($transferd_qty){		
			if($des) $des=$des." , ";
			$des=$des."$transferd_qty ($row->name) "; 
			}
			}                                                            
		}
		 $st = array('status' =>0,'des' =>$des);
         echo json_encode($st);
	}
		
	public function stock_movement_list(){
	
	$product_id=$this->input->post('product_id');
	$srh_warehouse_id=$this->input->post('srh_warehouse_id');
	$location_id=$this->input->post('location_id');
	$product_name=$this->input->post('product_name');
	$product_model=$this->input->post('product_model');
	$srh_from_date=$this->input->post('srh_from_date');
	$srh_to_date=$this->input->post('srh_to_date');
	$cat_srh=$this->input->post('cat_srh');
	$subcategory=$this->input->post('subcategory');
	$show_all=$this->input->post('show_all');
	
	
	$data=array();	
	//$data_list=$this->Report_Model->total_product_quantity_list($product_id);
	//$location_count=$data_list[0]['location_count'];
	//$warehouse_count=$data_list[0]['warehouse_count'];
	//$total=$location_count+$warehouse_count;
	//$location_list=$this->Location_Model->get_all_location_for_dropdown();
	/*
	echo json_encode(array("product_name"=>$product_name,"product_model"=>$product_model,"location_count"=>$location_count,"warehouse_count"=>$warehouse_count,"total"=>$total));
	*/
	
	//$srh_warehouse_id=1;
	//$product_name=$product_id;
	//$product_model=$product_id;
	$row="";
	$row.="<tr>";
	
	$item_location_qty=0;
	
	$item_tot_qty=0;
	$item_warehouse_qty='';
	$warehosue_balance=0;
	
	$warehouse_opening_stock=0;
	//get product table warehouse opening stock
	$product_info=$this->Product_Models->get_product_by_id($product_id);
	
	//category check
	
	if($cat_srh!=$product_info->cat_id && $cat_srh!=''){
		echo json_encode(array("row"=>''));
		die();
	}
	if($subcategory!=$product_info->sub_cat_id && $subcategory!=''){
		echo json_encode(array("row"=>''));
		die();
	}
	
	
	$warehouse_opening_stock=0;//$product_info->stock_mov_avalable_qty;
	
	/*
	if($srh_warehouse_id)
	{
		$item_warehouse_qty=floatval($this->Purchases_Model->get_issued_serial_no_by_product_id_location_id($product_id,0,$srh_warehouse_id,'only_qty'));
		$item_tot_qty=$item_tot_qty+$item_warehouse_qty;
	}
	*/
	
	//echo "srh_from_date:".$srh_from_date;
	
	//opening_stock_qty get
	$day_before = date( 'Y-m-d', strtotime( $srh_from_date . ' -1 day' ) );
	$opening_stock_date=$day_before;
	$opening_stock_qty=0;
	$opening_stock_from_date='2017-12-24';//date('2018-06-24');
	$date_1=date( 'Y-m-d', strtotime( $opening_stock_from_date . ' +1 day' ) );
	$os_i=0;//$this->Report_Model->get_location_issue_by_location_id_and_date($location_id,$product_id,$date_1,$day_before);
	//os grn
	$os_grn=0;
	$os_grn_rtn=0;
	$os_grn=$this->Purchases_Model->getPurchasedQtyByWarehouseIdAndDateRange($location_id,$product_id,$date_1,$day_before);
	$os_grn_rtn=$this->Purchases_Model->getPurchaseRTNdQtyByWarehouseIdAndDateRange($location_id,$product_id,$date_1,$day_before);
	$os_ir=0;//$this->Report_Model->get_location_issue_return_by_location_id_and_date($location_id,$product_id,$date_1,$day_before);
	$os_s =$this->Report_Model->get_location_sale_by_location_id_and_date($location_id,$product_id,$date_1,$day_before);
	//$os_s=$this->Report_Model->get_location_sale_by_location_id_and_date(0,$product_id,$srh_from_date,$srh_to_date,'',$srh_warehouse_id);
	//echo $this->db->last_query();
	$os_h =0;// $this->Report_Model->get_location_sale_by_location_id_and_date($location_id,$product_id,$date_1,$day_before,'Hire');
	$os_st_adj=0;
		//$os_st_adj=$this->Purchases_Model->getStockAdjQtyByWarehouseIdAndDateRange($location_id,$product_id,$date_1,$day_before);
	
	//service issue 
	$os_ser_issue=$this->Purchases_Model->getServiceIssueWarehouseIdAndDateRange($location_id,$product_id,$date_1,$day_before);
	$os_ser_issue_rtn=$this->Purchases_Model->getServiceReturnWarehouseIdAndDateRange($location_id,$product_id,$date_1,$day_before);
	
	
	$trf_out_os=0;
	$trf_in_os=0;
	$trf_out_os=intVal($this->Transfer_Model->getTransferdQtyByWarehouseId($srh_warehouse_id,$product_id,$date_1,$day_before,''));
	
	//$warehouse_id,$product_id,$srh_from_date='',$srh_to_date='',$search_key_val='',$cat_srh='',$trnsfr_to_warehouse_id=''
	$trf_in_os=intVal($this->Transfer_Model->getTransferdQtyByWarehouseId('',$product_id,$date_1,$day_before,'','',$srh_warehouse_id));
	
	
	$os_exchange_qty=0;//$this->Report_Model->get_location_sale_exchange_by_location_id_and_date(0,$product_id,$date_1,$day_before,'',$srh_warehouse_id);
	
	$os_exchange_qty=intval($os_exchange_qty);
	
	
	
	
	//
	
	$test_var='';
	$opening_stock_qty_des="";
	//Start Date: $opening_stock_from_date 
	$opening_stock_qty_des="<br/>wos:$warehouse_opening_stock , os_i:$os_i ,os_ir:$os_ir ,os_s:$os_s ,os_h:$os_h , os e :$os_exchange_qty:";
	//$opening_stock_qty=$os_i-$os_ir-$os_s-$os_h;
	$opening_stock_qty=$warehouse_opening_stock+$os_i-$os_ir-$os_s-$os_h;
	$warehouse_opening_stock_tot=0;
	$warehouse_opening_stock_tot=$warehouse_opening_stock+$os_grn-$os_grn_rtn-$os_i+$os_ir-$os_s-$os_h-$os_ser_issue+$os_ser_issue_rtn+$os_exchange_qty-$os_st_adj;
	
	//$opening_stock_qty_des="wos:$warehouse_opening_stock , os_i:$os_i, os_ir:$os_ir , ";
	
	//$opening_stock_qty=$os_i;
	//opening_stock_qty end
	
	
	
	//get issue item sum
	$location_issue_qty =0;// $this->Report_Model->get_location_issue_by_location_id_and_date($location_id,$product_id,$srh_from_date,$srh_to_date);
	$location_issue_qty=intval($location_issue_qty);
	$location_issue_return_qty = 0;//$this->Report_Model->get_location_issue_return_by_location_id_and_date($location_id,$product_id,$srh_from_date,$srh_to_date);
	$location_cash_sale_qty =0;// $this->Report_Model->get_location_sale_by_location_id_and_date($location_id,$product_id,$srh_from_date,$srh_to_date,'Cash');
	$location_hire_sale_qty =0;// $this->Report_Model->get_location_sale_by_location_id_and_date($location_id,$product_id,$srh_from_date,$srh_to_date,'Hire');
	//echo $this->db->last_query();
	
	//gen qty
	$purchased_qty=$this->Purchases_Model->getPurchasedQtyByWarehouseIdAndDateRange($srh_warehouse_id,$product_id,$srh_from_date,$srh_to_date);
	//get grn rtn qty
	$purchased_rtn_qty=$this->Purchases_Model->getPurchaseRTNdQtyByWarehouseIdAndDateRange($srh_warehouse_id,$product_id,$srh_from_date,$srh_to_date);
	
	$purchased_qty=intval($purchased_qty);
	
	$sold_qty=$this->Report_Model->get_location_sale_by_location_id_and_date(0,$product_id,$srh_from_date,$srh_to_date,'',$srh_warehouse_id);
	$sold_qty=intval($sold_qty);
	
	$exchange_qty=0;//$this->Report_Model->get_location_sale_exchange_by_location_id_and_date(0,$product_id,$srh_from_date,$srh_to_date,'',$srh_warehouse_id);
	
	$exchange_qty=intval($exchange_qty);
	
	$other_in=0;
	$other_in=0;//$this->Report_Model->get_location_sale_exchange_by_location_id_and_date($location_id,$product_id,$srh_from_date,$srh_to_date,'','');
	
	//service issue 
	$ser_issue=$this->Purchases_Model->getServiceIssueWarehouseIdAndDateRange($location_id,$product_id,$srh_from_date,$srh_to_date);
	//echo "ser_issue:$ser_issue";
	//echo $this->db->last_query();
	
	$ser_issue_rtn=$this->Purchases_Model->getServiceReturnWarehouseIdAndDateRange($location_id,$product_id,$srh_from_date,$srh_to_date);
	
		$st_adj=0;
		$st_adj=0;//$this->Purchases_Model->getStockAdjQtyByWarehouseIdAndDateRange($location_id,$product_id,$srh_from_date,$srh_to_date);
	
	//$ser_issue_rtn=1;
	
	$other_in=intval($other_in);
	$trf_out=0;
	$trf_in=0;
	$trf_out=intVal($this->Transfer_Model->getTransferdQtyByWarehouseId($srh_warehouse_id,$product_id,$srh_from_date,$srh_to_date,''));
	
	//$warehouse_id,$product_id,$srh_from_date='',$srh_to_date='',$search_key_val='',$cat_srh='',$trnsfr_to_warehouse_id=''
	$trf_in=intVal($this->Transfer_Model->getTransferdQtyByWarehouseId('',$product_id,$srh_from_date,$srh_to_date,'','',$srh_warehouse_id));
	
	//echo $this->db->last_query();
	
	//echo "location_cash_sale_qty:$location_cash_sale_qty";
	
	$warehosue_balance=$warehouse_opening_stock_tot+$purchased_qty-$purchased_rtn_qty-$sold_qty+$exchange_qty-$location_issue_qty+$location_issue_return_qty-$ser_issue+$ser_issue_rtn-$st_adj+$trf_in-$trf_out;
	
	//$warehosue_balance=$warehouse_opening_stock_tot;
	
	//$cl_balance=0;
	
	//$cl_balance=$other_in+$opening_stock_qty+$location_issue_qty-$location_issue_return_qty-$location_cash_sale_qty-$location_hire_sale_qty;
	//$cl_balance=$opening_stock_qty;
	
	
	
	$item_warehouse_qty='';
	$item_tot_qty='';
	
	$opening_stock_qty='';
	
	//test
	//$cl_balance='';
	$other_in='';
	$opening_stock_qty_des=''; //test
	$purchased_rtn_qty=intval($purchased_rtn_qty);
	
//	$warehouse_opening_stock_tot=$warehouse_opening_stock;
	
	//end test
	// ($product_model) 
	$row.="<td align=\"left\" style=\"text-align:left\">$product_name $opening_stock_qty_des</td>";
	$row.="<td align='right'>$warehouse_opening_stock_tot</td>";
	
	$row.="<td align='right'>$purchased_qty </td>";
	$row.="<td align='right'>$purchased_rtn_qty</td>";
	$row.="<td align='right'>$st_adj</td>";
	$row.="<td align='right'>$ser_issue</td>";
	$row.="<td align='right'>$ser_issue_rtn</td>";
	$row.="<td align='right'>$sold_qty </td>";
	$row.="<td align='right'><a style=\"cursor:pointer\" onclick=\"pop_up_view_transfer_details('$product_id')\">$trf_out</a> </td>";
	$row.="<td align='right'><a style=\"cursor:pointer\" onclick=\"pop_up_view_transfer_details('$product_id')\">$trf_in</a></td>";
	$row.="<td align='right'>$location_issue_qty</td>";
	$row.="<td align='right'>$location_issue_return_qty</td>";
	$row.="<td align='right'>$warehosue_balance </td>";
	//$row.="<td>$opening_stock_qty </td>";
	
	//$row.="<td>$location_cash_sale_qty</td>";
	//$row.="<td>$location_hire_sale_qty</td>";
	//$row.="<td>$other_in</td>";
	//$row.="<td></td>";
	//$row.="<td>$cl_balance</td>";
	$row.="</tr>";
	
	//"","","","",
	//$row="'1','2','3','4'";
	//$item_tot_qty=1; || $location_issue_return_qty!=0
	//echo "warehouse_opening_stock:$warehouse_opening_stock";
	$display=false;
	
	//echo ($show_all);
	
	if($show_all=='true'){
	if($warehosue_balance!=0 || $warehouse_opening_stock!=0 || $purchased_qty!=0 || $sold_qty!=0 || $location_issue_qty!=0 || $location_issue_return_qty!=0 || $location_cash_sale_qty!=0 || $location_hire_sale_qty!=0 || $ser_issue!=0 || $ser_issue_rtn!=0 || $st_adj!=0){
		$display=true;
	}
	}else{
		if($purchased_qty!=0 || $sold_qty!=0 || $location_issue_qty!=0 || $location_issue_return_qty!=0 || $location_cash_sale_qty!=0 || $location_hire_sale_qty!=0 || $ser_issue!=0 || $ser_issue_rtn!=0 || $st_adj!=0){
		$display=true;
	}
	}
	
	//$display=false;
	
	//$display=true; //test 
	if($display)
	{
	echo json_encode(array("row"=>$row));
	}else{
		echo json_encode(array("row"=>''));
	}
	}
	
	
	
	public function stock_book_list(){
	
	$product_id=$this->input->post('product_id');
	$srh_warehouse_id=$this->input->post('srh_warehouse_id');
	$location_id=$this->input->post('location_id');
	$product_name=$this->input->post('product_name');
	$product_model=$this->input->post('product_model');
	$srh_from_date=$this->input->post('srh_from_date');
	$srh_to_date=date( 'Y-m-d', strtotime( $srh_from_date . ' +1 day' ) );//$this->input->post('srh_to_date');
	$cat_srh=$this->input->post('cat_srh');
	$subcategory=$this->input->post('subcategory');
	$show_all=$this->input->post('show_all');
	
	
	$data=array();	
	$row="";
	$row.="<tr>";
	
	$item_location_qty=0;
	
	$item_tot_qty=0;
	$item_warehouse_qty='';
	$warehosue_balance=0;
	
	$warehouse_opening_stock=0;
	//get product table warehouse opening stock
	$product_info=$this->Product_Models->get_product_by_id($product_id,$cat_srh,$subcategory);
	
	//category check
	

	
	
	/*/////////////// start first date ///////////////*/
	
	
	$warehouse_opening_stock=0;//$product_info->stock_mov_avalable_qty;
	
	
	//opening_stock_qty get
	$day_before = date( 'Y-m-d', strtotime( $srh_from_date . ' -1 day' ) );
	$opening_stock_date=$day_before;
	$opening_stock_qty=0;
	$opening_stock_from_date='2017-12-24';//date('2018-06-24');
	$date_1=date( 'Y-m-d', strtotime( $opening_stock_from_date . ' +1 day' ) );
	$os_i=0;//$this->Report_Model->get_location_issue_by_location_id_and_date($location_id,$product_id,$date_1,$day_before);
	//os grn
	$os_grn=0;
	$os_grn_rtn=0;
	
	$os_ir=0;
	
	$os_h =0;
	
	$os_st_adj=0;
		
	
	//service issue 
	$os_ser_issue=0;
	$os_ser_issue_rtn=0;
	
	
	
	$trf_out_os=0;
	$trf_in_os=0;
	$os_s=0;
	
	
	
	$os_exchange_qty=0;//$this->Report_Model->get_location_sale_exchange_by_location_id_and_date(0,$product_id,$date_1,$day_before,'',$srh_warehouse_id);
	
	$os_exchange_qty=intval($os_exchange_qty);
	
	
	
	
	//
	
	$test_var='';
	$opening_stock_qty_des="";
	//Start Date: $opening_stock_from_date 
	$opening_stock_qty_des="<br/>wos:$warehouse_opening_stock , os_i:$os_i ,os_ir:$os_ir ,os_s:$os_s ,os_h:$os_h , os e :$os_exchange_qty:";
	//$opening_stock_qty=$os_i-$os_ir-$os_s-$os_h;
	$opening_stock_qty=$warehouse_opening_stock+$os_i-$os_ir-$os_s-$os_h;
	$warehouse_opening_stock_tot=0;
	$warehouse_opening_stock_tot=$warehouse_opening_stock+$os_grn-$os_grn_rtn-$os_i+$os_ir-$os_s-$os_h-$os_ser_issue+$os_ser_issue_rtn+$os_exchange_qty-$os_st_adj;
	
	//$opening_stock_qty_des="wos:$warehouse_opening_stock , os_i:$os_i, os_ir:$os_ir , ";
	
	//$opening_stock_qty=$os_i;
	//opening_stock_qty end
	
	
	
	//get issue item sum
	$location_issue_qty =0;// $this->Report_Model->get_location_issue_by_location_id_and_date($location_id,$product_id,$srh_from_date,$srh_to_date);
	$location_issue_qty=intval($location_issue_qty);
	$location_issue_return_qty = 0;//$this->Report_Model->get_location_issue_return_by_location_id_and_date($location_id,$product_id,$srh_from_date,$srh_to_date);
	$location_cash_sale_qty =0;// $this->Report_Model->get_location_sale_by_location_id_and_date($location_id,$product_id,$srh_from_date,$srh_to_date,'Cash');
	$location_hire_sale_qty =0;// $this->Report_Model->get_location_sale_by_location_id_and_date($location_id,$product_id,$srh_from_date,$srh_to_date,'Hire');
	//echo $this->db->last_query();
	
	//gen qty
	$purchased_qty=$this->Purchases_Model->getPurchasedQtyByWarehouseIdAndDateRange($srh_warehouse_id,$product_id,$srh_from_date,$srh_to_date);
	//get grn rtn qty
	$purchased_rtn_qty=$this->Purchases_Model->getPurchaseRTNdQtyByWarehouseIdAndDateRange($srh_warehouse_id,$product_id,$srh_from_date,$srh_to_date);
	
	$purchased_qty=intval($purchased_qty);
	
	$sold_qty=$this->Report_Model->get_location_sale_by_location_id_and_date(0,$product_id,$srh_from_date,$srh_to_date,'',$srh_warehouse_id);
	$sold_qty=intval($sold_qty);
	
	$exchange_qty=0;//$this->Report_Model->get_location_sale_exchange_by_location_id_and_date(0,$product_id,$srh_from_date,$srh_to_date,'',$srh_warehouse_id);
	
	$exchange_qty=intval($exchange_qty);
	
	$other_in=0;
	$other_in=0;//$this->Report_Model->get_location_sale_exchange_by_location_id_and_date($location_id,$product_id,$srh_from_date,$srh_to_date,'','');
	
	//service issue 
	$ser_issue=$this->Purchases_Model->getServiceIssueWarehouseIdAndDateRange($location_id,$product_id,$srh_from_date,$srh_to_date);
	//echo "ser_issue:$ser_issue";
	//echo $this->db->last_query();
	
	$ser_issue_rtn=$this->Purchases_Model->getServiceReturnWarehouseIdAndDateRange($location_id,$product_id,$srh_from_date,$srh_to_date);
	
		$st_adj=0;
		$st_adj=0;//$this->Purchases_Model->getStockAdjQtyByWarehouseIdAndDateRange($location_id,$product_id,$srh_from_date,$srh_to_date);
	
	//$ser_issue_rtn=1;
	
	$other_in=intval($other_in);
	$trf_out=0;
	$trf_in=0;
	$trf_out=intVal($this->Transfer_Model->getTransferdQtyByWarehouseId($srh_warehouse_id,$product_id,$srh_from_date,$srh_to_date,''));
	
	//$warehouse_id,$product_id,$srh_from_date='',$srh_to_date='',$search_key_val='',$cat_srh='',$trnsfr_to_warehouse_id=''
	$trf_in=intVal($this->Transfer_Model->getTransferdQtyByWarehouseId('',$product_id,$srh_from_date,$srh_to_date,'','',$srh_warehouse_id));
	
	//echo $this->db->last_query();
	
	//echo "location_cash_sale_qty:$location_cash_sale_qty";
	
	$warehosue_balance=$warehouse_opening_stock_tot+$purchased_qty-$purchased_rtn_qty-$sold_qty+$exchange_qty-$location_issue_qty+$location_issue_return_qty-$ser_issue+$ser_issue_rtn-$st_adj+$trf_in-$trf_out;
	
	//$warehosue_balance=$warehouse_opening_stock_tot;
	
	//$cl_balance=0;
	
	//$cl_balance=$other_in+$opening_stock_qty+$location_issue_qty-$location_issue_return_qty-$location_cash_sale_qty-$location_hire_sale_qty;
	//$cl_balance=$opening_stock_qty;
	
	
	
	$item_warehouse_qty='';
	$item_tot_qty='';
	
	$opening_stock_qty='';
	
	//test
	//$cl_balance='';
	$other_in='';
	$opening_stock_qty_des=''; //test
	$purchased_rtn_qty=intval($purchased_rtn_qty);
	
//	$warehouse_opening_stock_tot=$warehouse_opening_stock;
	
	//end test
	// ($product_model) 
	
	$in_sb=0;
	$out_sb=0;
	$sold_sb=0;
	$balance_sb=0;
	$transer_in_dis='';
	$transer_out_dis='';
	$purchased_qty_des='';
	
	$in_sb=$purchased_qty+$trf_in;
	$out_sb=$trf_out+$purchased_rtn_qty;
	$sold_sb=$sold_qty;
	//$balance_sb=$in_sb-$out_sb-$sold_sb;
	//$sn_list=$this->Purchases_Model->get_serial_no_by_avalable_warehosue_id($product_id,$srh_warehouse_id);
	//$balance_sb=count($sn_list);
	$balance_sb=0;
	
	//$balance_sb=0
	
	$transer_in_dis_ar=$this->Transfer_Model->getTransferdQtyByWarehouseIdStockBook($srh_warehouse_id,$product_id,$srh_from_date,$srh_to_date);
	foreach ($transer_in_dis_ar as $row_tr){
		$transer_in_dis.="<span class=\"text_tra\">&nbsp;".(int)$row_tr->trnsfr_itm_quantity."&nbsp;</span>"." <span class=\"text_top\"> $row_tr->code </span>  ";
	}
	
	$transer_out_dis_ar=$this->Transfer_Model->getTransferdQtyByWarehouseIdStockBookOut($srh_warehouse_id,$product_id,$srh_from_date,$srh_to_date);
	foreach ($transer_out_dis_ar as $row_tr){
		$transer_out_dis.="<span class=\"text_tra\">&nbsp;".(int)$row_tr->trnsfr_itm_quantity."&nbsp;</span>"." <span class=\"text_top\"> $row_tr->code </span>  ";
	}
	
	
	//print_r($transer_in_out_dis_ar);
	
	
	if(!$purchased_qty) $purchased_qty_des='';
	else $purchased_qty_des=$purchased_qty."<span class=\"text_top\"> GR </span>";
	
	
	
	
	//get balance qty
	$balance_sb=0;
	$grn_sb=0;
	$tr_in_sb=0;
	$tr_out_sb=0;
	$sale_2_sb=0;
	$sold_sb_des='';
	
	$grn_sb=$this->Purchases_Model->getPurchasedQtyByWarehouseIdAndDateRange($srh_warehouse_id,$product_id,'',$srh_to_date);
	$tr_in_sb=intVal($this->Transfer_Model->getTransferdQtyByWarehouseId('',$product_id,'',$srh_to_date,'','',$srh_warehouse_id));
	
	$tr_out_sb=intVal($this->Transfer_Model->getTransferdQtyByWarehouseId($srh_warehouse_id,$product_id,'',$srh_to_date,''));
	
	$sale_2_sb=intVal($this->Report_Model->get_location_sale_by_location_id_and_date(0,$product_id,'',$srh_to_date,'',$srh_warehouse_id));
	

	
	$balance_sb=$grn_sb+$tr_in_sb-$tr_out_sb-$sale_2_sb;
	
	if(!$sold_sb) $sold_sb_des=''; else  $sold_sb_des=$sold_sb; 
	
	$row.="<td align=\"left\" style=\"text-align:left\">$product_name $opening_stock_qty_des</td>";
	
	
	$row.="<td align='right'>$purchased_qty_des $transer_in_dis </td>";
	$row.="<td align='right'>$transer_out_dis</td>";
	$row.="<td align='right'>$sold_sb_des</td>";
	$row.="<td align='right'>$balance_sb</td>";
	
	/*/////////////// end first date ///////////////*/
	
	
	/*/////////////// start c date ///////////////*/
	
	$row.="<td align='right'></td>";
	$row.="<td align='right'></td>";
	$row.="<td align='right'></td>";
	$row.="<td align='right'></td>";
	
	/* end second date */
	
	$row.="<td align='right'></td>";
	$row.="<td align='right'></td>";
	$row.="<td align='right'></td>";
	$row.="<td align='right'></td>";
	$row.="</tr>";

	$display=false;
	
	if($show_all=='true'){
	$display=true;
	
	}else{
		if($in_sb!=0 || $out_sb!=0 || $sold_sb!=0 || $balance_sb!=0){
		$display=true;
	}
	}
	


	if($display)
	{
	echo json_encode(array("row"=>$row));
	}else{
		echo json_encode(array("row"=>''));
	}
	}
	
	public function total_product_quantity_report(){
	$data['main_menu_name'] = $this->main_menu_name;
	$data['sub_menu_name']='total_product_quantity_report';
	$data['sub_menu_name_1']='';
    $data['product_list'] = $this->Product_Models->getProducts();
	$data['location_list']=$this->Warehouse_Model->get_all_warehouse();//array();// $this->Warehouse_Model->get_all_warehouse();
	$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
	$data['category_list'] 	= $this->category_models->getCategory();
	$data['sub_category_list']   = $this->category_models->getSubCategory(1);
	$this->load->view('total_product_quantity_report',$data);
	}
	
	public function total_product_quantity_list(){
	$product_id=$this->input->post('product_id');
	$srh_warehouse_id=$this->input->post('srh_warehouse_id');
	$product_name=$this->input->post('product_name');
	$product_cost=$this->input->post('product_cost');
	$product_model=$this->input->post('product_model');
	$data=array();
	$data_list=array();//$this->Report_Model->total_product_quantity_list($product_id);
	$location_count=0;//$data_list[0]['location_count'];
	$warehouse_count=0;//$data_list[0]['warehouse_count'];
	$total=$location_count+$warehouse_count;
	$location_list=$this->Warehouse_Model->get_all_warehouse();//$this->Location_Model->get_all_location_for_dropdown();
	/*
	echo json_encode(array("product_name"=>$product_name,"product_model"=>$product_model,"location_count"=>$location_count,"warehouse_count"=>$warehouse_count,"total"=>$total));
	*/
	
	//$srh_warehouse_id=1;
	$row="";
	$row.="<tr>";
	$row.="<td align=\"left\" style=\"text-align:left\">$product_name ($product_model)</td>";
	$item_location_qty=0;
	
	$item_tot_qty=0;
	$item_warehouse_qty='';
	$balance_qty=0;
	if($srh_warehouse_id)
	{
		$item_warehouse_qty=0;//floatval($this->Purchases_Model->get_issued_serial_no_by_product_id_location_id($product_id,0,$srh_warehouse_id,'only_qty'));
		$item_tot_qty=$item_tot_qty+$item_warehouse_qty;
	}
	
	foreach ($location_list as $row_loc){
		$w_id=$row_loc->id;
		$location_name=0;//$row_loc['location_name'];
		
		$item_location_qty=0;//floatval($this->Purchases_Model->get_issued_serial_no_by_product_id_location_id($product_id,$location_id,$srh_warehouse_id,'only_qty'));
		//$item_tot_qty=$item_tot_qty+$item_location_qty;
		$srh_from_date='';
		$srh_to_date='';
		 $item_location_qty=$this->item_balance_warehoue_id($w_id, $product_id, $srh_from_date, $srh_to_date);
		
		//$row.="<td><a title=\"$location_name\" href=\"#\">$item_location_qty</a></td>";
		$row.="<td>$item_location_qty</td>";
		$balance_qty=$balance_qty+$item_location_qty;
	}
	$tot_cost=0;//number_format(($product_cost*$item_tot_qty), 2, '.', '');;//$product_cost*$item_tot_qty;
	$row.="<td>$item_location_qty</td>";
	//$row.="<td></td>";
	//$row.="<td></td>";
	//$row.="<td></td>";
	
	$row.="</tr>";
	
	//"","","","",
	//$row="'1','2','3','4'";
	$item_tot_qty=1;
	if($item_tot_qty)
	{
	echo json_encode(array("row"=>$row));
	}else{
		echo json_encode(array("row"=>''));
	}
	}
	

  public function get_list_product_for_stock_report_02($value = '') {
        $srh_warehouse_id = $this->input->post('srh_warehouse_id');
        $cat_srh = $this->input->post('cat_srh');
		$with_emi_no = $this->input->post('with_emi_no');
		$subcategory = $this->input->post('subcategory');
		$product_id = $this->input->post('product_id');
		$show_all = $this->input->post('show_all');
		$product_name = $this->input->post('product_name');
		$warehouse_list=$this->Warehouse_Model->get_all_warehouse();
		
		//print_r($srh_warehouse_id);
		
		

        $srh_from_date = '';
        $srh_to_date = '';
        if ($this->input->post('srh_to_date')) {
            $srh_to_date = date('Y-m-d', strtotime($this->input->post('srh_to_date')));
        }
        if ($this->input->post('srh_from_date')) {
            $srh_from_date = date('Y-m-d', strtotime($this->input->post('srh_from_date')));
        }

        /*         * ****************** */
        $search_key = $this->input->post('search');
        $search_key_val = $search_key['value'];
        $start = $this->input->post('start');
        $length = $this->input->post('length');

        $this->load->model('Product_Models');
        $values = '';
        $totalFiltered = 0;

//	$sales = $this->Sales_Model->get_all_sales($start,$length,$search_key_val);
//	$sales_count = $this->Sales_Model->get_all_sales('','','');

        $totalData = 0;
//	echo $length."//";
        //$getSumProductsForReport = $this->Product_Models->getSumProductsForReport($srh_warehouse_id,$cat_srh);

        if ($search_key_val) {
            $values = $this->Product_Models->getProductsForReport($srh_warehouse_id, $cat_srh, $start, $length, $search_key_val,'',$subcategory,$product_id,$product_name);
            //$values_c = $this->Product_Models->getProductsForReport_c($srh_warehouse_id, $cat_srh, '', '', $search_key_val);
            $totalData = $this->Product_Models->getProductsForReport($srh_warehouse_id, $cat_srh, $start, $length, $search_key_val,1,$subcategory,$product_id,$product_name);
        } else {
            $values = $this->Product_Models->getProductsForReport($srh_warehouse_id, $cat_srh, $start, $length, '','',$subcategory,$product_id,$product_name);
           // $values_c = $this->Product_Models->getProductsForReport_c($srh_warehouse_id, $cat_srh, $start, '', '');
            //print_r($values_c[0]->count);
             $totalData = $this->Product_Models->getProductsForReport($srh_warehouse_id, $cat_srh, '', '', '',1,$subcategory,$product_id,$product_name);
        }

        $totalFiltered = $totalData;
        /*         * ****************** */

        $costPriceTot = 0; //$this->Purchases_Model->getPurchasedQtyByWarehouseId('','',$srh_from_date,$srh_to_date);

        $data = array();
		$x=0;
		$tot_balance=0;
		$tot_in=0;
		$tot_out=0;
		$tot_sale=0;
		//$tot_c
        if (!empty($values)) {
            foreach ($values as $products) {
				$x++;

                if ($products->product_status == 0) {
                    $k = "btn-warning";
                    $m = "fa-minus-circle";
                } else {
                    $k = "btn-green";
                    $m = "fa-check";
                }
                $retVal = (empty($products->sub_cat_name)) ? "--:--" : $products->sub_cat_name;

                $row = array();

                //get transferd qty
               
				
				
				$display=0;
				
				if($show_all){
					$display=1;	// show all items with 0 stcok
				}
				
              
			   
              
                $row[] = $products->product_name.' / '.$products->product_code;
//$srh_from_date='';
//$srh_to_date='';
$item_qty=0;
$tot_item_qty=0;

//  $item_qty=$this->item_balance_warehoue_id($w_id, $products->product_id, $srh_from_date, $srh_to_date);
				
	
	
	
	/* start list */
	
	$purchased_qty=0;
	$product_id=$products->product_id;
	$purchased_rtn_qty=0;
	//gen qty=
	$purchased_qty=$this->Purchases_Model->getPurchasedQtyByWarehouseIdAndDateRange_mw($srh_warehouse_id,$product_id,$srh_from_date,$srh_to_date);
	//get grn rtn qty
	$purchased_rtn_qty=$this->Purchases_Model->getPurchaseRTNdQtyByWarehouseIdAndDateRange_mw($srh_warehouse_id,$product_id,$srh_from_date,$srh_to_date);
	
	$purchased_qty=intval($purchased_qty);
	
	$sold_qty=0;
	//$sold_qty=$this->Report_Model->get_location_sale_by_location_id_and_date(0,$product_id,$srh_from_date,$srh_to_date,'',$srh_warehouse_id);
	//echo $this->db->last_query();
	$sold_qty=intval($sold_qty);
	
	
	$other_in=0;
	$other_in=0;
	
	
	$other_in=intval($other_in);
	$trf_out=0;
	$trf_in=0;
	$trf_out=intVal($this->Transfer_Model->getTransferdQtyByWarehouseId_mw($srh_warehouse_id,$product_id,$srh_from_date,$srh_to_date,''));
//	echo $this->db->last_query();
	//$warehouse_id,$product_id,$srh_from_date='',$srh_to_date='',$search_key_val='',$cat_srh='',$trnsfr_to_warehouse_id=''
	$trf_in=intVal($this->Transfer_Model->getTransferdQtyByWarehouseId_mw('',$product_id,$srh_from_date,$srh_to_date,'','',$srh_warehouse_id));
	
	
	$in_sb=0;
	$out_sb=0;
	$sold_sb=0;
	$balance_sb=0;
	$transer_in_dis='';
	$transer_out_dis='';
	$purchased_qty_des='';
	
	$in_sb=$purchased_qty+$trf_in;
	$out_sb=$trf_out+$purchased_rtn_qty;
	$sold_sb=$sold_qty;
	//$balance_sb=$in_sb-$out_sb-$sold_sb;
	//$sn_list=$this->Purchases_Model->get_serial_no_by_avalable_warehosue_id($product_id,$srh_warehouse_id);
	//$balance_sb=count($sn_list);
	$balance_sb=0;
	
	//$balance_sb=0
	
	$transer_in_dis_ar=$this->Transfer_Model->getTransferdQtyByWarehouseIdStockBook($srh_warehouse_id,$product_id,$srh_from_date,$srh_to_date);
	foreach ($transer_in_dis_ar as $row_tr){
		$transer_in_dis.="<span class=\"text_tra\">&nbsp;".(int)$row_tr->trnsfr_itm_quantity."&nbsp;</span>"." <span class=\"text_top\"> $row_tr->code </span>  ";
	}
	
	$transer_out_dis_ar=$this->Transfer_Model->getTransferdQtyByWarehouseIdStockBookOut($srh_warehouse_id,$product_id,$srh_from_date,$srh_to_date);
	foreach ($transer_out_dis_ar as $row_tr){
		$transer_out_dis.="<span class=\"text_tra\">&nbsp;".(int)$row_tr->trnsfr_itm_quantity."&nbsp;</span>"." <span class=\"text_top\"> $row_tr->code </span>  ";
	}
	
	
	//print_r($transer_in_out_dis_ar);
	
	
	if(!$purchased_qty) $purchased_qty_des='';
	else $purchased_qty_des=$purchased_qty."<span class=\"text_top\"> G </span>";
	
	
	
	
	//get balance qty
	$balance_sb=0;
	$grn_sb=0;
	$tr_in_sb=0;
	$tr_out_sb=0;
	$sale_2_sb=0;
	$sold_sb_des='';
	
	$grn_sb=$this->Purchases_Model->getPurchasedQtyByWarehouseIdAndDateRange_mw($srh_warehouse_id,$product_id,$srh_from_date,$srh_to_date);
	$tr_in_sb=intVal($this->Transfer_Model->getTransferdQtyByWarehouseId_mw('',$product_id,$srh_from_date,$srh_to_date,'','',$srh_warehouse_id));
	
	//echo $this->db->last_query();
	
	$tr_out_sb=intVal($this->Transfer_Model->getTransferdQtyByWarehouseId_mw($srh_warehouse_id,$product_id,$srh_from_date,$srh_to_date,''));
	
	$grn_rtn=0;
	$grn_rtn_des='';
	//$grn_rtn_des
	$grn_rtn=intVal($this->Custom_Model->getReturnQtyByWarehouseId($srh_warehouse_id, $product_id, $srh_from_date, $srh_to_date));
	if($grn_rtn){
	$grn_rtn_des=$grn_rtn."<span class=\"text_top\"> GR </span>";
	}
	
	//echo " , tr_out_sb:$tr_out_sb";
	//echo $this->db->last_query();
	
	$sale_2_sb=intVal($this->Report_Model->get_location_sale_by_location_id_and_date_mw(0,$product_id,$srh_from_date,$srh_to_date,'',$srh_warehouse_id));
	
	//echo " , sale_2_sb:$sale_2_sb";
	
//	echo $this->db->last_query();
	
	/* start get balance */
	$balance_last_qty=0;
	$balance_last_qty=intVal($this->item_balance_warehoue_id($srh_warehouse_id, $product_id, $srh_from_date, $srh_to_date));
	
	/* end get balance */
	

	
	//$balance_sb=$grn_sb+$tr_in_sb-$tr_out_sb-$sold_sb;
	//echo "grn_rtn:$grn_rtn";
	$tot_in=$tot_in+$grn_sb+$tr_in_sb;
	$tot_out=$tot_out+$tr_out_sb+$grn_rtn;
	
	if(!$sale_2_sb) $sold_sb_des=''; else  $sold_sb_des=$sale_2_sb; 
	
	$row[]=$purchased_qty_des .$transer_in_dis;
	$row[]=$transer_out_dis." ".$grn_rtn_des;
	$tot_sale=$tot_sale+$sold_sb_des;
	$row[]=$sold_sb_des;
	
	
	// get serial no
	$serial_des='';
	if($with_emi_no){
	$sn_list_by_avalable_warehosue = $this->Purchases_Model->get_serial_no_by_avalable_warehosue_id_sb($product_id,$srh_warehouse_id);
	$tra_pending_sn_list_by_avalable_warehosue = $this->Purchases_Model->get_tra_pending_serial_no_by_avalable_warehosue_id_sb($product_id,$srh_warehouse_id);
	$k=0;
	foreach ($sn_list_by_avalable_warehosue as $row_1){ 
		$k++;
		$serial_des.= "<br/> ($k).".$row_1->pis_number.' - '.$row_1->code;
	}
	
	foreach ($tra_pending_sn_list_by_avalable_warehosue as $row_1){ 
						$k++;
						$serial_des.= "<br/> ($k).".$row_1->pis_number."( TP)".' - '.$row_1->code;
					}
					
	}
	// end get serial no
	
	$row[]=$balance_last_qty.$serial_des;
	
$tot_balance=$tot_balance+$balance_last_qty;
	
	/* end list */
	
				 
					
					// $row[] =$tot_item_qty;
					 
               
//if($purchased_qty_des!='' || $transer_out_dis!='' || $sold_sb_des!='' || $balance_sb!=0){
	$display=0;
	
	if($show_all){
		$display=1;
	}
	if($purchased_qty_des!='' || $transer_out_dis!='' || $sold_sb_des!='' || $balance_last_qty!=0){
	
	
				$display=1;
}




				if($display){
                $data[] = $row;
				}
				
				
				if($totalData==$x){
					//$display=1;
				//	$tot_balance=$tot_in-$tot_out-$tot_sale;
					$row_f[]='';
					$row_f[]="<div class=\"footer_bottom\">$tot_in</div>";
					$row_f[]="<div class=\"footer_bottom\">$tot_out</div>";
					$row_f[]="<div class=\"footer_bottom\">$tot_sale</div>";
					$row_f[]="<div class=\"footer_bottom\">$tot_balance</div>";
					 $data[] = $row_f;
				}

				 
            }
            /**/


           

            /**/
            $output = array(
               
                "recordsTotal" => intval($totalData),
                "recordsFiltered" => intval($totalFiltered),
                'data' => $data);
            echo json_encode($output);
        } else {
            $output = array(
                "recordsTotal" => '',
                "recordsFiltered" => '',
                'data' => '');
            echo json_encode($output);
        }
    }
		
	
		
    public function get_list_product_for_item_avalable($value = '') {
        $srh_warehouse_id = $this->input->post('srh_warehouse_id');
        $cat_srh = $this->input->post('cat_srh');
		$with_emi_no = $this->input->post('with_emi_no');
		$subcategory = $this->input->post('subcategory');
		$product_id = $this->input->post('product_id');
		$show_all = $this->input->post('show_all');
		$product_name = $this->input->post('product_name');
		$warehouse_list=$this->Warehouse_Model->get_all_warehouse();
		
		//print_r($srh_warehouse_id);
		
		

        $srh_from_date = '';
        $srh_to_date = '';
        if ($this->input->post('srh_to_date')) {
            $srh_to_date = date('Y-m-d', strtotime($this->input->post('srh_to_date')));
        }
        if ($this->input->post('srh_from_date')) {
            $srh_from_date = date('Y-m-d', strtotime($this->input->post('srh_from_date')));
        }

        /*         * ****************** */
        $search_key = $this->input->post('search');
        $search_key_val = $search_key['value'];
        $start = $this->input->post('start');
        $length = $this->input->post('length');

        $this->load->model('Product_Models');
        $values = '';
        $totalFiltered = 0;

//	$sales = $this->Sales_Model->get_all_sales($start,$length,$search_key_val);
//	$sales_count = $this->Sales_Model->get_all_sales('','','');

        $totalData = 0;
//	echo $length."//";
        //$getSumProductsForReport = $this->Product_Models->getSumProductsForReport($srh_warehouse_id,$cat_srh);

        if ($search_key_val) {
            $values = $this->Product_Models->getProductsForReport($srh_warehouse_id, $cat_srh, $start, $length, $search_key_val,'',$subcategory,$product_id,$product_name);
            //$values_c = $this->Product_Models->getProductsForReport_c($srh_warehouse_id, $cat_srh, '', '', $search_key_val);
            $totalData = $this->Product_Models->getProductsForReport($srh_warehouse_id, $cat_srh, $start, $length, $search_key_val,1,$subcategory,$product_id,$product_name);
        } else {
            $values = $this->Product_Models->getProductsForReport($srh_warehouse_id, $cat_srh, $start, $length, '','',$subcategory,$product_id,$product_name);
           // $values_c = $this->Product_Models->getProductsForReport_c($srh_warehouse_id, $cat_srh, $start, '', '');
            //print_r($values_c[0]->count);
             $totalData = $this->Product_Models->getProductsForReport($srh_warehouse_id, $cat_srh, '', '', '',1,$subcategory,$product_id,$product_name);
        }

        $totalFiltered = $totalData;
        /*         * ****************** */

        $costPriceTot = 0; //$this->Purchases_Model->getPurchasedQtyByWarehouseId('','',$srh_from_date,$srh_to_date);

        $data = array();

        if (!empty($values)) {
            foreach ($values as $products) {

                if ($products->product_status == 0) {
                    $k = "btn-warning";
                    $m = "fa-minus-circle";
                } else {
                    $k = "btn-green";
                    $m = "fa-check";
                }
                $retVal = (empty($products->sub_cat_name)) ? "--:--" : $products->sub_cat_name;

                $row = array();

                //get transferd qty
               
				
				
				$display=0;
				
				if($show_all){
					$display=1;	// show all items with 0 stcok
				}
				
              
			   
                $row[] = $products->product_code;
                $row[] = $products->product_name;
$srh_from_date='';
$srh_to_date='';
$item_qty=0;
$tot_item_qty=0;
				//foreach ($warehouse_list as $row_itm){
					for($k=0; $k<count($srh_warehouse_id); $k++){
						$w_id=$srh_warehouse_id[$k];
				
				 $item_qty=0;
				  $item_qty=$this->item_balance_warehoue_id($w_id, $products->product_id, $srh_from_date, $srh_to_date);
				   $row[] =$item_qty;
				   $tot_item_qty=$tot_item_qty+$item_qty;
				
				}
				 
				 
					
					 $row[] =$tot_item_qty;
					 
               
if($tot_item_qty){
	
	
				$display=1;
}
				if($display){
                $data[] = $row;
				}
				 
            }
            /**/


           

            /**/
            $output = array(
               
                "recordsTotal" => intval($totalData),
                "recordsFiltered" => intval($totalFiltered),
                'data' => $data);
            echo json_encode($output);
        } else {
            $output = array(
                "recordsTotal" => '',
                "recordsFiltered" => '',
                'data' => '');
            echo json_encode($output);
        }
    }
	
	/* pay role start */
	 public function pay_sheet_reports() {
        $data['main_menu_name'] = 'pay_role';
        $data['sub_menu_name'] = 'paysheet';
		 $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$data['user_group_list'] = $this->User_Group_Model->get_all_user_group();
		$data['user_list']=$this->User_Model->getUsers(1);
        $this->load->view('rep_paysheet', $data);
    }
	
	 public function salary_finalize() {
        $data['main_menu_name'] = 'pay_role';
        $data['sub_menu_name'] = 'salary_finalize';
		 $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$data['user_group_list'] = $this->User_Group_Model->get_all_user_group();
		$data['user_list']=$this->User_Model->getUsers(1);
        $this->load->view('salary_finalize', $data);
    }
	
	
	
	public function get_list_user($value = '') {
		$search_key = $this->input->post('search');
        $search_key_val = $search_key['value'];
        $start = $this->input->post('start');
        $length = $this->input->post('length');
        $warehouse_id = $this->input->post('warehouse_id');
        $srh_user_id = $this->input->post('srh_user_id');
		 $group_id = $this->input->post('group_id');
        $srh_from_date = $this->input->post('srh_from_date');
        $srh_to_date = $this->input->post('srh_to_date');
		
        $values = $this->Salary_Model->getUsersEmpSummary($start, $length, $search_key_val, $srh_user_id,'',$group_id);
		$list_count = $this->Salary_Model->getUsersEmpSummary('', '', $search_key_val,$srh_user_id,'num_rows',$group_id);

        $totalData = $list_count;
        $totalFiltered = $totalData;
		
        $data = array();

        if (!empty($values)) {
            foreach ($values as $users) {

                $row = array();
                $user_id = $users->user_id;
				$addtion=0;
				$deduction=0;
				$balance=0;
				$paid_amount=0;
				$basic_salary=0;
				$basic_allowance=0;
				$gross_salary=0;
				
				
				$basic_salary=$this->Salary_Model->get_salary_by_type_id($user_id,$srh_from_date,$srh_to_date,17);
				$basic_allowance=$this->Salary_Model->get_salary_by_type_id($user_id,$srh_from_date,$srh_to_date,18);
				$gross_salary=$basic_salary+$basic_allowance;
				$addtion_tot=$this->Salary_Model->get_salary_addtion($user_id,$srh_from_date,$srh_to_date,1);
				$deduction=$this->Salary_Model->get_salary_addtion($user_id,$srh_from_date,$srh_to_date,0);
				$paid_amount=$this->Salary_Model->get_salary_paid_amount($user_id,$srh_from_date,$srh_to_date);
				
				$addtion=$addtion_tot-$gross_salary;
				$balance=$addtion-$deduction-$paid_amount;
				$balance=$addtion+$gross_salary-$deduction-$paid_amount;
				
                $row[] = $users->user_first_name;//.' '.$users->user_last_name;
                $row[] = $users->user_emp_no;
                $group_name_des=$users->user_group_name;
                if($group_name_des=='Cash Collector'){
                    $group_name_des='Cash';
                }
                if($group_name_des=='Sales Rep'){
                    $group_name_des='Rep';
                }
                 if($group_name_des=='Sales Staff'){
                    $group_name_des='Staff';
                }
				 if($group_name_des=='Super Administrator'){
                    $group_name_des='Admin';
                }
                
				 $row[] = $group_name_des;
				  $row[] = number_format($basic_salary, 2, '.', ',');
				  $row[] = number_format($basic_allowance, 2, '.', ',');
				   $row[] = number_format($gross_salary, 2, '.', ',');
                $row[] = number_format($addtion, 2, '.', ',');
				$row[] = number_format($deduction, 2, '.', ',');
				//$row[] ='';
				$row[] = number_format($paid_amount, 2, '.', ',');
				$row[] = number_format($balance, 2, '.', ',');
               
                


                $row_action = '<div class="btn-group text-left">
                            <button data-toggle="dropdown" class="btn btn-default btn-xs btn-primary dropdown-toggle" type="button">Actions <span class="caret"></span></button>
                            <ul role="menu" class="dropdown-menu pull-right">';





                $row_action .= '                           
                                                             <li><a onClick="print_pay_sheet_sel_user(' . $user_id . ')" data-toggle="modal" href="#" data-placement="top" data-original-title="Print Pay Sheet"><i class="fa fa-print"></i> Print Pay Sheet</a></li>
								<li class="divider"></li>
							
                            </ul></div>';

                $row[] = $row_action;

                //$row[]=$actionTxtUpdate.$actionTxtDisble.$actionTxtEnable.$actionTxtPw.$actionTxtDelete;

                $data[] = $row;
            }


           $json_data = array(
            //"draw"            => intval( $requestData['draw'] ),  
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data" => $data
        );

        echo json_encode($json_data);
        } else {
            $output = array('data' => '');
            echo json_encode($output);
        }
    }
	
public function paysheet_print() {

        $this->load->model('Salary_model');

        $user_id = $this->input->get('user_id');
		 $srh_from_date = $this->input->get('srh_from_date');
		 $srh_to_date = $this->input->get('srh_to_date');

        if (null != $this->session->userdata('ss_warehouse_id')) {
            $data['warehouse_details'] = $this->Warehouse_Model->get_warehouse_info($this->session->userdata('ss_warehouse_id'));
        }
        $data['salary_details'] = $this->Salary_model->get_salary_details_by_user_2($user_id,$srh_from_date,$srh_to_date);
		//echo $this->db->last_query();
		$data['salary_payment_details'] = $this->Salary_model->get_salary_payment_details_by_user_id($user_id,$srh_from_date,$srh_to_date);

        $data['user_details'] = $this->User_Model->get_print_user($user_id);
		
		//echo "Test:";

        $this->load->view('models/view_paysheet', $data);
    }	
	
		
	/* end pay role start */
	
	
	    function get_supplier_data_for_report_del()
    {
        $data             = array();
        $data_array       = array();
        $srh_to_date      = '';
        $srh_from_date    = '';
        $srh_warehouse_id = $this->input->post('srh_warehouse_id');
        $srh_type         = '';
        $srh_payment_term = '';
        $ss_user_id       = $this->input->post('ss_user_id');
        $supplier_id       = $this->input->post('supplier_id');
        
        if ($this->input->post('srh_to_date')) {
            $srh_to_date = date('Y-m-d', strtotime($this->input->post('srh_to_date')));
        }
        if ($this->input->post('srh_from_date')) {
            $srh_from_date = date('Y-m-d', strtotime($this->input->post('srh_from_date')));
        }
        
        
        /* start multiple payment */
        $grn_payments              = $this->Sales_Model->getGrnMultiPayments($srh_warehouse_id, $srh_to_date, $srh_from_date, "grn", $srh_payment_term, $supplier_id , $ss_user_id);
        
       // print_r($grn_payments);
        
        if (!empty($grn_payments)) {
            foreach ($grn_payments as $users) {
                $row       = array();
                $row['datetime']     =  date("Y-m-d", strtotime($users->smp_date))." 20:00:00"; // date
                $row['what']     = "Purchase Mult. Payment";
                $row['ref']     = $users->smp_no;
                $row['pymnt_ref']     = $users->smp_no;
                $row['p_amt']     = "";
                $row['r_amt']     = "";
                $row['paid']     = $users->smp_amount;
                $row['rtnd']     = "";
                $row['sup_adj']        = "";
                $row['sup_adj_pay']        = "";
                $row['balance']     = "";

                $data_array[]    = $row;
            }
        }
        
        /* end multi ple payment */

        $grn_payments              = $this->Sales_Model->getGrnPayments($srh_warehouse_id, $srh_to_date, $srh_from_date, "grn", $srh_payment_term, $supplier_id , $ss_user_id);
        
       // print_r($grn_payments);
        
        if (!empty($grn_payments)) {
            foreach ($grn_payments as $users) {
                $row       = array();
                $row['datetime']     =  date("Y-m-d", strtotime($users->sale_pymnt_added_date_time))." 20:00:00"; // date
                $row['what']     = "Purchase Payment";
                $row['ref']     = $users->reference_no;
                $row['pymnt_ref']     = $users->sale_pymnt_ref_no;
                $row['p_amt']     = "";
                $row['r_amt']     = "";
                $row['paid']     = $users->sale_pymnt_amount;
                $row['rtnd']     = "";
                $row['sup_adj']        = "";
                $row['sup_adj_pay']        = "";
                $row['balance']     = "";

                //$data_array[]    = $row;
            }
        }
        
        /* start ajesment paymet */
        
        $grn_payments              = $this->Sales_Model->getStockAdjPayments($srh_warehouse_id, $srh_to_date, $srh_from_date, "supplier_payment_adjustment", $srh_payment_term, $supplier_id , $ss_user_id);
        
       // print_r($grn_payments);
        
        if (!empty($grn_payments)) {
            foreach ($grn_payments as $users) {
                $row       = array();
                
                 $deduct_amount=0;
                $addtion_amount=0;
                 $spa_debit_credit=$users->spa_debit_credit;
                 if($spa_debit_credit==1) {
                    $dis_amount=$users->spa_amount*-1;
                    $tpe=" - Deduction ";
                }
                else  {
                    $dis_amount=$users->spa_amount;
                     $tpe=" - Addition";
                }
                
                //$dis_amount=$users->spa_amount;
                
                
                $row['datetime']     =  date("Y-m-d", strtotime($users->sale_pymnt_added_date_time))." 20:00:00"; // date
                $row['what']     = "Payment Adjustment Payment $tpe";
                $row['ref']     = $users->spa_id;
                $row['pymnt_ref']     = $users->sale_pymnt_ref_no;
                $row['p_amt']     = '';
                $row['r_amt']     = "";
                $amt=0;
                //$amt=$users->sale_pymnt_amount;
               // if($amt<0) $amt=$amt*-1;
                $row['paid']     = '';
                $row['rtnd']     = "";
                $row['sup_adj']        = "";
                $row['sup_adj_pay']        = $dis_amount;
                $row['balance']     = "";

               // $data_array[]    = $row;
            }
        }
        
        /* end ajesment paymet */
        
        /* start ajesment */
        
        $grn_payments              = $this->Sales_Model->getSupPayAdj($srh_warehouse_id, $srh_to_date, $srh_from_date, "grn", $srh_payment_term, $supplier_id , $ss_user_id);
        
      
        
        if (!empty($grn_payments)) {
            foreach ($grn_payments as $users) {
                $row       = array();
                $row['datetime']     =  date("Y-m-d", strtotime($users->spa_added_datetime)); 
                $tpe='';
                 $spa_amount=0;
                $deduct_amount=0;
                $addtion_amount=0;
                 $spa_debit_credit=$users->spa_debit_credit;
                 if($spa_debit_credit==1) {
                   $sup_adj=$users->spa_amount*-1;
                    $tpe=" - Deduction ";
                }
                else  {
                   $sup_adj=$users->spa_amount;
                     $tpe=" - Addition";
                }
                
                
                
                
                $row['what']     = "Payment Adjustment $tpe";
                $row['ref']     = $users->spa_id;
                $row['pymnt_ref']     = '';
                
                $row['r_amt']     = "";
                
               
               
               
                $spa_amount=$users->spa_amount;//500;//$spa_debit_credit;
                
                $row['p_amt']     = '';
                
                $row['paid']     = '';//."$spa_debit_credit";
                $row['rtnd']     = "";
                $row['sup_adj']        = $sup_adj;
                $row['sup_adj_pay']        = "";
                $row['balance']     = "";

                $data_array[]    = $row;
            }
        }
        
        /* end ajesment */
        
         //echo "supplier_id:$supplier_id";

        $grn_return_payments              = $this->Sales_Model->getGrnReturnPayments($srh_warehouse_id, $srh_to_date, $srh_from_date, "grn_return", $srh_payment_term, $supplier_id , $ss_user_id);
        
        if (!empty($grn_return_payments)) {
            foreach ($grn_return_payments as $users) {
                $row       = array();
                $row['datetime']     = $users->sale_pymnt_added_date_time; // date
                $row['what']     = "Purchase Return Payment";
                $row['ref']     = $users->pur_rtn_reference_no;
                $row['pymnt_ref']     = $users->sale_pymnt_ref_no;
                $row['p_amt']     = "";
                $row['r_amt']     = "";
                $row['sup_adj']        = "";
                $row['sup_adj_pay']        = "";
                $row['paid']     = "";
                
                $row['rtnd']     = $users->sale_pymnt_amount*-1;
                $row['balance']     = "";
              //  $data_array[]    = $row;
            }
        }
        
        
        $purchases = $this->Purchases_Model->get_all_grn_for_report($srh_warehouse_id, $srh_to_date, $srh_from_date, '', '', $supplier_id);
        if (!empty($purchases)) {
            foreach ($purchases as $users) {
                $row       = array();
                
                

                $row['datetime']     = $users['date']; // date
                $row['what']     =  "Purchase";
                $row['ref']     = $users['reference_no'];
                $row['pymnt_ref']     = "";
                $row['p_amt']     = $users['grand_total'];
                $row['r_amt']     = "";
                $row['paid']     = "";
                $row['rtnd']     = "";
                $row['sup_adj']        = "";
                $row['sup_adj_pay']        = "";
                $row['balance']     = "";

                $data_array[]    = $row;
            }
        }

        $purchases_return = $this->Purchase_Return_Model->get_all_purchase_return_for_report_sup($srh_warehouse_id, $srh_to_date, $srh_from_date, "", "", $supplier_id);
        if (!empty($purchases_return)) {
            foreach ($purchases_return as $users) {
                $row       = array();
                $row['datetime']    = $users['pur_rtn_datetime']; // date
                $row['what']        =  "Purchase Return";
                $row['ref']         = $users['pur_rtn_reference_no'];
                $row['pymnt_ref']   = "";
                $row['p_amt']       = "";
                $row['r_amt']       = $users['pur_rtn_inv_total'];
                $row['paid']        = "";
                $row['rtnd']        = "";
                $row['sup_adj']        = "";
                $row['sup_adj_pay']        = "";
                $row['balance']     = "";
                $data_array[]       = $row;
            }
        }

        // Comparison function 
        function date_compare($element1, $element2) { 
            $datetime1 = strtotime($element1['datetime']); 
            $datetime2 = strtotime($element2['datetime']); 
            return $datetime1 - $datetime2; 
        }  
        
        usort($data_array, 'date_compare');

        $balance = 0;

        if (!empty($data_array)) {
            foreach ($data_array as $users) {
                
                $p_amt = ($users['p_amt'] > 0)? $users['p_amt']: 0;
                $r_amt = ($users['r_amt'] > 0)? $users['r_amt']: 0;
                $paid = ($users['paid'] > 0)? $users['paid']: 0;
                $rtnd = ($users['rtnd'] > 0)? $users['rtnd']: 0;
                $sup_adj_pay= ($users['sup_adj_pay'] != 0)? $users['sup_adj_pay']: 0;
                $sup_adj= ($users['sup_adj'] != 0)? $users['sup_adj']: 0;
                $balance += $p_amt - $r_amt - $paid - $rtnd+$sup_adj;

                $row    = array();
                $row[]      = $users['datetime']; // date
                $row[]      = $users['what']; // date
                $row[]      = $users['ref']; // date
                $row[]      = $users['pymnt_ref']; // date
                $row[]      = number_format($p_amt, 2, '.', ','); // date
                $row[]      = number_format($r_amt, 2, '.', ',');
                $row[]      = number_format($paid, 2, '.', ','); // date
                $row[]      = number_format($rtnd, 2, '.', ','); // date
                $row[]      = number_format($sup_adj, 2, '.', ',');
                $row[]      = number_format($sup_adj_pay, 2, '.', ',');
                $row[]      = number_format($balance, 2, '.', ','); // date
                $data[]     = $row;
            }
        }

        if(!empty($data)){
            $output = array(
                'data' => $data
            );
            echo json_encode($output);
        } else {
            $output = array(
                'data' => ''
            );
            echo json_encode($output);
        }
    }
    
    	
	    function get_supplier_data_for_report()
    {
        $data             = array();
        $data_array       = array();
        $srh_to_date      = '';
        $srh_from_date    = '';
        $srh_warehouse_id = $this->input->post('srh_warehouse_id');
        $srh_type         = '';
        $srh_payment_term = '';
        $ss_user_id       = $this->input->post('ss_user_id');
        $supplier_id       = $this->input->post('supplier_id');
        $sup_des=$this->Supplier_Model->get_supplier_info($supplier_id);
        $customer_id=$sup_des['customer_id'];
        //print_r($sup_des);
        
        if ($this->input->post('srh_to_date')) {
            $srh_to_date = date('Y-m-d', strtotime($this->input->post('srh_to_date')));
        }
        if ($this->input->post('srh_from_date')) {
            $srh_from_date = date('Y-m-d', strtotime($this->input->post('srh_from_date')));
        }
        
        
        /* start multiple payment */
        $grn_payments              = $this->Sales_Model->getGrnMultiPayments($srh_warehouse_id, $srh_to_date, $srh_from_date, "grn", $srh_payment_term, $supplier_id , $ss_user_id);
        
       // print_r($grn_payments);
        
        if (!empty($grn_payments)) {
            foreach ($grn_payments as $users) {
                $row       = array();
                $row['datetime']     =  date("Y-m-d", strtotime($users->smp_added_date))." 23:00:00"; // date
                $row['what']     = "Purchase Mult. Payment";
                $row['ref']     = $users->smp_no;
                $row['pymnt_ref']     = $users->sale_pymnt_paying_by;
                $row['p_amt']     = "";
                $row['r_amt']     = "";
                $row['paid']     = $users->smp_amount;
                $row['rtnd']     = "";
                $row['sup_adj']        = "";
                $row['sup_adj_pay']        = "";
                 $row['adi']        = "";
                  $row['did']        = "";
                $row['balance']     = "";

                $data_array[]    = $row;
            }
        }
        
        /* end multi ple payment */

        $grn_payments              = $this->Sales_Model->getGrnPayments($srh_warehouse_id, $srh_to_date, $srh_from_date, "grn", $srh_payment_term, $supplier_id , $ss_user_id);
        
       // print_r($grn_payments);
        
        if (!empty($grn_payments)) {
            foreach ($grn_payments as $users) {
                $row       = array();
                $row['datetime']     =  date("Y-m-d", strtotime($users->sale_pymnt_added_date_time))." 20:00:00"; // date
                $row['what']     = "Purchase Payment";
                $row['ref']     = $users->reference_no;
                $row['pymnt_ref']     = $users->sale_pymnt_ref_no;
                $row['p_amt']     = "";
                $row['r_amt']     = "";
                $row['paid']     = $users->sale_pymnt_amount;
                $row['rtnd']     = "";
                $row['sup_adj']        = "";
                $row['sup_adj_pay']        = "";
                  $row['adi']        = "";
                  $row['did']        = "";
                $row['balance']     = "";

                //$data_array[]    = $row;
            }
        }
        
        /* start ajesment paymet */
        
        $grn_payments              = $this->Sales_Model->getStockAdjPayments($srh_warehouse_id, $srh_to_date, $srh_from_date, "supplier_payment_adjustment", $srh_payment_term, $supplier_id , $ss_user_id);
        
       // print_r($grn_payments);
        
        if (!empty($grn_payments)) {
            foreach ($grn_payments as $users) {
                $row       = array();
                
                 $deduct_amount=0;
                $addtion_amount=0;
                 $spa_debit_credit=$users->spa_debit_credit;
                 if($spa_debit_credit==1) {
                    $dis_amount=$users->spa_amount*-1;
                    $tpe=" - Deduction ";
                }
                else  {
                    $dis_amount=$users->spa_amount;
                     $tpe=" - Addition";
                }
                
                //$dis_amount=$users->spa_amount;
                
                
                $row['datetime']     =  date("Y-m-d", strtotime($users->sale_pymnt_added_date_time))." 20:00:00"; // date
                $row['what']     = "Payment Adjustment Payment $tpe";
                $row['ref']     = $users->spa_id;
                $row['pymnt_ref']     = $users->sale_pymnt_ref_no;
                $row['p_amt']     = '';
                $row['r_amt']     = "";
                $amt=0;
                //$amt=$users->sale_pymnt_amount;
               // if($amt<0) $amt=$amt*-1;
                $row['paid']     = '';
                $row['rtnd']     = "";
                $row['sup_adj']        = "";
                $row['sup_adj_pay']        = $dis_amount;
                  $row['adi']        = "";
                  $row['did']        = "";
                $row['balance']     = "";

               // $data_array[]    = $row;
            }
        }
        
        /* end ajesment paymet */
        
        /* start ajesment */
        
        $grn_payments              = $this->Sales_Model->getSupPayAdj($srh_warehouse_id, $srh_to_date, $srh_from_date, "grn", $srh_payment_term, $supplier_id , $ss_user_id);
        
      
        
        if (!empty($grn_payments)) {
            foreach ($grn_payments as $users) {
                $row       = array();
                $row['datetime']     =  date("Y-m-d", strtotime($users->spa_added_datetime)); 
                $tpe='';
                 $spa_amount=0;
                $deduct_amount=0;
                $addtion_amount=0;
                 $spa_debit_credit=$users->spa_debit_credit;
                 if($spa_debit_credit==1) {
                   $sup_adj=$users->spa_amount*-1;
                    $tpe=" - Deduction ";
                }
                else  {
                   $sup_adj=$users->spa_amount;
                     $tpe=" - Addition";
                }
                
                
                
                
                $row['what']     = "Payment Adjustment $tpe";
                $row['ref']     = $users->spa_id;
                $row['pymnt_ref']     = '';
                
                $row['r_amt']     = "";
                
               
               
               
                $spa_amount=$users->spa_amount;//500;//$spa_debit_credit;
                
                $row['p_amt']     = '';
                
                $row['paid']     = '';//."$spa_debit_credit";
                $row['rtnd']     = "";
                $row['sup_adj']        = $sup_adj;
                $row['sup_adj_pay']        = "";
                  $row['adi']        = "";
                  $row['did']        = "";
                $row['balance']     = "";

                $data_array[]    = $row;
            }
        }
        
        /* end ajesment */
        
         //echo "supplier_id:$supplier_id";

        $grn_return_payments              = $this->Sales_Model->getGrnReturnPayments($srh_warehouse_id, $srh_to_date, $srh_from_date, "grn_return", $srh_payment_term, $supplier_id , $ss_user_id);
        
        if (!empty($grn_return_payments)) {
            foreach ($grn_return_payments as $users) {
                $row       = array();
                $row['datetime']     = $users->sale_pymnt_added_date_time; // date
                $row['what']     = "Purchase Return Payment";
                $row['ref']     = $users->pur_rtn_reference_no;
                $row['pymnt_ref']     = $users->sale_pymnt_ref_no;
                $row['p_amt']     = "";
                $row['r_amt']     = "";
                $row['sup_adj']        = "";
                $row['sup_adj_pay']        = "";
                $row['paid']     = "";
                
                $row['rtnd']     = $users->sale_pymnt_amount*-1;
                  $row['adi']        = "";
                  $row['did']        = "";
                $row['balance']     = "";
              //  $data_array[]    = $row;
            }
        }
        
        
        $purchases = $this->Purchases_Model->get_all_grn_for_report_v2($srh_warehouse_id, $srh_to_date, $srh_from_date, '', '', $supplier_id);
        if (!empty($purchases)) {
            foreach ($purchases as $users) {
                $row       = array();
                
                

                $row['datetime']     = $users['date']; // date
                $row['what']     =  "Purchase";
                $row['ref']     = $users['reference_no'];
                $row['pymnt_ref']     = "";
                $row['p_amt']     = $users['grand_total'];
                $row['r_amt']     = "";
                $row['paid']     = "";
                $row['rtnd']     = "";
                $row['sup_adj']        = "";
                $row['sup_adj_pay']        = "";
                  $row['adi']        = "";
                  $row['did']        = "";
                $row['balance']     = "";

                $data_array[]    = $row;
            }
        }
        
        
        //invocie
        if($customer_id){
        $invoice_des = $this->Purchases_Model->get_all_sales_list_for_sup_rep($srh_warehouse_id, $srh_to_date, $srh_from_date, '', '', $customer_id);
        if (!empty($invoice_des)) {
            foreach ($invoice_des as $users) {
                $row       = array();
                
                

                $row['datetime']     = $users['sale_datetime']; // date
                $row['what']     =  "Invoice";
                $row['ref']     = $users['sale_reference_no'];
                $row['pymnt_ref']     = "";
                $row['p_amt']     = "";
                $row['r_amt']     = "";
                $row['paid']     = "";
                $row['rtnd']     = "";
                $row['sup_adj']        = "";
                $row['sup_adj_pay']        = "";
                  $row['adi']        = "";
                  $row['did']        = $users['sale_total'];
                $row['balance']     = "";

                $data_array[]    = $row;
            }
        }
        } // end invocie 
        
        
        //invocie Payment
        if($customer_id){
        $invoice_des = $this->Purchases_Model->get_all_sales_payent_list_for_sup_rep($srh_warehouse_id, $srh_to_date, $srh_from_date, '', '', $customer_id);
        if (!empty($invoice_des)) {
            foreach ($invoice_des as $users) {
                $row       = array();
                
                

                $row['datetime']     = $users['sale_pymnt_added_date_time']; // date
                $row['what']     =  "Invoice Payment";
                $row['ref']     = $users['sale_pymnt_id'];
                $row['pymnt_ref']     = "";
                $row['p_amt']     = "";
                $row['r_amt']     = "";
                $row['paid']     = "";
                $row['rtnd']     = "";
                $row['sup_adj']        = "";
                $row['sup_adj_pay']        = "";
                  $row['adi']        = $users['sale_pymnt_amount'];
                  $row['did']        = "";
                $row['balance']     = "";

                $data_array[]    = $row;
            }
        }
        } // end invocie  Payment

        $purchases_return = $this->Purchase_Return_Model->get_all_purchase_return_for_report_sup($srh_warehouse_id, $srh_to_date, $srh_from_date, "", "", $supplier_id);
        if (!empty($purchases_return)) {
            foreach ($purchases_return as $users) {
                $row       = array();
                $row['datetime']    = $users['pur_rtn_datetime']; // date
                $row['what']        =  "Purchase Return";
                $row['ref']         = $users['pur_rtn_reference_no'];
                $row['pymnt_ref']   = "";
                $row['p_amt']       = "";
                $row['r_amt']       = $users['pur_rtn_inv_total'];
                $row['paid']        = "";
                $row['rtnd']        = "";
                $row['sup_adj']        = "";
                $row['sup_adj_pay']        = "";
                  $row['adi']        = "";
                  $row['did']        = "";
                $row['balance']     = "";
                $data_array[]       = $row;
            }
        }

        // Comparison function 
        function date_compare($element1, $element2) { 
            $datetime1 = strtotime($element1['datetime']); 
            $datetime2 = strtotime($element2['datetime']); 
            return $datetime1 - $datetime2; 
        }  
        
        usort($data_array, 'date_compare');

        $balance = 0;

        if (!empty($data_array)) {
            foreach ($data_array as $users) {
                
                $p_amt = ($users['p_amt'] > 0)? $users['p_amt']: 0;
                $r_amt = ($users['r_amt'] > 0)? $users['r_amt']: 0;
                $paid = ($users['paid'] > 0)? $users['paid']: 0;
                $rtnd = ($users['rtnd'] > 0)? $users['rtnd']: 0;
                $sup_adj_pay= ($users['sup_adj_pay'] != 0)? $users['sup_adj_pay']: 0;
                $sup_adj= ($users['sup_adj'] != 0)? $users['sup_adj']: 0;
                
                $adi=($users['adi'] != 0)? $users['adi']: 0;
                $did=($users['did'] != 0)? $users['did']: 0;
                //$balance += $p_amt - $r_amt - $paid - $rtnd+$sup_adj+$adi-$did;
                $r_amt=0; //test
                
                $balance += $p_amt - $r_amt - $paid - $rtnd+$adi-$did;
                
                /*
                  $row['adi']        = "";
                  $row['did']        = "";
                  */
                  
                  

                $row    = array();
                $row[]      = $users['datetime']; // date
                $row[]      = $users['what']; // date
                $row[]      = $users['ref']; // date
                $row[]      = $users['pymnt_ref']; // date
                $row[]      = number_format($p_amt, 2, '.', ','); // date
                $row[]      = number_format($r_amt, 2, '.', ',');
                $row[]      = number_format($paid, 2, '.', ','); // date
                $row[]      = number_format($rtnd, 2, '.', ','); // date
                $row[]      = number_format($sup_adj, 2, '.', ',');
                $row[]      = number_format($sup_adj_pay, 2, '.', ',');
                 $row[]      =number_format($adi, 2, '.', ',');
                  $row[]      =number_format($did, 2, '.', ',');
                $row[]      = number_format($balance, 2, '.', ','); // date
                $data[]     = $row;
            }
        }

        if(!empty($data)){
            $output = array(
                'data' => $data
            );
            echo json_encode($output);
        } else {
            $output = array(
                'data' => ''
            );
            echo json_encode($output);
        }
    }
    
    public function get_department_wise_gross_profit_report($value = '') {
	        
	     //   echo "test";
        $srh_warehouse_id = $this->input->post('srh_warehouse_id');
        $cat_srh = $this->input->post('cat_srh');
		$with_emi_no = $this->input->post('with_emi_no');
		$subcategory = $this->input->post('subcategory');
		$product_id = $this->input->post('product_id');
		$show_all = $this->input->post('show_all');
		$product_name = $this->input->post('product_name');
		$dep_id = $this->input->post('dep_id');
		$srh_sub_cat = $this->input->post('srh_sub_cat');
		
		

        $srh_from_date = '';
        $srh_to_date = '';
        if ($this->input->post('srh_to_date')) {
            $srh_to_date = date('Y-m-d', strtotime($this->input->post('srh_to_date')));
        }
        if ($this->input->post('srh_from_date')) {
            $srh_from_date = date('Y-m-d', strtotime($this->input->post('srh_from_date')));
        }

        /*         * ****************** */
        $search_key = $this->input->post('search');
        $search_key_val = $search_key['value'];
        $start = $this->input->post('start');
        $length = $this->input->post('length');

        $this->load->model('Product_Models');
        $values = '';
        $totalFiltered = 0;
        
        
        $row_no='';
        $product_code='';
        $product_name='';
        $product_tot_cost='';
        $product_balance='';
        $totalData=0;
        $data=array();
        
        //echo "<br/>test";
        	$department_list 	= $this->category_models->getCategory(1);
        //print_r($department_list);
       // die();
        
        
              if (!empty($department_list)) {
                  $no=0;
            foreach ($department_list as $items) {
                $no++;
                $product_id='';//$products->product_id;
               // print_r($items);
              $dep_id=$items->cat_id;
               
                //get sold qty by 
                $sold_qty=0;
                $sales_val=0;
                $sales_cost=0;
                
                $return_qty=0;
                $sales_rtn_cost=0;
                $sales_rtn_val=0;
                
                
                //error_reporting(E_ALL);
                
                
                $sold_qty_ary=$this->Report_Model->getSoldQtyByWarehouseIdAndDepID($srh_warehouse_id,$dep_id,$srh_from_date,$srh_to_date);
                if(count($sold_qty_ary)){
                    $sold_qty=$sold_qty_ary['sale_tot_qty'];
                     $sales_val=$sold_qty_ary['sale_gross_total'];
                     $sales_cost=$sold_qty_ary['sale_cost_total'];
                }
                
                
                $return_qty_ary=$this->Report_Model->getReturnQtyByWarehouseIdAndDepID($srh_warehouse_id,$dep_id,$srh_from_date,$srh_to_date);
                //print_r($return_qty_ary);
                if(count($return_qty_ary)){
                    $return_qty=$return_qty_ary['return_qty'];
                     $sales_rtn_val=$return_qty_ary['sales_rtn_val'];
                     $sales_rtn_cost=$return_qty_ary['sales_rtn_cost'];
                }
                
                
                 $sales_val_net=$sales_val-$sales_rtn_val;
                 $qty_net_tot=0;
                 $qty_net_tot=$sold_qty-$return_qty;
            
                
                //$sales_grand_tot=$sales_val-$sales_rtn_val;
                
                
                
                $sales_cost_grand=$sales_cost-$sales_rtn_cost;
                
                $gp=$sales_val_net-$sales_cost_grand;
                
                $gp_presnt='';
                if($sales_val_net){
                    $gp_presnt=round(($gp/$sales_val_net*100),2)."%";
                }
                
                $sold_qty=number_format($sold_qty, 2, '.', '');
                $sales_val_net=number_format($sales_val_net, 2, '.', '');
                $sales_cost_grand=number_format($sales_cost_grand, 2, '.', '');
                $gp=number_format($gp, 2, '.', '');
                
                $dev_text='';
               // $dev_text=" : dep_id:$dep_id , srh_from_date:$srh_from_date , srh_to_date:$srh_to_date";
                
                 //if($display)
                 {
                        $row=array();
                        $row_no++;
                        $row[] = $row_no;
                        $row[] =  $items->cat_name.$dev_text;
                        $row[] =  $qty_net_tot;
                        $row[] =  $sales_val_net;
                        $row[] =  $sales_cost_grand;
                        $row[] =  $gp;
                        $row[] = $gp_presnt;
                        $data[] = $row;
                    }
            
            }
            
            
            $output = array(
                "row_no" => '',
                "product_code" =>'',
                "product_name" => '',
                "product_balance" => '',
                "product_tot_cost" => '',
                "recordsTotal" => intval($totalData),
                "recordsFiltered" => intval($totalFiltered),
                'data' => $data);
            echo json_encode($output);
            
            
        } else {
            $output = array(
                "recordsTotal" => '',
                "recordsFiltered" => '',
                'data' => '');
            echo json_encode($output);
        }
        
    }
    
    
    
      public function get_rep_wise_sales_summary_report($value = '') {
	        
	     //   echo "test";
        $srh_warehouse_id = $this->input->post('srh_warehouse_id');
        $cat_srh = $this->input->post('cat_srh');
		$with_emi_no = $this->input->post('with_emi_no');
		$subcategory = $this->input->post('subcategory');
		$product_id = $this->input->post('product_id');
		$show_all = $this->input->post('show_all');
		$product_name = $this->input->post('product_name');
		$dep_id = $this->input->post('dep_id');
		$srh_sub_cat = $this->input->post('srh_sub_cat');
		
		

        $srh_from_date = '';
        $srh_to_date = '';
        if ($this->input->post('srh_to_date')) {
            $srh_to_date = date('Y-m-d', strtotime($this->input->post('srh_to_date')));
        }
        if ($this->input->post('srh_from_date')) {
            $srh_from_date = date('Y-m-d', strtotime($this->input->post('srh_from_date')));
        }

        /*         * ****************** */
        $search_key = $this->input->post('search');
        $search_key_val = $search_key['value'];
        $start = $this->input->post('start');
        $length = $this->input->post('length');

        $this->load->model('Product_Models');
        $values = '';
        $totalFiltered = 0;
        
        
        $row_no='';
        $product_code='';
        $product_name='';
        $product_tot_cost='';
        $product_balance='';
        $totalData=0;
        $data=array();
        
        //echo "<br/>test";
        	$department_list 	= $this->category_models->getEnableUsers();
        //print_r($department_list);
       // die();
        
        
              if (!empty($department_list)) {
                  $no=0;
            foreach ($department_list as $items) {
                $no++;
                $product_id='';//$products->product_id;
               // print_r($items);
              $dep_id=$items->user_id;
               
                //get sold qty by 
                $sold_qty=0;
                $sales_val=0;
                $sales_cost=0;
                
                $return_qty=0;
                $sales_rtn_cost=0;
                $sales_rtn_val=0;
                
                
                //error_reporting(E_ALL);
                
                
                
                $sold_qty_ary_all=$this->Report_Model->getSoldQtyByWarehouseIdAndDepID_v5($srh_warehouse_id,'',$srh_from_date,$srh_to_date);
                
                $sales_val_all=0;
                if(count($sold_qty_ary_all)){
                   // $sold_qty=$sold_qty_ary['sale_tot_qty'];
                     $sales_val_all=$sold_qty_ary_all['sale_gross_total'];
                    // $sales_cost=$sold_qty_ary['sale_cost_total'];
                }
                
               // $sales_val_all=500;
                
                
                $sold_qty_ary=$this->Report_Model->getSoldQtyByWarehouseIdAndDepID_v5($srh_warehouse_id,$dep_id,$srh_from_date,$srh_to_date);
                if(count($sold_qty_ary)){
                    $sold_qty=$sold_qty_ary['sale_tot_qty'];
                     $sales_val=$sold_qty_ary['sale_gross_total'];
                     $sales_cost=$sold_qty_ary['sale_cost_total'];
                }
                
                
                $return_qty_ary=$this->Report_Model->getReturnQtyByWarehouseIdAndDepID_v5($srh_warehouse_id,$dep_id,$srh_from_date,$srh_to_date);
                //print_r($return_qty_ary);
                if(count($return_qty_ary)){
                    $return_qty=$return_qty_ary['return_qty'];
                     $sales_rtn_val=$return_qty_ary['sales_rtn_val'];
                     $sales_rtn_cost=$return_qty_ary['sales_rtn_cost'];
                }
                
                
                 $sales_val_net=$sales_val-$sales_rtn_val;
                 $qty_net_tot=0;
                 $qty_net_tot=$sold_qty-$return_qty;
            
                
                //$sales_grand_tot=$sales_val-$sales_rtn_val;
                
                
                
                $sales_cost_grand=$sales_cost-$sales_rtn_cost;
                
                $gp=$sales_val_net-$sales_cost_grand;
                
                $gp_presnt='';
                if($sales_val_net){
                    $gp_presnt=round(($gp/$sales_val_net*100),2)."%";
                }
                
                $sold_qty=number_format($sold_qty, 2, '.', '');
                $sales_val_net=number_format($sales_val_net, 2, '.', '');
                $sales_cost_grand=number_format($sales_cost_grand, 2, '.', '');
                $gp=number_format($gp, 2, '.', '');
                
                $dev_text='';
               // $dev_text=" : dep_id:$dep_id , srh_from_date:$srh_from_date , srh_to_date:$srh_to_date";
                
                $display=0;
                if($sales_val_net!=0.00)   $display=1;
                
                 if($display)
                 {
                        $row=array();
                        $row_no++;
                       // $row[] = $row_no;
                        $row[] =  $items->user_first_name.$dev_text;
                       // $row[] =  '';//$qty_net_tot;
                        $row[] =  $sales_val_net;
                       // $row[] =  '';//$sales_cost_grand;
                       
                       
                       $div_text="";
                       $height=0;
                       if($sales_val_all){
                           $height=$sales_val_net/$sales_val_all*500;
                           //$height=$sales_val_all/$sales_val_net*100;
                           //$height=$height/100;
                       }
                        $div_text="<div style='width:".$height."px; height:10px; background-color:#5cb85c'>&nbsp;</div>".$sales_val_net;
                        $row[] =  $div_text;//$gp;
                       // $row[] ='';// $gp_presnt;
                        $data[] = $row;
                    }
            
            }
            
            
            $output = array(
                "row_no" => '',
                "product_code" =>'',
                "product_name" => '',
                "product_balance" => '',
                "product_tot_cost" => '',
                "recordsTotal" => intval($totalData),
                "recordsFiltered" => intval($totalFiltered),
                'data' => $data);
            echo json_encode($output);
            
            
        } else {
            $output = array(
                "recordsTotal" => '',
                "recordsFiltered" => '',
                'data' => '');
            echo json_encode($output);
        }
        
    }
    
    
        public function get_department_wise_gross_profit_with_filter_report($value = '') {
	        
	     //   echo "test";
        $srh_warehouse_id = $this->input->post('srh_warehouse_id');
        $cat_srh = $this->input->post('cat_srh');
		$with_emi_no = $this->input->post('with_emi_no');
		$subcategory = $this->input->post('subcategory');
		$product_id = $this->input->post('product_id');
		$show_all = $this->input->post('show_all');
		$product_name = $this->input->post('product_name');
		$dep_id = $this->input->post('dep_id');
		$srh_sub_cat = $this->input->post('srh_sub_cat');
		
		

        $srh_from_date = '';
        $srh_to_date = '';
        if ($this->input->post('srh_to_date')) {
            $srh_to_date = date('Y-m-d', strtotime($this->input->post('srh_to_date')));
        }
        if ($this->input->post('srh_from_date')) {
            $srh_from_date = date('Y-m-d', strtotime($this->input->post('srh_from_date')));
        }

        /*         * ****************** */
        $search_key = $this->input->post('search');
        $search_key_val = $search_key['value'];
        $start = $this->input->post('start');
        $length = $this->input->post('length');

        $this->load->model('Product_Models');
        $values = '';
        $totalFiltered = 0;
        
        
        $row_no='';
        $product_code='';
        $product_name='';
        $product_tot_cost='';
        $product_balance='';
        $totalData=0;
        $data=array();
        
        //echo "<br/>test";
        	$department_list 	= $this->category_models->getCategory(1);
        //print_r($department_list);
       // die();
        
        
              if (!empty($department_list)) {
                  $no=0;
            foreach ($department_list as $items) {
                $no++;
                $product_id='';//$products->product_id;
               // print_r($items);
              $dep_id=$items->cat_id;
               
                //get sold qty by 
                $sold_qty=0;
                $sales_val=0;
                $sales_cost=0;
                
                $return_qty=0;
                $sales_rtn_cost=0;
                $sales_rtn_val=0;
                
                
                //error_reporting(E_ALL);
                
                
                $sold_qty_ary=$this->Report_Model->getSoldQtyByWarehouseIdAndDepID($srh_warehouse_id,$dep_id,$srh_from_date,$srh_to_date);
                if(count($sold_qty_ary)){
                    $sold_qty=$sold_qty_ary['sale_tot_qty'];
                     $sales_val=$sold_qty_ary['sale_gross_total'];
                     $sales_cost=$sold_qty_ary['sale_cost_total'];
                }
                
                
                $return_qty_ary=$this->Report_Model->getReturnQtyByWarehouseIdAndDepID($srh_warehouse_id,$dep_id,$srh_from_date,$srh_to_date);
                //print_r($return_qty_ary);
                if(count($return_qty_ary)){
                    $return_qty=$return_qty_ary['return_qty'];
                     $sales_rtn_val=$return_qty_ary['sales_rtn_val'];
                     $sales_rtn_cost=$return_qty_ary['sales_rtn_cost'];
                }
                
                
                 $sales_val_net=$sales_val-$sales_rtn_val;
                 $qty_net_tot=0;
                 $qty_net_tot=$sold_qty-$return_qty;
            
                
                //$sales_grand_tot=$sales_val-$sales_rtn_val;
                
                
                
                $sales_cost_grand=$sales_cost-$sales_rtn_cost;
                
                $gp=$sales_val_net-$sales_cost_grand;
                
                $gp_presnt='';
                if($sales_val_net){
                    $gp_presnt=round(($gp/$sales_val_net*100),2)."%";
                }
                
                $sold_qty=number_format($sold_qty, 2, '.', '');
                $sales_val_net=number_format($sales_val_net, 2, '.', '');
                $sales_cost_grand=number_format($sales_cost_grand, 2, '.', '');
                $gp=number_format($gp, 2, '.', '');
                
                $dev_text='';
               // $dev_text=" : dep_id:$dep_id , srh_from_date:$srh_from_date , srh_to_date:$srh_to_date";
                
                 //if($display)
                 {
                        $row=array();
                        $row_no++;
                        $row[] = $row_no;
                        $row[] =  $items->cat_name.$dev_text;
                        $row[] =  $qty_net_tot;
                        $row[] =  $sales_val_net;
                        $row[] =  $sales_cost_grand;
                        $row[] =  $gp;
                        $row[] = $gp_presnt;
                        $data[] = $row;
                    }
            
            }
            
            
            $output = array(
                "row_no" => '',
                "product_code" =>'',
                "product_name" => '',
                "product_balance" => '',
                "product_tot_cost" => '',
                "recordsTotal" => intval($totalData),
                "recordsFiltered" => intval($totalFiltered),
                'data' => $data);
            echo json_encode($output);
            
            
        } else {
            $output = array(
                "recordsTotal" => '',
                "recordsFiltered" => '',
                'data' => '');
            echo json_encode($output);
        }
        
    }
    
    
    public function get_sales_assistant_wise_department_sales_summary($value = '') {
	        
	     //   echo "test";
        $srh_warehouse_id = $this->input->post('srh_warehouse_id');
        $cat_srh = $this->input->post('cat_srh');
		$with_emi_no = $this->input->post('with_emi_no');
		$subcategory = $this->input->post('subcategory');
		$product_id = $this->input->post('product_id');
		$show_all = $this->input->post('show_all');
		$product_name = $this->input->post('product_name');
		$dep_id = $this->input->post('dep_id');
		$srh_sub_cat = $this->input->post('srh_sub_cat');
			$srh_sales_rep_id = $this->input->post('srh_sales_rep_id');
		
		

        $srh_from_date = '';
        $srh_to_date = '';
        if ($this->input->post('srh_to_date')) {
            $srh_to_date = date('Y-m-d', strtotime($this->input->post('srh_to_date')));
        }
        if ($this->input->post('srh_from_date')) {
            $srh_from_date = date('Y-m-d', strtotime($this->input->post('srh_from_date')));
        }

        /*         * ****************** */
        $search_key = $this->input->post('search');
        $search_key_val = $search_key['value'];
        $start = $this->input->post('start');
        $length = $this->input->post('length');

        $this->load->model('Product_Models');
        $values = '';
        $totalFiltered = 0;
        
        
        $row_no='';
        $product_code='';
        $product_name='';
        $product_tot_cost='';
        $product_balance='';
        $totalData=0;
        $data=array();
        
        //echo "<br/>test";
        	$department_list 	= $this->category_models->getCategory();
        //print_r($department_list);
       // die();
        
        
              if (!empty($department_list)) {
                  $no=0;
            foreach ($department_list as $items) {
                $no++;
                $product_id='';//$products->product_id;
               // print_r($items);
              $dep_id=$items->cat_id;
               
                //get sold qty by 
                $sold_qty=0;
                $sales_val=0;
                $sales_cost=0;
                
                $return_qty=0;
                $sales_rtn_cost=0;
                $sales_rtn_val=0;
                
                
                //error_reporting(E_ALL);
                
                
                $sold_qty_ary=$this->Report_Model->get_sales_assistant_wise_department_sales_summary($srh_warehouse_id,$dep_id,$srh_from_date,$srh_to_date,$srh_sales_rep_id);
                if(count($sold_qty_ary)){
                    $sold_qty=$sold_qty_ary['sale_tot_qty'];
                     $sales_val=$sold_qty_ary['sale_gross_total'];
                     $sales_cost=$sold_qty_ary['sale_cost_total'];
                }
                
                //echo ", sales_val:$sales_val";
                
                $return_qty_ary=$this->Report_Model->getReturnQtyByWarehouseIdAndDepID_for_sales_rep($srh_warehouse_id,$dep_id,$srh_from_date,$srh_to_date,$srh_sales_rep_id);
                //print_r($return_qty_ary);
                if(count($return_qty_ary)){
                    $return_qty=$return_qty_ary['return_qty'];
                     $sales_rtn_val=$return_qty_ary['sales_rtn_val'];
                     $sales_rtn_cost=$return_qty_ary['sales_rtn_cost'];
                }
                
                
                //comment 22/02/2021
                //diduct return 
                 $sales_val_net=$sales_val-$sales_rtn_val;
                 
                 //with out return
                 //$sales_val_net=$sales_val;
                 
                 $qty_net_tot=0;
                 $qty_net_tot=$sold_qty-$return_qty;
            
                
                //$sales_grand_tot=$sales_val-$sales_rtn_val;
                
                
                
                $sales_cost_grand=$sales_cost-$sales_rtn_cost;
                
                $gp=$sales_val_net-$sales_cost_grand;
                
                $gp_presnt='';
                if($sales_val_net){
                    $gp_presnt=round(($gp/$sales_val_net*100),2)."%";
                }
                
                $sold_qty=number_format($sold_qty, 2, '.', '');
                $sales_val_net=number_format($sales_val_net, 2, '.', '');
                $sales_cost_grand=number_format($sales_cost_grand, 2, '.', '');
                $gp=number_format($gp, 2, '.', '');
                
                $dev_text='';
               // $dev_text=" : dep_id:$dep_id , srh_from_date:$srh_from_date , srh_to_date:$srh_to_date";
                
                 //if($display)
                 {
                        $row=array();
                        $row_no++;
                        $row[] = $row_no;
                        $row[] =  $items->cat_name.$dev_text;
                        $row[] =  $qty_net_tot;
                        $row[] =  $sales_val_net;
                        $row[] =  $sales_cost_grand;
                        $row[] =  '';//$gp;
                        $row[] = '';//$gp_presnt;
                        $data[] = $row;
                    }
            
            }
            
            
            $output = array(
                "row_no" => '',
                "product_code" =>'',
                "product_name" => '',
                "product_balance" => '',
                "product_tot_cost" => '',
                "recordsTotal" => intval($totalData),
                "recordsFiltered" => intval($totalFiltered),
                'data' => $data);
            echo json_encode($output);
            
            
        } else {
            $output = array(
                "recordsTotal" => '',
                "recordsFiltered" => '',
                'data' => '');
            echo json_encode($output);
        }
        
    }
}