<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Salary_payment extends CI_controller {

    var $main_menu_name = 'pay_role';
    var $sub_menu_name = 'salary_payment';

    public function __construct() {
        parent::__construct();
        $this->load->model('Common_Model');
        $this->load->model("Salary_payment_model");
        $this->load->model("Warehouse_Model");
    }

    public function index() {
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name'] = $this->sub_menu_name;
$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        $this->load->view('salary_payment', $data);
    }

    public function get_salary_payment_list() {
        $search_key = $this->input->post('search');
        $search_key_val = $search_key['value'];
        $start = $this->input->post('start');
        $length = $this->input->post('length');
        $warehouse_id = $this->input->post('warehouse_id');
        $srh_user_id = $this->input->post('srh_user_id');
        $srh_from_date = $this->input->post('srh_from_date');
        $srh_to_date = $this->input->post('srh_to_date');

        $salary_payment_list = $this->Salary_payment_model->get_salary_payment_list($start, $length, $search_key_val, $srh_user_id, $warehouse_id, $srh_from_date, $srh_to_date);
        $salary_payment_list_count = $this->Salary_payment_model->get_salary_payment_list('', '', $search_key_val, $srh_user_id, $warehouse_id, $srh_from_date, $srh_to_date);

        $totalData = $salary_payment_list_count;
        $totalFiltered = $totalData;

        $data = array();
        $balance_amount = 0;
        foreach ($salary_payment_list as $row) {
            $nestedData = array();
            $nestedData[] = $row['sp_refno'];
            $nestedData[] = $row['user_first_name'] . ' ' . $row['user_last_name'];
            $nestedData[] = $row['sp_date'];
            $type = '';
            if ($row['sp_is_sal_advance'] == 0) {
                $type = 'Salary';
            } elseif ($row['sp_is_sal_advance'] == 1) {
                $type = 'Advance';
            }
            $nestedData[] = $type;
			 $nestedData[] = $row['sp_note'];
            $nestedData[] = number_format($row['sp_amount'], 2, '.', '');
           // $tem_warehouse = $this->Warehouse_Model->get_warehouse_info($row['warehouse_id']);
           // $nestedData[] = $tem_warehouse['name'];

            $actionTxtUpdate = '<a onClick="click_salary_payment_btn(' . $row['sp_id'] . ')" data-toggle="modal" href="#" class="btn btn-xs btn-blue tooltips" data-placement="top" data-original-title="Edit suppliers"><i class="glyphicon fa fa-edit"></i></a> &nbsp;';
			$actionTxtDelete = '';
			if($this->session->userdata('ss_group_id')==1 || $this->session->userdata('ss_group_id')==2){
            $actionTxtDelete = '<a class="btn btn-xs btn-bricky tooltips" data-placement="top" data-original-title="Delete supplier" onClick="deleteSalaryPaymentData(' . $row['sp_id'] . ')">
															<i class="glyphicon fa fa-trash-o"></i></a>';
			}

            $nestedData[] = $actionTxtUpdate . $actionTxtDelete;

            $data[] = $nestedData;
        }

        $json_data = array(
            //"draw"            => intval( $requestData['draw'] ),  
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data" => $data
        );

        echo json_encode($json_data);
    }

    public function create_salary_payment() {
        if (isset($_GET['mstr_sal_pay_id'])) {
            $sal_pay_id = $_GET['mstr_sal_pay_id'];
        } else {
            $sal_pay_id = '';
        }


        if ($sal_pay_id) {
            $data['salary_pay_id'] = $sal_pay_id;
            $data['type'] = 'E';
            $data['pageName'] = 'UPDATE SALARY PAYMENT';
            $data['btnText'] = 'Update Salary Payment';
            $data['salary_pay_byid'] = $this->Salary_payment_model->get_salary_pay_details($sal_pay_id);
        } else {
            $data['salary_pay_id'] = '';
            $data['type'] = 'A';
            $data['pageName'] = 'ADD SALARY PAYMENT';
            $data['btnText'] = 'Add Salary Payment';
            $data['salary_pay_byid'] = array();
        }

        $this->load->view("models/create_salary_payment", $data);
    }

    public function save_salary_payment() {
        
        
        
        if(is_logged_in()){

		}else {

			redirect(base_url(),'refresh');

			exit();

		}
		
		
        $salary_pay_id = $this->input->post('salary_pay_id');

//        echo $salary_id;
        $type = $this->input->post('type');
//        $mstr_sal_type_id = $this->input->post('mstr_sal_type_id');
//        $temp_sal_type = explode("_", $this->input->post("mstr_sal_type_id"));
//        $mstr_sal_type_id = $temp_sal_type[0];
//        $mstr_sal_type_did_add = $temp_sal_type[1];
//        $mstr_sal_type_did_add = $this->input->post('mstr_sal_type_did_add');
        $user_id = $this->input->post('user_id');
        $sp_amount = $this->input->post('sp_amount');
        $sp_date = date('Y-m-d', strtotime($this->input->post("sp_date")));
        $sp_note = $this->input->post('sp_note');
        $sp_is_sal_advance = $this->input->post('sp_is_sal_advance');

        if ($type == 'A') {
            //start get next referance no
            $warehouse_id = $this->session->userdata('ss_warehouse_id');
            //echo "warehouse_id:$warehouse_id";
            $warehouse_dtls = $this->Warehouse_Model->get_warehouse_info($warehouse_id);
            //print_r($warehouse_dtls);
            $warehouse_code = $warehouse_dtls['code'];
            $warehouse_last_id = (1 + $this->Common_Model->get_next_warehouse_ref_no($warehouse_id, 'warehouse_id', 'last_warehouse_id', 'salary_payment'));
			
			//$curr_warehouse_last_id=$this->Common_Model->get_next_warehouse_ref_no($warehouse_id, 'warehouse_id', 'warehouse_last_id', 'salary_payment');

            //
            $reference_number = $warehouse_code . '/SPR/' . sprintf("%04d", $warehouse_last_id);
			
			//echo "curr_warehouse_last_id: $curr_warehouse_last_id";
            //end get next referance no
            //echo "reference_number:$reference_number";
            //$max_reference = $this->Salary_model->get_max_reference(); //for create next reference number
            // if (isset($max_reference['reference_number'])) {
            //  $next_ref = preg_match_all('!\d+!', $max_reference['reference_number'], $matches);
            //  $next_ref = $matches[0][0] + 1;
            //  $ref = "D/" . sprintf('%04d', $next_ref);
            //   } else {
            // $ref = "D/0001";
            //}
        }




        $this->load->library('form_validation'); //form validation lib

        if ($type == 'A') {
            $this->form_validation->set_rules('user_id', 'sp_amount', 'sp_date', 'sp_is_sal_advance', 'required');
        } else if ($type == 'E') {
            $this->form_validation->set_rules('user_id', 'sp_amount', 'required');
        }

        if ($this->form_validation->run() == FALSE) {
            $st = array('status' => 0, 'validation' => validation_errors());
            echo json_encode($st);
        } else {
            if ($type == 'A') {
//                echo 'add';
                $data = array(
                    'sp_refno' => $reference_number,
                    'last_warehouse_id' => $warehouse_last_id,
                    'warehouse_id' => $warehouse_id,
                    'sp_amount' => $sp_amount,
                    'sp_date' => $sp_date,
                    'user_id' => $user_id,
                    'sp_note' => $sp_note,
                    'sp_is_sal_advance' => $sp_is_sal_advance,
                    'added_user' => $this->session->userdata('ss_user_id')
                );
            } else if ($type == 'E') {
//                echo 'edit';
                $data = array(
                    'user_id' => $user_id,
                    'sp_amount' => $sp_amount,
                    'sp_date' => $sp_date,
                    'sp_note' => $sp_note,
                    'sp_is_sal_advance' => $sp_is_sal_advance,
                    'added_user' => $this->session->userdata('ss_user_id')
                );
            }


            $this->Salary_payment_model->save_salary_payment($salary_pay_id, $data);

            $lastid = $this->db->insert_id();

            if ($type == 'A') {
                if ($lastid) {
                    echo json_encode(array('id' => $salary_pay_id, 'type' => $type, 'status' => 1));
                } else {
                    echo json_encode(array('status' => 0));
                }
            }
            if ($type == 'E') {
                echo json_encode(array('type' => $type, 'status' => 1));
            }
        }
    }

    public function delete() {
        $id = $this->input->post('id');
        $this->Salary_payment_model->delete_salary_payment($id);
        if ($id) {
            echo json_encode(array('id' => $id));
        } else {
            echo json_encode(array('status' => 'error'));
        }
    }

}
