<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');



class Cash_Balance_Model extends CI_Model {

  

  private $tableName = 'cash_count';

  

  function __construct() 

  {

    /* Call the Model constructor */

    parent::__construct();

  }

 

 /* DB TABLE*/

 

/* 

CREATE TABLE `cash_balance` (

  `cb_id` int(11) NOT NULL,

  `cb_recieved` decimal(10,0) NOT NULL,

  `cb_cash_total` decimal(25,2) NOT NULL DEFAULT '0.00',

  `cb_sale` decimal(25,4) NOT NULL,

  `cb_service` decimal(25,4) NOT NULL,

  `cb_return` decimal(25,4) NOT NULL,

  `cb_expences` decimal(25,4) NOT NULL,

  `cb_balance` decimal(25,4) NOT NULL,

  `cb_remarks` varchar(100) NOT NULL,

  `cb_c_5000` int(4) NOT NULL DEFAULT '0',

  `cb_c_1000` int(4) NOT NULL DEFAULT '0',

  `cb_c_500` int(4) NOT NULL DEFAULT '0',

  `cb_c_100` int(4) NOT NULL DEFAULT '0',

  `cb_c_50` int(4) DEFAULT '0',

  `cb_c_20` int(4) NOT NULL DEFAULT '0',

  `cb_c_10` int(4) NOT NULL DEFAULT '0',

  `cb_c_c_10` int(4) NOT NULL DEFAULT '0',

  `cb_c_c_5` int(4) NOT NULL DEFAULT '0',

  `cb_c_c_2` int(4) NOT NULL DEFAULT '0',

  `cb_c_c_1` int(4) NOT NULL DEFAULT '0',

  `cb_user_id` int(4) NOT NULL,

  `cb_date_created` date NOT NULL

) ENGINE=InnoDB DEFAULT CHARSET=latin1;



--

-- Indexes for dumped tables

--



--

-- Indexes for table `cash_balance`

--

ALTER TABLE `cash_balance`

  ADD PRIMARY KEY (`cb_id`);



--

-- AUTO_INCREMENT for dumped tables

--



--

-- AUTO_INCREMENT for table `cash_balance`

--

ALTER TABLE `cash_balance`

  MODIFY `cb_id` int(11) NOT NULL AUTO_INCREMENT;*/

 

 /* END DB TABLE*/

 

 function get_cash_totals($srh_warehouse_id='',$srh_to_date='',$srh_from_date='',$srh_type='',$srh_payment_term='',$ss_user_id='',$srh_customer_id='')

   {

	   $warehouse_id='';

	   $this->db->select('sum(p.sale_pymnt_amount)');

       $this->db->from('sale_payments p');

	   $this->db->where("p.sale_pymnt_paying_by",$srh_payment_term);

	   

	   if($ss_user_id)

	   {

		   $this->db->where("p.user_id",$ss_user_id);

		}

	   if($srh_type){

	   	$this->db->where("p.sale_payment_type",$srh_type);//

	   }

	   

	   $query = $this->db->get();

	   

     if($query->num_rows() >0)

     {

       return $query->result_array();

     }

     else

     {

       return 0;

     }



   }
	function get_drawer_cash_total($count_date,$ss_user_id='',$srh_type=''){

		$warehouse_id='';
		$this->db->select('*,sum(p.cash_total_amount) as cash_total_amount');
		$this->db->from('cash_count p');
		$this->db->where("p.count_date",$count_date);
		$this->db->where("p.count_warehouse_id",1);
		
		/*if($ss_user_id)
		{
			$this->db->where("p.count_user_id",$ss_user_id);
		}
		
		if($srh_type){
			$this->db->where("p.sale_payment_type",$srh_type);
		}*/
		$query = $this->db->get();
		
		if($query->num_rows() >0)
		{
			return $query->row_array();
		}else{
		
		return 0;
		
		}



   }
   

   //Sales get information

	public function get_sale_info($id)

	 {

		$this->db->select('sales.*,user.user_first_name,user_group.user_group_name');

		$this->db->from('sales');

		$this->db->join('user','sales.user = user.user_id', 'left');

		$this->db->join('user_group','user_group.user_group_id = user.group_id', 'left');

		$this->db->where("sale_id", $id);

		$this->db->order_by("sale_id", "desc");

		$query = $this->db->get();

		return $query->row_array(); 

	 }

	 

	//Sales save

	function save_cash_balance(&$supplier_data)

	{

		return	$this->db->insert($this->tableName,$supplier_data);

	}	

	function get_counts_info($id)

	 {

		$this->db->select(''.$this->tableName.'.*,user.user_first_name,user_group.user_group_name');

		$this->db->from($this->tableName);

		$this->db->join('user',''.$this->tableName.'.count_user_id = user.user_id', 'left');

		$this->db->join('user_group','user_group.user_group_id = user.group_id', 'left');
		if($id)
		$this->db->where("count_id", $id);

		$this->db->order_by("count_id", "desc");

		$query = $this->db->get();

		return $query->row_array(); 

	 }

}