<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Custom_Model extends CI_Model {
  
  private $tableName = 'sales';
  
  function __construct() 
  {
    /* Call the Model constructor */
    parent::__construct();
  }
  
  
   public function get_search_customer_by_phone($str) {
        $this->db->select('c.*');
        $this->db->from('customer c');
       
        $this->db->order_by("c.cus_name", "asc");
       // $this->db->or_like('c.cus_name',$str);
		$this->db->where('c.cus_phone',$str);
       // $this->db->or_like('user_last_name',$str);
       // $this->db->or_like('user_group_name',$str);
	    $this->db->LIMIT(1);
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return false;
        }
    }
    
    	//getProductDamagedQtyByWarehouseId
	public function getProductDamagedQtyByWarehouseId($warehouse_id,$product_id)
	{
	    
		$this->db->select_sum('pdi.pdmgitm_quantity');
		$this->db->from('product_damage_item pdi');
		$this->db->join('product_damage p', 'p.pdmg_id = pdi.pdmg_id', 'left');
			//if($warehouse_id){
		//$this->db->where_in('p.warehouse_id',$warehouse_id);
		//	}
			
			if($warehouse_id){
		$this->db->where_in('p.warehouse_id',$warehouse_id);
		}
		
		$this->db->where('pdi.product_id',$product_id);
		$query=$this->db->get();
		return $data['quantity']=$query->row()->pdmgitm_quantity;
	}
	
		public function getSalesReturnQtyByWarehouseId($warehouse_id,$product_id)
	{
		$this->db->select_sum('sri.quantity');
		$this->db->from('sales_return_items sri');
		$this->db->join('sales_return sr', 'sr.sl_rtn_id = sri.sl_rtn_id', 'left');
		if($warehouse_id){
		$this->db->where_in('sr.warehouse_id',$warehouse_id);
		}
		$this->db->where('sri.product_id',$product_id);
		$query=$this->db->get();
		return $data['quantity']=$query->row()->quantity;
	}

  
		public function getReturnQtyByWarehouseId($warehouse_id,$product_id,$srh_from_date='',$srh_to_date='',$search_key_val='',$cat_srh='')
	{
		$this->db->select_sum('pi.pur_rtn_itm_quantity');
		$this->db->from('purchase_return_items pi');
		$this->db->join('purchase_return p', 'p.pur_rtn_id = pi.pur_rtn_id', 'left');
		$this->db->join('product pr','pi.product_id = pr.product_id');
		$this->db->join("product_category pc", "pr.cat_id = pc.cat_id", "left");
	  if($cat_srh){
	  $this->db->where("pc.cat_name",$cat_srh);
	  }
		if($search_key_val){
			 $this->db->where("pi.product_code LIKE '%$search_key_val%'","left");
		}
		if($warehouse_id){
		$this->db->where_in('p.warehouse_id',$warehouse_id);
		}
		if($product_id)
		$this->db->where('pi.product_id',$product_id);
		if($srh_to_date){
//		$srh_to_date=date('Y-m-d',strtotime($srh_to_date . ""));	
			$this->db->where("date(p.pur_rtn_datetime) <=",$srh_to_date);//("id !=",$id);
		}
		if($srh_from_date){
			$this->db->where("date(p.pur_rtn_datetime) >=",$srh_from_date);//("id !=",$id);
		}
		$query=$this->db->get();
		//echo $this->db->last_query();
		//return $data['quantity']=$query->row()->quantity;
		if($query->num_rows() >0)
     {
       return $data['pur_rtn_itm_quantity']=$query->row()->pur_rtn_itm_quantity;
     }
     else
     {
       return 0;
     }
	}

  
  
   //get Purchased Qty By WarehouseId
	public function getPurchasedQtyByWarehouseId($warehouse_id,$product_id,$srh_from_date='',$srh_to_date='',$search_key_val='',$cat_srh='')
	{
		$this->db->select_sum('pi.quantity');
		$this->db->from('purchase_items pi');
		$this->db->join('purchases p', 'p.id = pi.purchase_id', 'left');
		$this->db->join("product pr", "pr.product_id = pi.product_id", "left");
		$this->db->join("product_category pc", "pr.cat_id = pc.cat_id", "left");
	  if($cat_srh){
	  $this->db->where("pc.cat_name",$cat_srh);
	  }
		
		if($search_key_val){
			 $this->db->where("pi.product_code LIKE '%$search_key_val%'","left");
		}
		
		if($warehouse_id){
		$this->db->where_in('p.warehouse_id',$warehouse_id);
		}
		if($product_id)
		$this->db->where('pi.product_id',$product_id);
		
		
		if($srh_to_date){
			$srh_to_date=date('Y-m-d',strtotime($srh_to_date . ""));
		
		//echo $srh_to_date.'|';
			$this->db->where("date(p.date) <=",$srh_to_date);//("id !=",$id);
		}
		if($srh_from_date){
			$this->db->where("date(p.date) >=",$srh_from_date);//("id !=",$id);
		}
		$query=$this->db->get();
		//echo $this->db->last_query();
		//return $data['quantity']=$query->row()->quantity;
		
		if($query->num_rows() >0)
     {
       return $data['quantity']=$query->row()->quantity;
     }
     else
     {
       return 0;
     }
	}



  
  	//getTransferResevedQtyByWarehouseId
	public function getTransferResevedQtyByWarehouseId($warehouse_id,$product_id,$srh_from_date='',$srh_to_date='')
	{
		$this->db->select_sum('ti.trnsfr_itm_quantity');
		$this->db->from('transfer_item ti');
		$this->db->join('transfer t', 't.trnsfr_id = ti.trnsfr_id', 'left');
		 if($warehouse_id){
		$this->db->where_in('t.trnsfr_to_warehouse_id',$warehouse_id);
		}
		if($srh_to_date){
			$srh_to_date=date('Y-m-d',strtotime($srh_to_date . ""));
			$this->db->where("date(t.trnsfr_datetime) <=",$srh_to_date);//("id !=",$id);
		}
		if($srh_from_date){
			$this->db->where("date(t.trnsfr_datetime) >=",$srh_from_date);//("id !=",$id);
		}
	//	$this->db->where_in('t.trnsfr_to_warehouse_id',$warehouse_id);
		$this->db->where('ti.product_id',$product_id);
		$this->db->where('t.reviewed_status','Approved');
		$query=$this->db->get();
		return $data['total_transferd']=$query->row()->trnsfr_itm_quantity;
	}


  
  public function getTransferdQtyByWarehouseId($warehouse_id,$product_id,$srh_from_date='',$srh_to_date='',$search_key_val='',$cat_srh='',$trnsfr_to_warehouse_id='')
	{
		//echo " , trnsfr_to_warehouse_id:$trnsfr_to_warehouse_id ,";
		$this->db->select_sum('ti.trnsfr_itm_quantity');
		$this->db->from('transfer_item ti');
		$this->db->join('transfer t', 't.trnsfr_id = ti.trnsfr_id', 'left');
		//$this->db->where('t.trnsfr_from_warehouse_id',$warehouse_id);
		$this->db->where('ti.product_id',$product_id);
		$this->db->where('t.reviewed_status','Approved');
		 if($warehouse_id){
		$this->db->where_in('t.trnsfr_from_warehouse_id',$warehouse_id);
		}
		 if($trnsfr_to_warehouse_id){
		$this->db->where_in('t.trnsfr_to_warehouse_id',$trnsfr_to_warehouse_id);
		}
		if($srh_to_date){
			$srh_to_date=date('Y-m-d',strtotime($srh_to_date . ""));
			$this->db->where("date(t.trnsfr_datetime) <=",$srh_to_date);//("id !=",$id);
		}
		if($srh_from_date){
			$this->db->where("date(t.trnsfr_datetime) >=",$srh_from_date);//("id !=",$id);
		}
		$query=$this->db->get();
		//echo $this->db->last_query();
		return $data['total_transferd']=$query->row()->trnsfr_itm_quantity;
	}
	
 
 
 	public function getSoldQtyByWarehouseId($warehouse_id,$product_id,$srh_from_date='',$srh_to_date='',$search_key_val='',$cat_srh='')
	{
		$this->db->select_sum('si.quantity');
		$this->db->from('sale_items si');
		$this->db->join('sales s', 's.sale_id = si.sale_id', 'left');
		$this->db->join('product p','si.product_id = p.product_id');
//		$this->db->where('s.warehouse_id',$warehouse_id);
		$this->db->join("product_category pc", "p.cat_id = pc.cat_id", "left");
	  if($cat_srh){
	  $this->db->where("pc.cat_name",$cat_srh);
	  }
	  if($warehouse_id){
		$this->db->where_in('s.warehouse_id',$warehouse_id);
		}
		
		if($product_id)
		$this->db->where('si.product_id',$product_id);
		
		if($search_key_val){
			 $this->db->where("p.product_code LIKE '%$search_key_val%'","left");
		}
		
		if($srh_to_date){
			$srh_to_date=date('Y-m-d',strtotime($srh_to_date . ""));
			$this->db->where("date(s.sale_datetime) <=",$srh_to_date);//("id !=",$id);
		}
		if($srh_from_date){
			$this->db->where("date(s.sale_datetime) >=",$srh_from_date);//("id !=",$id);
		}
		$query=$this->db->get();
		//echo $this->db->last_query();
		//print_r($query->result());
		if($query->num_rows() >0)
     {
       return $data['quantity']=$query->row()->quantity;
     }
     else
     {
       return 0;
     }
	 
		
	}
}