<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Sales_Model extends CI_Model {
  
  private $tableName = 'sales';
  
  function __construct() 
  {
    /* Call the Model constructor */
    parent::__construct();
  }
  
  	function getChequeForPrint_ar($srh_warehouse_id='',$srh_to_date='',$srh_from_date='',$srh_type='',$srh_payment_term='',$ss_user_id='',$b_id='')
   {
	   if($srh_type =='grn'){
				$sel='p.*,b.reference_no as sale_reference_no,c.supp_company_name as cus_name, smp_amount,p.sale_pymnt_date_time as dis_date';
				if($ss_user_id) $sel.=',u.user_first_name';
				$this->db->select($sel);
				$this->db->from('sale_payments p');
				$this->db->join('purchases b', 'b.id = p.sale_id', 'left');
				$this->db->join('warehouses w', 'w.id = b.warehouse_id', 'left');
				$this->db->join('supplier c', 'c.supp_id = b.supplier_id', 'left');
				$this->db->join('sale_multiple_payment smp', 'smp.smp_id = p.smp_id', 'left');
				$this->db->where("p.sale_pymnt_paying_by",'Cheque');
				if($ss_user_id) $this->db->join('user u', 'u.user_id = p.user_id', 'left');
				// if($srh_type){
				$this->db->where("p.sale_payment_type",$srh_type);//
				// }
				if($srh_payment_term){
				// $this->db->where("p.sale_pymnt_paying_by",$srh_payment_term);//
				}
				if($ss_user_id){
				$this->db->where("p.user_id",$ss_user_id);//
				}
				if($b_id){
				$this->db->where("p.bank_id",$b_id);//
				}
				if($srh_warehouse_id){
				//  $this->db->where("b.warehouse_id",$srh_warehouse_id);//
				}
				if($srh_to_date){
				$this->db->where("date(p.sale_pymnt_date_time) <=",$srh_to_date);//("id !=",$id);
				}
				if($srh_from_date){
				$this->db->where("date(p.sale_pymnt_date_time) >=",$srh_from_date);//("id !=",$id);
				}
				$this->db->order_by("p.sale_pymnt_id", "desc");
				$this->db->group_by("p.sale_pymnt_cheque_no");
				$query = $this->db->get();
				 // echo $this->db->last_query();
				if($query->num_rows() >0)
				{
				return $query->result_array();
				}
				else
				{
				//return false;
				}
			}
			else{
				$sel='p.*,c.cus_name,b.*,smp_amount, p.sale_pymnt_date_time as order_date,p.sale_pymnt_date_time as dis_date';
				if($ss_user_id) $sel.=',u.user_first_name';
				$this->db->select($sel);
				$this->db->from('sale_payments p');
				$this->db->join('sales b', 'b.sale_id = p.sale_id', 'left');
				$this->db->join('warehouses w', 'w.id = b.warehouse_id', 'left');
				$this->db->join('customer c', 'c.cus_id = b.customer_id', 'left');
				$this->db->join('sale_multiple_payment smp', 'smp.smp_id = p.smp_id', 'left');
				
				//is_deposit
			//$this->db->where("p.is_deposit",1);
				
				$this->db->where("p.sale_pymnt_paying_by",'Cheque');
				if($ss_user_id) $this->db->join('user u', 'u.user_id = p.user_id', 'left');
				if($srh_type)	$this->db->where("p.sale_payment_type",$srh_type);//
				if($srh_payment_term){// $this->db->where("p.sale_pymnt_paying_by",$srh_payment_term);//
				}
				if($ss_user_id){$this->db->where("p.user_id",$ss_user_id);//
				}
					if($b_id){
				$this->db->where("p.bank_id",$b_id);//
				}
				if($srh_warehouse_id){//  $this->db->where("b.warehouse_id",$srh_warehouse_id);//
				}
				if($srh_to_date){
				$this->db->where("date(p.sale_pymnt_date_time) <=",$srh_to_date);//("id !=",$id);
				}
				if($srh_from_date){
				$this->db->where("date(p.sale_pymnt_date_time) >=",$srh_from_date);//("id !=",$id);
				}
				$this->db->order_by("p.sale_pymnt_id", "desc");
				$this->db->group_by("p.sale_pymnt_cheque_no");
				$query = $this->db->get();
				//  echo $this->db->last_query();
				if($query->num_rows() >0)
				{
				return $query->result_array();
				}
				else
				{
				//return false;
				}
	}
}



function get_prety_cash_list_by_date_range_and_bank_list($srh_warehouse_id='',$srh_to_date='',$srh_from_date='',$srh_type='',$srh_payment_term='',$ss_user_id='')
   {
	   {
				$sel='pc.*, pc.acctrnss_date as order_date,pc.acctrnss_date as dis_date,fa.fxd_ass_name,bc.b_name';
				if($ss_user_id) $sel.=',u.user_first_name';
				$this->db->select($sel);
				$this->db->from('petty_cash pc');
				$this->db->join('fixed_asset fa', 'pc.fxd_ass_id = fa.fxd_ass_id', 'left');
				$this->db->join('bank_accounts bc', 'pc.b_id = bc.b_id', 'left');
				//$this->db->join('customer c', 'c.cus_id = b.customer_id', 'left');
				//$this->db->join('sale_multiple_payment smp', 'smp.smp_id = p.smp_id', 'left');
				
				//is_deposit
			//$this->db->where("p.is_deposit",1);
				
				$this->db->where("pc.fxd_ass_id",'2');
				if($ss_user_id) $this->db->join('user u', 'u.user_id = pc.user_id', 'left');
			//	if($srh_type)	$this->db->where("p.sale_payment_type",$srh_type);//
				if($srh_payment_term){// $this->db->where("p.sale_pymnt_paying_by",$srh_payment_term);//
				}
				
				if($ss_user_id){$this->db->where("p.user_id",$ss_user_id);//
				}
				
				if($srh_warehouse_id){//  $this->db->where("b.warehouse_id",$srh_warehouse_id);//
				}
				if($srh_to_date){
				$this->db->where("date(pc.acctrnss_date) <=",$srh_to_date);//("id !=",$id);
				}
				if($srh_from_date){
				$this->db->where("date(pc.acctrnss_date) >=",$srh_from_date);//("id !=",$id);
				}
				$this->db->order_by("pc.acctrnss_id", "desc");
			//	$this->db->group_by("p.sale_pymnt_cheque_no");
				$query = $this->db->get();
				//  echo $this->db->last_query();
				if($query->num_rows() >0)
				{
				return $query->result_array();
				}
				else
				{
				//return false;
				}
	}
}


  
     function get_total_paid_by_sup_adj_id($sale_id){
	$this->db->select_sum('sale_pymnt_amount');
	$this->db->from('sale_payments');
		$this->db->where("sale_id", $sale_id);
		$this->db->where("sale_payment_type", "supplier_payment_adjustment");
	$query=$this->db->get();
//	echo $this->db->last_query();
	if($query->row()->sale_pymnt_amount){
		return $query->row()->sale_pymnt_amount;
	}else {
		return 0;
	}
  }
  
   function get_last_selling_price_by_product_id($product_id){
	$this->db->select('sale_items.*');
	$this->db->from('sale_items');
		$this->db->where("product_id", $product_id);
		$this->db->order_by("id", "desc");
	//	$this->db->where("sale_payment_type", "supplier_payment_adjustment");
	$query=$this->db->get();
//	echo $this->db->last_query();
	if($query->row()){
		return $query->row();
	}else {
		return 0;
	}
  }
  
  	function get_all_sales_for_manual_qury($start='',$length='',$search_key_val='',$srh_from_date='',$srh_to_date='',$srh_warehouse_id='',$srh_sales_rep_id='',$dep_id='',$sale_id='') {
		//echo "srh_warehouse_id:".count($srh_warehouse_id);
		$this->db->select('sales.*, customer.cus_name');
		$this->db->from('customer');
		$this->db->join('sales', 'sales.customer_id = customer.cus_id', 'left');
		
		//is_completed
		$this->db->where("sales.is_completed", 0);
		$this->db->order_by("sales.sale_id", "asc");
		$this->db->where("sales.sale_id IS NOT NULL");//("id !=",$id);
		if($srh_sales_rep_id){
			$this->db->where("sales.rep_id",$srh_sales_rep_id);
		}
		if($sale_id){
			$this->db->where("sales.sale_id",$sale_id);
		}
		if($search_key_val){
			//$this->db->where("sales.sale_reference_no LIKE '%$search_key_val%' OR customer.cus_name LIKE '%$search_key_val%'");
			$this->db->where("sales.warehouse_id = $srh_warehouse_id AND ( sales.sale_reference_no LIKE '%$search_key_val%' OR customer.cus_name LIKE '%$search_key_val%')");
		}
		if($srh_from_date){
			$srh_from_date=date('Y-m-d',strtotime($srh_from_date));
			$this->db->where("date(sales.sale_datetime) >=",$srh_from_date);
		}
		if($srh_to_date){
			$srh_to_date=date('Y-m-d',strtotime($srh_to_date));
			$this->db->where("date(sales.sale_datetime) <=",$srh_to_date);
		}
		if($srh_warehouse_id){
			$this->db->where_in("sales.warehouse_id",$srh_warehouse_id);
		}
		
		
		
	//	if($start!='' && $length!='')
		{
			if($length>0) $this->db->limit($length,$start);
		}
		
		//$this->db->order_by('sale_id','asc');
		
		$query = $this->db->get();
		echo $this->db->last_query();
		return $query->result_array();
	}
	
  
   function get_total_paid_cash_by_date_and_user_id($sel_date,$user_id,$acctrnss_id='',$sale_pymnt_paying_by='',$sale_pymnt_crdt_card_type=''){
       $sel_date = date('Y-m-d',strtotime($sel_date));
	$this->db->select_sum('sp.sale_pymnt_amount');
	$this->db->from('sale_payments sp');
	$this->db->join('sales s', 'sp.sale_id = s.sale_id', 'left');
	$this->db->where("s.acctrnss_id",$acctrnss_id);
	//$this->db->where("sp.sale_id",$sale_id)->where("(sp.sale_payment_type='sale' OR sp.sale_payment_type='pos_sale')");
	
	$this->db->where("sp.sale_payment_type","sale");
	//	$this->db->where("sp.user_id","1");
	if($sale_pymnt_paying_by){
		$this->db->where("sp.sale_pymnt_paying_by",$sale_pymnt_paying_by);
	}
	if($sale_pymnt_crdt_card_type){
		$this->db->where("sp.sale_pymnt_crdt_card_type",$sale_pymnt_crdt_card_type);
	}
			$this->db->where("date(sp.sale_pymnt_date_time)",$sel_date);
	$query=$this->db->get();
//	echo $this->db->last_query();
		return $query->row()->sale_pymnt_amount;
	
//	if($query->row()->sp.sale_pymnt_amount){
	//	return $query->row()->sp.sale_pymnt_amount;
//	}else {
	//	return 0;
//	}
  }
  
  function get_selected_date_invoice_and_total_paid_cash_by_date_and_user_id($sel_date,$user_id,$acctrnss_id='',$sale_pymnt_paying_by='',$sale_pymnt_crdt_card_type=''){
       $sel_date = date('Y-m-d',strtotime($sel_date));
	$this->db->select_sum('sp.sale_pymnt_amount');
	$this->db->from('sale_payments sp');
	$this->db->join('sales s', 'sp.sale_id = s.sale_id', 'left');
	$this->db->where("s.acctrnss_id",$acctrnss_id);
	//$this->db->where("sp.sale_id",$sale_id)->where("(sp.sale_payment_type='sale' OR sp.sale_payment_type='pos_sale')");
	
	$this->db->where("sp.sale_payment_type","sale");
	//	$this->db->where("sp.user_id","1");
	if($sale_pymnt_paying_by){
		$this->db->where("sp.sale_pymnt_paying_by",$sale_pymnt_paying_by);
	}
	if($sale_pymnt_crdt_card_type){
		$this->db->where("sp.sale_pymnt_crdt_card_type",$sale_pymnt_crdt_card_type);
	}
			$this->db->where("date(sp.sale_pymnt_added_date_time)",$sel_date);
			$this->db->where("date(s.sale_datetime)",$sel_date);
	$query=$this->db->get();
//	echo $this->db->last_query();
		return $query->row()->sale_pymnt_amount;
	
//	if($query->row()->sp.sale_pymnt_amount){
	//	return $query->row()->sp.sale_pymnt_amount;
//	}else {
	//	return 0;
//	}
  }
  
   function get_total_cash_service_shift($acctrnss_id='',$sale_pymnt_paying_by='',$sale_pymnt_crdt_card_type=''){
       $sel_date = date('Y-m-d',strtotime($sel_date));
	$this->db->select_sum('sp.sale_pymnt_amount');
	$this->db->from('sale_payments sp');
	//$this->db->join('sales s', 'sp.sale_id = s.sale_id', 'left');
	$this->db->where("sp.acctrnss_id_p",$acctrnss_id);
	//$this->db->where("sp.sale_id",$sale_id)->where("(sp.sale_payment_type='sale' OR sp.sale_payment_type='pos_sale')");
	
	//$this->db->where("sp.sale_payment_type","sale");
	//	$this->db->where("sp.user_id","1");
	if($sale_pymnt_paying_by){
		$this->db->where("sp.sale_pymnt_paying_by",$sale_pymnt_paying_by);
	}
	if($sale_pymnt_crdt_card_type){
		$this->db->where("sp.sale_payment_type",$sale_pymnt_crdt_card_type);
	}
		//	$this->db->where("date(sp.sale_pymnt_date_time)",$sel_date);
	$query=$this->db->get();
	//echo $this->db->last_query(); die();
		return $query->row()->sale_pymnt_amount;
	
//	if($query->row()->sp.sale_pymnt_amount){
	//	return $query->row()->sp.sale_pymnt_amount;
//	}else {
	//	return 0;
//	}
  }
  
     function get_total_cash_shift($acctrnss_id='',$sale_pymnt_paying_by='',$sale_pymnt_crdt_card_type=''){
       $sel_date = date('Y-m-d',strtotime($sel_date));
	$this->db->select_sum('sp.sale_pymnt_amount');
	$this->db->from('sale_payments sp');
	//$this->db->join('sales s', 'sp.sale_id = s.sale_id', 'left');
	$this->db->where("sp.acctrnss_id_p",$acctrnss_id);
	//$this->db->where("sp.sale_id",$sale_id)->where("(sp.sale_payment_type='sale' OR sp.sale_payment_type='pos_sale')");
	
	$this->db->where("sp.sale_payment_type","sale");
	//	$this->db->where("sp.user_id","1");
	if($sale_pymnt_paying_by){
		$this->db->where("sp.sale_pymnt_paying_by",$sale_pymnt_paying_by);
	}
	if($sale_pymnt_crdt_card_type){
		//$this->db->where("sp.sale_payment_type",$sale_pymnt_crdt_card_type);
	}
		//	$this->db->where("date(sp.sale_pymnt_date_time)",$sel_date);
	$query=$this->db->get();
	//echo $this->db->last_query(); die();
		return $query->row()->sale_pymnt_amount;
	
//	if($query->row()->sp.sale_pymnt_amount){
	//	return $query->row()->sp.sale_pymnt_amount;
//	}else {
	//	return 0;
//	}
  }
  
  
   function get_total_grn_payment_cash_shift($acctrnss_id='',$sale_pymnt_paying_by='',$sale_pymnt_crdt_card_type=''){
       $sel_date = date('Y-m-d',strtotime($sel_date));
	$this->db->select_sum('sp.sale_pymnt_amount');
	$this->db->from('sale_payments sp');
	//$this->db->join('sales s', 'sp.sale_id = s.sale_id', 'left');
	$this->db->where("sp.acctrnss_id_p",$acctrnss_id);
	//$this->db->where("sp.sale_id",$sale_id)->where("(sp.sale_payment_type='sale' OR sp.sale_payment_type='pos_sale')");
	
	$this->db->where("sp.sale_payment_type","grn");
	//	$this->db->where("sp.user_id","1");
	if($sale_pymnt_paying_by){
		$this->db->where("sp.sale_pymnt_paying_by",$sale_pymnt_paying_by);
	}
	if($sale_pymnt_crdt_card_type){
		$this->db->where("sp.sale_pymnt_crdt_card_type",$sale_pymnt_crdt_card_type);
	}
		//	$this->db->where("date(sp.sale_pymnt_date_time)",$sel_date);
	$query=$this->db->get();
	//echo $this->db->last_query();
		return $query->row()->sale_pymnt_amount;
	
//	if($query->row()->sp.sale_pymnt_amount){
	//	return $query->row()->sp.sale_pymnt_amount;
//	}else {
	//	return 0;
//	}
  }
  
   function get_total_cash_sales_return_shift($acctrnss_id='',$sale_pymnt_paying_by='',$sale_pymnt_crdt_card_type=''){
       $sel_date = date('Y-m-d',strtotime($sel_date));
	$this->db->select_sum('sp.sale_pymnt_amount');
	$this->db->from('sale_payments sp');
	//$this->db->join('sales s', 'sp.sale_id = s.sale_id', 'left');
	$this->db->where("sp.acctrnss_id_p",$acctrnss_id);
	//$this->db->where("sp.sale_id",$sale_id)->where("(sp.sale_payment_type='sale' OR sp.sale_payment_type='pos_sale')");
	
	$this->db->where("sp.sale_payment_type","sales_return");
	//	$this->db->where("sp.user_id","1");
	if($sale_pymnt_paying_by){
		$this->db->where("sp.sale_pymnt_paying_by",$sale_pymnt_paying_by);
	}
	if($sale_pymnt_crdt_card_type){
		$this->db->where("sp.sale_pymnt_crdt_card_type",$sale_pymnt_crdt_card_type);
	}
		//	$this->db->where("date(sp.sale_pymnt_date_time)",$sel_date);
	$query=$this->db->get();
//	echo $this->db->last_query();
		return $query->row()->sale_pymnt_amount;
	
//	if($query->row()->sp.sale_pymnt_amount){
	//	return $query->row()->sp.sale_pymnt_amount;
//	}else {
	//	return 0;
//	}
  }
   
   function get_total_exp_cash_by_date_and_user_id($acctrnss_id=''){
       
	$this->db->select_sum('e.exp_net_total');
	$this->db->from('expenses e');
//	$this->db->join('sales s', 'sp.sale_id = s.sale_id', 'left');
	$this->db->where("e.acctrnss_id",$acctrnss_id);
	//$this->db->where("sp.sale_id",$sale_id)->where("(sp.sale_payment_type='sale' OR sp.sale_payment_type='pos_sale')");
	
//	$this->db->where("sp.sale_payment_type","sale");
	//	$this->db->where("sp.user_id","1");
/*	if($sale_pymnt_paying_by){
		$this->db->where("sp.sale_pymnt_paying_by",$sale_pymnt_paying_by);
	}
	if($sale_pymnt_crdt_card_type){
		$this->db->where("sp.sale_pymnt_crdt_card_type",$sale_pymnt_crdt_card_type);
	}
			$this->db->where("date(sp.sale_pymnt_date_time)",$sel_date);
			*/
	$query=$this->db->get();
//	echo $this->db->last_query();
		return $query->row()->exp_net_total;
	
//	if($query->row()->sp.sale_pymnt_amount){
	//	return $query->row()->sp.sale_pymnt_amount;
//	}else {
	//	return 0;
//	}
  }
  
  function get_total_paid_by_service_id($sale_id){
	$this->db->select_sum('sale_pymnt_amount');
	$this->db->from('sale_payments');
	$this->db->where("sale_id",$sale_id)->where("(sale_payment_type='service')");
	$query=$this->db->get();
//	echo $this->db->last_query();
	if($query->row()->sale_pymnt_amount){
		return $query->row()->sale_pymnt_amount;
	}else {
		return 0;
	}
  }
  
	 function get_warranty_types() {
		$this->db->select('w.*');
		$this->db->from('warranty_types w');
		$this->db->where("w.w_status","1");//("id !=",$id);
		$query = $this->db->get();
	//	echo $this->db->last_query();
		return $query->result();
	}
	
	public function get_warranty_types_des_by_id($w_id)
	 {
		$this->db->select('*');
		$this->db->from('warranty_types');
		$this->db->where("w_id", $w_id);
		//$this->db->order_by("id", "desc");
		$query = $this->db->get();
		
		return $query->row_array(); 
	 }
  
    function get_all_bank() {
		$this->db->select('b.*');
		$this->db->from('mstr_bank b');
		//$this->db->join('mstr_country c', 's.country_id = c.country_id', 'left');
		//$this->db->join('mstr_city t', 's.supp_city = t.cid', 'left');
		//$this->db->order_by("s.supp_id", "desc");
		//$this->db->where("s.supp_status IS NOT NULL");//("id !=",$id);
		$query = $this->db->get();
		//echo $this->db->last_query();
		return $query->result();
	}
	
 function get_all_sales_return_for_summery_report($srh_warehouse_id='',$srh_to_date='',$srh_from_date='',$sale_id='',$from='',$to='',$srh_customer_id='') {
		//echo "<br/>Test".$srh_customer_id;
		$data = array();		

	$customers ='';	

		if($srh_customer_id)
		{
		$this->db->select('cus_id');
		$this->db->where('cus_type','normal');
		$this->db->where('cus_id',$srh_customer_id);
		$customers = $this->db->get('customer');
		}else
		{
		$this->db->select('cus_id');
		$this->db->where('cus_type','normal');
		$customers = $this->db->get('customer');
		}
		$customers = $customers->result_array();
		
		//print_r( $customers[0]['cus_id']);
		
		$i = 0;
		foreach( $customers as $row){
			
			$nestedData=array(); 
					$this->db->select('SUM(`sl_rtn_total`) AS sale_return_total, customer.cus_id');
					$this->db->from('sales_return');
					$this->db->join('customer','customer.cus_id = sales_return.customer_id');
					$this->db->where('customer_id',$customers[$i]['cus_id']);
					
				if($srh_warehouse_id){	
					$this->db->where("sales_return.warehouse_id",$srh_warehouse_id);//("id !=",$id);
				}
				
				if($srh_to_date){
					$srh_to_date = date('Y-m-d',strtotime($srh_to_date));
					$this->db->where("sales_return.sl_rtn_datetime <=",$srh_to_date);
			
				}
				if($srh_from_date){
					$srh_from_date = date('Y-m-d',strtotime($srh_from_date));
					$this->db->where("sales_return.sl_rtn_datetime >=",$srh_from_date);//("id !=",$id);
				}

					
					$query = $this->db->get();
		
			//		print_r($query->result_array());
					$query = $query->result_array();
					
					$nestedData['sale_rtn_total'] = $query[0]['sale_return_total'];
					$nestedData['cus_id'] = $query[0]['cus_id'];
					
					//print_r($query);
					
					$data[] = $nestedData;
			$i++;
//		return $query->result_array();
		}
		
		return $data;
	
	}

	function getPaymentsForView($srh_warehouse_id='',$srh_to_date='',$srh_from_date='',$srh_type='',$srh_payment_term='',$ss_user_id='',$srh_customer_id='')
   {
	   $warehouse_id='';
	   $this->db->select('sum(p.sale_pymnt_amount),b.*');
       $this->db->from('sale_payments p');
	   $this->db->join('sales b', 'b.sale_id = p.sale_id', 'left');
	   $this->db->join('warehouses w', 'w.id = b.warehouse_id', 'left');
	   $this->db->join('customer c', 'c.cus_id = b.customer_id', 'left');
		$this->db->where("p.sale_pymnt_paying_by != ","Cheque_Return");
	   	
	   if($srh_type){
	   
	   $this->db->where("p.sale_payment_type",$srh_type);//
	   }
	   if($srh_payment_term){
	   
	   $this->db->where("p.sale_pymnt_paying_by !=",$srh_payment_term);//
	   }
	if($srh_customer_id)
		{
		$this->db->where("b.warehouse_id =".$srh_warehouse_id." AND b.customer_id=".$srh_customer_id."" );//	   
		}
		else
		
		 if($srh_warehouse_id){
	   
	   $this->db->where("b.warehouse_id",$srh_warehouse_id);//
	   
	   }else{
	 	$this->session->userdata('ss_warehouse_id');
		$warehouse_id =	$this->session->userdata('ss_warehouse_id');
		
		$this->db->where("b.warehouse_id",$warehouse_id);

		}
		   
		   
	   $this->db->order_by("b.sale_id", "desc");
	  
	   $query = $this->db->get();
	   
     if($query->num_rows() >0)
     {
       return $query->result_array();
     }
     else
     {
       //return false;
     }

   }
   

 function get_all_sales_return_for_view($srh_warehouse_id='',$srh_to_date='',$srh_from_date='',$srh_customer_id='') {
	
		$query = $this->db->query('SELECT sum(sl_rtn_total) FROM sales_return WHERE customer_id = '.$srh_customer_id.' AND warehouse_id = '.$srh_warehouse_id.' ');

	//	echo $this->db->last_query();
		return $query->result_array();
	}
	
function get_all_sales_for_view($srh_warehouse_id='',$srh_customer_id='') {

$query = $this->db->query('SELECT sum(sale_total) FROM sales WHERE customer_id = '.$srh_customer_id.' AND warehouse_id = '.$srh_warehouse_id.' ');


//		$query = $this->db->get();
	
	
	
		//echo $this->db->last_query();
		return $query->result_array();
	}	
	
	
function get_products_suggestions_get_by_warehouse_id($term,$srh_warehouse_id='',$service_item_avalable='')

 {

	    $this->db->select('p.*,i.*');
		$this->db->from('purchase_items_serial i');
		$this->db->join('product p', 'p.product_id = i.product_id', 'left');
		$this->db->order_by("p.product_name", "asc");
		$this->db->group_by('p.product_id');
		$cat_query='';
		
		//echo "service_item_avalable:$service_item_avalable";
		
		if($srh_warehouse_id){
			//$cat_query="AND i.avalable_warehouse_id='$srh_warehouse_id' AND avalable_location_id='0'";
		}
		
		if($service_item_avalable=='Showroom'){
			$cat_query.="AND i.product_avalable='1'";
		}
		if($service_item_avalable=='Customer'){
			$cat_query.="AND i.product_avalable='0'";
		}
		
	//	$sql="(i.pis_number LIKE '%$term%' OR p.product_name LIKE '%$term%' OR p.product_code LIKE '%$term%' OR p.product_oem_part_number LIKE '%$term%' OR p.product_part_no LIKE '%$term%') AND p.product_sn_exissts='1' $cat_query";
	
	
		$sql="(i.pis_number LIKE '%$term%' OR p.product_name LIKE '%$term%') AND p.product_sn_exissts='1' $cat_query";
		
		
		//echo $sql;
		$this->db->where($sql);

		$this->db->limit(100, 0);
		$query = $this->db->get();
		//echo $this->db->last_query();
		return $query->result_array();

	}	
	
	
	function get_products_list_suggestions_get_by_warehouse_id($term,$srh_warehouse_id='',$service_item_avalable='')

 {

	    $this->db->select('p.*');
		$this->db->from('product p');
		
		$this->db->order_by("p.product_name", "asc");
		$this->db->group_by('p.product_id');
		$cat_query='';
		
		$sql="(p.product_name LIKE '%$term%' OR p.product_code LIKE '%$term%' OR p.product_oem_part_number LIKE '%$term%' OR p.product_part_no LIKE '%$term%') $cat_query";
		
		
		
	
		
		//$sql="(i.pis_number LIKE '%$term%' OR p.product_name LIKE '%$term%' OR p.product_code LIKE '%$term%' OR p.product_oem_part_number LIKE '%$term%' OR p.product_part_no LIKE '%$term%') AND p.product_sn_exissts='1' $cat_query";
		
		//echo $sql;
		$this->db->where($sql);

		$this->db->limit(50, 0);
		$query = $this->db->get();
		return $query->result_array();

	}
	
	function get_products_list_suggestions_get_by_warehouse_id_2($term,$srh_warehouse_id='',$cat_srh='',$subcategory='')

 {
	 
	// echo "subcategory:$subcategory";

	    $this->db->select('p.*');
		$this->db->from('product p');
		
		$this->db->order_by("p.product_name", "asc");
		$this->db->group_by('p.product_id');
		$cat_query='';
		
		//$sql="(p.product_name LIKE '%$term%' OR p.product_code LIKE '%$term%' OR p.product_oem_part_number LIKE '%$term%' OR p.product_part_no LIKE '%$term%') $cat_query";
		
		
		
	
		
		//$sql="(i.pis_number LIKE '%$term%' OR p.product_name LIKE '%$term%' OR p.product_code LIKE '%$term%' OR p.product_oem_part_number LIKE '%$term%' OR p.product_part_no LIKE '%$term%') AND p.product_sn_exissts='1' $cat_query";
		
		//echo $sql;
		$cat_query='';
		if($cat_srh){
			$cat_query="AND cat_id='$cat_srh'";
		}
		if($subcategory){
			$cat_query=$cat_query."AND sub_cat_id='$subcategory'";
		}
		
		$sql="(p.product_name LIKE '%$term%' OR p.product_code LIKE '%$term%' OR p.product_oem_part_number LIKE '%$term%' OR p.product_part_no LIKE '%$term%') $cat_query";

		$this->db->where($sql);

		$this->db->limit(50, 0);
		$query = $this->db->get();
		//echo $this->db->last_query();
		return $query->result_array();

	}
	
	
	function get_products_list_suggestions_get_by_warehouse_id_3($term,$srh_warehouse_id='',$cat_srh='',$subcategory='')

 {
	 
	// echo "subcategory:$subcategory";

	    $this->db->select('p.*');
		$this->db->from('product p');
		
		$this->db->order_by("p.product_name", "asc");
		$this->db->group_by('p.product_id');
		$cat_query='';
		
		//$sql="(p.product_name LIKE '%$term%' OR p.product_code LIKE '%$term%' OR p.product_oem_part_number LIKE '%$term%' OR p.product_part_no LIKE '%$term%') $cat_query";
		
		
		
	
		
		//$sql="(i.pis_number LIKE '%$term%' OR p.product_name LIKE '%$term%' OR p.product_code LIKE '%$term%' OR p.product_oem_part_number LIKE '%$term%' OR p.product_part_no LIKE '%$term%') AND p.product_sn_exissts='1' $cat_query";
		
		//echo $sql;
		$cat_query='p.product_status=1';
		if($cat_srh){
			$cat_query="AND cat_id='$cat_srh'";
		}
		if($subcategory){
			$cat_query=$cat_query."AND sub_cat_id='$subcategory'";
		}
		
		$q_where='';
		 /* serch + */
		        $pizza  = $term;
     $pieces = explode("+", $pizza);
     //print_r($pieces);
     for($i=0; $i<count($pieces); $i++){
        // echo ', key:'.$pieces[$i];
        $searh_key=$pieces[$i];
        //$this->db->like('p.product_name',$searh_key); 
       // if($i!=0)
       if($q_where)
        {
            $q_where.=" AND "; 
        }
        $q_where.="p.product_name LIKE '%$searh_key%'";
        $q_where.=" OR p.product_id LIKE '%$searh_key%'";
        //$q_where.="p.product_id LIKE '%$searh_key%'";
     }
		   /* end search + */
		
	//	$sql="(p.product_name LIKE '%$term%' OR p.product_code LIKE '%$term%' OR p.product_oem_part_number LIKE '%$term%' OR p.product_part_no LIKE '%$term%' $q_where) $cat_query ";
	
	$sql=$q_where;

		$this->db->where($sql);

		$this->db->limit(50, 0);
		$query = $this->db->get();
	//	echo $this->db->last_query();
		return $query->result_array();

	}
	
		
	function get_all_sales_for_summery_report($srh_warehouse_id='',$srh_to_date='',$srh_from_date='',$sale_id='',$from='',$to='',$srh_customer_id='') {
		//echo "<br/>Test".$srh_customer_id;
		$data = array();		

	$customers ='';	

if($srh_customer_id)
		{
		$this->db->select('cus_id');
		$this->db->where('cus_type','normal');
		$this->db->where('cus_id',$srh_customer_id);
		$this->db->order_by("cus_name", "asc");
		$customers = $this->db->get('customer');
		}else
		{
		$this->db->select('cus_id');
		$this->db->where('cus_type','normal');
		$this->db->order_by("cus_name", "asc");
		$customers = $this->db->get('customer');
		}
		$customers = $customers->result_array();
		
		//print_r( $customers[0]['cus_id']);
		
		$i = 0;
		foreach( $customers as $row){
			
			$nestedData=array(); 
					$this->db->select('SUM(`sale_total`) AS sale_total, customer.cus_id, customer.cus_name,customer.cus_code,sales.rep_id');
					$this->db->from('sales');
					$this->db->join('customer','customer.cus_id = sales.customer_id');
					$this->db->where('customer_id',$customers[$i]['cus_id']);
					
				if($srh_warehouse_id){	
					$this->db->where("sales.warehouse_id",$srh_warehouse_id);//("id !=",$id);
				}
				
				if($srh_to_date){
					$srh_to_date = date('Y-m-d',strtotime($srh_to_date));
					$this->db->where("sales.sale_datetime <=",$srh_to_date);
			
				}
				if($srh_from_date){
					$srh_from_date = date('Y-m-d',strtotime($srh_from_date));
					$this->db->where("sales.sale_datetime >=",$srh_from_date);//("id !=",$id);
				}

					
					$query = $this->db->get();
		
			//		print_r($query->result_array());
					$query = $query->result_array();
					
					$nestedData['cus_id'] = $query[0]['cus_id'];
					$nestedData['sale_total'] = $query[0]['sale_total'];
					$nestedData['cus_name'] = $query[0]['cus_name'];
					$nestedData['cus_code'] = $query[0]['cus_code'];
					
					//print_r($query);
					
					$data[] = $nestedData;
			$i++;
//		return $query->result_array();
		}
		
		return $data;
	
	}	
	public function get_last_sale_date($cus_id){
		$this->db->select('MAX(sale_datetime) AS sdt');
		$this->db->where('customer_id',$cus_id);
		$query = $this->db->get('sales');
		$query = $query->row_array();
		$sdt   = $query['sdt'];
		$sdt = date('Y/m/d',strtotime($sdt));
		return $sdt;
		}
		
		function getPaymentsForBalance($srh_warehouse_id='',$srh_to_date='',$srh_from_date='',$srh_type='',$srh_payment_term='',$ss_user_id='',$srh_customer_id='')
   {
	   $warehouse_id='';
	    $sel='p.*,c.cus_name,b.*';
	   if($ss_user_id) $sel.=',u.user_first_name';
	   $this->db->select($sel);
       $this->db->from('sale_payments p');
	   $this->db->join('sales b', 'b.sale_id = p.sale_id', 'left');
	   $this->db->join('warehouses w', 'w.id = b.warehouse_id', 'left');
	   $this->db->join('customer c', 'c.cus_id = b.customer_id', 'left');
	   $this->db->where('sale_pymnt_paying_by !=','Cheque_Return');
	    if($ss_user_id) $this->db->join('user u', 'u.user_id = p.user_id', 'left');

		
		
		
		if($srh_from_date){

			$this->db->where("p.sale_pymnt_added_date_time >=",$srh_from_date);//("id !=",$id);
		}
		
		
		if($srh_to_date){
			
			$srh_to_date=date('Y-m-d',strtotime($srh_to_date));
			
			$this->db->where("p.sale_pymnt_added_date_time <=",$srh_to_date);//("id !=",$id);
		}
		
	   if($srh_type){
	   
	   $this->db->where("p.sale_payment_type",$srh_type);//
	   }
	   if($srh_payment_term){
	   
	   $this->db->where("p.sale_pymnt_paying_by",$srh_payment_term);//
	   }
	    if($ss_user_id){
	   
	   $this->db->where("p.user_id",$ss_user_id);//
	   }
	   
	if($srh_customer_id)
		{
		$this->db->where("b.warehouse_id =".$srh_warehouse_id." AND b.customer_id=".$srh_customer_id."" );//	   
		}
		else
		
		 if($srh_warehouse_id){
	   
	   $this->db->where("b.warehouse_id",$srh_warehouse_id);//
	   
	   }else{
	 	$this->session->userdata('ss_warehouse_id');
		$warehouse_id =	$this->session->userdata('ss_warehouse_id');
		
//		echo $warehouse_id;
		$this->db->where("b.warehouse_id",$warehouse_id);
		//		echo "INN";
		}
		   
		   
	   /*
	   if($srh_to_date){
			$this->db->where("p.sale_pymnt_added_date_time <=",$srh_to_date);//("id !=",$id);
		}
		if($srh_from_date){
			$this->db->where("p.sale_pymnt_added_date_time >=",$srh_from_date);//("id !=",$id);
		}*/
	   $this->db->order_by("b.sale_id", "desc");
	  
	   $query = $this->db->get();
	   // echo $this->db->last_query();
     if($query->num_rows() >0)
     {
       return $query->result();
     }
     else
     {
       //return false;
     }

   }
    
   public function get_sales_serial_by_id($sale_id='',$sale_item_id='')
  {
     $this->db->select('*');
     $this->db->from('sale_items_serial');
     $this->db->where('sale_items_serial.sale_id',$sale_id);
	  $this->db->where('sale_items_serial.sale_item_id',$sale_item_id);
     $query = $this->db->get();
     if($query->num_rows() >0)
     {
       return $query->result();
     }
     else
     {
       return false;
     }
  }
  
  	//save sale serial numbers
	function save_sale_serial_numbers($data_item)
	{
		$this->db->insert('sale_items_serial',$data_item);
	}
	function update_sale_serial_numbers($data_item,$pis_number)
	{
		$this->db->where('sis_number', $pis_number);
		return $this->db->update('sale_items_serial',$data_item);
	}
  
 	 	//get Sold Qty By WarehouseId
	public function getSoldQtyByWarehouseId($warehouse_id,$product_id,$srh_from_date='',$srh_to_date='',$search_key_val='',$cat_srh='')
	{
		$this->db->select_sum('si.quantity');
		$this->db->from('sale_items si');
		$this->db->join('sales s', 's.sale_id = si.sale_id', 'left');
		$this->db->join('product p','si.product_id = p.product_id');
//		$this->db->where('s.warehouse_id',$warehouse_id);
		$this->db->join("product_category pc", "p.cat_id = pc.cat_id", "left");
	  if($cat_srh){
	  $this->db->where("pc.cat_name",$cat_srh);
	  }
	  if($warehouse_id){
		$this->db->where('s.warehouse_id',$warehouse_id);
		}
		
		if($product_id)
		$this->db->where('si.product_id',$product_id);
		
		if($search_key_val){
			 $this->db->where("p.product_code LIKE '%$search_key_val%'","left");
		}
		
		if($srh_to_date){
			$srh_to_date=date('Y-m-d',strtotime($srh_to_date . ""));
			$this->db->where("date(s.sale_datetime) <=",$srh_to_date);//("id !=",$id);
		}
		if($srh_from_date){
			$this->db->where("date(s.sale_datetime) >=",$srh_from_date);//("id !=",$id);
		}
		$query=$this->db->get();
		//echo $this->db->last_query();
		//print_r($query->result());
		if($query->num_rows() >0)
     {
       return $data['quantity']=$query->row()->quantity;
     }
     else
     {
       return 0;
     }
	 
		
	}
	
	public function get_cus_tot_credit($cus_id)
	{
		$this->db->select_sum('s.sale_total');
		$this->db->from('sales s');
		//$this->db->join('sales s', 's.sale_id = si.sale_id', 'left');
		$this->db->where('s.customer_id',$cus_id);
		
		$query=$this->db->get();
		return $query->row()->sale_total;
	}	

	public function get_cus_paid_amount($cus_id)
	{
		$this->db->select_sum('sp.sale_pymnt_amount');
		$this->db->from('sales s');
		$this->db->join('sale_payments sp', 's.sale_id = s.sale_id', 'left');
		$this->db->where('s.customer_id',$cus_id);
		$this->db->where('sp.sale_payment_type','sale');
		
		$query=$this->db->get();
		return $query->row()->sale_pymnt_amount;
	}
	
	public function get_cus_return_amount($cus_id)
	{
		$this->db->select_sum('sp.sale_pymnt_amount');
		$this->db->from('sales s');
		$this->db->join('sale_payments sp', 's.sale_id = s.sale_id', 'left');
		$this->db->where('s.customer_id',$cus_id);
		$this->db->where('sp.sale_payment_type','sales_return');
		
		$query=$this->db->get();
		return $query->row()->sale_pymnt_amount;
	}	
	
function get_all_sales_return_for_report($srh_warehouse_id='',$srh_to_date='',$srh_from_date='',$sale_id='',$from='',$to='',$srh_rep_id='') {
		$this->db->select('sr.* , c.cus_name ,SUM(p.sale_pymnt_amount) AS total_paid_amount');
		$this->db->from('sales_return sr');
		$this->db->join('customer c', 'sr.customer_id = c.cus_id', 'left');
		$this->db->join('sale_payments p', 'sr.sl_rtn_id = p.sale_id', 'left');
		$this->db->where("p.sale_payment_type",'sales_return');
		
		//$this->db->join('sales_return sr', 'sr.sale_id = p.sale_id', 'left');
		$this->db->order_by("sr.sl_rtn_id", "desc");
		$this->db->group_by('sr.sl_rtn_id');
		//if($srh_rep_id){
			//$this->db->where("p.sale_payment_type",$srh_rep_id);
	//	}
		if($srh_warehouse_id){
			$this->db->where("sr.warehouse_id",$srh_warehouse_id);//("id !=",$id);
		}
		if($srh_to_date){
			$this->db->where("date(sr.sl_rtn_datetime) <=",$srh_to_date);//("id !=",$id);
		}
		if($srh_from_date){
			$this->db->where("date(sr.sl_rtn_datetime) >=",$srh_from_date);//("id !=",$id);
		}
		//if($sl_rtn_id){
			//$this->db->where("sr.sl_rtn_id =",$sl_rtn_id);//("id !=",$id);
	//	}
		if($to){
		$this->db->limit($to,$from);
		}
		$query = $this->db->get();
		//echo $this->db->last_query();
		return $query->result_array();
	}	
	
	
		     //Sales get information
	public function get_sale_info_by_customer_id($id)
	 {
		$this->db->select('*');
		$this->db->from('sales');
		$this->db->where("customer_id", $id);
		$this->db->order_by("sale_id", "desc");
		$query = $this->db->get();
		return $query->result(); 
	 }
	 
	 
 function getPaymentsForPrint($srh_warehouse_id='',$srh_to_date='',$srh_from_date='',$srh_type='',$srh_payment_term='')
   {
	   $this->db->select('p.*,c.cus_name,b.sale_total,b.sale_reference_no,u.user_first_name,b.sale_datetime');
       $this->db->from('sale_payments p');
	   $this->db->join('sales b', 'b.sale_id = p.sale_id', 'left');
	   $this->db->join('warehouses w', 'w.id = b.warehouse_id', 'left');
	   $this->db->join('customer c', 'c.cus_id = b.customer_id', 'left');
	    $this->db->join('user u', 'u.user_id = p.user_id', 'left');
	
		
	   if($srh_type){
	   
	   //$this->db->where("p.sale_payment_type",$srh_type);//
	   }
	   $this->db->where("p.sale_payment_type",'sale');
	   if($srh_payment_term){
	   
	   $this->db->where("p.sale_pymnt_paying_by",$srh_payment_term);//
	   }
	   if($srh_warehouse_id){
	   
	   $this->db->where("b.warehouse_id",$srh_warehouse_id);//
	   }
	   if($srh_to_date){
			//$this->db->where("p.sale_pymnt_date_time <=",$srh_to_date);//("id !=",$id);
			$this->db->where("date(p.sale_pymnt_added_date_time) <=",$srh_to_date);//("id !=",$id);
			
		}
		if($srh_from_date){
		    //	$this->db->where("p.sale_pymnt_date_time >=",$srh_from_date);//("id !=",$id);
		    $this->db->where("date(p.sale_pymnt_added_date_time) >=",$srh_from_date);//("id !=",$id);
		}
	   $this->db->order_by("b.sale_id", "desc");
	  
	   $query = $this->db->get();
	   
	  // echo "111 , ";
	   // echo $this->db->last_query();
     if($query->num_rows() >0)
     {
        // echo "2222 , ";
       // print_r($query->result());
       return $query->result();
     }
     else
     {
       return array();
     }

   }	
	  
   //Sales best for dashboard
   function getBestSales($year=null,$month=0,$from=0,$to=0){
	$this->db->select('SUM(ft.fi_qty)AS fi_qty_tot,p.product_name,p.product_code,p.product_part_no,p.product_oem_part_number');
	$this->db->from('fi_table ft');
	$this->db->join('product p', 'ft.fi_item_id = p.product_id', 'left');
	$this->db->where('ft.fi_type_id', 'sale');
	if($month){
		//$this->db->where('MONTH(ft.fi_date_time)', $month , FALSE);
	}
	if($year){
		//$this->db->where('YEAR(ft.fi_date_time)', $year , FALSE);
	}
	//if($to)
	{
		$this->db->limit(10,0);
	}
	$this->db->order_by("fi_qty_tot", "desc");
	$this->db->group_by('ft.fi_item_id');
	$query=$this->db->get();
	return $query->result();
  }  
  
  //Sales genarate referance number
  function get_next_ref_no(){
	  $this->db->select_max('sale_id');
	  return $this->db->get('sales');
  }
 
  //Sales get avalable product qty
  function get_avalable_product_qty($product_id,$warehouse_id){
		$this->db->select_sum('fi_qty');
		$query = $this->db->get('fi_table');
		return $query->row()->fi_qty;
  }
  
  //Sales get toatal paid 
  function get_total_paid_by_sale_id($sale_id){
	$this->db->select_sum('sale_pymnt_amount');
	$this->db->from('sale_payments');
	$this->db->where("sale_id",$sale_id)->where("(sale_payment_type='sale' OR sale_payment_type='pos_sale')");
	$query=$this->db->get();
	//echo $this->db->last_query();
	if($query->row()->sale_pymnt_amount){
		return $query->row()->sale_pymnt_amount;
	}else {
		return 0;
	}
  }
  
  
  function get_total_paid_by_sale_return_id($sale_id){
	$this->db->select_sum('sale_pymnt_amount');
	$this->db->from('sale_payments');
	$this->db->where("sale_id",$sale_id)->where("(sale_payment_type='sales_return')");
	$query=$this->db->get();
	//echo $this->db->last_query();
	if($query->row()->sale_pymnt_amount){
		return $query->row()->sale_pymnt_amount;
	}else {
		return 0;
	}
  }
  
  
  //get total daily credit
  function get_total_sale_paid_by_acctrnss_id($acctrnss_id){
//	$this->db->select_sum('sale_total');
	$this->db->select_sum('sp.sale_pymnt_amount');
	$this->db->from('sales s');//sale_payments
		$this->db->join('sale_payments sp', 's.sale_id = sp.sale_id', 'left');
	
	$this->db->where("s.acctrnss_id",$acctrnss_id);
	$query=$this->db->get();
	//echo $this->db->last_query();
	if($query->row()->sale_pymnt_amount){
		return $query->row()->sale_pymnt_amount;
	}else {
		return 0;
	}
  }
  
  function get_total_sale_by_acctrnss_id($acctrnss_id){
	$this->db->select_sum('sale_total');
	$this->db->from('sales');
	$this->db->where("acctrnss_id",$acctrnss_id);
	$query=$this->db->get();
	//echo $this->db->last_query();
	if($query->row()->sale_total){
		return $query->row()->sale_total;
	}else {
		return 0;
	}
  }
  
  
  
    function get_total_interest_by_sale_id($sale_id){
	$this->db->select_sum('si_amount');
	$this->db->from('sale_interest');
	$this->db->where("sale_id",$sale_id);
	$query=$this->db->get();
	//echo $this->db->last_query();
	if($query->row()->si_amount){
		return $query->row()->si_amount;
	}else {
		return 0;
	}
  }
  
  //get returned qty by sale_id and product id
  function get_returned_qty_by_sale_id_and_product_id($sale_id,$product_id){
	$this->db->select_sum('sri.quantity');
	$this->db->from('sales_return_items sri');
	$this->db->join('sales_return sr', 'sr.sl_rtn_id = sri.sl_rtn_id', 'left');
	$this->db->where("sr.sale_id",$sale_id);
	$this->db->where("sri.product_id",$product_id);
	$query=$this->db->get();
	//echo $this->db->last_query();
	if($query->row()){
		return $query->row();
	}else {
		return 0;
	}
  }
  
  
  function get_returned_by_sale_id_and_product_id($sl_rtn_id){
	$this->db->select('sr.sl_rtn_total');
	$this->db->where("sr.sl_rtn_id",$sl_rtn_id);
	$this->db->from('sales_return sr');
	//$this->db->where("sri.product_id",$product_id);
	$query=$this->db->get();
	//echo $this->db->last_query(); die();
	if($query->num_rows()==1){
		return $query->row()->sl_rtn_total;
	}else {
		return 0;
	}
  }
  
  
  
    function get_total_paid_by_grn_id($sale_id){
	$this->db->select_sum('sale_pymnt_amount');
	$this->db->from('sale_payments');
	$this->db->where("sale_id",$sale_id)->where("(sale_payment_type='grn')");
	$query=$this->db->get();
	//echo $this->db->last_query();
	if($query->row()->sale_pymnt_amount){
		return $query->row()->sale_pymnt_amount;
	}else {
		return 0;
	}
  }
  
  function get_total_paid_by_grn_return_id_and_smp_id($smp_id){
	$this->db->select_sum('sale_pymnt_amount');
	$this->db->from('sale_payments');
		$this->db->where("smp_id", $smp_id);
		$this->db->where("sale_payment_type", "grn_return");
	$query=$this->db->get();
//	echo $this->db->last_query();
	if($query->row()->sale_pymnt_amount){
		return $query->row()->sale_pymnt_amount;
	}else {
		return 0;
	}
  }
  
  
  function get_service_payment($sale_id,$sale_payment_type=''){
	$this->db->select_sum('sale_pymnt_amount');
	$this->db->from('sale_payments');
	$this->db->where("sale_id", $sale_id);
	$this->db->where("sale_payment_type", $sale_payment_type);
	$query=$this->db->get();
	if($query->row()->sale_pymnt_amount){
		return $query->row()->sale_pymnt_amount;
	}else {
		return 0;
	}
  }
  
    function get_total_paid_by_grn_return_id($sale_id){
	$this->db->select_sum('sale_pymnt_amount');
	$this->db->from('sale_payments');
		$this->db->where("sale_id", $sale_id);
		$this->db->where("sale_payment_type", "grn_return");
	$query=$this->db->get();
//	echo $this->db->last_query();
	if($query->row()->sale_pymnt_amount){
		return $query->row()->sale_pymnt_amount;
	}else {
		return 0;
	}
  }
  
    //Sales get information
	public function get_sale_info($id)
	 {
		$this->db->select('*');
		$this->db->from('sales');
		$this->db->where("sale_id", $id);
		$this->db->order_by("sale_id", "desc");
		$query = $this->db->get();
		return $query->row_array(); 
	 }
	 
	 	public function get_sale_info_by_sale_id($service_id)
	 {
		$this->db->select('*');
		$this->db->from('sales');
		$this->db->where("service_id", $service_id);
		$this->db->order_by("sale_id", "desc");
		$query = $this->db->get();
		return $query->row_array(); 
	 }
	 
	//Sales item list get by id 
	public function get_sale_item_list_by_sale_id($sale_id)
	 {
		$this->db->select('sale_items.*, product.*, product.product_sn_exissts, product.product_code,product.product_part_no,product.product_oem_part_number');
		$this->db->from('sale_items');
		$this->db->join('product', 'sale_items.product_id = product.product_id', 'left');
		$this->db->order_by("sale_items.id", "asc");
		$this->db->where("sale_items.sale_id", $sale_id);//("id !=",$id);
		$query = $this->db->get();
		return $query->result_array();
		
	 }
	 

	 
public function check_serial_no_valid($sn='',$product_id='')
  {
     $this->db->select('*');
     $this->db->from('purchase_items_serial');
     $this->db->where('pis_number',$sn);
	 // $this->db->where('pis_sold',0);
	 // $this->db->where('product_id',$product_id);
     $query = $this->db->get();
	// echo $this->db->last_query();
       return $query->result();
  }
  
  
  public function get_serial_no_details($sn='')
  {
     $this->db->select('sis.*,s.*');
     $this->db->from('sale_items_serial sis');
	 $this->db->join('sale_items si', 'sis.sale_item_id = si.id', 'left');
	 $this->db->join('sales s', 's.sale_id = si.sale_id', 'left');
     $this->db->where('sis.sis_number',$sn);
	 // $this->db->where('pis_sold',0);
     $query = $this->db->get();
	// echo $this->db->last_query();
       return $query->result();
  }


  public function get_service_invocie_no_details($sale_id='',$product_id='')
  {
     $this->db->select('si.*,s.*');
     $this->db->from('sale_items si');
	// $this->db->join('sale_items si', 'sis.sale_item_id = si.id', 'left');
	 $this->db->join('sales s', 's.sale_id = si.sale_id', 'left');
     $this->db->where('s.sale_id',$sale_id);
	 $this->db->where('si.product_id',$product_id);
	 // $this->db->where('pis_sold',0);
     $query = $this->db->get();
	 //echo $this->db->last_query();
       return $query->result();
  }
    
  
  public function purchase_check_serial_no_valid($sn='')
  {
     $this->db->select('*');
     $this->db->from('purchase_items_serial');
     $this->db->where('pis_number',$sn);
	 // $this->db->where('pis_sold',0);
     $query = $this->db->get();
	// echo $this->db->last_query();
       return $query->result();
  }

	//Sales save
	function save_sales(&$supplier_data,$sale_id=false)
	{
		if (!$sale_id)
		{
			$this->db->insert($this->tableName,$supplier_data);
		}else {
			$this->db->where('sale_id', $sale_id);
			return $this->db->update($this->tableName,$supplier_data);
		}
	}	
	
	//Sales item save
	function save_sales_item(&$data_item)
	{
			$this->db->insert('sale_items',$data_item);
	}	

	//Sales get for report
	function get_all_sales_for_report($srh_warehouse_id='',$srh_to_date='',$srh_from_date='',$sale_id='',$from='',$to='',$srh_customer_id='',$srh_sales_rep_id='') {
		
		
		//echo "<br/>Test".$srh_customer_id;
		$this->db->select('s.cost_total,s.sale_total,s.sale_id,s.sale_datetime,s.sale_reference_no , c.cus_name ,SUM(p.sale_pymnt_amount) AS total_paid_amount,s.service_id');
		$this->db->from('sales s');
		$this->db->join('customer c', 's.customer_id = c.cus_id', 'left');
		$this->db->join('user u', 'u.user_id = s.rep_id', 'left');
		$this->db->join('sale_payments p', 's.sale_id = p.sale_id', 'left');
		$this->db->order_by("s.sale_id", "desc");
		$this->db->group_by('s.sale_id');
		//$this->db->where("p.sale_payment_type",'sale');
		if($srh_warehouse_id){
			$this->db->where("s.warehouse_id",$srh_warehouse_id);//("id !=",$id);
		}
		if($srh_to_date){
			$this->db->where("date(s.sale_datetime) <=",$srh_to_date);//("id !=",$id);
		}
		if($srh_from_date){
			$this->db->where("date(s.sale_datetime) >=",$srh_from_date);//("id !=",$id);
		}
		if($sale_id){
			$this->db->where("s.sale_id =",$sale_id);//("id !=",$id);
		}
		if($srh_customer_id){
			$this->db->where("s.customer_id",$srh_customer_id);//("id !=",$id);
		}
		if($srh_sales_rep_id){
			$this->db->where("s.rep_id",$srh_sales_rep_id);//("id !=",$id);
		}
		if($to){
		$this->db->limit($to,$from);
		}
		$query = $this->db->get();
		
	//	echo $this->db->last_query();
		return $query->result_array();
	}
	
	
	function get_sales_assistant_wise_sales_summary($srh_warehouse_id='',$srh_to_date='',$srh_from_date='',$sale_id='',$from='',$to='',$srh_customer_id='',$srh_sales_rep_id='') {
		
		
		//echo "<br/>Test".$srh_customer_id;
		$this->db->select('s.cost_total,s.sale_total,s.sale_id,s.sale_datetime,s.sale_reference_no , c.cus_name ,SUM(p.sale_pymnt_amount) AS total_paid_amount,s.rep_id');
		$this->db->from('sales s');
		$this->db->join('customer c', 's.customer_id = c.cus_id', 'left');
		$this->db->join('user u', 'u.user_id = s.rep_id', 'left');
		$this->db->join('sale_payments p', 's.sale_id = p.sale_id', 'left');
		$this->db->order_by("s.sale_id", "desc");
		$this->db->group_by('s.sale_id');
		//$this->db->where("p.sale_payment_type",'sale');
		if($srh_warehouse_id){
			$this->db->where("s.warehouse_id",$srh_warehouse_id);//("id !=",$id);
		}
		if($srh_to_date){
			$this->db->where("date(s.sale_datetime) <=",$srh_to_date);//("id !=",$id);
		}
		if($srh_from_date){
			$this->db->where("date(s.sale_datetime) >=",$srh_from_date);//("id !=",$id);
		}
		if($sale_id){
			$this->db->where("s.sale_id =",$sale_id);//("id !=",$id);
		}
		if($srh_customer_id){
			$this->db->where("s.customer_id",$srh_customer_id);//("id !=",$id);
		}
		if($srh_sales_rep_id){
			$this->db->where("s.rep_id",$srh_sales_rep_id);//("id !=",$id);
		}
		if($to){
		$this->db->limit($to,$from);
		}
		$query = $this->db->get();
		
		//echo $this->db->last_query();
		return $query->result_array();
	}
	
	
	function get_all_sales_for_rep_com_report($srh_warehouse_id='',$srh_to_date='',$srh_from_date='',$sale_id='',$from='',$to='',$srh_customer_id='',$srh_sales_rep_id='') {
		
		//echo "<br/>Test".$srh_customer_id;
		$this->db->select('s.* , c.cus_name ,p.sale_pymnt_date_time ,p.sale_pymnt_amount');
		$this->db->from('sale_payments p');
		$this->db->join('sales s', 's.sale_id = p.sale_id', 'left');
		$this->db->join('customer c', 's.customer_id = c.cus_id', 'left');
		$this->db->join('user u', 'u.user_id = s.rep_id', 'left');
		//$this->db->join('sale_payments p', 's.sale_id = p.sale_id', 'left');
		
		$this->db->order_by("s.sale_id", "desc");
		//$this->db->group_by('s.sale_id');
		//$this->db->where("p.sale_payment_type",'sale');
		if($srh_warehouse_id){
			$this->db->where("s.warehouse_id",$srh_warehouse_id);//("id !=",$id);
		}
		if($srh_to_date){
			$this->db->where("s.sale_datetime <=",$srh_to_date);//("id !=",$id);
		}
		if($srh_from_date){
			$this->db->where("s.sale_datetime >=",$srh_from_date);//("id !=",$id);
		}
		if($sale_id){
			$this->db->where("s.sale_id =",$sale_id);//("id !=",$id);
		}
		if($srh_customer_id){
			$this->db->where("s.customer_id",$srh_customer_id);//("id !=",$id);
		}
		if($srh_sales_rep_id){
			$this->db->where("s.rep_id",$srh_sales_rep_id);//("id !=",$id);
		}
		if($to){
		//$this->db->limit($to,$from);
		}
		$query = $this->db->get();
		
		//echo $this->db->last_query();
		return $query->result_array();
	}	
	
	//Sales all get
	function get_all_sales($start='',$length='',$search_key_val='',$srh_from_date='',$srh_to_date='',$srh_warehouse_id='',$srh_sales_rep_id='',$dep_id='',$search_key1='') {
		//echo "srh_warehouse_id:".count($srh_warehouse_id);
		$this->db->select('sales.*, customer.cus_name');
		$this->db->from('customer');
		$this->db->join('sales', 'sales.customer_id = customer.cus_id', 'left');
		$this->db->order_by("sales.warehouse_last_id", "desc");
		$this->db->where("sales.sale_id IS NOT NULL");//("id !=",$id);
		if($srh_sales_rep_id){
			$this->db->where("sales.rep_id",$srh_sales_rep_id);
		}
		if($search_key1){
		    //$this->db->where("customer.cus_phone",$search_key1);
		    $this->db->where(" sales.sale_reference_no LIKE '%$search_key1%' OR customer.cus_name LIKE '%$search_key1%' OR customer.cus_phone LIKE '%$search_key1%' OR sales.sale_reference_no LIKE '%$search_key1%' )");
		}
		if($search_key_val)
		{
			//$this->db->where("sales.sale_reference_no LIKE '%$search_key_val%' OR customer.cus_name LIKE '%$search_key_val%'");
			$this->db->where("sales.warehouse_id = $srh_warehouse_id AND ( sales.sale_reference_no LIKE '%$search_key_val%' OR customer.cus_name LIKE '%$search_key_val%' OR customer.cus_phone LIKE '%$search_key_val%' OR sales.sale_reference_no LIKE '%$search_key_val%' )");
		}
		if($srh_from_date){
			$srh_from_date=date('Y-m-d',strtotime($srh_from_date));
			$this->db->where("date(sales.sale_datetime) >=",$srh_from_date);
		}
		if($srh_to_date){
			$srh_to_date=date('Y-m-d',strtotime($srh_to_date));
			$this->db->where("date(sales.sale_datetime) <=",$srh_to_date);
		}
		if($srh_warehouse_id){
			$this->db->where_in("sales.warehouse_id",$srh_warehouse_id);
		}
		
		if($start!='' && $length!=''){
			if($length>0) $this->db->limit($length,$start);
		}
		$query = $this->db->get();
		//echo $this->db->last_query();
		return $query->result_array();
	}
	
		//Sales all get
	function get_all_sales_v1($start='',$length='',$search_key_val='',$srh_from_date='',$srh_to_date='',$srh_warehouse_id='',$srh_sales_rep_id='',$dep_id='',$category='') {
		//echo "srh_warehouse_id:".count($srh_warehouse_id);
		$this->db->select('sales.*, customer.cus_name, customer.cus_phone');
		$this->db->from('sales');
	    //		$this->db->from('customer');
		$this->db->join('customer', 'sales.customer_id=customer.cus_id', 'left');
		//	$this->db->join('sales', 'sales.customer_id = customer.cus_id', 'left');
		$this->db->join('sale_items', 'sales.sale_id = sale_items.sale_id', 'left');
        $this->db->join('product', 'sale_items.product_id = product.product_id', 'left');
		$this->db->order_by("sales.sale_id", "desc");
		$this->db->where("sales.sale_id IS NOT NULL");//("id !=",$id);
		if($srh_sales_rep_id){
			$this->db->where("sales.rep_id",$srh_sales_rep_id);
		}
		if($dep_id){
			$this->db->where("product.dep_id",$dep_id);
		}
		if($category){
			$this->db->where("product.cat_id",$category);
		}
		if($search_key_val){
			//$this->db->where("sales.sale_reference_no LIKE '%$search_key_val%' OR customer.cus_name LIKE '%$search_key_val%'");
			$this->db->where("sales.warehouse_id = $srh_warehouse_id AND ( sales.sale_reference_no LIKE '%$search_key_val%' OR customer.cus_name LIKE '%$search_key_val%')");
		}
		if($srh_from_date){
			$srh_from_date=date('Y-m-d',strtotime($srh_from_date));
			$this->db->where("date(sales.sale_datetime) >=",$srh_from_date);
		}
		if($srh_to_date){
			$srh_to_date=date('Y-m-d',strtotime($srh_to_date));
			$this->db->where("date(sales.sale_datetime) <=",$srh_to_date);
		}
		
			if($srh_warehouse_id[0]==''){
		    
		    //echo "11111";
		}else{
		   // echo "2222";
		   //echo "srh_warehouse_id:$srh_warehouse_id";
		    	$this->db->where_in("sales.warehouse_id",$srh_warehouse_id);
		}
		
		/*
		if($srh_warehouse_id){
			$this->db->where_in("sales.warehouse_id",$srh_warehouse_id);
		}
		*/
		
		if($start!='' && $length!=''){
			if($length>0) $this->db->limit($length,$start);
		}
		 $this->db->group_by("sales.sale_id");
		$query = $this->db->get();
	//	echo $this->db->last_query();
		return $query->result_array();
	}
	
	function delete_sales($sale_id){
		
//		$sale_id = $this->input->get('sale_id');
		
	$query =	$this->db->query('DELETE FROM `sales` WHERE `sale_id` = '.$sale_id.'');
			//	print_r($query->result());
	$query =    $this->db->query('DELETE FROM `sale_items` WHERE `sale_id` = '.$sale_id.'');
				//print_r($query->result());
	$query =    $this->db->query('DELETE FROM `sale_payments` WHERE `sale_id` = '.$sale_id.' AND `sale_payment_type`= "sale" ');
				//print_r($query->result());
		//return $query->result_array();
		
		}
		
	function delete_sales_items_by_sale_id($sale_id){	
		$query =    $this->db->query('DELETE FROM `sale_items` WHERE `sale_id` = '.$sale_id.'');
		$query =    $this->db->query('DELETE FROM `sale_items_serial` WHERE `sale_id` = '.$sale_id.'');
	}
	
	//Sales get for print
	function get_all_sales_for_print_sales() {
		$this->db->select('s.* , c.cus_name ,SUM(p.sale_pymnt_amount) AS total_paid_amount');
		$this->db->from('sales s');
		$this->db->join('customer c', 's.customer_id = c.cus_id', 'left');
		$this->db->join('sale_payments p', 's.sale_id = p.sale_id', 'left');
		$this->db->order_by("s.sale_id", "desc");
		$this->db->group_by('s.sale_id');
		$this->db->where("s.sale_id IS NOT NULL");//("id !=",$id);
		$query = $this->db->get();
		return $query->result_array();
	}
	
	
	function get_sale_print() {
		$this->db->select('s.sale_id');
		$this->db->from('sales s');
	
		$this->db->where("s.phone_bill_print_status",0);//("id !=",$id);
		$this->db->where("s.is_phone_bill",1);
		$query = $this->db->get();
		return $query->row_array();
	}
	
	//Sales payment get 
	function get_sale_payments_by_sale_id($sale_id,$type='sale') {
		$this->db->select('sale_payments.*,user.user_first_name,user_group.user_group_name,sale_payments.extra_val_1');
		$this->db->from('sale_payments');
		$this->db->join('user', 'sale_payments.user_id = user.user_id', 'left');
		$this->db->join('user_group', 'user.group_id = user_group.user_group_id', 'left');
		$this->db->order_by("sale_payments.sale_pymnt_id", "desc");
		$this->db->where("sale_payments.sale_id",$sale_id);//("id !=",$id);
		$this->db->where("sale_payments.sale_payment_type",$type);
		$query = $this->db->get();
		return $query->result();
	}
	
	
		function get_sale_list_by_sales_return_id($sl_rtn_id) {
		$this->db->select('s.*');
		$this->db->from('sales s');
	//	$this->db->join('user', 'sale_payments.user_id = user.user_id', 'left');
	//	$this->db->join('user_group', 'user.group_id = user_group.user_group_id', 'left');
	//	$this->db->order_by("sale_payments.sale_pymnt_id", "desc");
		$this->db->where("s.sl_rtn_id",$sl_rtn_id);//("id !=",$id);
		//$this->db->where("sale_payments.sale_payment_type",'sale');
		$query = $this->db->get();
	//	echo $this->db->last_query();
		return $query->result();
	}
	
		function get_sale_return_payments_by_sale_id($sale_id) {
		$this->db->select('sale_payments.*,user.user_first_name,user_group.user_group_name,sale_payments.extra_val_1');
		$this->db->from('sale_payments');
		$this->db->join('user', 'sale_payments.user_id = user.user_id', 'left');
		$this->db->join('user_group', 'user.group_id = user_group.user_group_id', 'left');
		$this->db->order_by("sale_payments.sale_pymnt_id", "desc");
		$this->db->where("sale_payments.sale_id",$sale_id);//("id !=",$id);
		$this->db->where("sale_payments.sale_payment_type",'sales_return');
		$query = $this->db->get();
		return $query->result();
	}
	
		function get_service_payments_by_sale_id($sale_id) {
		$this->db->select('sale_payments.*,user.user_first_name,user_group.user_group_name');
		$this->db->from('sale_payments');
		$this->db->join('user', 'sale_payments.user_id = user.user_id', 'left');
		$this->db->join('user_group', 'user.group_id = user_group.user_group_id', 'left');
		$this->db->order_by("sale_payments.sale_pymnt_id", "desc");
		$this->db->where("sale_payments.sale_id",$sale_id);//("id !=",$id);
		$this->db->where("sale_payments.sale_payment_type",'service');
		$query = $this->db->get();
		return $query->result();
	}
	
	//Get product sujetions
	function get_products_suggestions($term='',$cat_id='',$srh_warehouse_id='') {
		//
		
	//	echo "$manual_search";
		$this->db->select('p.*,i.*');
		$this->db->from('purchase_items_serial i');
		$this->db->join('product p', 'p.product_id = i.product_id', 'left');
		
		$this->db->order_by("p.product_name", "asc");
		
		/*if(!$manual_search){
		    $this->db->group_by('i.product_id');
		}else{
		    $this->db->group_by('i.pis_number');
		}*/
		
	//	$this->db->group_by('i.pis_number');
		/*$this->db->group_by('i.product_id');*/
		//$this->db->where("i.pis_sold",0);
		//$this->db->where("product_name LIKE '%$term%'");
		//$this->db->where("(i.pis_number LIKE '%$term%' OR p.product_name LIKE '%$term%' OR p.product_code LIKE '%$term%' OR p.product_oem_part_number LIKE '%$term%' OR p.product_part_no LIKE '%$term%') AND i.pis_sold='0' AND p.product_sn_exissts='1'");
		
		$cat_query='';
		
		//echo "cat_id:$cat_id";
		if($cat_id){
			$cat_query="AND p.cat_id='$cat_id'";
		}
		if($srh_warehouse_id){
			$cat_query.="AND i.avalable_warehouse_id='$srh_warehouse_id'";
		}
		
		//$this->db->where("(i.pis_number = '$term' OR p.product_name LIKE '%$term%' OR p.product_code LIKE '%$term%' ) AND i.product_avalable='1' AND p.product_sn_exissts='1' AND p.product_status='1' $cat_query");
    		if ($term == trim($term) && strpos($term, ' ') !== false) {
                $this->db->where("(p.product_name like '%$term%') AND i.product_avalable='1' AND p.product_sn_exissts='1' AND p.product_status='1' $cat_query");
            }else{
                if(is_numeric($term)){
                    $this->db->where("(i.pis_number like '$term%') AND i.product_avalable='1' AND p.product_sn_exissts='1' AND p.product_status='1' $cat_query");
                }else{
                    $this->db->where("(p.product_name like '%$term%') AND i.product_avalable='1' AND p.product_sn_exissts='1' AND p.product_status='1' $cat_query");
                }
                
            }
		

		$this->db->where("p.is_saleable","yes");
		
		 $this->db->limit(20, 0);
		$query = $this->db->get();
		
	//	if($this->session->userdata('ss_user_id')==1)
		//echo $this->db->last_query(); die();
		return $query->result_array();
	}
	
	function get_non_serial_products_suggestions($term,$cat_id='') {
		$this->db->select('p.*');
		$this->db->from('product p');
		$this->db->order_by("p.product_name", "asc");
		//$this->db->where("product_name LIKE '%$term%'");
		//$this->db->join('purchase_items pi', 'pi.product_id = p.product_id', 'left');
		$cat_query='';
		if($cat_id){
			$cat_query="AND p.cat_id='$cat_id'";
		}
		
	//	$this->db->where("(p.product_name LIKE '%$term%' OR p.product_code LIKE '%$term%') AND p.product_status='1' AND p.product_sn_exissts='0' $cat_query");
		$this->db->where("(p.product_code = '$term') AND p.product_status='1' AND p.product_sn_exissts='0' $cat_query");
		 $this->db->limit(20, 0);
		$query = $this->db->get();
	//	echo $this->db->last_query();
		return $query->result_array();
	}
	
	
		function get_products_suggestions_for_service($term='') {
		//
		$this->db->select('i.*,p.product_name,p.product_code,p.product_id');
		$this->db->from('sale_items_serial i');
		$this->db->join('product p', 'p.product_id = i.product_id', 'left');
		
		//$this->db->order_by("p.product_name", "asc");
		//$this->db->group_by('p.product_id');
		
		//$this->db->where("i.pis_sold",0);
		//$this->db->where("product_name LIKE '%$term%'");
		//$this->db->where("(i.pis_number LIKE '%$term%' OR p.product_name LIKE '%$term%' OR p.product_code LIKE '%$term%' OR p.product_oem_part_number LIKE '%$term%' OR p.product_part_no LIKE '%$term%') AND i.pis_sold='1'");
		// $this->db->limit(20, 0);
		$query = $this->db->get();
		//echo $this->db->last_query();
		return $query->result();
	}


		function get_products_suggestions_for_service_del($term='') {
		//
		$this->db->select('p.*,i.*');
		$this->db->from('purchase_items_serial i');
		$this->db->join('product p', 'p.product_id = i.product_id', 'left');
		
		$this->db->order_by("p.product_name", "asc");
		$this->db->group_by('p.product_id');
		//$this->db->where("i.pis_sold",0);
		//$this->db->where("product_name LIKE '%$term%'");
		$this->db->where("(i.pis_number LIKE '%$term%' OR p.product_name LIKE '%$term%' OR p.product_code LIKE '%$term%' OR p.product_oem_part_number LIKE '%$term%' OR p.product_part_no LIKE '%$term%') AND i.pis_sold='1'");
		 $this->db->limit(20, 0);
		$query = $this->db->get();
		//echo $this->db->last_query();
		return $query->result();
	}
		
	
	//Get all products
	function get_all_products() {
		$this->db->select('product'.'.*');
		$this->db->order_by("product_name", "asc");
		$this->db->where("product_id IS NOT NULL");//("id !=",$id);
		$query = $this->db->get('product');
		return $query->result_array();
	}
	
	//Sales payment save
	function save_sale_payments(&$data,$sale_pymnt_id=false)
	{
		if (!$sale_pymnt_id)
		{
			return $this->db->insert('sale_payments',$data);
		}else {
			$this->db->where('supp_id', $sale_pymnt_id);
			return $this->db->update('sale_payments',$data);
		}
	}	
	
	function save_sale_interest(&$data,$si_id=false)
	{
		if (!$si_id)
		{
			return $this->db->insert('sale_interest',$data);
		}else {
			$this->db->where('si_id', $si_id);
			return $this->db->update('sale_interest',$data);
		}
	}	
	
		function get_all_sales_bu_cus_id($cus_id,$srh_rep_id='') {
		//echo $srh_rep_id;
		$this->db->select('sales.*, customer.cus_name');
		$this->db->from('customer');
		$this->db->join('sales', 'sales.customer_id = customer.cus_id', 'left');
		$this->db->order_by("sales.sale_id", "desc");
		$this->db->where("sales.customer_id",$cus_id);//("id !=",$id);
		if($srh_rep_id){
			$this->db->where("sales.rep_id",$srh_rep_id);
		}
		
		$query = $this->db->get();
		//echo $this->db->last_query();
		return $query->result();
	}
	
	function get_all_sale_items_count($start='',$length='',$search_key_val='') {
		$this->db->select('COUNT(sale_items.id) AS count_s');
		$this->db->from('sale_items');
		$this->db->join('product','product.product_id = sale_items.product_id');
		$this->db->join('sales', 'sales.sale_id = sale_items.sale_id', 'left');
		$this->db->join('customer ','customer.cus_id = sales.customer_id');
		$this->db->order_by("sale_items.sale_id", "desc");
		//$this->db->where("sales.sale_id IS NOT NULL");//("id !=",$id);
		if($search_key_val){
			$this->db->where("sales.sale_reference_no LIKE '%$search_key_val%' OR product.product_code LIKE '%$search_key_val%' OR customer.cus_name LIKE '%$search_key_val%'");
			//$this->db->like('sales.sale_reference_no', $search_key_val);
			//$this->db->like('customer.cus_name', $search_key_val);
		}
		//$this->db->where("product_name LIKE '%$term%' OR product_code LIKE '%$term%' OR product_oem_part_number LIKE '%$term%' OR product_part_no LIKE '%$term%'");
		if($start!='' && $length!=''){
			$this->db->limit($length,$start);
		}
		$query = $this->db->get();
		//echo $this->db->last_query();
		return $query->result_array();
	}
	
		function get_all_sale_items($start='',$length='',$search_key_val='',$sale_id='',$category='',$dep_id='',$srh_sub_cat='',$product_id='') {
		$this->db->select('sale_items.id,product.cat_id,product.product_name,product.product_code,sales.sale_datetime,sales.sale_reference_no, customer.cus_name,sale_items.sale_id,sale_items.gross_total,sale_items.item_cost,sale_items.quantity,sale_items.product_id,sale_items.unit_price');
		$this->db->from('sale_items');
		$this->db->join('product','product.product_id = sale_items.product_id');
		$this->db->join('sales', 'sales.sale_id = sale_items.sale_id', 'left');
		$this->db->join('customer ','customer.cus_id = sales.customer_id');
		$this->db->order_by("sale_items.sale_id", "desc");
		//$this->db->where("sales.sale_id IS NOT NULL");//("id !=",$id);
		if($product_id){
			$this->db->where("sale_items.product_id", $product_id);
		}
		if($sale_id){
			$this->db->where("sales.sale_id", $sale_id);
		}
		if($category){
			$this->db->where("product.cat_id", $category);
		}
		if($dep_id){
			$this->db->where("product.dep_id", $dep_id);
		}
		if($srh_sub_cat){
			$this->db->where("product.sub_cat_id", $srh_sub_cat);
		}
		if($search_key_val){
			$this->db->where("sales.sale_reference_no LIKE '%$search_key_val%' OR product.product_code LIKE '%$search_key_val%' OR customer.cus_name LIKE '%$search_key_val%'");
			//$this->db->like('sales.sale_reference_no', $search_key_val);
			//$this->db->like('customer.cus_name', $search_key_val);
		}
		//$this->db->where("product_name LIKE '%$term%' OR product_code LIKE '%$term%' OR product_oem_part_number LIKE '%$term%' OR product_part_no LIKE '%$term%'");
		if($start!='' && $length!=''){
			$this->db->limit($length,$start);
		}
		$query = $this->db->get();
		//echo $this->db->last_query();
		return $query->result_array();
	}
	
	
	function get_all_sales_count($start='',$length='',$search_key_val='',$srh_from_date,$srh_to_date,$srh_warehouse_id='',$srh_sales_rep_id='',$dep_id='') {
		$this->db->select('sales.*, customer.cus_name');
		$this->db->from('customer');
		$this->db->join('sales', 'sales.customer_id = customer.cus_id', 'left');
		$this->db->order_by("sales.sale_id", "desc");
		//$this->db->where("sales.sale_id IS NOT NULL");//("id !=",$id);
		if($search_key_val){
			$this->db->where("sales.sale_reference_no = '$search_key_val' OR customer.cus_name LIKE '%$search_key_val%'");
			//$this->db->like('sales.sale_reference_no', $search_key_val);
			//$this->db->like('customer.cus_name', $search_key_val);
		}
		if($srh_sales_rep_id){
			$this->db->where("sales.rep_id",$srh_sales_rep_id);
		}
		if($srh_from_date){
			$srh_to_date=date('Y-m-d',strtotime($srh_from_date));
			$this->db->where("date(sales.sale_datetime) >=",$srh_to_date);
		}
		if($srh_to_date){
			$srh_to_date=date('Y-m-d',strtotime($srh_from_date));
			$this->db->where("date(sales.sale_datetime) <=",$srh_to_date);
		}
		if($srh_warehouse_id){
			$this->db->where_in("sales.warehouse_id",$srh_warehouse_id);
		}
		
		
		//$this->db->where("product_name LIKE '%$term%' OR product_code LIKE '%$term%' OR product_oem_part_number LIKE '%$term%' OR product_part_no LIKE '%$term%'");
		if($start!='' && $length!=''){
			if($length>0) $this->db->limit($length,$start);
			//$this->db->limit($length,$start);
		}
		//$this->db->limit(20); 
		$query = $this->db->get();
		//echo $this->db->last_query();
		return $rowcount = $query->num_rows();
	}	
	
	
		
	function get_all_sales_count_v1($start='',$length='',$search_key_val='',$srh_from_date,$srh_to_date,$srh_warehouse_id='',$srh_sales_rep_id='',$dep_id='',$category='') {
		$this->db->select('sales.*, customer.cus_name, customer.cus_phone');
		//$this->db->from('customer');
		$this->db->from('sales');
		$this->db->join('customer', 'sales.customer_id = customer.cus_id', 'left');
	//	$this->db->join('sales', 'sales.customer_id = customer.cus_id', 'left');
		$this->db->join('sale_items', 'sales.sale_id = sale_items.sale_id', 'left');
		$this->db->join('product', 'sale_items.product_id = product.product_id', 'left');
		$this->db->order_by("sales.sale_id", "desc");
		//$this->db->where("sales.sale_id IS NOT NULL");//("id !=",$id);
		if($search_key_val){
			$this->db->where("sales.sale_reference_no = '$search_key_val' OR customer.cus_name LIKE '%$search_key_val%'");
			//$this->db->like('sales.sale_reference_no', $search_key_val);
			//$this->db->like('customer.cus_name', $search_key_val);
		}
		if($srh_sales_rep_id){
			$this->db->where("sales.rep_id",$srh_sales_rep_id);
		}
		if($category){
			$this->db->where("product.cat_id",$category);
		}
		if($dep_id){
			$this->db->where("product.dep_id",$dep_id);
		}
		if($srh_from_date){
			$srh_to_date=date('Y-m-d',strtotime($srh_from_date));
			$this->db->where("date(sales.sale_datetime) >=",$srh_to_date);
		}
		if($srh_to_date){
			$srh_to_date=date('Y-m-d',strtotime($srh_from_date));
			$this->db->where("date(sales.sale_datetime) <=",$srh_to_date);
		}
		
	//	print_r($srh_warehouse_id);
	
	//echo "srh_warehouse_id:".$srh_warehouse_id[0];
		
		if($srh_warehouse_id[0]==''){
		    
		    //echo "11111";
		}else{
		   // echo "2222";
		    	$this->db->where_in("sales.warehouse_id",$srh_warehouse_id);
		}
		/*
		if($srh_warehouse_id){
			$this->db->where_in("sales.warehouse_id",$srh_warehouse_id);
		}
		*/
		
		
		//$this->db->where("product_name LIKE '%$term%' OR product_code LIKE '%$term%' OR product_oem_part_number LIKE '%$term%' OR product_part_no LIKE '%$term%'");
		if($start!='' && $length!=''){
			if($length>0) $this->db->limit($length,$start);
			//$this->db->limit($length,$start);
		}
		//$this->db->limit(20); 
		$query = $this->db->get();
	//	echo $this->db->last_query();
		return $rowcount = $query->num_rows();
	}	
	
	  function getPaymentsForPrint_rtn($srh_warehouse_id='',$srh_to_date='',$srh_from_date='',$srh_type='',$srh_payment_term='',$ss_user_id='')
   {
	   $warehouse_id='';
	    $sel='p.*,c.cus_name,sr.*';
	   if($ss_user_id) $sel.=',u.user_first_name';
	   $this->db->select($sel);
       $this->db->from('sale_payments p');
	   $this->db->join('sales_return sr', 'sr.sl_rtn_id = p.sale_id', 'left');
	   $this->db->join('warehouses w', 'w.id = sr.warehouse_id', 'left');
	   $this->db->join('customer c', 'c.cus_id = sr.customer_id', 'left');
	    if($ss_user_id) $this->db->join('user u', 'u.user_id = p.user_id', 'left');
	
		
	   if($srh_type){
	   
	   $this->db->where("p.sale_payment_type",$srh_type);//
	   }
	   if($srh_payment_term){
	   
	   $this->db->where("p.sale_pymnt_paying_by",$srh_payment_term);//
	   }
	    if($ss_user_id){
	   
	   $this->db->where("p.user_id",$ss_user_id);//
	   }
	   if($srh_warehouse_id){
	   
	   $this->db->where("sr.warehouse_id",$srh_warehouse_id);//
	   
	   }else{
	 	$this->session->userdata('ss_warehouse_id');
		$warehouse_id =	$this->session->userdata('ss_warehouse_id');
		
//		echo $warehouse_id;
		$this->db->where("sr.warehouse_id",$warehouse_id);
		
		
		
		//		echo "INN";
		}


		$this->db->where("p.sale_payment_type",'sales_return');
		   
		   
	   
	   if($srh_to_date){
			$this->db->where("p.sale_pymnt_date_time <=",$srh_to_date);//("id !=",$id);
		}
		if($srh_from_date){
			$this->db->where("p.sale_pymnt_date_time >=",$srh_from_date);//("id !=",$id);
		}
	   $this->db->order_by("sr.sl_rtn_id", "desc");
	  
	   $query = $this->db->get();
	   // echo $this->db->last_query();
     if($query->num_rows() >0)
     {
       return $query->result();
     }
     else
     {
       //return false;
     }

   }
   
   
     function getPaymentsForPrint_rtn_2($srh_warehouse_id='',$srh_to_date='',$srh_from_date='',$srh_type='',$srh_payment_term='',$ss_user_id='')
   {
	   $warehouse_id='';
	    $sel='p.*,c.cus_name,sr.*';
	   if($ss_user_id) $sel.=',u.user_first_name';
	   $this->db->select($sel);
       $this->db->from('sale_payments p');
	   $this->db->join('sales_return sr', 'sr.sl_rtn_id = p.sale_id', 'left');
	   $this->db->join('warehouses w', 'w.id = sr.warehouse_id', 'left');
	   $this->db->join('customer c', 'c.cus_id = sr.customer_id', 'left');
	    if($ss_user_id) $this->db->join('user u', 'u.user_id = p.user_id', 'left');
	
		
	   if($srh_type){
	   
	   $this->db->where("p.sale_payment_type",$srh_type);//
	   }
	   
	   $this->db->where("p.sale_pymnt_paying_by","Cash");//
	   if($srh_payment_term){
	   
	   $this->db->where("p.sale_pymnt_paying_by",$srh_payment_term);//
	   }
	    if($ss_user_id){
	   
	   $this->db->where("p.user_id",$ss_user_id);//
	   }
	   if($srh_warehouse_id){
	   
	   $this->db->where("sr.warehouse_id",$srh_warehouse_id);//
	   
	   }else{
	 	$this->session->userdata('ss_warehouse_id');
		$warehouse_id =	$this->session->userdata('ss_warehouse_id');
		
//		echo $warehouse_id;
		$this->db->where("sr.warehouse_id",$warehouse_id);
		
		
		
		//		echo "INN";
		}


		$this->db->where("p.sale_payment_type",'sales_return');
		   
		   
	   
	   if($srh_to_date){
			$this->db->where("p.sale_pymnt_date_time <=",$srh_to_date);//("id !=",$id);
		}
		if($srh_from_date){
			$this->db->where("p.sale_pymnt_date_time >=",$srh_from_date);//("id !=",$id);
		}
	   $this->db->order_by("sr.sl_rtn_id", "desc");
	  
	   $query = $this->db->get();
	   // echo $this->db->last_query();
     if($query->num_rows() >0)
     {
       return $query->result();
     }
     else
     {
       //return false;
     }

   }
   
   
     public function get_last_interest_des($sale_id)
	 {
		 /*
		$this->db->select('*');
		$this->db->from('sale_interest');
		$this->db->where("sale_id", $sale_id);
		$this->db->order_by("si_id", "desc");
		$this->db->limit(1);
		//$query = $this->db->get->row();
		$query = $this->db->get();
		$result =$query->row_array(); 
		
		return $result;
		*/
		

$this->db->select("*");
$this->db->from("sale_interest");
$this->db->where("sale_id", $sale_id);
$this->db->limit(1);
$this->db->order_by('si_id',"DESC");
$query = $this->db->get();
$result = $query->result();
//echo $this->db->last_query();
return $result;

	 }
   
   	function sale_pymnts_delete_by_sp_id($sp_id){
		
		$this->db->query('DELETE FROM `sale_payments` WHERE `sale_pymnt_id` = '.$sp_id.'');
	
		}
			function cheque_return_by_sp_id($sale_pymnt_id,$data){
		$this->db->where('sale_pymnt_id', $sale_pymnt_id);
		return $this->db->update('sale_payments',$data);
		
		//$this->db->query('UPDATE `sale_payments` SET `sale_pymnt_paying_by`= "Cheque_Return" WHERE `sale_pymnt_id` = '.$sp_id.'');
	
	}
	
	
	function getPaymentsForPrintService($srh_warehouse_id='',$srh_to_date='',$srh_from_date='',$srh_type='',$srh_payment_term='',$ss_user_id='')
   {
	   $warehouse_id='';
	    $sel='p.*,s.*';
	   if($ss_user_id) $sel.=',u.user_first_name';
	   $this->db->select($sel);
       $this->db->from('sale_payments p');
	   $this->db->join('service s', 's.service_id = p.sale_id', 'left');
	   $this->db->join('warehouses w', 'w.id = s.warehouse_id', 'left');
	  // $this->db->join('customer c', 'c.cus_id = s.customer_id', 'left');
	    if($ss_user_id) $this->db->join('user u', 'u.user_id = p.user_id', 'left');
	
		
	   
	   if($srh_payment_term){
	   
	   $this->db->where("p.sale_pymnt_paying_by",$srh_payment_term);//
	   }
	    if($ss_user_id){
	   
	   $this->db->where("p.user_id",$ss_user_id);//
	   }
	   if($srh_warehouse_id){
	   
	   $this->db->where("s.warehouse_id",$srh_warehouse_id);//
	   
	   }else{
	 	$this->session->userdata('ss_warehouse_id');
		$warehouse_id =	$this->session->userdata('ss_warehouse_id');
		
//		echo $warehouse_id;
		$this->db->where("s.warehouse_id",$warehouse_id);
		
		
		
		//		echo "INN";
		}


		$this->db->where("p.sale_payment_type",'service');
		   
		   
	   
	   if($srh_to_date){
			$this->db->where("p.sale_pymnt_date_time <=",$srh_to_date);//("id !=",$id);
		}
		if($srh_from_date){
			$this->db->where("p.sale_pymnt_date_time >=",$srh_from_date);//("id !=",$id);
		}
	   $this->db->order_by("s.service_id", "desc");
	  
	   $query = $this->db->get();
	   //echo $this->db->last_query();
     if($query->num_rows() >0)
     {
       return $query->result();
     }
     else
     {
       //return false;
     }

   }
   
   
     public function get_sales_item_serial_by_id($sale_id='',$sale_item_id='')

  {

     $this->db->select('*');

     $this->db->from('sale_items_serial');

     $this->db->where('sale_items_serial.sale_id',$sale_id);

	 $this->db->where('sale_items_serial.sale_item_id',$sale_item_id);

     $query = $this->db->get();
	 
	// echo $this->db->last_query();

     if($query->num_rows() >0)
	 

     {

       return $query->result();

     }

     else

     {

       return false;

     }

  }
   public function get_sale_items_serial_details_by_sis_id($sis_id='')

  {

     $this->db->select('sis.*,si.unit_price');

     $this->db->from('sale_items_serial sis');

	 $this->db->join('sale_items si', 'sis.sale_item_id = si.id', 'left');

	// $this->db->join('sales s', 's.sale_id = si.sale_id', 'left');

     $this->db->where('sis.sis_id',$sis_id);

	 // $this->db->where('pis_sold',0);

     $query = $this->db->get();

       return $query->result();

  }
  
  public function get_purchase_status($pieces_sn,$product_id)

	{

		$this->db->select('product_status');

		$this->db->from('purchase_items_serial');

		$this->db->where_in('pis_number',$pieces_sn);

		$this->db->where('product_id',$product_id);

		$query=$this->db->get();

		return $data['product_status']=$query->row()->product_status;

	}
	
	
public function get_product_cost_by_serial_no_id($pis_number='')
  {
     $this->db->select('sis.pis_cost_price,sis.pis_cash_price');
     $this->db->from('purchase_items_serial sis');
	// $this->db->join("purchases p", "p.id = sis.purchase_id", "left");
     //$this->db->where('sis.product_id',$product_id);
	 $this->db->where('sis.pis_number',$pis_number);
	// $this->db->where('sis.pis_transferred',0);
     $query = $this->db->get();
	// echo $this->db->last_query();
	//print_r($query->result());
	
       return $query->result();
  }
  

 public function get_sales_return_serial_by_id($sl_rtn_id='',$sale_rtn_item_id='')
  {
     $this->db->select('*');
     $this->db->from('sale_return_items_serial');
     $this->db->where('sale_return_items_serial.sl_rtn_id',$sl_rtn_id);
	  $this->db->where('sale_return_items_serial.sale_rtn_item_id',$sale_rtn_item_id);
     $query = $this->db->get();
     if($query->num_rows() >0)
     {
       return $query->result();
     }
     else
     {
       return false;
     }
  }
  
   public function get_grn_return_serial_by_id($pur_rtn_id='',$pur_rtn_itm_id='')
  {
     $this->db->select('pris.*');
     $this->db->from('purchase_return_items_serial pris');
     $this->db->where('pris.pur_rtn_id',$pur_rtn_id);
	  $this->db->where('pris.pur_rtn_itm_id',$pur_rtn_itm_id);
     $query = $this->db->get();
     if($query->num_rows() >0)
     {
       return $query->result();
     }
     else
     {
       return false;
     }
  }
  
  	   public function get_purchase_info_r($id)
	 {
		
		$this->db->select('*');
		$this->db->from('purchases');
		$this->db->where("purchases.id", $id);
		$this->db->order_by("purchases.id", "desc");
		$query = $this->db->get();
		
		//print_r ($query-> result());
		return $query->row_array(); 
	 }
	 
	 public function get_next_warehouse_ref_no($warehouse_id){
	$this->db->select_max('warehouse_last_id');
	$this->db->where('warehouse_id', $warehouse_id);
	$query = $this->db->get('sales');
     if($query->num_rows() >0)
     {
       $g = $query->result();
       $u = $g[0]->warehouse_last_id;
       return $u;
     }
     else
     {
       return false;
     }
}
    function get_all_sales_for_report_balance($srh_warehouse_id = '', $srh_to_date = '', $srh_from_date = '', $sale_id = '', $from = '', $to = '', $srh_customer_id = '')
    {
        $this->db->select('s.* , c.cus_name ,SUM(p.sale_pymnt_amount) AS total_paid_amount');
        $this->db->from('sales s');
        $this->db->join('customer c', 's.customer_id = c.cus_id', 'left');
        $this->db->join('sale_payments p', 's.sale_id = p.sale_id', 'left');
        $this->db->order_by("s.sale_id", "desc");
        $this->db->group_by('s.sale_id');
        if ($srh_warehouse_id) {
            $this->db->where("s.warehouse_id", $srh_warehouse_id);
        }
        if ($srh_from_date) {
            $this->db->where("s.sale_datetime >=", $srh_from_date);
        }
        if ($srh_to_date) {
            $this->db->where("s.sale_datetime <=", $srh_to_date);
        }
        if ($sale_id) {
            $this->db->where("s.sale_id =", $sale_id);
        }
        if ($srh_customer_id) {
            $this->db->where("s.customer_id", $srh_customer_id);
        }
        if ($to) {
            $this->db->limit($to, $from);
        }
        $query = $this->db->get();
        return $query->result_array();
    }
	    function get_all_sales_return_for_balance_report($srh_warehouse_id = '', $srh_to_date = '', $srh_from_date = '', $srh_customer_id = '')
    {
        $this->db->select('sr.* , c.cus_name,SUM(p.sale_pymnt_amount) AS total_paid_amount');
        $this->db->from('sales_return sr');
        $this->db->join('customer c', 'sr.customer_id = c.cus_id', 'left');
        $this->db->join('sale_payments p', 'sr.sl_rtn_id = p.sale_id', 'left');
        if ($srh_customer_id) {
            $this->db->where("sr.customer_id", $srh_customer_id);
        }
		$this->db->where('sale_pymnt_paying_by !=', 'Cash');
        if ($srh_warehouse_id) {
            $this->db->where("sr.warehouse_id", $srh_warehouse_id);
        }
        if ($srh_from_date) {
            $this->db->where("sr.sl_rtn_datetime >=", $srh_from_date);
        }
        if ($srh_to_date) {
            $this->db->where("sr.sl_rtn_datetime <=", $srh_to_date);
        }
        $this->db->order_by("sr.sl_rtn_id", "desc");
        $this->db->group_by('sr.sl_rtn_id');
		$query = $this->db->get();
        return $query->result_array();
    }
	  function get_all_sum_sales_for_summery_report($srh_warehouse_id = '', $srh_to_date = '', $srh_from_date = '', $sale_id = '', $from = '', $to = '', $srh_customer_id = '')
    {
        $this->db->select('SUM(`sale_total`) AS sale_total');
        $this->db->from('sales');
        $this->db->where('sales.customer_id', $srh_customer_id);
        if ($srh_warehouse_id) {
            $this->db->where("sales.warehouse_id", $srh_warehouse_id);
        }
        if ($srh_to_date) {
            $srh_to_date = date('Y-m-d 23:59:59', strtotime($srh_to_date . ""));
            $this->db->where("sales.sale_datetime <=", $srh_to_date);
        }
        if ($srh_from_date) {
            $srh_from_date = date('Y-m-d 00:00:00', strtotime($srh_from_date));
            $this->db->where("sales.sale_datetime >=", $srh_from_date);
        }
        $query  = $this->db->get();
        $result = $query->result_array();
        return $result;
    }
    function get_sum_sales_return($srh_warehouse_id = '', $srh_to_date = '', $srh_from_date = '', $sale_id = '', $from = '', $to = '', $srh_customer_id = '')
    {
        $this->db->select('SUM(`sl_rtn_total`) AS sale_return_total');
        $this->db->from('sales_return');
        $this->db->where('customer_id', $srh_customer_id);
        if ($srh_warehouse_id) {
            $this->db->where("sales_return.warehouse_id", $srh_warehouse_id);
        }
        if ($srh_to_date) {
            $srh_to_date = date('Y-m-d 23:59:59', strtotime($srh_to_date ));
            $this->db->where("sales_return.sl_rtn_datetime <=", $srh_to_date);
        }
       // if ($srh_from_date) {
//            $srh_from_date = date('Y-m-d 00:00:00', strtotime($srh_from_date));
//            $this->db->where("sales_return.sl_rtn_datetime >=", $srh_from_date);
//        }
        $query  = $this->db->get();
        $result = $query->row_array();
		return $result;
    }
	    function getSumPaymentsForBalanceRep($srh_warehouse_id = '', $srh_to_date = '', $srh_from_date = '', $srh_type = '', $srh_payment_term = '', $ss_user_id = '', $srh_customer_id = '', $return_name = '')
    {
        $warehouse_id = '';
        $sel          = 'SUM(p.sale_pymnt_amount) AS ' . $return_name . '';
        if ($ss_user_id)
            $sel .= ',u.user_first_name';
        $this->db->select($sel);
        $this->db->from('sale_payments p');
        $this->db->join('sales b', 'b.sale_id = p.sale_id', 'left');
        if ($ss_user_id)
            $this->db->join('user u', 'u.user_id = p.user_id', 'left');
        if ($srh_from_date) {
            $srh_from_date = date('Y-m-d 00:00:00', strtotime($srh_from_date));
            $this->db->where("p.sale_pymnt_added_date_time >=", $srh_from_date);
        }
        if ($return_name == 'tot_sp') {
            $this->db->where('sale_pymnt_paying_by !=', 'Cheque_Return');
        }
        if ($return_name == 'unrealized_chq') {
            $srh_to_date = date('Y-m-d H:i:s', strtotime($srh_to_date . ""));
            $this->db->where("p.sale_pymnt_date_time >=", $srh_to_date);
        } else if ($srh_to_date) {
            $srh_to_date = date('Y-m-d 23:59:59', strtotime($srh_to_date . ""));
            $this->db->where("p.sale_pymnt_added_date_time <=", $srh_to_date);
        }
        if ($srh_type) {
            $this->db->where("p.sale_payment_type", $srh_type);
        }
        if ($srh_payment_term) {
            $this->db->where("p.sale_pymnt_paying_by", $srh_payment_term);
        }
        if ($ss_user_id) {
            $this->db->where("p.user_id", $ss_user_id);
        }
        if ($srh_customer_id) {
            $this->db->where("b.warehouse_id =" . $srh_warehouse_id . " AND b.customer_id=" . $srh_customer_id . "");
        } else if ($srh_warehouse_id) {
            $this->db->where("b.warehouse_id", $srh_warehouse_id);
        } else {
            $this->session->userdata('ss_warehouse_id');
            $warehouse_id = $this->session->userdata('ss_warehouse_id');
            $this->db->where("b.warehouse_id", $warehouse_id);
        }
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
        }
    }
	
	function getChequeForPrint($srh_warehouse_id='',$srh_to_date='',$srh_from_date='',$srh_type='',$srh_payment_term='',$ss_user_id='')
   {
	   if($srh_type =='grn'){
				$sel='p.*,b.reference_no as sale_reference_no,c.supp_company_name as cus_name, smp_amount';
				if($ss_user_id) $sel.=',u.user_first_name';
				$this->db->select($sel);
				$this->db->from('sale_payments p');
				$this->db->join('purchases b', 'b.id = p.sale_id', 'left');
				$this->db->join('warehouses w', 'w.id = b.warehouse_id', 'left');
				$this->db->join('supplier c', 'c.supp_id = b.supplier_id', 'left');
				$this->db->join('sale_multiple_payment smp', 'smp.smp_id = p.smp_id', 'left');
				$this->db->where("p.sale_pymnt_paying_by",'Cheque');
				if($ss_user_id) $this->db->join('user u', 'u.user_id = p.user_id', 'left');
				// if($srh_type){
				$this->db->where("p.sale_payment_type",$srh_type);//
				// }
				if($srh_payment_term){
				// $this->db->where("p.sale_pymnt_paying_by",$srh_payment_term);//
				}
				if($ss_user_id){
				$this->db->where("p.user_id",$ss_user_id);//
				}
				if($srh_warehouse_id){
				//  $this->db->where("b.warehouse_id",$srh_warehouse_id);//
				}
				if($srh_to_date){
				$this->db->where("date(p.sale_pymnt_added_date_time) <=",$srh_to_date);//("id !=",$id);
				}
				if($srh_from_date){
				$this->db->where("date(p.sale_pymnt_added_date_time) >=",$srh_from_date);//("id !=",$id);
				}
				$this->db->order_by("p.sale_pymnt_id", "desc");
				$this->db->group_by("p.sale_pymnt_cheque_no");
				$query = $this->db->get();
				 // echo $this->db->last_query();
				if($query->num_rows() >0)
				{
				return $query->result();
				}
				else
				{
				//return false;
				}
			}
			else{
				$sel='p.*,c.cus_name,b.*,smp_amount';
				if($ss_user_id) $sel.=',u.user_first_name';
				$this->db->select($sel);
				$this->db->from('sale_payments p');
				$this->db->join('sales b', 'b.sale_id = p.sale_id', 'left');
				$this->db->join('warehouses w', 'w.id = b.warehouse_id', 'left');
				$this->db->join('customer c', 'c.cus_id = b.customer_id', 'left');
				$this->db->join('sale_multiple_payment smp', 'smp.smp_id = p.smp_id', 'left');
				$this->db->where("p.sale_pymnt_paying_by",'Cheque');
				if($ss_user_id) $this->db->join('user u', 'u.user_id = p.user_id', 'left');
				if($srh_type)	$this->db->where("p.sale_payment_type",$srh_type);//
				if($srh_payment_term){// $this->db->where("p.sale_pymnt_paying_by",$srh_payment_term);//
				}
				if($ss_user_id){$this->db->where("p.user_id",$ss_user_id);//
				}
				if($srh_warehouse_id){//  $this->db->where("b.warehouse_id",$srh_warehouse_id);//
				}
				if($srh_to_date){
				$this->db->where("date(p.sale_pymnt_added_date_time) <=",$srh_to_date);//("id !=",$id);
				}
				if($srh_from_date){
				$this->db->where("date(p.sale_pymnt_added_date_time) >=",$srh_from_date);//("id !=",$id);
				}
				$this->db->order_by("p.sale_pymnt_id", "desc");
				$this->db->group_by("p.sale_pymnt_cheque_no");
				$query = $this->db->get();
				//  echo $this->db->last_query();
				if($query->num_rows() >0)
				{
				return $query->result();
				}
				else
				{
				//return false;
				}
	}
}



	function getsupplier_paymentForPrint($srh_warehouse_id='',$srh_to_date='',$srh_from_date='',$srh_type='',$srh_payment_term='',$ss_user_id='')
   {
	   if($srh_type =='grn'){
				$sel='p.*,b.reference_no as sale_reference_no,c.supp_company_name as cus_name, smp_amount';
				if($ss_user_id) $sel.=',u.user_first_name';
				$this->db->select($sel);
				$this->db->from('sale_payments p');
				$this->db->join('purchases b', 'b.id = p.sale_id', 'left');
				$this->db->join('warehouses w', 'w.id = b.warehouse_id', 'left');
				$this->db->join('supplier c', 'c.supp_id = b.supplier_id', 'left');
				$this->db->join('sale_multiple_payment smp', 'smp.smp_id = p.smp_id', 'left');
				//$this->db->where("p.sale_pymnt_paying_by",'Cheque');
				if($ss_user_id) $this->db->join('user u', 'u.user_id = p.user_id', 'left');
				// if($srh_type){
				$this->db->where("p.sale_payment_type",$srh_type);//
				// }
				if($srh_payment_term){
				// $this->db->where("p.sale_pymnt_paying_by",$srh_payment_term);//
				}
				if($ss_user_id){
				$this->db->where("p.user_id",$ss_user_id);//
				}
				if($srh_warehouse_id){
				//  $this->db->where("b.warehouse_id",$srh_warehouse_id);//
				}
				if($srh_to_date){
				$this->db->where("date(p.sale_pymnt_added_date_time) <=",$srh_to_date);//("id !=",$id);
				}
				if($srh_from_date){
				$this->db->where("date(p.sale_pymnt_added_date_time) >=",$srh_from_date);//("id !=",$id);
				}
				$this->db->order_by("p.sale_pymnt_id", "desc");
			//	$this->db->group_by("p.sale_pymnt_cheque_no");
				$query = $this->db->get();
				 // echo $this->db->last_query();
				if($query->num_rows() >0)
				{
				return $query->result();
				}
				else
				{
				//return false;
				}
			}
			else{
				$sel='p.*,c.cus_name,b.*,smp_amount';
				if($ss_user_id) $sel.=',u.user_first_name';
				$this->db->select($sel);
				$this->db->from('sale_payments p');
				$this->db->join('sales b', 'b.sale_id = p.sale_id', 'left');
				$this->db->join('warehouses w', 'w.id = b.warehouse_id', 'left');
				$this->db->join('customer c', 'c.cus_id = b.customer_id', 'left');
				$this->db->join('sale_multiple_payment smp', 'smp.smp_id = p.smp_id', 'left');
				$this->db->where("p.sale_pymnt_paying_by",'Cheque');
				if($ss_user_id) $this->db->join('user u', 'u.user_id = p.user_id', 'left');
				if($srh_type)	$this->db->where("p.sale_payment_type",$srh_type);//
				if($srh_payment_term){// $this->db->where("p.sale_pymnt_paying_by",$srh_payment_term);//
				}
				if($ss_user_id){$this->db->where("p.user_id",$ss_user_id);//
				}
				if($srh_warehouse_id){//  $this->db->where("b.warehouse_id",$srh_warehouse_id);//
				}
				if($srh_to_date){
				$this->db->where("date(p.sale_pymnt_added_date_time) <=",$srh_to_date);//("id !=",$id);
				}
				if($srh_from_date){
				$this->db->where("date(p.sale_pymnt_added_date_time) >=",$srh_from_date);//("id !=",$id);
				}
				$this->db->order_by("p.sale_pymnt_id", "desc");
				$this->db->group_by("p.sale_pymnt_cheque_no");
				$query = $this->db->get();
				//  echo $this->db->last_query();
				if($query->num_rows() >0)
				{
				return $query->result();
				}
				else
				{
				//return false;
				}
	}
}


	function getCreditCardForPrint($srh_warehouse_id='',$srh_to_date='',$srh_from_date='',$srh_type='',$srh_payment_term='',$ss_user_id='')
   {
	   if($srh_type =='grn'){
				$sel='p.*,b.reference_no as sale_reference_no,c.supp_company_name as cus_name, smp_amount';
				if($ss_user_id) $sel.=',u.user_first_name';
				$this->db->select($sel);
				$this->db->from('sale_payments p');
				$this->db->join('purchases b', 'b.id = p.sale_id', 'left');
				$this->db->join('warehouses w', 'w.id = b.warehouse_id', 'left');
				$this->db->join('supplier c', 'c.supp_id = b.supplier_id', 'left');
				$this->db->join('sale_multiple_payment smp', 'smp.smp_id = p.smp_id', 'left');
				$this->db->where("p.sale_pymnt_paying_by",'Cheque');
				if($ss_user_id) $this->db->join('user u', 'u.user_id = p.user_id', 'left');
				// if($srh_type){
				$this->db->where("p.sale_payment_type",$srh_type);//
				// }
				if($srh_payment_term){
				// $this->db->where("p.sale_pymnt_paying_by",$srh_payment_term);//
				}
				if($ss_user_id){
				$this->db->where("p.user_id",$ss_user_id);//
				}
				if($srh_warehouse_id){
				//  $this->db->where("b.warehouse_id",$srh_warehouse_id);//
				}
				if($srh_to_date){
				$this->db->where("date(p.sale_pymnt_added_date_time) <=",$srh_to_date);//("id !=",$id);
				}
				if($srh_from_date){
				$this->db->where("date(p.sale_pymnt_added_date_time) >=",$srh_from_date);//("id !=",$id);
				}
				$this->db->order_by("p.sale_pymnt_id", "desc");
				$this->db->group_by("p.sale_pymnt_cheque_no");
				$query = $this->db->get();
				 // echo $this->db->last_query();
				if($query->num_rows() >0)
				{
				return $query->result();
				}
				else
				{
				//return false;
				}
			}
			else{
				$sel='p.*,c.cus_name,b.*,smp_amount';
				if($ss_user_id) $sel.=',u.user_first_name';
				$this->db->select($sel);
				$this->db->from('sale_payments p');
				$this->db->join('sales b', 'b.sale_id = p.sale_id', 'left');
				$this->db->join('warehouses w', 'w.id = b.warehouse_id', 'left');
				$this->db->join('customer c', 'c.cus_id = b.customer_id', 'left');
				$this->db->join('sale_multiple_payment smp', 'smp.smp_id = p.smp_id', 'left');
			//	$this->db->where("p.sale_pymnt_paying_by",'Cheque');
				$this->db->where("p.sale_pymnt_paying_by",'Credit Card');
				if($ss_user_id) $this->db->join('user u', 'u.user_id = p.user_id', 'left');
				if($srh_type)	$this->db->where("p.sale_payment_type",$srh_type);//
				if($srh_payment_term){// $this->db->where("p.sale_pymnt_paying_by",$srh_payment_term);//
				}
				if($ss_user_id){$this->db->where("p.user_id",$ss_user_id);//
				}
				if($srh_warehouse_id){//  $this->db->where("b.warehouse_id",$srh_warehouse_id);//
				}
				if($srh_to_date){
				$this->db->where("date(p.sale_pymnt_added_date_time) <=",$srh_to_date);//("id !=",$id);
				}
				if($srh_from_date){
				$this->db->where("date(p.sale_pymnt_added_date_time) >=",$srh_from_date);//("id !=",$id);
				}
				$this->db->order_by("p.sale_pymnt_id", "desc");
			//	$this->db->group_by("p.sale_pymnt_cheque_no");
				$query = $this->db->get();
				//  echo $this->db->last_query();
				if($query->num_rows() >0)
				{
				return $query->result();
				}
				else
				{
				//return false;
				}
	}
}
   
    function getUnrealizedChequeForPrint($srh_warehouse_id='',$srh_to_date='',$srh_from_date='',$srh_type='',$srh_payment_term='',$ss_user_id='')
   {
	    

 if($srh_type =='grn'){
				$sel='p.*,b.reference_no as sale_reference_no,c.supp_company_name as cus_name';
				if($ss_user_id) $sel.=',u.user_first_name';
				$this->db->select($sel);
				$this->db->from('sale_payments p');
				$this->db->join('purchases b', 'b.id = p.sale_id', 'left');
				$this->db->join('warehouses w', 'w.id = b.warehouse_id', 'left');
				$this->db->join('supplier c', 'c.supp_id = b.supplier_id', 'left');
				$this->db->where("p.sale_pymnt_paying_by",'Cheque');
				if($ss_user_id) $this->db->join('user u', 'u.user_id = p.user_id', 'left');
				// if($srh_type){
				$this->db->where("p.sale_payment_type",$srh_type);//
				// }
				if($srh_payment_term){
				// $this->db->where("p.sale_pymnt_paying_by",$srh_payment_term);//
				}
				if($ss_user_id){
				$this->db->where("p.user_id",$ss_user_id);//
				}
				if($srh_from_date){
				$srh_from_date=date('Y-m-d',strtotime($srh_from_date. ""));
				$this->db->where("p.sale_pymnt_date_time >=",$srh_from_date);//("id !=",$id);
				}
				$this->db->order_by("p.sale_pymnt_id", "desc");
				$query = $this->db->get();
				//  echo $this->db->last_query();
				if($query->num_rows() >0)
				{
				return $query->result();
				}
				else
				{
				//return false;
				}
			}
			else{
				$sel='p.*,c.cus_name,b.*';
				   if($ss_user_id) $sel.=',u.user_first_name';
				   $this->db->select($sel);
				   $this->db->from('sale_payments p');
				   $this->db->join('sales b', 'b.sale_id = p.sale_id', 'left');
				   $this->db->join('warehouses w', 'w.id = b.warehouse_id', 'left');
				   $this->db->join('customer c', 'c.cus_id = b.customer_id', 'left');
				   $this->db->where("p.sale_pymnt_paying_by",'Cheque');
				   
				   
				   if($ss_user_id) $this->db->join('user u', 'u.user_id = p.user_id', 'left');
				
					
				   if($srh_type){
				   
				   $this->db->where("p.sale_payment_type",$srh_type);//
				   }
				   if($srh_payment_term){
				   
				  // $this->db->where("p.sale_pymnt_paying_by",$srh_payment_term);//
				   }
					if($ss_user_id){
				   
				   $this->db->where("p.user_id",$ss_user_id);//
				   }
				   if($srh_warehouse_id){
				   
				 //  $this->db->where("b.warehouse_id",$srh_warehouse_id);//
				   }
			//	   if($srh_to_date){
				//		
						//$this->db->where("p.sale_pymnt_date_time <=",$srh_to_date);//("id !=",$id);
					//}
					if($srh_from_date){
						$srh_from_date=date('Y-m-d',strtotime($srh_from_date. ""));
						$this->db->where("p.sale_pymnt_date_time >=",$srh_from_date);//("id !=",$id);
					}
				   $this->db->order_by("p.sale_pymnt_id", "desc");
				  
				   $query = $this->db->get();
				  //  echo $this->db->last_query();
				 if($query->num_rows() >0)
				 {
				   return $query->result();
				 }
				 else
				 {
				   //return false;
				 }
	}


   }
 
    function getRetChequeForPrint($srh_warehouse_id='',$srh_to_date='',$srh_from_date='',$srh_type='',$srh_payment_term='',$ss_user_id='')
   {
	    $sel='p.*,c.cus_name,b.*';
	   if($ss_user_id) $sel.=',u.user_first_name';
	   $this->db->select($sel);
       $this->db->from('sale_payments p');
	   $this->db->join('sales b', 'b.sale_id = p.sale_id', 'left');
	   $this->db->join('warehouses w', 'w.id = b.warehouse_id', 'left');
	   $this->db->join('customer c', 'c.cus_id = b.customer_id', 'left');
	   $this->db->where("p.sale_pymnt_paying_by",'Cheque_Return');
	   
	   
	    if($ss_user_id) $this->db->join('user u', 'u.user_id = p.user_id', 'left');
	
		
	   if($srh_type){
	   
	   $this->db->where("p.sale_payment_type",$srh_type);//
	   }
	   if($srh_payment_term){
	   
	  // $this->db->where("p.sale_pymnt_paying_by",$srh_payment_term);//
	   }
	    if($ss_user_id){
	   
	   $this->db->where("p.user_id",$ss_user_id);//
	   }
	   if($srh_warehouse_id){
	   
	 //  $this->db->where("b.warehouse_id",$srh_warehouse_id);//
	   }
	   if($srh_to_date){
		   	$srh_to_date=date('Y-m-d',strtotime($srh_to_date . ""));
			$this->db->where("p.sale_pymnt_added_date_time <=",$srh_to_date);//("id !=",$id);
		}
		if($srh_from_date){
			$this->db->where("p.sale_pymnt_added_date_time >=",$srh_from_date);//("id !=",$id);
		}
	   $this->db->order_by("p.sale_pymnt_id", "desc");
	  
	   $query = $this->db->get();
	  //  echo $this->db->last_query();
     if($query->num_rows() >0)
     {
       return $query->result();
     }
     else
     {
       //return false;
     }

   }
   
     
   function get_total_paid_by_sale_pymnt_id($sale_pymnt_id){
	$this->db->select('sale_payments.*');
	$this->db->from('sale_payments');
	$this->db->where("sale_pymnt_id",$sale_pymnt_id)->where("(sale_payment_type='sale' OR sale_payment_type='pos_sale')");
	$query=$this->db->get();
	//echo $this->db->last_query();
	//if($query->row()->sale_pymnt_amount){
		return $query->row();
	//}else {
		//return 0;
	//}
  }
 
   public function get_list_sale_interest($srh_warehouse_id,$srh_to_date,$srh_from_date,$from='',$to='')
  {
     $this->db->select("si.*,s.*");
     $this->db->from("sale_interest si");
    // $this->db->join("user u", "u.user_id = l.user_id", "left"); 
	 $this->db->join("sales s", "si.sale_id = s.sale_id", "left");
	if($srh_warehouse_id){
		$this->db->where("s.warehouse_id",$srh_warehouse_id);//("id !=",$id);
	}
	if($srh_to_date){
		$this->db->where("date(si.si_added) <=",$srh_to_date);//("id !=",$id);
	}
	if($srh_from_date){
		$this->db->where("date(si.si_added) >=",$srh_from_date);//("id !=",$id);
	}
	if($to){
		$this->db->limit($to,$from);
		}	
     $this->db->group_by("si.si_id");
     $this->db->order_by("si.si_id", "desc");
     $query = $this->db->get();  
 // echo $this->db->last_query();
     return $query->result_array();
  }  
  
  
     public function get_list_sale_current_interest($srh_warehouse_id,$srh_to_date,$srh_from_date,$from='',$to='')
  {
     $this->db->select("s.*");
     $this->db->from("sales s");
    // $this->db->join("user u", "u.user_id = l.user_id", "left"); 
	// $this->db->join("sales s", "si.sale_id = s.sale_id", "left");
	if($srh_warehouse_id){
		$this->db->where("s.current_interest!=",'0.00');//("id !=",$id);
	}
	if($srh_warehouse_id){
		$this->db->where("s.warehouse_id",$srh_warehouse_id);//("id !=",$id);
	}
	if($srh_to_date){
		$this->db->where("date(s.current_interest_date) <=",$srh_to_date);//("id !=",$id);
	}
	if($srh_from_date){
		$this->db->where("date(s.current_interest_date) >=",$srh_from_date);//("id !=",$id);
	}
	if($to){
		$this->db->limit($to,$from);
		}	
     $this->db->group_by("s.sale_id");
     $this->db->order_by("s.current_interest_date", "desc");
     $query = $this->db->get();  
 // echo $this->db->last_query();
     return $query->result_array();
  }  	
  
  function get_product_by_serial_no($term='',$cat_id='',$srh_warehouse_id='') {
		//
		
	//	echo "$manual_search";
	//	$this->db->select('p.*,i.*');
	$this->db->select('p.*,i.*,s.supp_id,s.supp_company_name');
		$this->db->from('purchase_items_serial i');
		$this->db->join('product p', 'p.product_id = i.product_id', 'left');
		
		$this->db->join('purchases pu', 'i.purchase_id = pu.id', 'left');
		$this->db->join('supplier s', 'pu.supplier_id = s.supp_id', 'left');
		
		$this->db->order_by("p.product_name", "asc");
		$cat_query='';
		if($cat_id){
			$cat_query="AND p.cat_id='$cat_id'";
		}
		if($srh_warehouse_id){
			$cat_query.="AND i.avalable_warehouse_id='$srh_warehouse_id'";
		}
		
		//$this->db->where("(i.pis_number = '$term' OR p.product_name LIKE '%$term%' OR p.product_code LIKE '%$term%' ) AND i.product_avalable='1' AND p.product_sn_exissts='1' AND p.product_status='1' $cat_query");
		
		$this->db->where("i.pis_number = '$term' AND i.product_avalable='1' AND p.product_sn_exissts='1' AND p.product_status='1' $cat_query");

		$this->db->where("p.is_saleable","yes");
		
		 $this->db->limit(20, 0);
		$query = $this->db->get();
		//echo $this->db->last_query();
		return $query->result_array();
	}
	
	 	public function get_grn_cash_book_data_by_date_range($srh_from_date,$srh_to_date,$srh_warehouse_id){
		$this->db->select('sp.*');    
		$this->db->from('sale_payments sp');
		$this->db->join('purchases p','sp.sale_id=p.id','left');
		
		{
		$srh_to_date=date('Y-m-d',strtotime($srh_to_date));
		$this->db->where("date(sp.sale_pymnt_date_time) <=",$srh_to_date);
		}
		
		{
		$srh_from_date=date('Y-m-d',strtotime($srh_from_date));
		$this->db->where("date(sp.sale_pymnt_date_time) >=",$srh_from_date);
		}
		
		
		if($srh_warehouse_id){
		$this->db->where('p.warehouse_id',$srh_warehouse_id);	
		}
		
		$this->db->where('sp.sale_pymnt_amount != ' ,'0.00');	
		$query=$this->db->get();
		//echo $this->db->last_query();
		return $query->result();
	}	
	
		public function get_salary_payment_cash_book_data_by_date_range($srh_from_date,$srh_to_date,$srh_warehouse_id){
		$this->db->select('sp.*');    
		$this->db->from('salary_payment sp');
		//$this->db->join('purchases p','sp.sale_id=p.id','left');
		
		{
		$srh_to_date=date('Y-m-d',strtotime($srh_to_date));
		$this->db->where("date(sp.sp_date) <=",$srh_to_date);
		}
		
		{
		$srh_from_date=date('Y-m-d',strtotime($srh_from_date));
		$this->db->where("date(sp.sp_date) >=",$srh_from_date);
		}
		
		
		if($srh_warehouse_id){
		$this->db->where('sp.warehouse_id',$srh_warehouse_id);	
		}
		
		$this->db->where('sp.sp_amount != ' ,'0.00');	
		$query=$this->db->get();
		//echo $this->db->last_query();
		return $query->result();
	}
	
		public function get_cash_sale_by_date_range($srh_from_date,$srh_to_date,$srh_warehouse_id,$in_type,$sale_pymnt_paying_by){
		
		$this->db->select('sp.*,SUM(sp.sale_pymnt_amount) as hire_sale_tot_amount,u.user_first_name');    
		$this->db->from('sale_payments sp');
		$this->db->join('sales s','sp.sale_id=s.sale_id','left');
		$this->db->join('user u','sp.cash_collector_id=u.user_id','left');
		//if($srh_to_date)
		{
			$srh_to_date=date('Y-m-d',strtotime($srh_to_date));
          //  $this->db->where("s.sale_datetime <=",$srh_to_date);
		  $this->db->where("date(sp.sale_pymnt_date_time) <=",$srh_to_date);
			}
		//if($srh_from_date)
		{
			$srh_from_date=date('Y-m-d',strtotime($srh_from_date));
			$this->db->where("date(sp.sale_pymnt_date_time) >=",$srh_from_date);
		}
		
		
			//$this->db->where("s.sale_manual_setlmnt_status",0);
			//sale_manual_setlmnt_status
			if($in_type){
		    $this->db->where('s.in_type',$in_type);	
			}
			if($srh_warehouse_id){
			 $this->db->where('s.warehouse_id',$srh_warehouse_id);	
			}
			if($sale_pymnt_paying_by){
		    $this->db->where('sp.sale_pymnt_paying_by',$sale_pymnt_paying_by);	
			}
			$this->db->where('sp.sale_pymnt_amount != ' ,'0.00');	
			
			$this->db->group_by('cash_collector_id');	
			
		//$this->db->group_by('s.sale_id');	
		$query=$this->db->get();
		//echo $this->db->last_query();
		return $query->result();
		}	
		
		function getGrnReturnPayments($srh_warehouse_id = '', $srh_to_date = '', $srh_from_date = '', $srh_type = '', $srh_payment_term = '', $supplier_id = "" , $ss_user_id = '')
    {
        
       // echo "supplier_id:$supplier_id";
        $this->db->select('p.*,c.supp_company_name,b.*,u.user_first_name');
        $this->db->from('sale_payments p');
        
        $this->db->join('purchase_return b', 'p.sale_id=b.pur_rtn_id', 'left');

        $this->db->join('warehouses w', 'w.id = b.warehouse_id', 'left');
        $this->db->join('supplier c', 'c.supp_id = b.supp_id', 'left');

        $this->db->join('user u', 'u.user_id = p.user_id', 'left');
        if ($srh_payment_term) {
            $this->db->where("p.sale_pymnt_paying_by", $srh_payment_term); //
        }
        if ($srh_warehouse_id) {
            $this->db->where("b.warehouse_id", $srh_warehouse_id); //
        }
        if ($srh_to_date) {
            $this->db->where("date(p.sale_pymnt_added_date_time) <=", $srh_to_date); //("id !=",$id);
        }
        if ($srh_from_date) {
            $this->db->where("date(p.sale_pymnt_added_date_time) >=", $srh_from_date); //("id !=",$id);
        }
        if($supplier_id){
            $this->db->where("b.supp_id", $supplier_id);
        }
        if ($ss_user_id) {
            $this->db->where("p.user_id", $ss_user_id);
        }
        if ($srh_type) {
            $this->db->where("p.sale_payment_type", $srh_type);
        }
        $this->db->order_by("p.sale_pymnt_id", "asc");
        $query = $this->db->get();
       //  echo $this->db->last_query();
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            //return false;
        }
    }
    
    function getGrnPayments($srh_warehouse_id = '', $srh_to_date = '', $srh_from_date = '', $srh_type = '', $srh_payment_term = '', $supplier_id = "" , $ss_user_id = '')
    {
        $this->db->select('p.*,c.supp_company_name,b.*,u.user_first_name');
        $this->db->from('sale_payments p');
        
        $this->db->join('purchases b', 'b.id = p.sale_id', 'left');

        $this->db->join('warehouses w', 'w.id = b.warehouse_id', 'left');
        $this->db->join('supplier c', 'c.supp_id = b.supplier_id', 'left');

        $this->db->join('user u', 'u.user_id = p.user_id', 'left');
        if ($srh_payment_term) {
            $this->db->where("p.sale_pymnt_paying_by", $srh_payment_term); //
        }
        if ($srh_warehouse_id) {
            $this->db->where("b.warehouse_id", $srh_warehouse_id); //
        }
        if ($srh_to_date) {
            $this->db->where("date(p.sale_pymnt_added_date_time) <=", $srh_to_date); //("id !=",$id);
        }
        if ($srh_from_date) {
            $this->db->where("date(p.sale_pymnt_added_date_time) >=", $srh_from_date); //("id !=",$id);
        }
        if($supplier_id){
            $this->db->where("b.supplier_id", $supplier_id);
        }
        if ($ss_user_id) {
            $this->db->where("p.user_id", $ss_user_id);
        }
        if ($srh_type) {
            $this->db->where("p.sale_payment_type", $srh_type);
        }
        $this->db->order_by("p.sale_pymnt_id", "asc");
        $query = $this->db->get();
        // echo $this->db->last_query();
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            //return false;
        }
    }
    
    
    //grn multiple payment add
      function getGrnMultiPayments($srh_warehouse_id = '', $srh_to_date = '', $srh_from_date = '', $srh_type = '', $srh_payment_term = '', $supplier_id = "" , $ss_user_id = '')
    {
        $this->db->select('smp.*,s.supp_company_name,u.user_first_name,sp.sale_pymnt_paying_by');
        $this->db->from('supplier_multiple_payment smp');
        
        //$this->db->join('purchases b', 'b.id = p.sale_id', 'left');

        $this->db->join('warehouses w', 'smp.warehouse_id = w.id', 'left');
        $this->db->join('supplier s', 'smp.supplier_id = s.supp_id', 'left');
        $this->db->join('sale_payments sp', 'smp.smp_id = sp.smp_id', 'left');

        $this->db->join('user u', 'smp.user_id = u.user_id', 'left');
        if ($srh_payment_term) {
            $this->db->where("p.sale_pymnt_paying_by", $srh_payment_term); //
        }
        if ($srh_warehouse_id) {
            $this->db->where("b.warehouse_id", $srh_warehouse_id); //
        }
        if ($srh_to_date) {
            $this->db->where("date(smp.smp_date) <=", $srh_to_date); //("id !=",$id);
        }
        if ($srh_from_date) {
            $this->db->where("date(smp.smp_date) >=", $srh_from_date); //("id !=",$id);
        }
        if($supplier_id){
            $this->db->where("smp.supplier_id", $supplier_id);
        }
        if ($ss_user_id) {
            $this->db->where("smp.user_id", $ss_user_id);
        }
        if ($srh_type) {
            //$this->db->where("p.sale_payment_type", $srh_type);
        }
         $this->db->group_by("smp.smp_id");
        $this->db->order_by("smp.smp_id", "asc");
        $query = $this->db->get();
       //  echo $this->db->last_query();
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            //return false;
        }
    }
    
    
      function getStockAdjPayments($srh_warehouse_id = '', $srh_to_date = '', $srh_from_date = '', $srh_type = '', $srh_payment_term = '', $supplier_id = "" , $ss_user_id = '')
    {
        $this->db->select('p.*,c.supp_company_name,u.user_first_name, spa.*');
        $this->db->from('sale_payments p');
        
        $this->db->join('supplier_payment_adjustment spa', 'p.sale_id = spa.spa_id', 'left');

        $this->db->join('warehouses w', 'w.id = spa.warehouse_id', 'left');
        $this->db->join('supplier c', 'c.supp_id = spa.supplier_id', 'left');

        $this->db->join('user u', 'u.user_id = p.user_id', 'left');
        if ($srh_payment_term) {
            $this->db->where("p.sale_pymnt_paying_by", $srh_payment_term); //
        }
        if ($srh_warehouse_id) {
            $this->db->where("spa.warehouse_id", $srh_warehouse_id); //
        }
        if ($srh_to_date) {
            $this->db->where("date(p.sale_pymnt_added_date_time) <=", $srh_to_date); //("id !=",$id);
        }
        if ($srh_from_date) {
            $this->db->where("date(p.sale_pymnt_added_date_time) >=", $srh_from_date); //("id !=",$id);
        }
        if($supplier_id){
            $this->db->where("spa.supplier_id", $supplier_id);
        }
        if ($ss_user_id) {
            $this->db->where("p.user_id", $ss_user_id);
        }
        if ($srh_type) {
            $this->db->where("p.sale_payment_type", $srh_type);
        }
        $this->db->order_by("p.sale_pymnt_id", "asc");
        $query = $this->db->get();
        // echo $this->db->last_query();
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            //return false;
        }
    }
    
    function getSupPayAdj($srh_warehouse_id = '', $srh_to_date = '', $srh_from_date = '', $srh_type = '', $srh_payment_term = '', $supplier_id = "" , $ss_user_id = '')
    {
        $this->db->select('spa.*,c.supp_company_name,u.user_first_name');
        $this->db->from('supplier_payment_adjustment spa');
        
        //$this->db->join('purchases b', 'b.id = p.sale_id', 'left');

        $this->db->join('warehouses w', 'spa.warehouse_id = w.id', 'left');
        $this->db->join('supplier c', 'spa.supplier_id = c.supp_id', 'left');

        $this->db->join('user u', 'u.user_id = spa.user_id', 'left');
        if ($srh_payment_term) {
           // $this->db->where("p.sale_pymnt_paying_by", $srh_payment_term); //
        }
        if ($srh_warehouse_id) {
            $this->db->where("spa.warehouse_id", $srh_warehouse_id); //
        }
        if ($srh_to_date) {
            $this->db->where("date(spa.spa_added_datetime) <=", $srh_to_date); //("id !=",$id);
        }
        if ($srh_from_date) {
            $this->db->where("date(spa.spa_added_datetime) >=", $srh_from_date); //("id !=",$id);
        }
        if($supplier_id){
            $this->db->where("spa.supplier_id", $supplier_id);
        }
        if ($ss_user_id) {
            $this->db->where("spa.user_id", $ss_user_id);
        }
        if ($srh_type) {
           // $this->db->where("p.sale_payment_type", $srh_type);
        }
        $this->db->order_by("spa.spa_id", "asc");
        $query = $this->db->get();
        // echo $this->db->last_query();
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            //return false;
        }
    }
    
}