<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Service_details_Model extends CI_Model {
  
  private $tableName = 'mst_ser_dtls';
  
  function __construct() 
  {
    /* Call the Model constructor */
    parent::__construct();
  }


  /* save and update checks   */
	function save_service(&$data,$service_id)
	{
		if (!$service_id)
		{
			$this->db->insert($this->tableName,$data);
		}else {
			$this->db->where('mstserdtl_id', $service_id);
			return $this->db->update($this->tableName,$data);
		}
	}	



	 /* get all service details    */
	 function get_all_details() {
		$this->db->select($this->tableName.'.*,types.*');
		$this->db->join('mst_ser_dtls_type types', ''.$this->tableName.'.mstserdtpe_id = types.mstserdtpe_id', 'left');
		$this->db->where($this->tableName.".mstserdtl_id IS NOT NULL");
			$query = $this->db->get($this->tableName);
		return $query->result_array();
	}

	
	 /* get all service details    */
	 function get_all_enable_details() {
		$this->db->select($this->tableName.'.*,types.*');
		$this->db->join('mst_ser_dtls_type types', ''.$this->tableName.'.mstserdtpe_id = types.mstserdtpe_id', 'left');
		$this->db->where($this->tableName.".mstserdtl_id IS NOT NULL");
		$this->db->where($this->tableName.".mstserdtl_status = 1");
			$query = $this->db->get($this->tableName);
		return $query->result_array();
	}


		 /* get all service details  by id  */
		 function get_all_details_by_id($id) {
			$this->db->select('service_assign_itms.*');
			$this->db->where('service_id', $id);
				$query = $this->db->get('service_assign_itms');
			 $list=$query->result_array();
			 $list_temp=[];
			 foreach($list as $row){
				$list_temp[$row['mstserdtl_id']]=$row;

			 }

			 
			 return $list_temp;
		}
	
		 /* get all type details    */
		 function get_all_types() {
			$this->db->select('mst_ser_dtls_type.*');
			$this->db->where("mst_ser_dtls_type.mstserdtpe_status = 1");
			$query = $this->db->get('mst_ser_dtls_type');
		
			return $query->result_array();
		}

			 /* get  service details by id   */
			 function get_service_details($id) {
				$this->db->select($this->tableName.'.*,types.*');
				$this->db->join('mst_ser_dtls_type types', ''.$this->tableName.'.mstserdtpe_id = types.mstserdtpe_id', 'left');
				$this->db->where($this->tableName.".mstserdtl_id IS NOT NULL");
				$this->db->where($this->tableName.".mstserdtl_id", $id);
					$query = $this->db->get($this->tableName);
				return $query->row_array();
			}

	

	
	  /* delete check    */
	public function delete($id)
	{
		$this->db->where('mstserdtl_id', $id);
		$this->db->delete($this->tableName);
	
	}

	public function disable($id)
	{
		$data = array(
			'mstserdtl_status' => 0
		);	
		$this->db->where('mstserdtl_id', $id);
		$this->db->update($this->tableName, $data);
	}
	
	public function enable($id)
	{
		$data = array(
			'mstserdtl_status' => 1
		);	
		$this->db->where('mstserdtl_id', $id);
		$this->db->update($this->tableName, $data);
	}


}