<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class SMS_Model extends CI_Model {
  
  private $tableName = 'customer';
  
  function __construct() 
  {
    /* Call the Model constructor */
    parent::__construct();
  }
 
 
	
	function get_all_customers_by_route_id($rote_id)
	{
		$this->db->select('c.cus_id,c.cus_name,c.cus_code,c.cus_phone,c.cus_address,c.city_name,c.cus_status');
		//$this->db->select('r.route_name');
		$this->db->from('customer c');
		//$this->db->join('routes r', 'c.route_id = r.route_id', 'left');
		//$this->db->where('c.cus_status',1);
		//$this->db->where('c.route_id',$rote_id);
		$this->db->where('c.cus_phone != ',0,FALSE);
		$this->db->group_by('c.cus_phone'); 
		//$this->db->where('c.cus_phone!=""'); 
		$query=$this->db->get();
		return $query->result_array();
	}
	
	
	function get_customer_number_name($cus_id){
		$this->db->select('c.cus_phone,c.cus_name');
		$this->db->from('customer c');
		$this->db->where("c.cus_id",$cus_id);		
		$query = $this->db->get();
		return $query->row_array();
	}
	

	function get_all_customer_print($cus_id=false) {
		$this->db->select('customer.*, mstr_country.country_short_name');
		$this->db->from('mstr_country');
		$this->db->join('customer', 'customer.country_id = mstr_country.country_id', 'left');
		$this->db->order_by("customer.cus_name", "asc");
		$this->db->where("customer.cus_status IS NOT NULL");//("id !=",$id);
		$this->db->where("customer.cus_type","normal");
		if($cus_id){
		$this->db->where("customer.cus_id",$cus_id);
		}
		$query = $this->db->get();
		return $query->result();
	}
	
		
	function get_all_customers() {
		$this->db->select($this->tableName.'.*');
		
		$this->db->order_by("cus_id", "asc");
		$this->db->where("cus_status",1);//("id !=",$id);
		$this->db->where("cus_type","normal");
		$query = $this->db->get($this->tableName);
		return $query->result_array();
	}
	
	
	function get_all_easy_customers() {
		$this->db->select($this->tableName.'.*');
		$this->db->order_by("cus_id", "asc");
		//$this->db->where("cus_status",1);//("id !=",$id);
		
		$this->db->where("cus_type","easy");
		//$this->db->where("cus_id", $id);
		$query = $this->db->get($this->tableName);
		return $query->result_array();
	}
	
	
	function get_all_customer() {
		$this->db->select('customer.*, mstr_country.country_short_name,routes.route_name');
		$this->db->from('mstr_country');
		$this->db->join('customer', 'customer.country_id = mstr_country.country_id', 'left');
		$this->db->join('routes', 'routes.route_id = customer.route_id', 'left');
		$this->db->order_by("customer.cus_id", "desc");
		$this->db->where("customer.cus_type","normal");
		$this->db->where("customer.cus_status IS NOT NULL");//("id !=",$id);
		$query = $this->db->get();
		return $query->result_array();
	}
	
	public function get_customer_info($id)
	 {
		$this->db->select('*');
		$this->db->from('customer');
		$this->db->where("cus_id", $id);
		$this->db->order_by("cus_id", "desc");
		$query = $this->db->get();
		
		return $query->row_array(); 
	 }
	
	public function delete_customer($cus_id)
	{
		$this->db->where('cus_id', $cus_id);
		$this->db->delete('customer');
	
	}

	public function disable_customer($cus_id)
	{
		$data = array(
			'cus_status' => 0
		);	
		$this->db->where('cus_id', $cus_id);
		$this->db->update('customer', $data);
	}
	
	public function enable_customer($cus_id)
	{
		$data = array(
			'cus_status' => 1
		);	
		$this->db->where('cus_id', $cus_id);
		$this->db->update('customer', $data);
	}	


 public function get_ref_customer_info($cus_code)
	 {
		$this->db->select('*');
		$this->db->from('customer');
		$this->db->where("cus_id", $cus_code);
		//$this->db->order_by("cus_id", "desc");
		$query = $this->db->get();		
		return $query->row_array(); 
	 }

 public function gen_cus_code($column_name,$table_name,$type_code)
   {
	$this->db->select_max($column_name);
	$query = $this->db->get($table_name);
	
		$g = $query->result();
		$val = 1;
		$u = 0 ;
		
     if($query->num_rows() >0)
     {
	$val += $g[0]->$column_name;
	$u = $this->set_ref_no($val,$type_code);
	
	return $u;
	   
	  /*  
	 if($query->num_rows() >0)
     {	   
		   for($val = $g[0]->$column_name;$query->num_rows() > 0; $val++ ){
			   	$u = $this->set_ref_no($val,$type_code);
				//check if exist cus_code
       			$this->db->select('cus_code');
			   	$this->db->where('cus_code',$u);
			   	$query = $this->db->get($table_name);
			   }*/
	  
	 } else
     {
       return false;
     }


	/* if($query->num_rows() >0)
     {
       $g = $query->result();
       $u = $this->set_ref_no($g[0]->$column_name,$type_code);
	   
	   return $u;
     }
     else
     {
       return false;
     }
  */
   }

   function set_ref_no($f,$t)
   {
	  $w='';
   	 $d = date('Y/m/');
	 if($t){
		$w=$t;
	 }
   	 $w =$w.sprintf("%04d",$f+1);
   	 return $w;
   }
}