<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Supplier_Payment_Adjustment_Model extends CI_Model {
	 function __construct(){
		 parent::__construct();
		 }
    function transactions_type_list(){
	$this->db->select('*');	
	$this->db->from('fixed_assets_type');
	$this->db->where('fa_type_status',1);
	$query=$this->db->get();
	return $query->result_array();
		}	
		
		
		function get_sup_ajes_payments_by_sale_id($sale_id) {
		$this->db->select('sale_payments.*,user.user_first_name,user_group.user_group_name,sale_payments.extra_val_1');
		$this->db->from('sale_payments');
		$this->db->join('user', 'sale_payments.user_id = user.user_id', 'left');
		$this->db->join('user_group', 'user.group_id = user_group.user_group_id', 'left');
		$this->db->order_by("sale_payments.sale_pymnt_id", "desc");
		$this->db->where("sale_payments.sale_id",$sale_id);//("id !=",$id);
		$this->db->where("sale_payments.sale_payment_type",'supplier_payment_adjustment');
		$query = $this->db->get();
		return $query->result();
	}
	
		 function get_total_paid_sup_ajest_by_id($spa_id){
	$this->db->select_sum('sale_pymnt_amount');
	$this->db->from('sale_payments');
		$this->db->where("sale_id", $spa_id);
		$this->db->where("sale_payment_type", "supplier_payment_adjustment");
	$query=$this->db->get();
//	echo $this->db->last_query();
	if($query->row()->sale_pymnt_amount){
		return $query->row()->sale_pymnt_amount;
	}else {
		return 0;
	}
  }
  
  
	function save_supplier_payment_adjustment(&$data,$acctrnss_id=false)
	{
		if (!$acctrnss_id)
		{
			$this->db->insert('supplier_payment_adjustment',$data);
		}else {
			//$this->db->where('acctrnss_id', $acctrnss_id);
			//return $this->db->update('supplier_payment_adjustment',$data);
			
		}
	}
	function get_supplier_payment_adjustment_list($supplier_id='')
	{
		$this->db->select('spa.*,w.name,s.supp_company_name');
		$this->db->from('supplier_payment_adjustment spa');
		$this->db->join('warehouses w', 'spa.warehouse_id = w.id', 'left');
		$this->db->join('supplier s', 'spa.supplier_id = s.supp_id', 'left');
		if($supplier_id){
		    $this->db->where('supplier_id', $supplier_id);
		}
		
		$query=$this->db->get();
	//	echo $this->db->last_query();
		return $query->result_array();
	}
	
	function get_fixed_assets_master_list()
	{
		$this->db->select('fixed_assets_master.*');
		$this->db->from('fixed_assets_master');
		$this->db->order_by("fam_id", "asc");
		$query=$this->db->get();
		return $query->result();
	}	

	function get_fixed_assets_type_list($fam_id='')
	{
		$this->db->select('fixed_assets_type.*');
		$this->db->from('fixed_assets_type');
		$this->db->where('fam_id',$fam_id);
		$this->db->order_by("fa_type_id", "asc");
		$query=$this->db->get();
		return $query->result();
	}

	function get_fixed_assets_list($fa_type_id='')
	{
		$this->db->select('fa.*');
		$this->db->from('fixed_asset fa');
		$this->db->where('fa.fa_type_id',$fa_type_id);
		$this->db->order_by("fa.fxd_ass_id", "asc");
		$query=$this->db->get();
		return $query->result();
	}

	function get_acc_transactions_list($fa_type_id='')
	{
		$this->db->select('fa.*,at.*');
		$this->db->from('acc_transactions at');
		$this->db->join('fixed_asset fa','fa.fxd_ass_id=at.fxd_ass_id','left');
		$this->db->where('fa.fa_type_id',$fa_type_id);
		$this->db->order_by("at.acctrnss_id", "asc");
		$query=$this->db->get();
		return $query->result();
	}
				
	function get_supplier_payment_adjustment_details($spa_id)
	{
	$this->db->select('spa.*,s.supp_company_name,u.user_first_name');
	$this->db->from('supplier_payment_adjustment spa');	
	$this->db->join('user u','spa.user_id=u.user_id','left');
	$this->db->join('supplier s','spa.supplier_id=s.supp_id','left');
	$this->db->where('spa.spa_id',$spa_id);
	$query=$this->db->get();
	return $query->row_array();
	}
	
	function get_fixed_asset_vehical(){
		$this->db->select('fixed_asset.fxd_ass_id,fixed_asset.fxd_ass_name');
		$this->db->from('fixed_asset');
		$this->db->join('fixed_assets_type','fixed_assets_type.fa_type_id=fixed_asset.fa_type_id','left');
		$this->db->where('fixed_asset.fxd_ass_status',1);
		$this->db->where('fixed_assets_type.fa_type_id',1);
		$this->db->where('fixed_assets_type.fa_type_status',1);
		$query=$this->db->get();
		return $query->result_array();
		}
}