<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Transactions_Model extends CI_Model {
	 function __construct(){
		 parent::__construct();
		 }
    function transactions_type_list(){
	$this->db->select('*');	
	$this->db->from('fixed_assets_type');
	$this->db->where('fa_type_status',1);
	$query=$this->db->get();
	return $query->result_array();
		}		 
	function save_transactions(&$data,$acctrnss_id=false)
	{
		if (!$acctrnss_id)
		{
			$this->db->insert('acc_transactions',$data);
		}else {
			$this->db->where('acctrnss_id', $acctrnss_id);
			return $this->db->update('acc_transactions',$data);
			
		}
	}
	function get_transactions_list()
	{
		$this->db->select('acc_transactions.*,warehouses.name');
		$this->db->select('fixed_asset.*');
		$this->db->select('fixed_assets_type.*');
		$this->db->select('fixed_assets_master.*');
		$this->db->from('acc_transactions');
		$this->db->join('fixed_asset','fixed_asset.fxd_ass_id=acc_transactions.fxd_ass_id','left');
		$this->db->join('fixed_assets_type','fixed_asset.fa_type_id=fixed_assets_type.fa_type_id','left');
		$this->db->join('fixed_assets_master','fixed_assets_master.fam_id=fixed_assets_type.fam_id','left');
		$this->db->join('warehouses', 'acc_transactions.warehouse_id = warehouses.id', 'left');
		$query=$this->db->get();
		return $query->result_array();
	}
	
	function get_fixed_assets_master_list()
	{
		$this->db->select('fixed_assets_master.*');
		$this->db->from('fixed_assets_master');
		$this->db->order_by("fam_id", "asc");
		$query=$this->db->get();
		return $query->result();
	}	

	function get_fixed_assets_type_list($fam_id='')
	{
		$this->db->select('fixed_assets_type.*');
		$this->db->from('fixed_assets_type');
		$this->db->where('fam_id',$fam_id);
		$this->db->order_by("fa_type_id", "asc");
		$query=$this->db->get();
		return $query->result();
	}

	function get_fixed_assets_list($fa_type_id='')
	{
		$this->db->select('fa.*');
		$this->db->from('fixed_asset fa');
		$this->db->where('fa.fa_type_id',$fa_type_id);
		$this->db->order_by("fa.fxd_ass_id", "asc");
		$query=$this->db->get();
		return $query->result();
	}

	function get_acc_transactions_list($fa_type_id='')
	{
		$this->db->select('fa.*,at.*');
		$this->db->from('acc_transactions at');
		$this->db->join('fixed_asset fa','fa.fxd_ass_id=at.fxd_ass_id','left');
		$this->db->where('fa.fa_type_id',$fa_type_id);
		$this->db->order_by("at.acctrnss_id", "asc");
		$query=$this->db->get();
		return $query->result();
	}
				
	function get_transactions_details($acctrnss_id)
	{
	$this->db->select('t.*,u.*');
	$this->db->from('acc_transactions t');	
	$this->db->join('user u','t.user_id=u.user_id','left');
	$this->db->where('t.acctrnss_id',$acctrnss_id);
	$query=$this->db->get();
	return $query->row_array();
	}
	
	function get_fixed_asset_vehical(){
		$this->db->select('fixed_asset.fxd_ass_id,fixed_asset.fxd_ass_name');
		$this->db->from('fixed_asset');
		$this->db->join('fixed_assets_type','fixed_assets_type.fa_type_id=fixed_asset.fa_type_id','left');
		$this->db->where('fixed_asset.fxd_ass_status',1);
		$this->db->where('fixed_assets_type.fa_type_id',1);
		$this->db->where('fixed_assets_type.fa_type_status',1);
		$query=$this->db->get();
		return $query->result_array();
		}
}